/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.allocations;

import com.triloggroup.gantt.ProjectModel;
import com.triloggroup.gantt.Resource;
import com.triloggroup.gantt.app.AppProjectModel;
import com.triloggroup.gantt.app.ui.WDButton;
import com.triloggroup.gantt.app.ui.WDDatePicker;
import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.gantt.util.ValueInterval;
import com.triloggroup.gantt.util.ValueIntervals;
import com.triloggroup.project.components.allocations.SimpleAllocationsChart;
import com.triloggroup.project.components.resourceeditor.ResourceView;
import com.triloggroup.project.components.ui.Workbench;
import com.triloggroup.util.date.TGTime;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ResourceAllocationsDialog
extends WDDialog {
    private Resource resource;
    private ResourceView view;
    private SimpleAllocationsChart prjChart;
    private SimpleAllocationsChart crossPrjChart;
    private WDDatePicker fromPicker;
    private WDDatePicker toPicker;

    public static ResourceAllocationsDialog create(Resource resource, ResourceView resourceView) {
        Component component = resourceView.getComponent();
        Window window = (component = WDDialog.adjustParentComponent(component)) == null ? null : (component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component));
        GraphicsConfiguration graphicsConfiguration = WDUtil.getGraphicsConfiguration(component);
        ResourceAllocationsDialog resourceAllocationsDialog = null;
        resourceAllocationsDialog = new ResourceAllocationsDialog(window, graphicsConfiguration);
        resourceAllocationsDialog.view = resourceView;
        resourceAllocationsDialog.resource = resource;
        resourceAllocationsDialog.init();
        resourceAllocationsDialog.setLocationRelativeTo(component);
        resourceAllocationsDialog.setModal(false);
        return resourceAllocationsDialog;
    }

    public ResourceAllocationsDialog(Window window, GraphicsConfiguration graphicsConfiguration) {
        super(window, graphicsConfiguration);
    }

    private void init() {
        this.setDragHeader(true);
        this.setResizable(true);
        ProjectModel projectModel = (ProjectModel)((Object)this.view.getProjectModel());
        this.prjChart = new SimpleAllocationsChart(projectModel);
        this.prjChart.setCrossProject(false);
        this.crossPrjChart = new SimpleAllocationsChart(projectModel);
        this.crossPrjChart.setCrossProject(true);
        Date date = projectModel.getProjectStartDate();
        Date date2 = projectModel.getProjectEndDate();
        long l = (date2.getTime() - date.getTime()) / 20L;
        date = new Date(date.getTime() - l);
        date2 = new Date(date2.getTime() + l);
        TGTime tGTime = new TGTime(0, 0);
        date = tGTime.applyTime(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date2);
        calendar.add(5, 1);
        date2 = tGTime.applyTime(calendar.getTime());
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        WDButton wDButton = WDUtil.createOkButton();
        gridBagLayout.setConstraints(wDButton, gridBagConstraints);
        this.getContentPane().add(wDButton);
        wDButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResourceAllocationsDialog.this.dispose();
            }
        });
        gridBagConstraints.fill = 2;
        JLabel jLabel = new JLabel(Workbench.getNLSString("allocationsFor", new Object[0]) + ' ' + this.resource.getCn());
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        Font font = jLabel.getFont();
        jLabel.setFont(font.deriveFont(font.getSize2D() + 2.0f));
        this.getContentPane().add(jLabel);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(-1, 0, 1, 1, 0.0, 1.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout2);
        jLabel = new JLabel(Workbench.getNLSString("from", new Object[0]));
        gridBagLayout2.setConstraints(jLabel, gridBagConstraints2);
        jPanel.add(jLabel);
        Locale locale = Workbench.get().getFormatLocale();
        this.fromPicker = new WDDatePicker(locale);
        this.fromPicker.setDate(date);
        jPanel.add(this.fromPicker);
        jLabel = new JLabel(Workbench.getNLSString("to", new Object[0]));
        gridBagLayout2.setConstraints(jLabel, gridBagConstraints2);
        jPanel.add(jLabel);
        this.toPicker = new WDDatePicker(locale);
        this.toPicker.setDate(date2);
        jPanel.add(this.toPicker);
        WDButton wDButton2 = new WDButton(Workbench.getNLSString("apply_button", new Object[0]));
        jPanel.add(wDButton2);
        wDButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResourceAllocationsDialog.this.updateDates();
            }
        });
        gridBagConstraints2.weightx = 1.0;
        gridBagLayout2.setConstraints(this.fromPicker, gridBagConstraints2);
        gridBagLayout2.setConstraints(this.toPicker, gridBagConstraints2);
        gridBagLayout2.setConstraints(wDButton2, gridBagConstraints2);
        Component component = Box.createVerticalGlue();
        gridBagLayout2.setConstraints(component, gridBagConstraints2);
        jPanel.add(component);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.getContentPane().add(jPanel);
        jLabel = new JLabel(Workbench.getNLSString("currentProject", new Object[0]));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.getContentPane().add(jLabel);
        gridBagLayout.setConstraints(this.prjChart, gridBagConstraints);
        this.getContentPane().add(this.prjChart);
        jLabel = new JLabel(Workbench.getNLSString("crossProject", new Object[0]));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.getContentPane().add(jLabel);
        gridBagLayout.setConstraints(this.crossPrjChart, gridBagConstraints);
        this.getContentPane().add(this.crossPrjChart);
        component = Box.createVerticalGlue();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.getContentPane().add(component);
        this.pack();
        int n = this.getPreferredSize().height;
        int n2 = Math.max(this.getSize().width, 450);
        this.setMinimumSize(new Dimension(n2, n));
        this.updateDates();
    }

    private void updateDates() {
        Date date = this.fromPicker.getDate();
        Date date2 = this.toPicker.getDate();
        if (date == null || date2 == null || date.after(date2)) {
            String string = Workbench.getNLSString("invalidDate", new Object[0]);
            this.prjChart.setMessage(string);
            this.crossPrjChart.setMessage(string);
            return;
        }
        TGTime tGTime = new TGTime(0, 0);
        final Date date3 = tGTime.applyTime(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date2);
        calendar.add(5, 1);
        final Date date4 = tGTime.applyTime(calendar.getTime());
        String string = Workbench.getNLSString("loading", new Object[0]);
        this.prjChart.setMessage(string);
        this.crossPrjChart.setMessage(string);
        this.prjChart.setPeriod(date3, date4);
        this.crossPrjChart.setPeriod(date3, date4);
        new Thread(){

            public void run() {
                AppProjectModel appProjectModel = (AppProjectModel)ResourceAllocationsDialog.this.view.getProjectModel();
                ValueIntervals valueIntervals = appProjectModel.computeResourceAllocation(ResourceAllocationsDialog.this.resource, true);
                ResourceAllocationsDialog.this.prjChart.setAllocations(valueIntervals);
                ResourceAllocationsDialog.this.prjChart.setMessage(null);
                try {
                    ValueIntervals valueIntervals2 = ResourceAllocationsDialog.this.view.getWSHelper().getUserAllocationsForOtherProjects(ResourceAllocationsDialog.this.resource.getDn(), date3, date4);
                    for (int i = 0; i < valueIntervals.size(); ++i) {
                        valueIntervals2.addInterval((ValueInterval)valueIntervals.get(i));
                    }
                    ResourceAllocationsDialog.this.crossPrjChart.setAllocations(valueIntervals2);
                    ResourceAllocationsDialog.this.crossPrjChart.setMessage(null);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String string = Workbench.getNLSString("unexpected_error", exception.getMessage());
                    ResourceAllocationsDialog.this.crossPrjChart.setMessage(string);
                }
            }
        }.start();
    }
}

