/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.treetable;

import com.triloggroup.gantt.EmptyNode;
import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.GanttWBS;
import com.triloggroup.gantt.TGChart;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.treetable.TGTreeTableModel;
import com.triloggroup.project.components.ui.table.TGTableCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class TGTreeTableCellRenderer
extends TGTableCellRenderer {
    private static final Icon doneIcon;
    private static final Icon[] pendingIcons;
    private static final Icon[] inProgressIcons;
    private static final Icon milestoneDoneIcon;
    private static final Icon[] milestonePendingIcons;
    private static final Icon[] milestoneInProgressIcons;
    private static ImageIcon wbsIcon;
    private static ImageIcon subprojectIcon;
    private static ImageIcon brokenSubprojectLinkIcon;
    protected static final Color LINE_COLOR;
    protected TreeBorder border = new TreeBorder();
    protected Color focusColor;
    protected int state;
    protected int depth;
    protected boolean[] levels = new boolean[32];
    protected boolean firstRow = false;

    public TGTreeTableCellRenderer() {
        super.setBorder(this.border);
    }

    public JComponent getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Object object2;
        super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        this.firstRow = n == 0;
        TGTreeTableModel tGTreeTableModel = (TGTreeTableModel)jTable.getModel();
        TGNode tGNode = tGTreeTableModel.nodeForRow(n);
        this.setIcon(this.getIconForNode(tGNode));
        this.state = 0;
        if (tGNode instanceof EmptyNode) {
            this.depth = 0;
        } else {
            object2 = tGNode;
            TGNode tGNode2 = TGChart.getUIParentNode(tGNode);
            this.depth = 0;
            while (tGNode2 != null) {
                TGNode tGNode3 = tGNode2.getLastVisibleSubtask();
                if (tGNode2 != ((TGNode)object2).getParent()) {
                    object2 = ((TGNode)object2).getParent();
                }
                this.levels[this.depth] = tGNode3 != object2;
                object2 = tGNode2;
                tGNode2 = TGChart.getUIParentNode((TGNode)object2);
                ++this.depth;
            }
        }
        if (this.isShowExpandControl(tGNode)) {
            this.state = tGNode.isExpanded() ? 1 : -1;
        }
        object2 = this.computeRightIconForNode(tGNode);
        this.setRightIcon((Icon)object2);
        return this;
    }

    private boolean isShowExpandControl(TGNode tGNode) {
        if (tGNode == null || tGNode.isLeaf()) {
            return false;
        }
        if (tGNode.hasVisibleSubtask()) {
            return true;
        }
        if (GanttNode.isSubprojectLink(tGNode)) {
            return !((GanttWBS)tGNode).isBrokenSubprojectLink();
        }
        return false;
    }

    public void setBorder(Border border) {
        this.focusColor = border instanceof LineBorder ? ((LineBorder)border).getLineColor() : null;
    }

    public void showBorder(boolean bl) {
        super.setBorder(bl ? this.border : EMPTY_BORDER);
    }

    protected Icon getIconForNode(TGNode tGNode) {
        return this.getHealthIconForNode(tGNode);
    }

    public Icon getHealthIconForNode(TGNode tGNode) {
        if (tGNode instanceof GanttTask) {
            GanttTask ganttTask = (GanttTask)tGNode;
            if (ganttTask.isMilestone()) {
                if (ganttTask.isDone()) {
                    return milestoneDoneIcon;
                }
                int n = ganttTask.getHealthStatus();
                if (ganttTask.isInProgress()) {
                    return milestoneInProgressIcons[n];
                }
                return milestonePendingIcons[n];
            }
            if (ganttTask.isDone()) {
                return doneIcon;
            }
            int n = ganttTask.getHealthStatus();
            if (ganttTask.isInProgress()) {
                return inProgressIcons[n];
            }
            return pendingIcons[n];
        }
        if (tGNode instanceof GanttWBS) {
            GanttWBS ganttWBS = (GanttWBS)tGNode;
            if (ganttWBS.isProjectRoot() && ganttWBS.getParent() != null || ganttWBS.isSubProject() && ganttWBS.getAllSubTaskCount() == 0) {
                return this.getSubprojectIcon(ganttWBS);
            }
            return this.getWBSIcon(ganttWBS);
        }
        return null;
    }

    protected ImageIcon getWBSIcon(GanttWBS ganttWBS) {
        return this.getBasicWBSIcon();
    }

    protected Icon getSubprojectIcon(GanttWBS ganttWBS) {
        if (ganttWBS.isBrokenSubprojectLink()) {
            return this.getBrokenSubprojectLinkIcon();
        }
        return this.getBasicSubprojectIcon();
    }

    protected Icon computeRightIconForNode(TGNode tGNode) {
        return null;
    }

    protected static int getNodeDepth(TGNode tGNode) {
        int n = 0;
        while (tGNode != null) {
            ++n;
            tGNode = TGChart.getUIParentNode(tGNode);
        }
        return n - 1;
    }

    public boolean isLocationInExpandControl(TGNode tGNode, int n, int n2, Rectangle rectangle) {
        if (!this.isShowExpandControl(tGNode)) {
            return false;
        }
        int n3 = TGChart.getRowHeight();
        if (rectangle != null) {
            n2 -= rectangle.y;
            n -= rectangle.x;
        } else {
            n2 %= n3;
        }
        if (n2 < n3 / 2 - 4 || n2 > n3 / 2 + 4) {
            return false;
        }
        int n4 = TGTreeTableCellRenderer.getNodeDepth(tGNode) - 1;
        if (n4 < 0) {
            return false;
        }
        return n >= n4 * 20 + 4 && n <= n4 * 20 + 12;
    }

    public boolean isLocationInRightIcon(TGNode tGNode, int n, int n2, Rectangle rectangle) {
        if (tGNode == null) {
            return false;
        }
        Icon icon = this.computeRightIconForNode(tGNode);
        if (icon == null) {
            return false;
        }
        int n3 = rectangle.x + rectangle.width - n;
        return n3 >= 0 && n3 <= icon.getIconWidth() + 2;
    }

    public int getXTextOffset(TGNode tGNode) {
        if (tGNode == null || tGNode instanceof EmptyNode) {
            return 0;
        }
        int n = TGTreeTableCellRenderer.getNodeDepth(tGNode);
        int n2 = n * 20;
        Icon icon = this.getIconForNode(tGNode);
        if (icon != null) {
            n2 += icon.getIconWidth() + this.getIconTextGap();
        }
        return n2;
    }

    private void setRightIcon(Icon icon) {
        this.border.rightIcon = icon;
    }

    protected Icon getRightIcon() {
        return this.border.rightIcon;
    }

    protected ImageIcon getBasicWBSIcon() {
        if (wbsIcon == null) {
            wbsIcon = new ImageIcon(this.getClass().getResource("/com/triloggroup/gantt/resources/wbs.gif"));
        }
        return wbsIcon;
    }

    protected ImageIcon getBasicSubprojectIcon() {
        if (subprojectIcon == null) {
            subprojectIcon = new ImageIcon(this.getClass().getResource("/com/triloggroup/gantt/resources/project.gif"));
        }
        return subprojectIcon;
    }

    protected ImageIcon getBrokenSubprojectLinkIcon() {
        if (brokenSubprojectLinkIcon == null) {
            brokenSubprojectLinkIcon = new ImageIcon(this.getClass().getResource("/com/triloggroup/gantt/resources/brokenproject.gif"));
        }
        return brokenSubprojectLinkIcon;
    }

    static {
        int n;
        Class<TGTreeTableCellRenderer> clazz = TGTreeTableCellRenderer.class;
        doneIcon = new ImageIcon(clazz.getResource("/com/triloggroup/gantt/resources/task_done.gif"));
        pendingIcons = new Icon[4];
        for (n = 1; n < 4; ++n) {
            TGTreeTableCellRenderer.pendingIcons[n] = new ImageIcon(clazz.getResource("/com/triloggroup/gantt/resources/task_pending_" + n + ".gif"));
        }
        inProgressIcons = new Icon[4];
        for (n = 1; n < 4; ++n) {
            TGTreeTableCellRenderer.inProgressIcons[n] = new ImageIcon(clazz.getResource("/com/triloggroup/gantt/resources/task_inprogress_" + n + ".gif"));
        }
        milestoneDoneIcon = new ImageIcon(clazz.getResource("/com/triloggroup/gantt/resources/milestone_done.gif"));
        milestonePendingIcons = new Icon[4];
        for (n = 1; n < 4; ++n) {
            TGTreeTableCellRenderer.milestonePendingIcons[n] = new ImageIcon(clazz.getResource("/com/triloggroup/gantt/resources/milestone_pending_" + n + ".gif"));
        }
        milestoneInProgressIcons = new Icon[4];
        for (n = 1; n < 4; ++n) {
            TGTreeTableCellRenderer.milestoneInProgressIcons[n] = new ImageIcon(clazz.getResource("/com/triloggroup/gantt/resources/milestone_inprogress_" + n + ".gif"));
        }
        LINE_COLOR = new Color(184, 207, 229);
    }

    class TreeBorder
    implements Border {
        public static final int LEVEL_OFFSET = 20;
        Icon rightIcon;

        TreeBorder() {
        }

        public Insets getBorderInsets(Component component) {
            int n = 1 + TGTreeTableCellRenderer.this.depth * 20;
            int n2 = this.rightIcon == null ? 1 : this.rightIcon.getIconWidth() + 1;
            return new Insets(1, n, 1, n2);
        }

        public boolean isBorderOpaque() {
            return false;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            int n5;
            int n6;
            if (TGTreeTableCellRenderer.this.depth > 0) {
                graphics.setColor(LINE_COLOR);
                n6 = n + 8 - 20;
                for (n5 = TGTreeTableCellRenderer.this.depth - 1; n5 >= 0; --n5) {
                    n6 += 20;
                    if (TGTreeTableCellRenderer.this.levels[n5]) {
                        if (TGTreeTableCellRenderer.this.firstRow) {
                            graphics.drawLine(n6, n2 + n4 / 2, n6, n2 + n4);
                            continue;
                        }
                        graphics.drawLine(n6, n2, n6, n2 + n4);
                        continue;
                    }
                    if (n5 != 0 || TGTreeTableCellRenderer.this.firstRow) continue;
                    graphics.drawLine(n6, n2, n6, n2 + n4 / 2);
                }
                n5 = (n2 + n4) / 2;
                graphics.drawLine(n6, n5, n6 + 10, n5);
                if (TGTreeTableCellRenderer.this.state != 0) {
                    graphics.setColor(Color.BLACK);
                    graphics.drawRect(n6 - 4, n5 - 4, 8, 8);
                    graphics.drawLine(n6 - 2, n5, n6 + 2, n5);
                    if (TGTreeTableCellRenderer.this.state < 0) {
                        graphics.drawLine(n6, n5 - 2, n6, n5 + 2);
                    }
                }
            }
            if (TGTreeTableCellRenderer.this.focusColor != null) {
                graphics.setColor(TGTreeTableCellRenderer.this.focusColor);
                graphics.drawRect(n, n2, n3 - 1, n4 - 1);
            }
            if (this.rightIcon != null) {
                n6 = n + n3 - 1 - this.rightIcon.getIconWidth();
                n5 = n2 + 1 + Math.max(0, (this.rightIcon.getIconHeight() - n4) / 2);
                this.rightIcon.paintIcon(component, graphics, n6, n5);
            }
        }
    }
}

