/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.treetable;

import com.triloggroup.gantt.TGChart;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.treetable.ResourcesRenderer;
import com.triloggroup.gantt.treetable.TGTreeTableCellRenderer;
import com.triloggroup.gantt.treetable.TGTreeTableModel;
import com.triloggroup.project.components.ui.UIConstants;
import com.triloggroup.project.components.ui.table.DateTableCellRenderer;
import com.triloggroup.project.components.ui.table.TGTable;
import com.triloggroup.project.components.ui.table.TGTableCellRenderer;
import com.triloggroup.project.components.ui.table.TGTableHeaderRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TGTreeTable
extends TGTable {
    protected static final int CELL_WIDTH_MARGIN = 5;
    public static final Color EDITABLE_CELL_BORDER_COLOR = new Color(51, 102, 204);
    public static final Color READONLY_CELL_BORDER_COLOR = Color.DARK_GRAY;
    public static final Color READONLY_SELECTED_CELL_BACKGROUND_COLOR = new Color(199, 208, 221);
    protected static final Color READONLY_CELL_BACKGROUND_COLOR = Color.WHITE;
    protected ResourcesRenderer resourcesRenderer;
    protected TGTreeTableCellRenderer treeRenderer;

    public TGTreeTable(TGTreeTableModel tGTreeTableModel, Locale locale, TimeZone timeZone) {
        super(tGTreeTableModel);
        this.setLocale(locale);
        this.resourcesRenderer = new ResourcesRenderer(tGTreeTableModel.chartModel, locale);
        this.updateSelectionModel(this.getSelectionModel());
        this.treeRenderer = this.createTreeTableCellRenderer();
        this.setGridColor(UIConstants.GRID_COLOR);
        this.setSelectionBackground(UIConstants.BACKGROUND_SELECTION_COLOR);
        this.getTableHeader().setDefaultRenderer(new TGTableHeaderRenderer(TGChart.isServerMode));
        boolean bl = tGTreeTableModel.getChartModel().getGlobalContext().isTimePrecision();
        DateTableCellRenderer dateTableCellRenderer = new DateTableCellRenderer(locale, timeZone, bl);
        this.setDefaultRenderer(Date.class, dateTableCellRenderer);
        TGTableCellRenderer tGTableCellRenderer = new TGTableCellRenderer();
        this.setDefaultRenderer(String.class, tGTableCellRenderer);
        this.setResizingAndReorderingPolicy();
        this.updateRenderers();
        this.updateTableInputMap();
    }

    protected TGTreeTableCellRenderer createTreeTableCellRenderer() {
        return new TGTreeTableCellRenderer();
    }

    public TGTreeTableModel getModel() {
        return (TGTreeTableModel)super.getModel();
    }

    public void setVisibleColumns(String[] stringArray) {
        this.getModel().setVisibleColumns(stringArray);
        this.updateRenderers();
    }

    protected void updateRenderers() {
        TGTreeTableModel tGTreeTableModel = this.getModel();
        TableColumnModel tableColumnModel = this.getColumnModel();
        boolean bl = false;
        for (int i = 0; i < tGTreeTableModel.getColumnCount(); ++i) {
            String string = tGTreeTableModel.getColumnKeyName(i);
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            if (string == "Name" || string == "Id") {
                if (bl) continue;
                tableColumn.setCellRenderer(this.treeRenderer);
                bl = true;
                continue;
            }
            if (string == "Resources") {
                tableColumn.setCellRenderer(this.resourcesRenderer);
                continue;
            }
            tableColumn.setCellRenderer(null);
        }
        this.computePreferredWidth();
    }

    protected void updateTableInputMap() {
        InputMap inputMap = this.getInputMap(1);
        InputMap inputMap2 = new InputMap();
        KeyStroke[] keyStrokeArray = inputMap.allKeys();
        if (keyStrokeArray != null) {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(67, 128);
            KeyStroke keyStroke2 = KeyStroke.getKeyStroke(86, 128);
            for (int i = 0; i < keyStrokeArray.length; ++i) {
                if (keyStrokeArray[i].equals(keyStroke) || keyStrokeArray[i].equals(keyStroke2)) continue;
                inputMap2.put(keyStrokeArray[i], inputMap.get(keyStrokeArray[i]));
            }
        }
        this.setInputMap(1, inputMap2);
    }

    protected void setResizingAndReorderingPolicy() {
        this.getTableHeader().setReorderingAllowed(false);
        this.setAutoResizeMode(0);
        TableColumnModel tableColumnModel = this.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            tableColumnModel.getColumn(i).setResizable(false);
        }
    }

    protected void updateSelectionModel(ListSelectionModel listSelectionModel) {
        listSelectionModel.setSelectionMode(0);
    }

    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == TGTreeTableModel.class ? -1 : this.editingRow;
    }

    public void setRowHeight(int n) {
        super.setRowHeight(n);
        if (this.getTableHeader().getDefaultRenderer() instanceof JComponent) {
            JComponent jComponent = (JComponent)((Object)this.getTableHeader().getDefaultRenderer());
            Dimension dimension = new Dimension(10, n);
            jComponent.setMinimumSize(dimension);
            jComponent.setPreferredSize(dimension);
        }
    }

    public int getPreferredWidth() {
        return this.getColumnModel().getTotalColumnWidth();
    }

    public void nodeExpanded() {
        this.computePreferredWidth();
    }

    public void nodeCollapsed() {
        this.computePreferredWidth();
    }

    public TGTreeTableCellRenderer getTreeCellRenderer() {
        return this.treeRenderer;
    }

    public TGNode getNodeAtPoint(Point point) {
        int n = this.rowAtPoint(point);
        return this.getModel().nodeForRow(n);
    }

    public BufferedImage createBufferedImage(int n, int n2) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setPaint(Color.white);
        graphics2D.fillRect(0, 0, n, n2);
        this.printAll(graphics2D, n, n2);
        graphics2D.dispose();
        return bufferedImage;
    }

    public void printAll(Graphics graphics, int n, int n2) {
        this.printAll(graphics, n, n2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void printAll(Graphics graphics, int n, int n2, boolean bl) {
        Dimension dimension = null;
        JTableHeader jTableHeader = this.getTableHeader();
        int n3 = jTableHeader.getHeight();
        if (this.getWidth() != n) {
            if (!TGChart.isServerMode) {
                dimension = this.getSize();
            }
            this.setSize(n, n2);
            jTableHeader.setSize(n, n3);
        }
        try {
            if (bl) {
                graphics.translate(1, 0);
            }
            jTableHeader.printAll(graphics);
            graphics.translate(0, n3);
            super.printAll(graphics);
            graphics.setColor(UIConstants.GRID_COLOR);
            graphics.translate(bl ? -1 : 0, -n3);
            graphics.drawLine(0, 0, n - 1, 0);
            graphics.drawLine(0, 0, 0, n2 - 1);
            graphics.drawLine(0, n2 - 1, n - 1, n2 - 1);
            if (!bl) {
                graphics.drawLine(n - 1, 0, n - 1, n2 - 1);
            }
        }
        finally {
            if (dimension != null) {
                this.setSize(dimension);
                jTableHeader.setSize(dimension.width, n3);
            }
        }
    }

    public void computePreferredWidth() {
        TGTreeTableModel tGTreeTableModel = this.getModel();
        TableColumnModel tableColumnModel = this.tableHeader.getColumnModel();
        int n = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            Component component;
            TableCellRenderer tableCellRenderer;
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            int n2 = this.getHeaderPreferredWidth(i);
            for (int j = 0; j < this.getRowCount(); ++j) {
                tableCellRenderer = this.getCellRenderer(j, i);
                component = tableCellRenderer.getTableCellRendererComponent(this, this.getValueAt(j, i), true, true, j, i);
                n2 = Math.max(n2, this.getPreferredWidth(component));
            }
            n2 += 5;
            if (tGTreeTableModel.getColumnKeyName(i).equals("Resources")) {
                String string = "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaa";
                component = new JLabel(string);
                n2 = Math.min(n2, this.getPreferredWidth(component));
            }
            if (TGChart.isServerMode && tGTreeTableModel.getColumnKeyName(i).equals("Name")) {
                String string = "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa";
                if (this.getRowCount() > 0) {
                    tableCellRenderer = this.getCellRenderer(1, i);
                    component = tableCellRenderer.getTableCellRendererComponent(this, string, false, false, 0, i);
                    n2 = Math.min(n2, this.getPreferredWidth(component));
                } else {
                    component = new JLabel(string);
                    n2 = Math.min(n2, this.getPreferredWidth(component));
                }
            }
            tableColumn.setPreferredWidth(n2);
            tableColumn.setWidth(n2);
        }
        this.invalidate();
    }

    protected int getHeaderPreferredWidth(int n) {
        TableColumn tableColumn = this.columnModel.getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.tableHeader.getDefaultRenderer();
        }
        Component component = tableCellRenderer.getTableCellRendererComponent(this, tableColumn.getHeaderValue(), false, false, 0, n);
        return this.getPreferredWidth(component);
    }

    protected int getPreferredWidth(Component component) {
        ((JComponent)component).setPreferredSize(null);
        return component.getPreferredSize().width;
    }

    public boolean isIgnoreSelectionChange() {
        return false;
    }
}

