/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.renderer;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;

class PredecessorPath {
    private static final int MAX_POINTS = 6;
    private int nbPoints;
    private int[] xPoints = new int[6];
    private int[] yPoints = new int[6];
    private boolean[] horizontal;
    private boolean[] up;

    public PredecessorPath(double d, double d2) {
        this.xPoints[0] = (int)Math.floor(d + 0.5);
        this.yPoints[0] = (int)Math.floor(d2 + 0.5);
        this.nbPoints = 1;
        this.horizontal = new boolean[5];
        this.up = new boolean[5];
    }

    public void moveX(double d) {
        this.xPoints[this.nbPoints] = (int)Math.floor(d + 0.5);
        this.yPoints[this.nbPoints] = this.yPoints[this.nbPoints - 1];
        this.horizontal[this.nbPoints - 1] = true;
        this.up[this.nbPoints - 1] = d > (double)this.xPoints[this.nbPoints - 1];
        ++this.nbPoints;
    }

    public void moveY(double d) {
        this.xPoints[this.nbPoints] = this.xPoints[this.nbPoints - 1];
        this.yPoints[this.nbPoints] = (int)Math.floor(d + 0.5);
        this.horizontal[this.nbPoints - 1] = false;
        this.up[this.nbPoints - 1] = d > (double)this.yPoints[this.nbPoints - 1];
        ++this.nbPoints;
    }

    public Shape createPath() {
        GeneralPath generalPath = new GeneralPath(1, this.nbPoints);
        generalPath.moveTo(this.xPoints[0], this.yPoints[0]);
        for (int i = 1; i < this.nbPoints; ++i) {
            generalPath.lineTo(this.xPoints[i], this.yPoints[i]);
        }
        return generalPath;
    }

    public void draw(Graphics2D graphics2D) {
        int n = this.xPoints[0];
        int n2 = this.yPoints[0];
        for (int i = 1; i < this.nbPoints; ++i) {
            int n3 = n;
            int n4 = n2;
            n = this.xPoints[i];
            n2 = this.yPoints[i];
            graphics2D.drawLine(n3, n4, n, n2);
        }
    }

    public Shape createThickPath(int n) {
        int n2;
        int n3;
        int n4;
        GeneralPath generalPath = new GeneralPath(1, this.nbPoints * 2);
        if (this.horizontal[0]) {
            n4 = 0;
            n3 = n;
        } else {
            n4 = n;
            n3 = 0;
        }
        generalPath.moveTo(this.xPoints[0] + n4, this.yPoints[0] + n3);
        for (n2 = 1; n2 < this.nbPoints; ++n2) {
            if (this.horizontal[n2 - 1]) {
                n4 = n2 == this.nbPoints - 1 ? 0 : (this.up[n2 - 1] ^ this.up[n2] ? n3 : -n3);
            } else {
                n3 = n2 == this.nbPoints - 1 ? 0 : (this.up[n2 - 1] ^ this.up[n2] ? n4 : -n4);
            }
            generalPath.lineTo(this.xPoints[n2] + n4, this.yPoints[n2] + n3);
        }
        if (this.horizontal[this.nbPoints - 2]) {
            n3 = -n3;
        } else {
            n4 = -n4;
        }
        generalPath.lineTo(this.xPoints[this.nbPoints - 1] + n4, this.yPoints[this.nbPoints - 1] + n3);
        for (n2 = this.nbPoints - 2; n2 > -1; --n2) {
            if (this.horizontal[n2]) {
                n4 = n2 == 0 ? 0 : (this.up[n2 - 1] ^ this.up[n2] ? n3 : -n3);
            } else {
                n3 = n2 == 0 ? 0 : (this.up[n2 - 1] ^ this.up[n2] ? n4 : -n4);
            }
            generalPath.lineTo(this.xPoints[n2] + n4, this.yPoints[n2] + n3);
        }
        generalPath.closePath();
        return generalPath;
    }

    public Shape createCriticalPath() {
        int n;
        int n2;
        GeneralPath generalPath = new GeneralPath(1, this.nbPoints * 2);
        int n3 = 1;
        int n4 = 0;
        if (this.horizontal[0]) {
            n2 = 0;
            n = -n3;
            n4 = this.up[0] ? n3 : -n3;
        } else {
            n2 = n3;
            n = 0;
        }
        generalPath.moveTo(this.xPoints[0] + n2 + n4, this.yPoints[0] + n);
        for (int i = 1; i < this.nbPoints; ++i) {
            if (this.horizontal[i - 1]) {
                n2 = i == this.nbPoints - 1 ? (this.up[0] ? -n3 : n3) : (this.up[i - 1] ^ this.up[i] ? n : -n);
            } else {
                n = i == this.nbPoints - 1 ? 0 : (this.up[i - 1] ^ this.up[i] ? n2 : -n2);
            }
            generalPath.lineTo(this.xPoints[i] + n2, this.yPoints[i] + n);
        }
        return generalPath;
    }
}

