/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.pe.app.ws;

import com.flowbuilder.util.xml.JDOMUtil;
import com.triloggroup.gantt.CriticalPathRuntimeConf;
import com.triloggroup.gantt.GanttChartException;
import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GanttWBS;
import com.triloggroup.gantt.Resource;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.TaskResource;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.AppProjectModel;
import com.triloggroup.gantt.app.UserPreferences;
import com.triloggroup.gantt.app.change.Change;
import com.triloggroup.gantt.app.change.CloneChange;
import com.triloggroup.gantt.app.change.FieldModification;
import com.triloggroup.gantt.app.change.ParentFieldValue;
import com.triloggroup.gantt.app.change.ReorderChildrenChange;
import com.triloggroup.gantt.app.filter.AdvancedFilter;
import com.triloggroup.gantt.pe.app.ChangeResult;
import com.triloggroup.gantt.pe.app.PEAppProjectContext;
import com.triloggroup.gantt.pe.app.PEUserPreferences;
import com.triloggroup.gantt.pe.app.ws.WebServiceHelper;
import com.triloggroup.project.NameId;
import com.triloggroup.project.components.ObjectType;
import com.triloggroup.project.components.resourceeditor.CostRate;
import com.triloggroup.project.components.resourceeditor.ProjectResource;
import com.triloggroup.project.components.resourceeditor.ProjectRole;
import com.triloggroup.project.components.resourceeditor.ProjectTeam;
import com.triloggroup.project.components.resourceeditor.change.ReplaceResourceChange;
import com.triloggroup.project.financial.CostRates;
import com.triloggroup.project.financial.ICostRate;
import com.triloggroup.project.financial.VariableCost;
import com.triloggroup.project.schedule.Predecessor;
import com.triloggroup.util.UString;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GanttWSHelper
extends WebServiceHelper {
    public GanttWSHelper(PEAppProjectContext pEAppProjectContext) {
        super(pEAppProjectContext, "GanttChartWS");
    }

    public Element getScheduleDataFromWS(int n) throws Exception {
        Element element = this.createSOAPDoc("getScheduleData");
        element.addContent(this.createStringSOAPParamElt("sessionId", this.getSessionId()));
        element.addContent(this.createStringSOAPParamElt("siteId", this.getSiteId()));
        element.addContent(this.createStringSOAPParamElt("projectId", this.getProjectId()));
        element.addContent(this.createIntSOAPParamElt("dataType", n));
        Element element2 = this.callWebService(element);
        if (element2 != null) {
            return this.getResultElement(element2);
        }
        throw new GanttChartException("No valid data in web service response");
    }

    public Element getNodesDataFromWS(String[] stringArray, int n) throws Exception {
        Element element = this.createSOAPDoc("getNodesData");
        element.addContent(this.createStringSOAPParamElt("sessionId", this.getSessionId()));
        element.addContent(this.createStringSOAPParamElt("siteId", this.getSiteId()));
        element.addContent(this.createStringSOAPParamElt("projectId", this.getProjectId()));
        element.addContent(this.createStringArraySOAPParamElt("nodeIds", stringArray));
        element.addContent(this.createIntSOAPParamElt("timesheetLevel", n));
        Element element2 = this.callWebService(element);
        if (element2 != null) {
            return this.getResultElement(element2);
        }
        throw new GanttChartException("No valid data in web service response");
    }

    public Element getSubprojectData(String string) throws Exception {
        Element element = this.createSOAPDoc("getSubprojectData");
        element.addContent(this.createStringSOAPParamElt("sessionId", this.getSessionId()));
        element.addContent(this.createStringSOAPParamElt("siteId", this.getSiteId()));
        element.addContent(this.createStringSOAPParamElt("projectId", string));
        Element element2 = this.callWebService(element);
        if (element2 != null) {
            return this.getResultElement(element2);
        }
        throw new GanttChartException("No valid data in web service response");
    }

    public Element getResourcesDataFromWS(String[] stringArray) throws Exception {
        Element element = this.createSOAPDoc("getProjectResourcesByDn");
        element.addContent(this.createStringSOAPParamElt("sessionId", this.getSessionId()));
        element.addContent(this.createStringSOAPParamElt("siteId", this.getSiteId()));
        element.addContent(this.createStringSOAPParamElt("projectId", this.getProjectId()));
        element.addContent(this.createStringArraySOAPParamElt("dns", stringArray));
        Element element2 = this.callWebService(element);
        if (element2 != null) {
            return element2;
        }
        throw new GanttChartException("No valid data in web service response");
    }

    public Element getAlertsMetadataFromWS() throws Exception {
        Element element = this.createSOAPDoc("getAlertsMetadata");
        element.addContent(this.createStringSOAPParamElt("sessionId", this.getSessionId()));
        element.addContent(this.createStringSOAPParamElt("siteId", this.getSiteId()));
        element.addContent(this.createStringSOAPParamElt("projectId", this.getProjectId()));
        Element element2 = this.callWebService(element);
        if (element2 != null) {
            return element2;
        }
        throw new GanttChartException("No valid data in web service response");
    }

    public Document getCalendarsFromWS() throws Exception {
        Element element = this.createSOAPDoc("getAllCalendars");
        element.addContent(this.createStringSOAPParamElt("sessionId", this.getSessionId()));
        element.addContent(this.createStringSOAPParamElt("siteId", this.getSiteId()));
        element.addContent(this.createStringSOAPParamElt("projectId", this.getProjectId()));
        Element element2 = this.callWebService(element);
        if (element2 != null) {
            Element element3 = element2.getChild("Calendars");
            element3.getParent().removeContent(element3);
            Document document = new Document();
            document.setRootElement(element3);
            return document;
        }
        throw new GanttChartException("No valid data in web service response");
    }

    public ChangeResult[] applyChangesByWS(ArrayList<Change> arrayList) throws Exception {
        Element element = this.createSOAPDoc("applyChanges");
        element.addContent(this.createStringSOAPParamElt("sessionId", this.getSessionId()));
        Element element2 = new Element("changesElt");
        element2.setAttribute("type", "apachesoap:Element", xsiNs);
        element.addContent(element2);
        Element element3 = this.createChangesElementTree(arrayList);
        element2.addContent(element3);
        element.addContent(this.createStringSOAPParamElt("siteId", this.getSiteId()));
        Element element4 = this.callWebService(element);
        if (element4 != null) {
            List list = element4.getChildren("applyChangesReturn");
            ChangeResult[] changeResultArray = new ChangeResult[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Element element5 = (Element)list.get(i);
                changeResultArray[i] = new ChangeResult(JDOMUtil.getString(element5, "id"), JDOMUtil.getInteger(element5, "resultCode"), JDOMUtil.getString(element5, "targetType"), JDOMUtil.getString(element5, "projectId"));
                String string = JDOMUtil.getString(element5, "message");
                if (UString.isEmpty(string)) continue;
                changeResultArray[i].setMessage(string);
            }
            return changeResultArray;
        }
        throw new GanttChartException("No valid data in web service response");
    }

    protected Element createChangesElementTree(ArrayList<Change> arrayList) {
        Element element = new Element("changesElt");
        for (Change change : arrayList) {
            String[][] stringArray;
            Element element2;
            Object object;
            String[] stringArray2;
            Object object2;
            Element element3 = new Element("change");
            element.addContent(element3);
            String string = null;
            switch (change.getOperation()) {
                case 0: {
                    string = "update";
                    break;
                }
                case 2: {
                    string = "delete";
                    break;
                }
                case 1: {
                    string = "new";
                    break;
                }
                case 3: {
                    string = "clone";
                    break;
                }
                case 6: {
                    string = "transformIntoWbs";
                    break;
                }
                case 7: {
                    string = "transformIntoTask";
                    break;
                }
                case 4: {
                    string = "reorder";
                    break;
                }
                case 5: {
                    string = "replace";
                }
            }
            element3.setAttribute("operation", string);
            ObjectType objectType = change.getTargetType();
            element3.setAttribute("targetType", objectType.code);
            element3.setAttribute("projectId", change.getTarget().getProjectId());
            Element element4 = new Element("id");
            element4.setText(change.getTarget().getUid());
            element3.addContent(element4);
            if (objectType == ProjectResource.TYPE) {
                if (change.getOperation() == 5) {
                    object2 = (ReplaceResourceChange)change;
                    stringArray2 = new Element("newResource");
                    element3.addContent((Element)stringArray2);
                    Element element5 = new Element("cn");
                    stringArray2.addContent(element5);
                    element5.setText(((ReplaceResourceChange)object2).getNewResource().getCn());
                    object = new Element("dn");
                    stringArray2.addContent(object);
                    object.setText(((ReplaceResourceChange)object2).getNewResource().getDn());
                    element2 = new Element("email");
                    stringArray2.addContent(element2);
                    element2.setText(((ReplaceResourceChange)object2).getNewResource().getEmail());
                    stringArray = new Element("options");
                    element3.addContent((Element)stringArray);
                    stringArray.setText(((ReplaceResourceChange)object2).getOptionsAsString());
                    continue;
                }
                object2 = change.getFieldModifications();
                for (int i = 0; i < object2.size(); ++i) {
                    FieldModification fieldModification = (FieldModification)object2.get(i);
                    object = this.createModificationXML(fieldModification);
                    element3.addContent(object);
                }
                continue;
            }
            if (objectType == ProjectTeam.TYPE || objectType == ProjectRole.TYPE) {
                object2 = change.getFieldModifications();
                for (int i = 0; i < object2.size(); ++i) {
                    FieldModification fieldModification = (FieldModification)object2.get(i);
                    object = this.createModificationXML(fieldModification);
                    element3.addContent(object);
                }
                continue;
            }
            object2 = (GanttNode)change.getTarget();
            element3.setAttribute("lastModificationDate", Long.toString(((TGNode)object2).getLastModificationTime()));
            if (change.getOperation() == 3) {
                stringArray2 = new Element("targetParentId");
                element3.addContent((Element)stringArray2);
                GanttWBS ganttWBS = ((CloneChange)change).getNewParent();
                stringArray2.setText(ganttWBS.getUid());
                if (!UString.equals(((GanttNode)object2).getProjectId(), ganttWBS.getProjectId())) {
                    stringArray2.setAttribute("projectid", ganttWBS.getProjectId());
                }
                object = new Element("name");
                element3.addContent(object);
                object.setText(((CloneChange)change).getNewName());
                element2 = new Element("internalNodeIds");
                element3.addContent(element2);
                stringArray = ((CloneChange)change).getUids();
                for (int i = 0; i < stringArray.length; ++i) {
                    Element element6 = new Element("ids");
                    element2.addContent(element6);
                    Element element7 = new Element("src");
                    element6.addContent(element7);
                    element7.setText(stringArray[i][0]);
                    Element element8 = new Element("clone");
                    element6.addContent(element8);
                    element8.setText(stringArray[i][1]);
                }
                continue;
            }
            if (change.getOperation() == 4) {
                stringArray2 = ((ReorderChildrenChange)change).getUids();
                for (int i = 0; i < stringArray2.length; ++i) {
                    object = new Element("childId");
                    object.setText(stringArray2[i]);
                    element3.addContent(object);
                }
                continue;
            }
            stringArray2 = change.getFieldModifications();
            for (int i = 0; i < stringArray2.size(); ++i) {
                object = (FieldModification)stringArray2.get(i);
                element2 = this.createModificationXML((FieldModification)object);
                element3.addContent(element2);
            }
        }
        return element;
    }

    protected Element createModificationXML(FieldModification fieldModification) {
        Element element = new Element("modification");
        Element element2 = new Element("field");
        element2.setText(fieldModification.field);
        element.addContent(element2);
        Element element3 = new Element("value");
        element.addContent(element3);
        if (UString.equals(fieldModification.field, "parentInternalId")) {
            ParentFieldValue parentFieldValue = (ParentFieldValue)fieldModification.newValue;
            element3.setText(parentFieldValue.parentUid);
        } else if (UString.equals(fieldModification.field, "remainWork") || UString.equals(fieldModification.field, "actualWork")) {
            Number number = (Number)fieldModification.newValue;
            if (number != null && number.doubleValue() >= 0.0) {
                element3.setText(number.toString());
            }
        } else if (UString.equals(fieldModification.field, "taskResources")) {
            TaskResource[] taskResourceArray = (TaskResource[])fieldModification.newValue;
            if (taskResourceArray != null) {
                for (int i = 0; i < taskResourceArray.length; ++i) {
                    Element element4 = new Element("taskResource");
                    element3.addContent(element4);
                    Element element5 = new Element("dn");
                    element4.addContent(element5);
                    element5.setText(taskResourceArray[i].getDn());
                    Element element6 = new Element("cn");
                    element4.addContent(element6);
                    element6.setText(taskResourceArray[i].getCn());
                    Element element7 = new Element("units");
                    element4.addContent(element7);
                    element7.setText(String.valueOf(taskResourceArray[i].getUnit()));
                    if (!taskResourceArray[i].isWorkSpecified()) continue;
                    Element element8 = new Element("work");
                    element4.addContent(element8);
                    element8.setText(String.valueOf(taskResourceArray[i].getWork()));
                }
            }
        } else if (UString.equals(fieldModification.field, "taskPredecessors")) {
            List list = (List)fieldModification.newValue;
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    Predecessor predecessor = (Predecessor)list.get(i);
                    Element element9 = new Element("taskPredecessor");
                    element3.addContent(element9);
                    Element element10 = new Element("predecessorid");
                    element9.addContent(element10);
                    element10.setText(predecessor.getId());
                    Element element11 = new Element("type");
                    element9.addContent(element11);
                    element11.setText(Predecessor.predecessorTypeAsString(predecessor.getType()));
                    Element element12 = new Element("lag");
                    element9.addContent(element12);
                    element12.setText(String.valueOf(predecessor.getLag()));
                    Element element13 = new Element("lagformat");
                    element9.addContent(element13);
                    element13.setText(String.valueOf(predecessor.getLagFormat()));
                }
            }
        } else if (UString.equals(fieldModification.field, "wbsSupervisors")) {
            Resource[] resourceArray = (Resource[])fieldModification.newValue;
            if (resourceArray != null) {
                for (int i = 0; i < resourceArray.length; ++i) {
                    Element element14 = new Element("Resource");
                    element3.addContent(element14);
                    Element element15 = new Element("dn");
                    element14.addContent(element15);
                    element15.setText(resourceArray[i].getDn());
                    Element element16 = new Element("cn");
                    element14.addContent(element16);
                    element16.setText(resourceArray[i].getCn());
                }
            }
        } else if (UString.equals(fieldModification.field, "CostRate")) {
            CostRates costRates = (CostRates)fieldModification.newValue;
            ICostRate iCostRate = costRates.defaultCost;
            Element element17 = new Element("default");
            element17.setText(String.valueOf(iCostRate.getCost()));
            element17.setAttribute("unit", iCostRate.getRateUnitCode());
            element3.addContent(element17);
            VariableCost[] variableCostArray = costRates.variableCosts;
            if (variableCostArray != null) {
                for (VariableCost variableCost : variableCostArray) {
                    Element element18 = new Element("variablecost");
                    Element element19 = new Element("from");
                    element19.setText(JDOMUtil.toString(variableCost.from));
                    element18.addContent(element19);
                    Element element20 = new Element("costrate");
                    element20.setText(String.valueOf(variableCost.costRate.getCost()));
                    element18.addContent(element20);
                    Element element21 = new Element("costrateunit");
                    element21.setText(variableCost.costRate.getRateUnitCode());
                    element18.addContent(element21);
                    element3.addContent(element18);
                }
            }
        } else {
            Object object = fieldModification.newValue;
            if (object != null) {
                if (object instanceof Date) {
                    element3.setText(JDOMUtil.toString((Date)object));
                } else if (object instanceof CostRate) {
                    CostRate costRate = (CostRate)object;
                    element3.setText(String.valueOf(costRate.getCost()));
                    element3.setAttribute("unit", costRate.getRateUnit().code);
                } else if (object instanceof NameId) {
                    element3.setText(((NameId)object).getId());
                } else {
                    element3.setText(object.toString());
                }
            }
        }
        return element;
    }

    public String getResourceCnByDn(String string) throws Exception {
        Element element = this.createSOAPDoc("getResourceCnByDn");
        element.addContent(this.createStringSOAPParamElt("sessionId", this.getSessionId()));
        element.addContent(this.createStringSOAPParamElt("resourceDn", string));
        Element element2 = this.callWebService(element);
        if (element2 != null) {
            return element2.getText();
        }
        throw new GanttChartException("No valid data in web service response");
    }

    public NameId[] getAvailableSubprojects(String[] stringArray, String[] stringArray2) throws Exception {
        Element element = this.createSOAPDoc("getAvailableSubprojects");
        element.addContent(this.createStringSOAPParamElt("sessionId", this.getSessionId()));
        element.addContent(this.createStringSOAPParamElt("siteId", this.getSiteId()));
        element.addContent(this.createStringSOAPParamElt("projectId", this.getProjectId()));
        element.addContent(this.createStringArraySOAPParamElt("allSubProjectRefs", stringArray));
        element.addContent(this.createStringArraySOAPParamElt("loadedProjects", stringArray2));
        Element element2 = this.callWebService(element);
        if (element2 != null) {
            List list = element2.getChildren("getAvailableSubprojectsReturn");
            NameId[] nameIdArray = new NameId[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Element element3 = (Element)list.get(i);
                nameIdArray[i] = new NameId(JDOMUtil.getString(element3, "name"), JDOMUtil.getString(element3, "id"));
            }
            return nameIdArray;
        }
        throw new GanttChartException("No valid data in web service response");
    }

    private Element getResultElement(Element element) {
        Element element2 = element.getChild("result");
        if (element2 == null) {
            element2 = element.getChild("ViewContent");
        }
        return element2;
    }

    public UserPreferences getUserPreferences(AppProjectModel appProjectModel) throws Exception {
        Element element = this.createSOAPDoc("getUserPreferences");
        element.addContent(this.createStringSOAPParamElt("sessionId", this.getSessionId()));
        element.addContent(this.createStringSOAPParamElt("siteId", this.getSiteId()));
        element.addContent(this.createStringSOAPParamElt("projectId", this.getProjectId()));
        Element element2 = this.callWebService(element);
        if (element2 != null) {
            int n;
            Element element3 = element2.getChild("cpConf");
            CriticalPathRuntimeConf criticalPathRuntimeConf = new CriticalPathRuntimeConf();
            if (element3 != null) {
                criticalPathRuntimeConf.setDisplayCriticalPath(UString.equalsIgnoreCase(element3.getChildText("displayCriticalPath"), "true"));
                criticalPathRuntimeConf.setDisplayNearCritical(UString.equalsIgnoreCase(element3.getChildText("displayNearCritical"), "true"));
                criticalPathRuntimeConf.setDisplayLateDates(UString.equalsIgnoreCase(element3.getChildText("displayLateDates"), "true"));
                try {
                    criticalPathRuntimeConf.setSlackDisplayUnitCode(Integer.parseInt(element3.getChildText("slackDisplayUnitCode")));
                    criticalPathRuntimeConf.setNearCriticalSlackValue(Integer.parseInt(element3.getChildText("nearCriticalSlackValue")));
                    criticalPathRuntimeConf.setNearCriticalSlackUnitCode(Integer.parseInt(element3.getChildText("nearCriticalSlackUnitCode")));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            List list = element2.getChildren("columns");
            String[] stringArray = new String[list.size()];
            for (n = 0; n < list.size(); ++n) {
                Element element4 = (Element)list.get(n);
                stringArray[n] = element4.getText();
            }
            n = -1;
            try {
                n = Integer.parseInt(element2.getChildText("wbsLevel"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            int n2 = -1;
            try {
                n2 = Integer.parseInt(element2.getChildText("fontSize"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n2 <= 0) {
                n2 = 11;
            }
            boolean bl = UString.equalsIgnoreCase(element2.getChildText("showFinancialTracking"), "true");
            String string = element2.getChildText("highlightOverallocationsMode");
            UserPreferences.HighlightOverallocationsMode highlightOverallocationsMode = UserPreferences.HighlightOverallocationsMode.PROJECT.name().equals(string) ? UserPreferences.HighlightOverallocationsMode.PROJECT : UserPreferences.HighlightOverallocationsMode.NONE;
            PEUserPreferences pEUserPreferences = new PEUserPreferences(this, criticalPathRuntimeConf, stringArray, n, n2, bl, highlightOverallocationsMode);
            try {
                String string2 = null;
                Element element5 = element2.getChild("defaultFilter");
                if (element5 != null) {
                    string2 = element5.getText();
                }
                ArrayList<AdvancedFilter> arrayList = new ArrayList<AdvancedFilter>();
                List list2 = element2.getChildren("filters");
                try {
                    for (Object e : list2) {
                        Element element6 = (Element)e;
                        String string3 = element6.getChildText("id");
                        AdvancedFilter advancedFilter = new AdvancedFilter(string3);
                        String string4 = element6.getChildText("name");
                        if (UString.isEmpty(string4)) {
                            string4 = AppGanttChart.NLS_BUNDLE.getString("filter_defaultName");
                        }
                        advancedFilter.setName(string4);
                        advancedFilter.setSharedAcrossProjects(UString.isEmpty(element6.getChildText("projectId")));
                        advancedFilter.setHideEmptyWBS(UString.equalsIgnoreCase(element6.getChildText("hideEmptyWBS"), "true"));
                        List list3 = element6.getChildren("criteria");
                        String[] stringArray2 = new String[list3.size()];
                        for (int i = 0; i < stringArray2.length; ++i) {
                            stringArray2[i] = ((Element)list3.get(i)).getText();
                        }
                        advancedFilter.loadCriteria(appProjectModel, stringArray2);
                        arrayList.add(advancedFilter);
                    }
                }
                catch (Exception exception) {
                    System.out.println("Unable to load a filter");
                    exception.printStackTrace();
                }
                pEUserPreferences.initFilters(arrayList, string2);
            }
            catch (Exception exception) {
                System.out.println("Unable to load filter preferences");
                exception.printStackTrace();
            }
            if (UString.equals("true", element2.getChildText("paintDeadline"))) {
                pEUserPreferences.initPaintDeadline(true);
            }
            if (UString.equals("true", element2.getChildText("paintActualDates"))) {
                pEUserPreferences.initPaintActualDates(true);
            }
            boolean bl2 = false;
            bl2 = UString.equals("true", element2.getChildText("recentCommentsHighlight"));
            int n3 = 1;
            try {
                n3 = Integer.parseInt(element2.getChildText("recentCommentsDays"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            pEUserPreferences.initRecentComments(bl2, n3);
            return pEUserPreferences;
        }
        throw new GanttChartException("No valid data in web service response");
    }

    public void setUserPreferenceTableColumns(String[] stringArray) throws Exception {
        Element element = this.createSOAPDoc("setUserPreferenceTableColumns");
        element.addContent(this.createStringSOAPParamElt("sessionId", this.getSessionId()));
        element.addContent(this.createStringArraySOAPParamElt("columns", stringArray));
        this.callWebService(element.getDocument());
    }

    public void setUserPreferenceWbsLevel(int n) throws Exception {
        Element element = this.createSOAPDoc("setUserPreferenceWbsLevel");
        element.addContent(this.createStringSOAPParamElt("sessionId", this.getSessionId()));
        element.addContent(this.createIntSOAPParamElt("level", n));
        this.callWebService(element.getDocument());
    }

    public void deleteUserPreferenceFilter(String string) throws Exception {
        Element element = this.createSOAPDoc("userPreferenceDeleteFilter");
        element.addContent(this.createStringSOAPParamElt("sessionId", this.getSessionId()));
        element.addContent(this.createStringSOAPParamElt("filterId", string));
        element.addContent(this.createStringSOAPParamElt("siteId", this.getSiteId()));
        element.addContent(this.createStringSOAPParamElt("projectId", this.getProjectId()));
        this.callWebService(element.getDocument());
    }

    public void setUserPreferenceDefaultFilter(String string) throws Exception {
        Element element = this.createSOAPDoc("userPreferenceSetDefaultFilter");
        element.addContent(this.createStringSOAPParamElt("sessionId", this.getSessionId()));
        element.addContent(this.createStringSOAPParamElt("filterId", string));
        element.addContent(this.createStringSOAPParamElt("siteId", this.getSiteId()));
        element.addContent(this.createStringSOAPParamElt("projectId", this.getProjectId()));
        this.callWebService(element.getDocument());
    }

    public void saveUserPreferenceFilter(AdvancedFilter advancedFilter) throws Exception {
        String[] stringArray;
        Element element = this.createSOAPDoc("userPreferenceSaveFilter");
        Element element2 = new Element("filter");
        element2.addContent(this.createStringSOAPParamElt("id", advancedFilter.getId()));
        element2.addContent(this.createStringSOAPParamElt("name", advancedFilter.getName()));
        if (!advancedFilter.isSharedAcrossProjects()) {
            element2.addContent(this.createStringSOAPParamElt("projectId", this.getProjectId()));
        }
        element2.addContent(this.createBooleanSOAPParamElt("hideEmptyWBS", advancedFilter.isHideEmptyWBS()));
        for (String string : stringArray = advancedFilter.saveCriteria()) {
            Element element3 = new Element("criteria");
            element3.setText(string);
            element2.addContent(element3);
        }
        element.addContent(this.createStringSOAPParamElt("sessionId", this.getSessionId()));
        element.addContent(element2);
        element.addContent(this.createStringSOAPParamElt("siteId", this.getSiteId()));
        element.addContent(this.createStringSOAPParamElt("projectId", this.getProjectId()));
        this.callWebService(element.getDocument());
    }

    public void setUserPreferenceCriticalPathConf(CriticalPathRuntimeConf criticalPathRuntimeConf) throws Exception {
        Element element = this.createSOAPDoc("setUserPreferenceCriticalPathConf");
        element.addContent(this.createStringSOAPParamElt("sessionId", this.getSessionId()));
        Element element2 = new Element("cpConf");
        element2.addContent(this.createBooleanSOAPParamElt("displayCriticalPath", criticalPathRuntimeConf.getDisplayCriticalPath()));
        element2.addContent(this.createBooleanSOAPParamElt("displayNearCritical", criticalPathRuntimeConf.getDisplayNearCritical()));
        element2.addContent(this.createBooleanSOAPParamElt("displayLateDates", criticalPathRuntimeConf.getDisplayLateDates()));
        element2.addContent(this.createIntSOAPParamElt("slackDisplayUnitCode", criticalPathRuntimeConf.getSlackDisplayUnitCode()));
        element2.addContent(this.createIntSOAPParamElt("nearCriticalSlackValue", criticalPathRuntimeConf.getNearCriticalSlackValue()));
        element2.addContent(this.createIntSOAPParamElt("nearCriticalSlackUnitCode", criticalPathRuntimeConf.getNearCriticalSlackUnitCode()));
        element.addContent(element2);
        this.callWebService(element2.getDocument());
    }

    public void setUserPreferenceFontSize(int n) throws Exception {
        Element element = this.createSOAPDoc("setUserPreferenceFontSize");
        element.addContent(this.createStringSOAPParamElt("sessionId", this.getSessionId()));
        element.addContent(this.createIntSOAPParamElt("fontSize", n));
        this.callWebService(element.getDocument());
    }

    public void setUserPreferenceShowFinancialTracking(boolean bl) throws Exception {
        Element element = this.createSOAPDoc("setUserPreferenceShowFinancialTracking");
        element.addContent(this.createStringSOAPParamElt("sessionId", this.getSessionId()));
        element.addContent(this.createBooleanSOAPParamElt("showFinancialTracking", bl));
        this.callWebService(element.getDocument());
    }

    public void setUserPreferenceHighlightOverallocationsMode(UserPreferences.HighlightOverallocationsMode highlightOverallocationsMode) throws Exception {
        Element element = this.createSOAPDoc("setUserPreferenceHighlightOverallocationsMode");
        element.addContent(this.createStringSOAPParamElt("sessionId", this.getSessionId()));
        element.addContent(this.createStringSOAPParamElt("highlightOverallocationsMode", highlightOverallocationsMode.name()));
        this.callWebService(element.getDocument());
    }

    public void setUserPreferencePaintActualDates(boolean bl) throws Exception {
        Element element = this.createSOAPDoc("setUserPreferencePaintActualDates");
        element.addContent(this.createStringSOAPParamElt("sessionId", this.getSessionId()));
        element.addContent(this.createBooleanSOAPParamElt("flag", bl));
        this.callWebService(element.getDocument());
    }

    public void setUserPreferencePaintDeadline(boolean bl) throws Exception {
        Element element = this.createSOAPDoc("setUserPreferencePaintDeadline");
        element.addContent(this.createStringSOAPParamElt("sessionId", this.getSessionId()));
        element.addContent(this.createBooleanSOAPParamElt("flag", bl));
        this.callWebService(element.getDocument());
    }

    public void setUserPreferenceRecentCommentsHighlight(boolean bl, int n) throws Exception {
        Element element = this.createSOAPDoc("setUserPreferenceRecentCommentsHighlight");
        element.addContent(this.createStringSOAPParamElt("sessionId", this.getSessionId()));
        element.addContent(this.createBooleanSOAPParamElt("highlight", bl));
        element.addContent(this.createIntSOAPParamElt("days", n));
        this.callWebService(element.getDocument());
    }

    public long getServerTime() throws Exception {
        Element element = this.createSOAPDoc("getTime");
        Element element2 = this.callWebService(element);
        if (element2 != null) {
            return Long.parseLong(element2.getText());
        }
        throw new GanttChartException("No valid data in web service response");
    }
}

