/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.pe.app.social;

import com.flowbuilder.util.xml.JDOMUtil;
import com.triloggroup.gantt.GanttChartException;
import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GanttWBS;
import com.triloggroup.gantt.app.social.ISocialDataProvider;
import com.triloggroup.gantt.pe.app.PEAppProjectContext;
import com.triloggroup.gantt.pe.app.ws.WebServiceHelper;
import com.triloggroup.project.social.Bookmark;
import com.triloggroup.project.social.BookmarksAndComments;
import com.triloggroup.project.social.CommentEntry;
import com.triloggroup.project.social.CustomBookmark;
import com.triloggroup.project.social.NotificationConfig;
import com.triloggroup.project.social.NotificationItem;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import org.jdom.Element;
import org.jdom.Namespace;

public class SocialWSHelper
extends WebServiceHelper
implements ISocialDataProvider {
    private static final String xsiNs_prefix = "xsi";
    private static final String xsiNs_uri = "http://www.w3.org/2001/XMLSchema-instance";
    protected static final Namespace xsiNs = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
    private static final String socialNs_prefix = "pesocial";
    private static final String socialNs_uri = "http://social.project.triloggroup.com";
    private static final Namespace socialNs = Namespace.getNamespace((String)"pesocial", (String)"http://social.project.triloggroup.com");

    public SocialWSHelper(PEAppProjectContext pEAppProjectContext) {
        super(pEAppProjectContext, "SocialWS");
    }

    protected Element createSOAPDoc(String string) {
        Element element = super.createSOAPDoc(string);
        element.addNamespaceDeclaration(socialNs);
        return element;
    }

    public BookmarksAndComments getBookmarksAndComments(GanttNode ganttNode) throws Exception {
        Element element = this.createSOAPDoc("getBookmarksAndComments");
        String string = this.getProjectId();
        String string2 = ganttNode.getUid();
        if (GanttNode.isSubprojectLink(ganttNode)) {
            string = ((GanttWBS)ganttNode).getSubProject().getId();
            string2 = null;
        }
        element.addContent(this.createStringSOAPParamElt("sessionId", this.getSessionId()));
        element.addContent(this.createStringSOAPParamElt("siteId", this.getSiteId()));
        element.addContent(this.createStringSOAPParamElt("projectId", string));
        element.addContent(this.createStringSOAPParamElt("nodeUid", string2));
        Element element2 = this.callWebService(element);
        if (element2 != null) {
            BookmarksAndComments bookmarksAndComments = new BookmarksAndComments();
            List list = element2.getChildren("bookmarks");
            Bookmark[] bookmarkArray = new Bookmark[list.size()];
            for (int i = 0; i < bookmarkArray.length; ++i) {
                bookmarkArray[i] = this.readBookmark((Element)list.get(i));
            }
            bookmarksAndComments.bookmarks = bookmarkArray;
            List list2 = element2.getChildren("comments");
            CommentEntry[] commentEntryArray = new CommentEntry[list2.size()];
            for (int i = 0; i < commentEntryArray.length; ++i) {
                commentEntryArray[i] = this.readComment((Element)list2.get(i));
            }
            bookmarksAndComments.comments = commentEntryArray;
            return bookmarksAndComments;
        }
        throw new GanttChartException("No valid data in web service response");
    }

    public long deleteComment(CommentEntry commentEntry, GanttNode ganttNode) throws Exception {
        Element element = this.createSOAPDoc("deleteComment");
        element.addContent(this.createStringSOAPParamElt("sessionId", this.getSessionId()));
        element.addContent(this.createStringSOAPParamElt("commentDocId", commentEntry.id));
        element.addContent(this.createLongSOAPParamElt("lastModifiedRef", ganttNode.getLastModificationTime()));
        Element element2 = this.callWebService(element);
        if (element2 != null) {
            return Long.parseLong(element2.getText());
        }
        throw new GanttChartException("No valid data in web service response");
    }

    public long updateComment(CommentEntry commentEntry, GanttNode ganttNode) throws Exception {
        Element element = this.createSOAPDoc("updateComment");
        element.addContent(this.createStringSOAPParamElt("sessionId", this.getSessionId()));
        this.writeComment(commentEntry, element);
        element.addContent(this.createLongSOAPParamElt("lastModifiedRef", ganttNode.getLastModificationTime()));
        Element element2 = this.callWebService(element);
        if (element2 != null) {
            return Long.parseLong(element2.getText());
        }
        throw new GanttChartException("No valid data in web service response");
    }

    public String postComment(CommentEntry commentEntry, NotificationConfig notificationConfig, GanttNode ganttNode, boolean bl) throws Exception {
        Element element = this.createSOAPDoc("postComment");
        String string = commentEntry.parentId;
        if (string == null) {
            string = ganttNode.getDocId();
        }
        element.addContent(this.createStringSOAPParamElt("sessionId", this.getSessionId()));
        element.addContent(this.createStringSOAPParamElt("parentDocId", string));
        this.writeComment(commentEntry, element);
        this.writeNotificationConfig(notificationConfig, element);
        element.addContent(this.createLongSOAPParamElt("lastModifiedRef", ganttNode.getLastModificationTime()));
        element.addContent(this.createBooleanSOAPParamElt("postOnWall", bl));
        Element element2 = this.callWebService(element);
        if (element2 != null) {
            return element2.getText();
        }
        throw new GanttChartException("No valid data in web service response");
    }

    public long addBookmarks(Bookmark[] bookmarkArray, boolean[] blArray, GanttNode ganttNode) throws Exception {
        Element element = this.createSOAPDoc("addBookmarks");
        element.addContent(this.createStringSOAPParamElt("sessionId", this.getSessionId()));
        element.addContent(this.createStringSOAPParamElt("docId", ganttNode.getDocId()));
        element.addContent(this.writeBookmarks(bookmarkArray));
        element.addContent(this.createBooleanArraySOAPParamElt("addReverseBms", blArray));
        element.addContent(this.createLongSOAPParamElt("lastModifiedRef", ganttNode.getLastModificationTime()));
        Element element2 = this.callWebService(element);
        if (element2 != null) {
            return Long.parseLong(element2.getText());
        }
        throw new GanttChartException("No valid data in web service response");
    }

    public long deleteBookmark(Bookmark bookmark, GanttNode ganttNode) throws Exception {
        Element element = this.createSOAPDoc("deleteBookmark");
        element.addContent(this.createStringSOAPParamElt("sessionId", this.getSessionId()));
        element.addContent(this.createStringSOAPParamElt("docId", ganttNode.getDocId()));
        element.addContent(this.writeBookmark(bookmark));
        element.addContent(this.createLongSOAPParamElt("lastModifiedRef", ganttNode.getLastModificationTime()));
        Element element2 = this.callWebService(element);
        if (element2 != null) {
            return Long.parseLong(element2.getText());
        }
        throw new GanttChartException("No valid data in web service response");
    }

    public NotificationConfig getNotificationConfig(GanttNode ganttNode) throws Exception {
        Element element = this.createSOAPDoc("getNotificationConfig");
        element.addContent(this.createStringSOAPParamElt("sessionId", this.getSessionId()));
        element.addContent(this.createStringSOAPParamElt("docId", ganttNode.getDocId()));
        Element element2 = this.callWebService(element);
        if (element2 != null) {
            NotificationConfig notificationConfig = new NotificationConfig();
            notificationConfig.notify = JDOMUtil.getBoolean(element2, "notify");
            List list = element2.getChildren("items");
            notificationConfig.items = new NotificationItem[list.size()];
            for (int i = 0; i < notificationConfig.items.length; ++i) {
                Element element3 = (Element)list.get(i);
                notificationConfig.items[i] = new NotificationItem();
                notificationConfig.items[i].type = JDOMUtil.getInteger(element3, "type");
                notificationConfig.items[i].value = element3.getChildText("value");
                notificationConfig.items[i].label = element3.getChildText("label");
            }
            return notificationConfig;
        }
        throw new GanttChartException("No valid data in web service response");
    }

    private Bookmark readBookmark(Element element) {
        Bookmark bookmark;
        String string = element.getChildText("custom");
        if ("true".equals(string)) {
            bookmark = new CustomBookmark();
            bookmark.iconPath = element.getChildText("icon");
            bookmark.jsOpenCode = element.getChildText("jsOpenCode");
        } else {
            bookmark = new Bookmark();
        }
        bookmark.title = element.getChildText("title");
        bookmark.date = DatatypeConverter.parseDateTime((String)element.getChildText("date")).getTime();
        bookmark.authorDn = element.getChildText("authorDn");
        bookmark.authorCn = element.getChildText("authorCn");
        bookmark.type = JDOMUtil.getInteger(element, "type");
        bookmark.isTargetValid = JDOMUtil.getBoolean(element, "isTargetValid");
        bookmark.peId = element.getChildText("peId");
        bookmark.docId = element.getChildText("docId");
        bookmark.url = element.getChildText("url");
        bookmark.entryUrl = element.getChildText("entryUrl");
        bookmark.contentUrl = element.getChildText("contentUrl");
        bookmark.deliverable = JDOMUtil.getBoolean(element, "deliverable");
        return bookmark;
    }

    private CommentEntry readComment(Element element) {
        CommentEntry commentEntry = new CommentEntry();
        commentEntry.id = element.getChildText("id");
        commentEntry.parentId = element.getChildText("parentId");
        if ("".equals(commentEntry.parentId)) {
            commentEntry.parentId = null;
        }
        commentEntry.body = element.getChildText("body");
        commentEntry.date = DatatypeConverter.parseDateTime((String)element.getChildText("date")).getTime();
        commentEntry.authorCn = element.getChildText("authorCn");
        commentEntry.authorDn = element.getChildText("authorDn");
        commentEntry.attachments = JDOMUtil.getStrings(element, "attachments");
        List list = element.getChildren("bookmarks");
        Bookmark[] bookmarkArray = new Bookmark[list.size()];
        for (int i = 0; i < bookmarkArray.length; ++i) {
            bookmarkArray[i] = this.readBookmark((Element)list.get(i));
        }
        commentEntry.bookmarks = bookmarkArray;
        return commentEntry;
    }

    private Element writeBookmarks(Bookmark[] bookmarkArray) {
        Element element = new Element("bookmarks");
        element.setAttribute("type", "xsoapenc:Array", xsiNs);
        element.setAttribute("arrayType", "socialNs:Bookmark[" + bookmarkArray.length + "]", soapEncNs);
        for (int i = 0; i < bookmarkArray.length; ++i) {
            Element element2 = new Element("bookmarks");
            this.writeBookmarkContent(bookmarkArray[i], element2);
            element.addContent(element2);
        }
        return element;
    }

    private Element writeBookmark(Bookmark bookmark) {
        return this.writeBookmarkContent(bookmark, new Element("bookmark"));
    }

    private Element writeBookmarkContent(Bookmark bookmark, Element element) {
        element.addContent(this.createStringSOAPParamElt("title", bookmark.title));
        element.addContent(this.createDateTimeSOAPParamElt("date", bookmark.date));
        element.addContent(this.createStringSOAPParamElt("authorDn", bookmark.authorDn));
        element.addContent(this.createStringSOAPParamElt("authorCn", bookmark.authorCn));
        element.addContent(this.createIntSOAPParamElt("type", bookmark.type));
        element.addContent(this.createBooleanSOAPParamElt("isTargetValid", true));
        element.addContent(this.createStringSOAPParamElt("peId", bookmark.peId));
        element.addContent(this.createStringSOAPParamElt("docId", bookmark.docId));
        element.addContent(this.createStringSOAPParamElt("url", bookmark.url));
        element.addContent(this.createStringSOAPParamElt("entryUrl", bookmark.entryUrl));
        element.addContent(this.createStringSOAPParamElt("contentUrl", bookmark.contentUrl));
        element.addContent(this.createBooleanSOAPParamElt("deliverable", bookmark.deliverable));
        return element;
    }

    private void writeComment(CommentEntry commentEntry, Element element) {
        Element element2 = new Element("comment");
        element.addContent(element2);
        element2.addContent(this.createStringSOAPParamElt("id", commentEntry.id));
        element2.addContent(this.createStringSOAPParamElt("parentId", commentEntry.parentId));
        element2.addContent(this.createStringSOAPParamElt("body", commentEntry.body));
        element2.addContent(this.createDateTimeSOAPParamElt("date", commentEntry.date));
        element2.addContent(this.createStringSOAPParamElt("authorDn", commentEntry.authorDn));
        element2.addContent(this.createStringSOAPParamElt("authorCn", commentEntry.authorCn));
        if (commentEntry.attachments != null) {
            for (String object : commentEntry.attachments) {
                element2.addContent(this.createStringSOAPParamElt("attachments", object));
            }
        }
        if (commentEntry.bookmarks != null) {
            for (Bookmark bookmark : commentEntry.bookmarks) {
                Element element3 = new Element("bookmarks");
                this.writeBookmarkContent(bookmark, element3);
                element2.addContent(element3);
            }
        }
    }

    private void writeNotificationConfig(NotificationConfig notificationConfig, Element element) {
        Element element2 = new Element("notifConfig");
        element2.setAttribute("type", "pesocial:NotificationConfig", xsiNs);
        element.addContent(element2);
        if (notificationConfig == null) {
            element2.setAttribute("nil", "true", xsiNs);
        } else {
            if (notificationConfig.items != null && notificationConfig.items.length > 0) {
                Element element3 = new Element("items");
                element3.setAttribute("arrayType", "pesocial:NotificationItem[" + notificationConfig.items.length + "]", soapEncNs);
                element3.setAttribute("type", "soapenc:Array", xsiNs);
                for (int i = 0; i < notificationConfig.items.length; ++i) {
                    Element element4 = new Element("items");
                    element4.setAttribute("type", "pesocial:NotificationItem", xsiNs);
                    element4.addContent(this.createIntSOAPParamElt("type", notificationConfig.items[i].type));
                    element4.addContent(this.createStringSOAPParamElt("value", notificationConfig.items[i].value));
                    element4.addContent(this.createStringSOAPParamElt("label", notificationConfig.items[i].label));
                    element3.addContent(element4);
                }
                element2.addContent(element3);
            }
            element2.addContent(this.createBooleanSOAPParamElt("notify", notificationConfig.notify));
            element2.addContent(this.createBooleanSOAPParamElt("sendBookmarks", notificationConfig.sendBookmarks));
        }
    }

    public Element getAvailableCustomBookmarks(GanttNode ganttNode) throws Exception {
        Element element = this.createSOAPDoc("getAvailableCustomBookmarks");
        element.addContent(this.createStringSOAPParamElt("sessionId", this.getSessionId()));
        element.addContent(this.createStringSOAPParamElt("siteId", this.getSiteId()));
        element.addContent(this.createStringSOAPParamElt("projectId", this.getProjectId()));
        element.addContent(this.createStringSOAPParamElt("nodeUid", ganttNode.getDocId()));
        Element element2 = this.callWebService(element);
        if (element2 != null) {
            return element2;
        }
        throw new GanttChartException("No valid data in web service response");
    }
}

