/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.pe.app.dialog;

import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GanttWBS;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.IActionCallback;
import com.triloggroup.gantt.app.WBSSupervisorsPanel;
import com.triloggroup.gantt.app.change.ChangeException;
import com.triloggroup.gantt.app.social.NodeSocialData;
import com.triloggroup.gantt.app.ui.AsyncActionRunner;
import com.triloggroup.gantt.app.ui.CancelAsyncActionException;
import com.triloggroup.gantt.app.ui.IAsyncAction;
import com.triloggroup.gantt.app.ui.LineWrapTextArea;
import com.triloggroup.gantt.app.ui.WDButton;
import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.gantt.app.ui.WDExpandableSection;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.gantt.pe.app.PEAppGanttChart;
import com.triloggroup.gantt.pe.app.PEAppProjectContext;
import com.triloggroup.gantt.pe.app.PEAppProjectModel;
import com.triloggroup.gantt.pe.app.WBSUpdater;
import com.triloggroup.gantt.pe.app.dialog.GanttNodeCostSection;
import com.triloggroup.gantt.pe.app.dialog.SubProjectPicker;
import com.triloggroup.project.NameId;
import com.triloggroup.project.components.ui.Workbench;
import com.triloggroup.project.schedule.SubprojectOptions;
import com.triloggroup.ui.DatePicker;
import com.triloggroup.util.NLSBundle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class WBSDetailDialog
extends WDDialog
implements ActionListener {
    private static final int MIN_WIDTH = 340;
    private GanttWBS originalWBS;
    private GanttWBS clonedWBS;
    private GanttNode insertAfter;
    private PEAppGanttChart ganttCtrl;
    private IActionCallback callback;
    private WDButton okButton;
    private JTextField nameTxtField;
    private JTextField idTxtField;
    private JComboBox wbsParentCombo;
    private DatePicker startDatePicker;
    private DatePicker endDatePicker;
    private JTextArea descriptionTA;
    private SubProjectPicker subProjectPicker;
    private JCheckBox subProjectFinancialRollup;
    private String overrideHierarchicalId;
    private GanttWBS overrideParent;
    private SubprojectOptions overrideSubprojectOptions;
    private WBSSupervisorsPanel supervisorsPanel;
    private GanttNodeCostSection costsSection;
    private boolean updating;

    public static void showDetail(GanttWBS ganttWBS, PEAppGanttChart pEAppGanttChart, Point point, IActionCallback iActionCallback) {
        Window window = SwingUtilities.getWindowAncestor(pEAppGanttChart.getView());
        GraphicsConfiguration graphicsConfiguration = WDUtil.getGraphicsConfiguration(point);
        WBSDetailDialog wBSDetailDialog = new WBSDetailDialog(ganttWBS, window, pEAppGanttChart, graphicsConfiguration);
        if (iActionCallback != null) {
            wBSDetailDialog.setCallBack(iActionCallback);
        }
        wBSDetailDialog.setLocation(point);
        wBSDetailDialog.setVisible(340, -1, -1, -1, null);
    }

    public static void showNewWBSDetail(GanttWBS ganttWBS, boolean bl, PEAppGanttChart pEAppGanttChart, Point point, GanttNode ganttNode) {
        Window window = SwingUtilities.getWindowAncestor(pEAppGanttChart.getView());
        GraphicsConfiguration graphicsConfiguration = WDUtil.getGraphicsConfiguration(point);
        WBSDetailDialog wBSDetailDialog = new WBSDetailDialog(ganttWBS, bl, window, pEAppGanttChart, ganttNode, graphicsConfiguration);
        wBSDetailDialog.pack();
        wBSDetailDialog.nameTxtField.requestFocusInWindow();
        wBSDetailDialog.setLocation(point);
        wBSDetailDialog.setVisible(340, -1, -1, -1, null);
    }

    protected WBSDetailDialog(GanttWBS ganttWBS, Window window, PEAppGanttChart pEAppGanttChart, GraphicsConfiguration graphicsConfiguration) {
        super(window, graphicsConfiguration);
        this.setDragHeader(true);
        this.setResizable(true);
        this.ganttCtrl = pEAppGanttChart;
        this.clonedWBS = ganttWBS.clone();
        this.originalWBS = ganttWBS;
        this.createUI();
        this.setReadonlyFields();
        this.updateFieldsFromWBS();
        this.restrictPreferredSizes();
    }

    protected WBSDetailDialog(GanttWBS ganttWBS, boolean bl, Window window, PEAppGanttChart pEAppGanttChart, GanttNode ganttNode, GraphicsConfiguration graphicsConfiguration) {
        super(window, graphicsConfiguration);
        this.setDragHeader(true);
        this.setResizable(true);
        this.ganttCtrl = pEAppGanttChart;
        this.insertAfter = ganttNode;
        this.clonedWBS = pEAppGanttChart.getModel().newGantWBS(ganttWBS, ganttNode);
        if (bl) {
            this.clonedWBS.setSubProject(WBSUpdater.DUMMY_SUBPROJECT);
            this.clonedWBS.setSubprojectOptions(new SubprojectOptions());
            this.clonedWBS.setName("");
        }
        this.createUI();
        this.setReadonlyFields();
        this.updateFieldsFromWBS();
        this.restrictPreferredSizes();
    }

    public IActionCallback getCallback() {
        return this.callback;
    }

    public void setCallBack(IActionCallback iActionCallback) {
        this.callback = iActionCallback;
    }

    private void createUI() {
        Serializable serializable;
        JLabel jLabel;
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.createButtonsPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel = new JPanel(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        this.getContentPane().add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        NLSBundle nLSBundle = AppGanttChart.NLS_BUNDLE;
        Insets insets = new Insets(5, 0, 0, 0);
        Insets insets2 = new Insets(5, 0, 0, 5);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 2, insets2, 0, 0);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        String string = this.clonedWBS.isSubProject() || this.clonedWBS.isProjectRoot() && this.clonedWBS.getParent() != null ? "subprojectLinkName" : "wbsName";
        JLabel jLabel2 = new JLabel(nLSBundle.getString(string));
        jPanel.add((Component)jLabel2, gridBagConstraints);
        this.nameTxtField = new JTextField();
        WDUtil.setDocumentWithMaxLength(this.nameTxtField, 256);
        jPanel.add((Component)this.nameTxtField, gridBagConstraints2);
        if (this.clonedWBS.isSubProject() || this.isSubprojectRootAndParentHidden()) {
            jLabel = new JLabel(nLSBundle.getString("subprojectField"));
            jPanel.add((Component)jLabel, gridBagConstraints);
            this.subProjectPicker = new SubProjectPicker((PEAppProjectContext)this.clonedWBS.getProjectContext());
            this.subProjectPicker.setProject(this.clonedWBS.getSubProject());
            jPanel.add((Component)this.subProjectPicker, gridBagConstraints2);
            if (this.clonedWBS.isSubProject()) {
                this.subProjectPicker.addPropertyChangeListener("project", new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        final NameId nameId = (NameId)propertyChangeEvent.getNewValue();
                        if (nameId == WBSUpdater.DUMMY_SUBPROJECT) {
                            WBSDetailDialog.this.nameTxtField.setText("");
                            return;
                        }
                        IAsyncAction iAsyncAction = new IAsyncAction(){

                            public Object awtBeforeRun() throws CancelAsyncActionException {
                                return null;
                            }

                            public Object asyncRun(Object object) throws Throwable {
                                PEAppProjectModel pEAppProjectModel = WBSDetailDialog.this.ganttCtrl.getModel().getProjectModel(WBSDetailDialog.this.clonedWBS.getProjectId());
                                GanttWBS ganttWBS = pEAppProjectModel.loadSubprojectRoot(nameId.getId());
                                return ganttWBS;
                            }

                            public void awtAfterRun(Object object, Throwable throwable) {
                                try {
                                    if (throwable != null) {
                                        throw throwable;
                                    }
                                    GanttWBS ganttWBS = (GanttWBS)object;
                                    WBSDetailDialog.this.clonedWBS.setName(ganttWBS.getName());
                                    WBSDetailDialog.this.clonedWBS.setSubProject(nameId);
                                    WBSDetailDialog.this.clonedWBS.setDates(ganttWBS.getStartDate(), ganttWBS.getFinishDate());
                                    WBSDetailDialog.this.clonedWBS.setDurationDisplay(ganttWBS.getDurationDisplay());
                                    WBSDetailDialog.this.clonedWBS.setWorkDisplay(ganttWBS.getWorkDisplay());
                                    WBSDetailDialog.this.clonedWBS.setNodeDescription(ganttWBS.getNodeDescription());
                                    WBSDetailDialog.this.clonedWBS.setProgress(ganttWBS.getProgress());
                                    WBSDetailDialog.this.clonedWBS.setPlannedProgress(ganttWBS.getPlannedProgress());
                                    WBSDetailDialog.this.clonedWBS.setComputedWorkedHours(ganttWBS.getComputedWorkedHours());
                                    WBSDetailDialog.this.clonedWBS.setPlannedWorkedHours(ganttWBS.getPlannedWorkedHours());
                                    WBSDetailDialog.this.clonedWBS.setStatus(ganttWBS.getStatus());
                                    NodeSocialData nodeSocialData = ganttWBS.getSocialData();
                                    WBSDetailDialog.this.clonedWBS.getSocialData().updateSummary(nodeSocialData);
                                    WBSDetailDialog.this.clonedWBS.setActualAdditionalCost(ganttWBS.getActualAdditionalCost());
                                    WBSDetailDialog.this.clonedWBS.setActualResourceCost(ganttWBS.getActualResourceCost());
                                    WBSDetailDialog.this.clonedWBS.setAdditionalCost(ganttWBS.getAdditionalCost());
                                    WBSDetailDialog.this.clonedWBS.setAdditionalCostDescription(ganttWBS.getAdditionalCostDescription());
                                    WBSDetailDialog.this.clonedWBS.setProjectedAdditionalCost(ganttWBS.getProjectedAdditionalCost());
                                    WBSDetailDialog.this.clonedWBS.setProjectedResourceCost(ganttWBS.getProjectedResourceCost());
                                    WBSDetailDialog.this.clonedWBS.setSpecifiedActualAdditionalCost(ganttWBS.getSpecifiedActualAdditionalCost());
                                    WBSDetailDialog.this.clonedWBS.setInitiallyPlannedAdditionalCost(ganttWBS.getInitiallyPlannedAdditionalCost());
                                    WBSDetailDialog.this.clonedWBS.setInitiallyPlannedResourceCost(ganttWBS.getInitiallyPlannedResourceCost());
                                    WBSDetailDialog.this.clonedWBS.setResources(ganttWBS.getResources());
                                    WBSDetailDialog.this.updateFieldsFromWBS();
                                }
                                catch (Throwable throwable2) {
                                    throwable2.printStackTrace();
                                    WBSDetailDialog.this.clonedWBS.setSubProject(WBSUpdater.DUMMY_SUBPROJECT);
                                    WBSDetailDialog.this.updateFieldsFromWBS();
                                }
                            }
                        };
                        AsyncActionRunner asyncActionRunner = new AsyncActionRunner(iAsyncAction, WBSDetailDialog.this, null);
                        asyncActionRunner.setWaitUIBounds(WBSDetailDialog.this.getBounds());
                        asyncActionRunner.runAction();
                    }
                });
            } else {
                this.subProjectPicker.setEditable(false);
            }
            if (this.showFinancial()) {
                this.subProjectFinancialRollup = new JCheckBox(nLSBundle.getString("financial_rollupSubprojectCosts"));
                serializable = new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 18, 2, insets, 0, 0);
                jPanel.add((Component)this.subProjectFinancialRollup, serializable);
            }
        }
        jLabel = new JLabel(nLSBundle.getString("id"));
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.idTxtField = new JTextField();
        this.idTxtField.setEditable(false);
        jPanel.add((Component)this.idTxtField, gridBagConstraints2);
        serializable = new JLabel(nLSBundle.getString("wbsEntry"));
        jPanel.add((Component)serializable, gridBagConstraints);
        this.createWbsParentCombo();
        jPanel.add((Component)this.wbsParentCombo, gridBagConstraints2);
        boolean bl = this.ganttCtrl.getModel().getGlobalContext().isTimePrecision();
        JLabel jLabel3 = new JLabel(nLSBundle.getString("startDate"));
        this.startDatePicker = this.createDatePicker();
        this.startDatePicker.setShowTime(bl);
        this.startDatePicker.setEditable(false);
        jPanel.add((Component)jLabel3, gridBagConstraints);
        jPanel.add((Component)this.startDatePicker, gridBagConstraints2);
        JLabel jLabel4 = new JLabel(nLSBundle.getString("endDate"));
        this.endDatePicker = this.createDatePicker();
        this.endDatePicker.setShowTime(bl);
        this.endDatePicker.setEditable(false);
        jPanel.add((Component)jLabel4, gridBagConstraints);
        jPanel.add((Component)this.endDatePicker, gridBagConstraints2);
        JLabel jLabel5 = new JLabel(nLSBundle.getString("description"));
        jPanel.add((Component)jLabel5, gridBagConstraints);
        this.descriptionTA = new LineWrapTextArea();
        WDUtil.setDocumentWithMaxLength(this.descriptionTA, 512);
        jPanel.add((Component)this.descriptionTA, gridBagConstraints2);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 18, 2, insets, 0, 0);
        this.supervisorsPanel = new WBSSupervisorsPanel((AppGanttChart)this.ganttCtrl, this.clonedWBS);
        WDExpandableSection wDExpandableSection = new WDExpandableSection(nLSBundle.getString("wbsSupervisors"), this.supervisorsPanel);
        jPanel.add((Component)wDExpandableSection, gridBagConstraints3);
        if (this.showFinancial()) {
            this.costsSection = new GanttNodeCostSection(this.ganttCtrl, this.clonedWBS, nLSBundle);
            jPanel.add((Component)this.costsSection, gridBagConstraints3);
        }
        jPanel.add(Box.createVerticalGlue(), new GridBagConstraints(0, -1, 2, 1, 0.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void restrictPreferredSizes() {
        this.restrictPreferredSize(this.nameTxtField);
        this.nameTxtField.setCaretPosition(0);
        this.restrictPreferredSize(this.idTxtField);
        this.idTxtField.setCaretPosition(0);
        this.restrictPreferredSize(this.wbsParentCombo);
    }

    protected void restrictPreferredSize(JComponent jComponent) {
        Dimension dimension = jComponent.getPreferredSize();
        if (dimension.width > 600) {
            jComponent.setPreferredSize(new Dimension(600, dimension.height));
        }
    }

    protected void updateWBSfromFields() throws ChangeException {
        Object object;
        String string = this.nameTxtField.getText().trim();
        String string2 = Workbench.checkInvalidCharacters(string);
        if (string2 != null) {
            throw new ChangeException(string2, "name");
        }
        this.clonedWBS.setName(string);
        boolean bl = this.isSubprojectRootAndParentHidden();
        if (this.subProjectPicker != null) {
            if (!bl) {
                object = this.subProjectPicker.getProject();
                this.clonedWBS.setSubProject((NameId)(object == null ? WBSUpdater.DUMMY_SUBPROJECT : object));
            }
            if (this.subProjectFinancialRollup != null) {
                if (bl) {
                    if (this.overrideSubprojectOptions == null) {
                        this.overrideSubprojectOptions = new SubprojectOptions();
                    }
                    this.overrideSubprojectOptions.setFinancialRollup(this.subProjectFinancialRollup.isSelected());
                } else {
                    this.clonedWBS.getSubprojectOptions().setFinancialRollup(this.subProjectFinancialRollup.isSelected());
                }
            }
        }
        if ((string2 = Workbench.checkInvalidCharacters((String)(object = this.descriptionTA.getText().trim()))) != null) {
            throw new ChangeException(string2, "description");
        }
        this.clonedWBS.setNodeDescription((String)object);
        GanttWBS ganttWBS = (GanttWBS)this.wbsParentCombo.getSelectedItem();
        if (bl) {
            this.overrideHierarchicalId = this.hidFromText(this.idTxtField.getText());
            this.overrideParent = ganttWBS;
        } else if (ganttWBS != this.clonedWBS.getParent()) {
            this.clonedWBS.setHierarchicalId(this.hidFromText(this.idTxtField.getText()));
            this.clonedWBS.setParent(ganttWBS);
        }
        if (this.costsSection != null) {
            this.costsSection.updateNodefromFields();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateFieldsFromWBS() {
        try {
            GanttWBS ganttWBS;
            this.updating = true;
            this.nameTxtField.setText(this.clonedWBS.getName());
            this.descriptionTA.setText(this.clonedWBS.getNodeDescription());
            GanttWBS ganttWBS2 = ganttWBS = this.isSubprojectRootAndParentHidden() ? (GanttWBS)this.clonedWBS.getParent() : this.clonedWBS;
            if (this.overrideHierarchicalId != null) {
                this.idTxtField.setText(this.hidToText(this.overrideHierarchicalId));
                this.wbsParentCombo.setSelectedItem(this.overrideParent);
            } else {
                this.idTxtField.setText(this.hidToText(ganttWBS.getHierarchicalId()));
                this.wbsParentCombo.setSelectedItem(ganttWBS.getParent());
            }
            if (this.subProjectFinancialRollup != null) {
                boolean bl = this.overrideSubprojectOptions != null ? this.overrideSubprojectOptions.isFinancialRollup() : ganttWBS.getSubprojectOptions().isFinancialRollup();
                this.subProjectFinancialRollup.setSelected(bl);
            }
            this.startDatePicker.setDate(this.clonedWBS.getDuration().getStart());
            this.endDatePicker.setDate(this.clonedWBS.getDuration().getEnd());
            if (this.subProjectPicker != null) {
                GanttWBS ganttWBS3 = this.clonedWBS.isSubProject() ? this.clonedWBS : (GanttWBS)this.clonedWBS.getParent();
                this.subProjectPicker.setProject(ganttWBS3.getSubProject());
                if (this.subProjectFinancialRollup != null) {
                    this.subProjectFinancialRollup.setSelected(ganttWBS3.getSubprojectOptions().isFinancialRollup());
                }
            }
            this.supervisorsPanel.getTableModel().fireTableDataChanged();
            if (this.costsSection != null) {
                this.costsSection.updateFieldsFromNode();
            }
        }
        finally {
            this.updating = false;
        }
    }

    protected void setReadonlyFields() {
        boolean bl = this.clonedWBS.isSubProject();
        boolean bl2 = this.isEditable();
        if (this.costsSection != null) {
            if (!bl && this.ganttCtrl.getModel().getProjectModel(this.clonedWBS.getProjectId()).getProjectContext().isFinancialEditable()) {
                this.costsSection.registerListeners();
            } else {
                this.costsSection.setEditable(false);
            }
        }
        if (bl2 && !bl) {
            return;
        }
        this.nameTxtField.setEditable(false);
        this.descriptionTA.setEditable(false);
        this.wbsParentCombo.setEnabled(bl2);
        this.supervisorsPanel.setEnabled(false);
        if (bl) {
            this.subProjectPicker.setEditable(bl2 && !this.isSubprojectRootAndParentHidden());
            if (this.subProjectFinancialRollup != null) {
                this.subProjectFinancialRollup.setEnabled(bl2);
            }
        }
    }

    private JPanel createButtonsPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        this.okButton = WDUtil.createOkButton();
        jPanel.add(this.okButton);
        this.okButton.addActionListener(this);
        if (this.isEditable()) {
            WDButton wDButton = WDUtil.createCancelButton();
            jPanel.add(wDButton);
            wDButton.addActionListener(this);
        }
        return jPanel;
    }

    private DatePicker createDatePicker() {
        return new DatePicker(this.ganttCtrl.getDateLocale());
    }

    protected void createWbsParentCombo() {
        this.wbsParentCombo = new JComboBox();
        this.wbsParentCombo.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (object instanceof GanttWBS) {
                    this.setText(((GanttWBS)object).getHierarchicalId() + " - " + ((GanttWBS)object).getName());
                }
                return this;
            }
        });
        GanttWBS ganttWBS = this.isSubprojectRootAndParentHidden() ? (GanttWBS)this.clonedWBS.getParent() : this.clonedWBS;
        Iterator<TGNode> iterator = this.ganttCtrl.getModel().getProjectModel(ganttWBS.getProjectId()).getAllWBS().iterator();
        ArrayList<GanttWBS> arrayList = new ArrayList<GanttWBS>();
        while (iterator.hasNext()) {
            GanttNode ganttNode;
            GanttWBS ganttWBS2 = (GanttWBS)iterator.next();
            if (!ganttWBS2.isReadeable() || ganttWBS2.isSubProject()) continue;
            for (ganttNode = ganttWBS2; ganttNode != null && ganttNode != this.originalWBS; ganttNode = (GanttNode)ganttNode.getParent()) {
            }
            if (ganttNode != null) continue;
            arrayList.add(ganttWBS2);
        }
        Collections.sort(arrayList, TGNode.sortedIdComparator);
        for (int i = 0; i < arrayList.size(); ++i) {
            this.wbsParentCombo.addItem(arrayList.get(i));
        }
        this.wbsParentCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                GanttWBS ganttWBS;
                if (WBSDetailDialog.this.updating) {
                    return;
                }
                if (itemEvent.getStateChange() == 1 && (ganttWBS = (GanttWBS)itemEvent.getItem()) != null) {
                    int n;
                    if (WBSDetailDialog.this.insertAfter != null && WBSDetailDialog.this.insertAfter.getParent() == ganttWBS) {
                        n = WBSDetailDialog.this.insertAfter.getSubId() + 1;
                    } else {
                        if (WBSDetailDialog.this.originalWBS != null) {
                            GanttWBS ganttWBS2;
                            GanttNode ganttNode = ganttWBS2 = WBSDetailDialog.this.isSubprojectRootAndParentHidden() ? (GanttNode)WBSDetailDialog.this.originalWBS.getParent() : WBSDetailDialog.this.originalWBS;
                            if (ganttWBS == ganttWBS2.getParent()) {
                                WBSDetailDialog.this.idTxtField.setText(WBSDetailDialog.this.hidToText(ganttWBS2.getHierarchicalId()));
                                return;
                            }
                        }
                        n = WBSDetailDialog.this.ganttCtrl.getModel().getNextTaskSubId(ganttWBS);
                    }
                    WBSDetailDialog.this.idTxtField.setText(WBSDetailDialog.this.hidToText(ganttWBS.getHierarchicalId() + '.' + n));
                }
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton && this.isEditable()) {
            boolean bl = false;
            try {
                boolean bl2;
                this.updateWBSfromFields();
                bl = true;
                boolean bl3 = bl2 = this.originalWBS != null && this.clonedWBS.getSubProject() != null && !this.clonedWBS.getSubProject().equals(this.originalWBS.getSubProject());
                if (this.insertAfter != null && this.clonedWBS.getParent() == this.insertAfter.getParent()) {
                    GanttWBS ganttWBS = (GanttWBS)this.clonedWBS.getParent();
                    int n = this.ganttCtrl.getModel().getNextTaskSubId(ganttWBS);
                    this.clonedWBS.setHierarchicalId(ganttWBS.getHierarchicalId() + '.' + n);
                    this.ganttCtrl.getModel().checkComputeAndUpdateWBSValues(this.originalWBS, this.clonedWBS, this);
                    int n2 = this.insertAfter.getSubId() + 1;
                    this.ganttCtrl.getModel().reorderNodeToPosition(this.clonedWBS, n2, true);
                } else {
                    boolean bl4 = false;
                    GanttWBS ganttWBS = (GanttWBS)this.clonedWBS.getParent();
                    GanttWBS ganttWBS2 = null;
                    if (this.isSubprojectRootAndParentHidden()) {
                        if (this.overrideParent != null && this.overrideParent != ganttWBS.getParent()) {
                            ganttWBS2 = ganttWBS.clone();
                            ganttWBS2.setHierarchicalId(this.overrideHierarchicalId);
                            ganttWBS2.setParent(this.overrideParent);
                        }
                        if (this.overrideSubprojectOptions != null && !this.overrideSubprojectOptions.equals(ganttWBS.getSubprojectOptions())) {
                            if (ganttWBS2 == null) {
                                ganttWBS2 = ganttWBS.clone();
                            }
                            ganttWBS2.setSubprojectOptions(this.overrideSubprojectOptions);
                        }
                        if (ganttWBS2 != null) {
                            this.ganttCtrl.getModel().checkComputeAndUpdateWBSValues(ganttWBS, ganttWBS2, this);
                            bl4 = true;
                        }
                    }
                    this.ganttCtrl.getModel().checkComputeAndUpdateWBSValues(this.originalWBS, this.clonedWBS, this, bl4, false);
                }
                if (this.originalWBS == null) {
                    if (this.clonedWBS.getStartDate().after(this.ganttCtrl.getDisplayEndDate()) || this.clonedWBS.getFinishDate().before(this.ganttCtrl.getDisplayStartDate())) {
                        this.ganttCtrl.centerGraphOnNode(this.clonedWBS);
                    }
                    this.ganttCtrl.scrollToNode(this.clonedWBS);
                } else if (bl2) {
                    this.ganttCtrl.getModel().unloadSubproject(this.originalWBS);
                }
            }
            catch (ChangeException changeException) {
                if (bl) {
                    this.updateFieldsFromWBS();
                }
                if (changeException.getField() == "name") {
                    this.nameTxtField.requestFocus();
                } else if (changeException.getField() == "subproject") {
                    this.subProjectPicker.requestFocus();
                } else if (changeException.getField() == "description") {
                    this.descriptionTA.requestFocus();
                } else if (changeException.getField() == "parentInternalId") {
                    this.wbsParentCombo.requestFocus();
                } else {
                    if (changeException.getField() == "additionalcost") {
                        this.costsSection.expand();
                        this.costsSection.tfAdditionalCost.requestFocus();
                        return;
                    }
                    if (changeException.getField() == "actualadditionalcost") {
                        this.costsSection.expand();
                        this.costsSection.tfActualAdditionalCost.requestFocus();
                        return;
                    }
                    if (changeException.getField() == "additionalcostdescription") {
                        this.costsSection.expand();
                        this.costsSection.additionCostDescriptionTA.requestFocus();
                    }
                }
                WDDialog.showErrorMsgDialog(this, changeException);
                return;
            }
            catch (Exception exception) {
                if (bl) {
                    this.updateFieldsFromWBS();
                }
                WDDialog.showErrorMsgDialog(this, exception);
                return;
            }
            this.dispose();
            if (this.callback != null) {
                this.callback.actionDone();
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (WBSDetailDialog.this.originalWBS != null) {
                        WBSDetailDialog.this.ganttCtrl.setSelectedNode(WBSDetailDialog.this.originalWBS);
                    } else {
                        WBSDetailDialog.this.ganttCtrl.setSelectedNode(WBSDetailDialog.this.clonedWBS);
                    }
                }
            });
        } else {
            this.dispose();
            if (this.callback != null) {
                this.callback.actionCancelled();
            }
        }
    }

    public void close() {
        super.close();
        if (this.callback != null) {
            this.callback.actionCancelled();
        }
    }

    protected boolean isEditable() {
        return this.ganttCtrl.isEditable() && this.ganttCtrl.getModel().isProjectScheduleEditable(this.clonedWBS);
    }

    private boolean isSubprojectRootAndParentHidden() {
        return this.clonedWBS.isProjectRoot() && this.clonedWBS.getParent() != null && ((GanttWBS)this.clonedWBS.getParent()).isSubProject();
    }

    private boolean showFinancial() {
        return this.ganttCtrl.getModel().getGlobalContext().hasFinancialModule();
    }

    private String hidToText(String string) {
        if (this.clonedWBS.isSubProject() || this.isSubprojectRootAndParentHidden()) {
            return string + "/1";
        }
        return string;
    }

    private String hidFromText(String string) {
        int n = string.indexOf(47);
        if (n < 0) {
            return string;
        }
        return string.substring(0, n);
    }
}

