/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.pe.app;

import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GanttWBS;
import com.triloggroup.gantt.Resource;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.app.ChangeCanceledException;
import com.triloggroup.gantt.app.change.Change;
import com.triloggroup.gantt.app.change.ChangeException;
import com.triloggroup.gantt.app.change.ParentFieldValue;
import com.triloggroup.gantt.app.social.NodeSocialData;
import com.triloggroup.gantt.pe.app.NodeUpdater;
import com.triloggroup.gantt.pe.app.PEAppGanttChartModel;
import com.triloggroup.project.NameId;
import com.triloggroup.project.schedule.SubprojectOptions;
import com.triloggroup.util.UString;
import java.awt.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WBSUpdater
extends NodeUpdater<GanttWBS> {
    public static final NameId DUMMY_SUBPROJECT = new NameId("DUMMY_SUBPROJECT", "DUMMY_SUBPROJECT");

    public WBSUpdater(GanttWBS ganttWBS, GanttWBS ganttWBS2, PEAppGanttChartModel pEAppGanttChartModel, Component component) {
        super(ganttWBS, ganttWBS2, pEAppGanttChartModel, component);
    }

    public void checkAndCompute() throws ChangeException, ChangeCanceledException {
        if (((GanttWBS)this.copy).getSubProject() == DUMMY_SUBPROJECT) {
            throw new ChangeException("subprojet_empty", "subproject", this.getSourceName());
        }
        if (UString.isEmpty(((GanttWBS)this.copy).getName())) {
            throw new ChangeException("name_empty", "name", this.getSourceName());
        }
        if (UString.isEmpty(((GanttWBS)this.copy).getParentHierarchicalId())) {
            throw new ChangeException("wbs_empty", "parentInternalId", this.getSourceName());
        }
        for (TGNode tGNode = ((GanttWBS)this.copy).getParent(); tGNode != null; tGNode = tGNode.getParent()) {
            if (tGNode != this.original) continue;
            throw new ChangeException("operation_not_available_child_node", "parentInternalId", this.getSourceName());
        }
        int n = ((GanttWBS)this.copy).getLevel();
        if (n > 32) {
            throw new ChangeException("error_max_level_32", "parentInternalId", this.getSourceName());
        }
        if (this.original != null && !UString.equals(((GanttWBS)this.copy).getHierarchicalId(), ((GanttWBS)this.original).getHierarchicalId())) {
            this.checkLevel((GanttWBS)this.copy, n);
        }
    }

    private void checkLevel(GanttWBS ganttWBS, int n) throws ChangeException {
        int n2 = ganttWBS.getAllSubTaskCount();
        if (n > 32 || n == 32 && n2 > 0) {
            throw new ChangeException("error_max_level_32", "parentInternalId", this.getSourceName());
        }
        for (int i = 0; i < n2; ++i) {
            GanttNode ganttNode = ganttWBS.getSubtaskInAll(i);
            if (!(ganttNode instanceof GanttWBS)) continue;
            this.checkLevel((GanttWBS)ganttNode, n + 1);
        }
    }

    public Change checkComputeAndUpdateOriginal() throws ChangeException, ChangeCanceledException {
        this.checkAndCompute();
        GanttWBS ganttWBS = null;
        if (this.original != null && !UString.equals(((GanttWBS)this.copy).getHierarchicalId(), ((GanttWBS)this.original).getHierarchicalId())) {
            ganttWBS = this.ganttModel.getProjectModel(((GanttWBS)this.original).getProjectId()).getWBSByHierarchicalId(((GanttWBS)this.original).getParentHierarchicalId());
        }
        Change change = this.updateWBS();
        try {
            if (this.original != null) {
                this.ganttModel.getProjectModel(((GanttWBS)this.original).getProjectId()).getScheduleComputation().onPostUpdateWbsValues((GanttWBS)this.original, ganttWBS);
            } else {
                this.ganttModel.getProjectModel(((GanttWBS)this.copy).getProjectId()).getScheduleComputation().onPostUpdateWbsValues((GanttWBS)this.copy, ganttWBS);
            }
        }
        catch (Exception exception) {
            throw new ChangeException("Cannot update parent WBS of " + this.getSourceName(), exception);
        }
        return change;
    }

    protected Change updateWBS() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Change change = this.updateNode();
        if (this.original == null || !UString.equals(((GanttWBS)this.copy).getHierarchicalId(), ((GanttWBS)this.original).getHierarchicalId())) {
            object4 = this.original == null ? null : ((GanttWBS)this.original).getHierarchicalId();
            object3 = null;
            object2 = null;
            if (this.original != null) {
                object2 = this.ganttModel.getProjectModel(((GanttWBS)this.original).getProjectId()).getWBSByHierarchicalId(((GanttWBS)this.original).getParentHierarchicalId());
                object3 = ((GanttNode)object2).getUid();
                ((TGNode)object2).removeSubtask(this.original);
            }
            object = new ParentFieldValue((String)object3, (String)object4);
            GanttWBS ganttWBS = this.ganttModel.getProjectModel(((GanttWBS)this.copy).getProjectId()).getWBSByHierarchicalId(((GanttWBS)this.copy).getParentHierarchicalId());
            String string = ganttWBS.getUid();
            ParentFieldValue parentFieldValue = new ParentFieldValue(string);
            change.addModification("parentInternalId", object, parentFieldValue);
            if (this.original != null) {
                ((GanttWBS)this.original).setHierarchicalId(((GanttWBS)this.copy).getHierarchicalId());
                this.ganttModel.recomputeIdsForWbsIfChanged((GanttWBS)object2);
                ((GanttWBS)this.original).setHierarchicalId(((GanttWBS)this.copy).getHierarchicalId());
                ganttWBS.addSubtask(this.original);
                this.ganttModel.recomputeIdsForWbs(ganttWBS);
            } else {
                String string2 = ganttWBS.getHierarchicalId();
                int n = this.ganttModel.getNextTaskSubId(ganttWBS);
                String string3 = string2 + '.' + n;
                ((GanttWBS)this.copy).setHierarchicalId(string3);
                ganttWBS.addSubtask(this.copy);
                this.ganttModel.recomputeIdsForWbs((GanttWBS)this.copy);
            }
        }
        if (this.original != null) {
            object4 = ((GanttWBS)this.copy).getSubProject();
            if (!this.equals(object4, object3 = ((GanttWBS)this.original).getSubProject())) {
                if (object4 == null || object3 == null || !this.equals(((NameId)object4).getId(), ((NameId)object3).getId())) {
                    change.addModification("subproject", object3, object4);
                    if (!this.equals(((GanttWBS)this.copy).getStartDate(), ((GanttWBS)this.original).getStartDate()) || !this.equals(((GanttWBS)this.copy).getFinishDate(), ((GanttWBS)this.original).getFinishDate())) {
                        change.addModification("startDate", ((GanttWBS)this.original).getStartDate(), ((GanttWBS)this.copy).getStartDate());
                        change.addModification("endDate", ((GanttWBS)this.original).getFinishDate(), ((GanttWBS)this.copy).getFinishDate());
                        ((GanttWBS)this.original).setDates(((GanttWBS)this.copy).getStartDate(), ((GanttWBS)this.copy).getFinishDate());
                    }
                    if (((GanttWBS)this.copy).getDurationDisplay() != ((GanttWBS)this.original).getDurationDisplay()) {
                        change.addModification("durationdisplay", ((GanttWBS)this.original).getDurationDisplay(), ((GanttWBS)this.copy).getDurationDisplay());
                        ((GanttWBS)this.original).setDurationDisplay(((GanttWBS)this.copy).getDurationDisplay());
                    }
                    if (((GanttWBS)this.copy).getWorkDisplay() != ((GanttWBS)this.original).getWorkDisplay()) {
                        change.addModification("workdisplay", ((GanttWBS)this.original).getWorkDisplay(), ((GanttWBS)this.copy).getWorkDisplay());
                        ((GanttWBS)this.original).setWorkDisplay(((GanttWBS)this.copy).getWorkDisplay());
                    }
                    if (!this.equals(((GanttWBS)this.copy).getStatus(), ((GanttWBS)this.original).getStatus())) {
                        change.addModification("status", ((GanttWBS)this.original).getStatus(), ((GanttWBS)this.copy).getStatus());
                        ((GanttWBS)this.original).setStatus(((GanttWBS)this.copy).getStatus());
                    }
                    object2 = ((GanttWBS)this.copy).getSocialData();
                    object = ((GanttWBS)this.original).getSocialData();
                    change.addModification("Social", object, object2);
                    ((NodeSocialData)object).updateSummary((NodeSocialData)object2);
                    if (!this.equals(((GanttWBS)this.copy).getProjectedAdditionalCost(), ((GanttWBS)this.original).getProjectedAdditionalCost())) {
                        change.addModification("subPrjFinPAC", ((GanttWBS)this.original).getProjectedAdditionalCost(), ((GanttWBS)this.copy).getProjectedAdditionalCost());
                        ((GanttWBS)this.original).setProjectedAdditionalCost(((GanttWBS)this.copy).getProjectedAdditionalCost());
                    }
                    if (!this.equals(((GanttWBS)this.copy).getActualAdditionalCost(), ((GanttWBS)this.original).getActualAdditionalCost())) {
                        change.addModification("subPrjFinAAC", ((GanttWBS)this.original).getActualAdditionalCost(), ((GanttWBS)this.copy).getActualAdditionalCost());
                        ((GanttWBS)this.original).setActualAdditionalCost(((GanttWBS)this.copy).getActualAdditionalCost());
                    }
                    if (!this.equals(((GanttWBS)this.copy).getProjectedResourceCost(), ((GanttWBS)this.original).getProjectedResourceCost())) {
                        change.addModification("subPrjFinPRC", ((GanttWBS)this.original).getProjectedResourceCost(), ((GanttWBS)this.copy).getProjectedResourceCost());
                        ((GanttWBS)this.original).setProjectedResourceCost(((GanttWBS)this.copy).getProjectedResourceCost());
                    }
                    if (!this.equals(((GanttWBS)this.copy).getActualResourceCost(), ((GanttWBS)this.original).getActualResourceCost())) {
                        change.addModification("subPrjFinARC", ((GanttWBS)this.original).getActualResourceCost(), ((GanttWBS)this.copy).getActualResourceCost());
                        ((GanttWBS)this.original).setActualResourceCost(((GanttWBS)this.copy).getActualResourceCost());
                    }
                    if (!this.equals(((GanttWBS)this.copy).getInitiallyPlannedAdditionalCost(), ((GanttWBS)this.original).getInitiallyPlannedAdditionalCost())) {
                        change.addModification("subPrjFinIPAC", ((GanttWBS)this.original).getInitiallyPlannedAdditionalCost(), ((GanttWBS)this.copy).getInitiallyPlannedAdditionalCost());
                        ((GanttWBS)this.original).setInitiallyPlannedAdditionalCost(((GanttWBS)this.copy).getInitiallyPlannedAdditionalCost());
                    }
                    if (!this.equals(((GanttWBS)this.copy).getInitiallyPlannedResourceCost(), ((GanttWBS)this.original).getInitiallyPlannedResourceCost())) {
                        change.addModification("subPrjFinIPRC", ((GanttWBS)this.original).getInitiallyPlannedResourceCost(), ((GanttWBS)this.copy).getInitiallyPlannedResourceCost());
                        ((GanttWBS)this.original).setInitiallyPlannedResourceCost(((GanttWBS)this.copy).getInitiallyPlannedResourceCost());
                    }
                    if (!this.equals(((GanttWBS)this.copy).getPercentComplete(), ((GanttWBS)this.original).getPercentComplete())) {
                        change.addModification("percentComplete", ((GanttWBS)this.original).getPercentComplete(), ((GanttWBS)this.copy).getPercentComplete());
                        ((GanttWBS)this.original).setPercentComplete(((GanttWBS)this.copy).getPercentComplete());
                    }
                    for (int i = 0; i < ((GanttWBS)this.original).getAllSubTaskCount(); ++i) {
                        ((GanttWBS)this.original).removeSubtask(((GanttWBS)this.original).getSubtaskInAll(0));
                    }
                    ((GanttWBS)this.original).setExpanded(false);
                }
                ((GanttWBS)this.original).setSubProject((NameId)object4);
            }
        } else if (((GanttWBS)this.copy).getSubProject() != null) {
            change.addModification("subproject", null, ((GanttWBS)this.copy).getSubProject());
            change.addModification("workdisplay", null, ((GanttWBS)this.copy).getWorkDisplay());
            change.addModification("status", null, ((GanttWBS)this.copy).getStatus());
            change.addModification("percentComplete", 0, ((GanttWBS)this.copy).getPercentComplete());
            change.addModification("plW", 0, ((GanttWBS)this.copy).getPlannedWorkedHours());
            change.addModification("cpW", 0, ((GanttWBS)this.copy).getComputedWorkedHours());
            change.addModification("Social", null, ((GanttWBS)this.copy).getSocialData());
            change.addModification("subPrjFinPAC", 0, ((GanttWBS)this.copy).getProjectedAdditionalCost());
            change.addModification("subPrjFinAAC", 0, ((GanttWBS)this.copy).getActualAdditionalCost());
            change.addModification("subPrjFinPRC", 0, ((GanttWBS)this.copy).getProjectedResourceCost());
            change.addModification("subPrjFinARC", 0, ((GanttWBS)this.copy).getActualResourceCost());
            change.addModification("subPrjFinIPAC", 0, ((GanttWBS)this.copy).getInitiallyPlannedAdditionalCost());
            change.addModification("subPrjFinIPRC", 0, ((GanttWBS)this.copy).getInitiallyPlannedResourceCost());
        }
        if (this.original != null) {
            object4 = ((GanttWBS)this.copy).getSubprojectOptionsAsString();
            if (!this.equals(object4, object3 = ((GanttWBS)this.original).getSubprojectOptionsAsString())) {
                change.addModification("subprojectOptions", object3, object4);
                ((GanttWBS)this.original).setSubprojectOptions(new SubprojectOptions((String)object4));
            }
        } else if (((GanttWBS)this.copy).getSubprojectOptions() != null) {
            change.addModification("subprojectOptions", null, ((GanttWBS)this.copy).getSubprojectOptionsAsString());
        }
        if (this.original != null) {
            if (!this.areSameResources(((GanttWBS)this.copy).getResources(), ((GanttWBS)this.original).getResources())) {
                change.addModification("wbsSupervisors", ((GanttWBS)this.original).getResourcesCopy(), ((GanttWBS)this.copy).getResourcesCopy());
                ((GanttWBS)this.original).setResources(((GanttWBS)this.copy).getResourcesCopy());
            }
        } else if (((GanttWBS)this.copy).getResourcesCopy() != null) {
            change.addModification("wbsSupervisors", null, ((GanttWBS)this.copy).getResourcesCopy());
        }
        return change;
    }

    protected boolean areSameResources(Resource[] resourceArray, Resource[] resourceArray2) {
        if (resourceArray != null) {
            if (resourceArray2 != null) {
                if (resourceArray.length != resourceArray2.length) {
                    return false;
                }
                for (int i = 0; i < resourceArray.length; ++i) {
                    if (UString.equals(resourceArray[i].getDn(), resourceArray2[i].getDn())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return resourceArray2 == null;
    }
}

