/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.pe.app;

import com.flowbuilder.util.xml.JDOMUtil;
import com.flowbuilder.util.xml.XMLException;
import com.triloggroup.gantt.EmptyNode;
import com.triloggroup.gantt.GanttChartException;
import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.GanttWBS;
import com.triloggroup.gantt.GlobalContext;
import com.triloggroup.gantt.ProjectModel;
import com.triloggroup.gantt.Resource;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.TaskResource;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.AppGanttChartModel;
import com.triloggroup.gantt.app.ChangeCanceledException;
import com.triloggroup.gantt.app.NodeRef;
import com.triloggroup.gantt.app.SaveResult;
import com.triloggroup.gantt.app.Status;
import com.triloggroup.gantt.app.UnexpectedChangeException;
import com.triloggroup.gantt.app.applet.GanttAppletBase;
import com.triloggroup.gantt.app.change.Change;
import com.triloggroup.gantt.app.change.ChangeException;
import com.triloggroup.gantt.app.change.TransformWBSIntoTaskChange;
import com.triloggroup.gantt.app.social.NodeSocialData;
import com.triloggroup.gantt.event.GanttModelSelectionEvent;
import com.triloggroup.gantt.pe.PETimeUnits;
import com.triloggroup.gantt.pe.app.AppScheduleComputation;
import com.triloggroup.gantt.pe.app.CalendarAccessor;
import com.triloggroup.gantt.pe.app.ChangeResult;
import com.triloggroup.gantt.pe.app.GanttChangeHandler;
import com.triloggroup.gantt.pe.app.PEAppGlobalContext;
import com.triloggroup.gantt.pe.app.PEAppProjectModel;
import com.triloggroup.gantt.pe.app.ServerChangesCreator;
import com.triloggroup.gantt.pe.app.TaskUpdater;
import com.triloggroup.gantt.pe.app.WBSUpdater;
import com.triloggroup.gantt.pe.app.alerts.AlertManager;
import com.triloggroup.project.ObjectRef;
import com.triloggroup.project.components.IdentifiableObject;
import com.triloggroup.project.components.resourceeditor.CostRateUnit;
import com.triloggroup.project.components.resourceeditor.ProjectResource;
import com.triloggroup.project.components.resourceeditor.ProjectRole;
import com.triloggroup.project.components.resourceeditor.ProjectTeam;
import com.triloggroup.project.components.ui.Workbench;
import com.triloggroup.project.schedule.CalendarUtil;
import com.triloggroup.project.schedule.ScheduleCalendar;
import com.triloggroup.util.Message;
import com.triloggroup.util.NLSBundle;
import com.triloggroup.util.UString;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PEAppGanttChartModel
extends AppGanttChartModel {
    private AlertManager alertManager;

    public PEAppGanttChartModel(String string, String string2) {
        super(string, string2);
        this.changeManager.registerHandler(new GanttChangeHandler(this));
    }

    @Override
    protected GlobalContext createGlobalContext(String string) {
        return new PEAppGlobalContext(string);
    }

    @Override
    protected ProjectModel createProjectModel(String string) {
        PEAppProjectModel pEAppProjectModel = new PEAppProjectModel(this.globalContext, string, this);
        return pEAppProjectModel;
    }

    @Override
    public PEAppProjectModel getProjectModel(String string) {
        return (PEAppProjectModel)super.getProjectModel(string);
    }

    @Override
    public PEAppProjectModel getMainProjectModel() {
        return (PEAppProjectModel)super.getMainProjectModel();
    }

    @Override
    public PEAppGlobalContext getGlobalContext() {
        return (PEAppGlobalContext)this.globalContext;
    }

    protected void refresh() {
        this.fireNodesChanged(null);
    }

    public void init(GanttAppletBase ganttAppletBase, String string, String string2, Date date) throws XMLException, GanttChartException {
        CostRateUnit.init(Workbench.get().getNLSBundle());
        PEAppGlobalContext pEAppGlobalContext = this.getGlobalContext();
        pEAppGlobalContext.setServerBaseUrl(string);
        pEAppGlobalContext.setWSSessionId(string2);
        pEAppGlobalContext.setApplet(ganttAppletBase);
        this.alertManager = new AlertManager();
        this.alertManager.loadAsync(this.getMainProjectModel().getProjectContext().getWSHelper());
        this.init(date, 256);
    }

    protected void init(Date date, int n) throws GanttChartException {
        ArrayList<NodeRef> arrayList;
        TGNode tGNode = this.getRootNode();
        ArrayList<NodeRef> arrayList2 = arrayList = tGNode == null ? null : new ArrayList<NodeRef>();
        if (tGNode != null) {
            this.getLoadedSubprojects(tGNode, arrayList);
        }
        this.changeManager.clear();
        this.resetTaskSeriesForInit();
        try {
            Element element = this.getMainProjectModel().getProjectContext().getWSHelper().getScheduleDataFromWS(n);
            PEAppGlobalContext pEAppGlobalContext = this.getGlobalContext();
            NLSBundle nLSBundle = Workbench.get().getNLSBundle();
            PETimeUnits pETimeUnits = Workbench.get().getTimeUnits();
            this.getGlobalContext().init(date, nLSBundle, pETimeUnits, pEAppGlobalContext);
            this.getGlobalContext().additionalInit(element);
            this.getGlobalContext().computeClientServerTimeOffset(this.getMainProjectModel().getProjectContext().getWSHelper().getServerTime());
            this.fireSelectionChanged(new GanttModelSelectionEvent(this, 0, null, 0, null));
            this.getMainProjectModel().init(element);
            Element element2 = element.getChild("global");
            Element element3 = element2.getChild("properties");
            if (element3 != null) {
                Workbench workbench = Workbench.get();
                List object3 = element3.getChildren("prop");
                for (Object object : object3) {
                    workbench.addProperty(object.getAttributeValue("name"), object.getText());
                }
            }
            if (arrayList != null) {
                for (NodeRef nodeRef : arrayList) {
                    Object object;
                    PEAppProjectModel pEAppProjectModel = this.getProjectModel(nodeRef.projectId);
                    if (pEAppProjectModel == null || (object = pEAppProjectModel.getNodeByUid(nodeRef.id)) == null) continue;
                    this.loadSubproject((GanttWBS)object);
                }
            }
        }
        catch (GanttChartException ganttChartException) {
            throw ganttChartException;
        }
        catch (Exception exception) {
            throw new GanttChartException("Error during initialization of the Gantt chart model", exception);
        }
    }

    public AlertManager getAlertManager() {
        return this.alertManager;
    }

    public GanttWBS loadSubproject(GanttWBS ganttWBS) throws GanttChartException {
        if (ganttWBS.isBrokenSubprojectLink()) {
            return null;
        }
        try {
            String string = ganttWBS.getSubProject().getId();
            PEAppProjectModel pEAppProjectModel = new PEAppProjectModel(this.getGlobalContext(), string, this);
            Element element = pEAppProjectModel.getProjectContext().getWSHelper().getScheduleDataFromWS(256);
            pEAppProjectModel.init(element);
            this.projectModels.put(string, pEAppProjectModel);
            ganttWBS.setAdditionalCost(0.0);
            ganttWBS.setSpecifiedActualAdditionalCost(null);
            ganttWBS.addSubtask(pEAppProjectModel.getRootNode());
            return pEAppProjectModel.getRootNode();
        }
        catch (GanttChartException ganttChartException) {
            throw ganttChartException;
        }
        catch (Exception exception) {
            throw new GanttChartException("Error loading subproject", exception);
        }
    }

    public void unloadSubproject(GanttWBS ganttWBS) {
        if (ganttWBS.getAllSubTaskCount() == 0) {
            return;
        }
        this.collapseNode(ganttWBS);
        String string = ganttWBS.getSubProject().getId();
        this.projectModels.remove(string);
        GanttNode ganttNode = ganttWBS.getSubtaskInAll(0);
        ganttWBS.removeSubtask(ganttNode);
    }

    public void rebuildAllFromServer() throws GanttChartException {
        this.getMainProjectModel().setUpdatingResources(true);
        this.init(this.globalContext.getCurrentDate(), 256);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PEAppGanttChartModel.this.getMainProjectModel().setUpdatingResources(false);
                PEAppGanttChartModel.this.fireStructureChanged();
                PEAppGanttChartModel.this.getMainProjectModel().fireResourcesUpdated(65535);
            }
        });
    }

    private GanttNode[] refreshNodesFromServer(String string, String[] stringArray) throws GanttChartException {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        try {
            Element element = this.getProjectModel(string).getProjectContext().getWSHelper().getNodesDataFromWS(stringArray, this.getProjectModel(string).getTimesheetLevel());
            List list = element.getChildren("e");
            if (list == null || list.size() != stringArray.length) {
                int n = list == null ? 0 : list.size();
                throw new GanttChartException("Refresh nodes uncomplete (" + n + '/' + stringArray.length + "). Full resfresh is needed");
            }
            ArrayList<GanttNode> arrayList = new ArrayList<GanttNode>();
            for (Element element2 : list) {
                String string2 = JDOMUtil.getString(element2, "inId");
                GanttNode ganttNode = this.getProjectModel(string).getNodeByUid(string2);
                String string3 = ganttNode.getParentHierarchicalId();
                this.getProjectModel(string).updateNode(ganttNode, element2);
                if (ganttNode != this.getRootNode() && !UString.equals(string3, ganttNode.getParentHierarchicalId())) {
                    throw new GanttChartException("Refresh of node " + ganttNode.getName() + " not supported. Full resfresh is needed");
                }
                arrayList.add(ganttNode);
            }
            TGNode[] tGNodeArray = new GanttNode[arrayList.size()];
            tGNodeArray = arrayList.toArray(tGNodeArray);
            this.getProjectModel(string).runFullBackwardSchedule(true);
            this.fireNodesChanged(tGNodeArray);
            return tGNodeArray;
        }
        catch (Exception exception) {
            if (exception instanceof GanttChartException) {
                throw (GanttChartException)exception;
            }
            throw new GanttChartException(2, "Error in refresh Nodes FromServer", exception);
        }
    }

    public SaveResult saveChanges() throws GanttChartException {
        SaveResult saveResult = new SaveResult();
        if (!this.changeManager.hasChange()) {
            return saveResult;
        }
        ArrayList<Change> arrayList = this.createSrvChanges(this.changeManager.getAllChanges());
        ChangeResult[] changeResultArray = null;
        try {
            changeResultArray = this.getMainProjectModel().getProjectContext().getWSHelper().applyChangesByWS(arrayList);
        }
        catch (Throwable throwable) {
            if (throwable instanceof GanttChartException) {
                throw (GanttChartException)throwable;
            }
            throw new GanttChartException(2, "Error in applyChanges", throwable);
        }
        if (changeResultArray != null) {
            Object object;
            Object object22;
            ArrayList<Change> arrayList2 = new ArrayList<Change>(arrayList.size());
            ObjectsRefByProjetId objectsRefByProjetId = new ObjectsRefByProjetId();
            ObjectsRefByProjetId objectsRefByProjetId2 = new ObjectsRefByProjetId();
            HashSet<ObjectRef> hashSet = new HashSet<ObjectRef>();
            boolean bl = false;
            for (int i = 0; i < changeResultArray.length; ++i) {
                boolean bl2;
                object22 = changeResultArray[i];
                if (((com.triloggroup.pe.webservices.gantt.ChangeResult)object22).getResultCode() == -2147483548) {
                    saveResult.setIntegrityError(true);
                    continue;
                }
                boolean bl3 = bl2 = ((com.triloggroup.pe.webservices.gantt.ChangeResult)object22).getResultCode() == Integer.MIN_VALUE || ((com.triloggroup.pe.webservices.gantt.ChangeResult)object22).getResultCode() == -2147483647;
                if (bl2) {
                    if (ProjectResource.TYPE.code.equals(((com.triloggroup.pe.webservices.gantt.ChangeResult)object22).getTargetType())) {
                        objectsRefByProjetId2.add(new ObjectRef(null, ((com.triloggroup.pe.webservices.gantt.ChangeResult)object22).getProjectId(), ((com.triloggroup.pe.webservices.gantt.ChangeResult)object22).getId()));
                    } else if (!ProjectTeam.TYPE.code.equals(((com.triloggroup.pe.webservices.gantt.ChangeResult)object22).getTargetType()) && !ProjectRole.TYPE.code.equals(((com.triloggroup.pe.webservices.gantt.ChangeResult)object22).getTargetType())) {
                        objectsRefByProjetId.add(new ObjectRef(null, ((com.triloggroup.pe.webservices.gantt.ChangeResult)object22).getProjectId(), ((com.triloggroup.pe.webservices.gantt.ChangeResult)object22).getId()));
                    }
                } else {
                    hashSet.add(new ObjectRef(null, ((com.triloggroup.pe.webservices.gantt.ChangeResult)object22).getProjectId(), ((com.triloggroup.pe.webservices.gantt.ChangeResult)object22).getId()));
                    arrayList2.add(arrayList.get(i));
                }
                if (((ChangeResult)object22).getMessage() != null) {
                    String string = ((ChangeResult)object22).getMessage();
                    object = bl2 ? Message.newWarning(string) : Message.newError(string);
                    ((Message)object).data = arrayList.get(i).getTarget();
                    saveResult.getMessages().addMessage((Message)object);
                }
                if (((com.triloggroup.pe.webservices.gantt.ChangeResult)object22).getResultCode() != -2147483647) continue;
                bl = true;
            }
            if (!hashSet.isEmpty()) {
                bl = true;
            }
            if (!bl) {
                for (Object object22 : this.projectModels.keySet()) {
                    try {
                        if (!objectsRefByProjetId2.isObjectsRefForProjectIdEmpty((String)object22)) {
                            this.getProjectModel((String)object22).refreshResourcesFromServer(objectsRefByProjetId2.getObjectIdsArrayForProjectId((String)object22));
                        }
                        if (objectsRefByProjetId.isObjectsRefForProjectIdEmpty((String)object22)) continue;
                        this.refreshNodesFromServer((String)object22, objectsRefByProjetId.getObjectIdsArrayForProjectId((String)object22));
                    }
                    catch (GanttChartException ganttChartException) {
                        ganttChartException.printStackTrace();
                        System.out.println("Cannot partially refresh server so rebuildAllFromServer");
                        bl = true;
                    }
                }
            }
            if (bl) {
                this.rebuildAllFromServer();
            }
            if (hashSet.isEmpty()) {
                saveResult.setStatus(0);
                this.changeManager.clear();
            } else {
                if (objectsRefByProjetId.isEmpty() && objectsRefByProjetId2.isEmpty()) {
                    saveResult.setStatus(2);
                } else {
                    saveResult.setStatus(1);
                }
                ArrayList<IdentifiableObject> arrayList3 = new ArrayList<IdentifiableObject>(hashSet.size());
                object22 = new ArrayList<Change>();
                ArrayList<Change> arrayList4 = new ArrayList<Change>();
                for (int i = 0; i < arrayList2.size(); ++i) {
                    object = (Change)arrayList2.get(i);
                    try {
                        ((Change)object).setLinkedToPreviousChange(false);
                        this.changeManager.applyChange((Change)object, false, true, (List<Change>)object22);
                    }
                    catch (ChangeException changeException) {
                        changeException.printStackTrace();
                        arrayList4.add((Change)object);
                    }
                    if (!hashSet.remove(new ObjectRef(null, ((Change)object).getTarget().getProjectId(), ((Change)object).getTarget().getUid()))) continue;
                    arrayList3.add(((Change)object).getTarget());
                }
                saveResult.setNotSavedNodes(arrayList3);
                saveResult.setChangesNotReaplied(arrayList4);
                this.changeManager.setAllChanges((ArrayList<Change>)object22);
            }
        }
        return saveResult;
    }

    protected ArrayList<Change> createSrvChanges(List<Change> list) {
        return ServerChangesCreator.createSrvChanges(list);
    }

    @Override
    protected boolean checkComputeAndUpdateTaskValues(GanttTask ganttTask, GanttTask ganttTask2, Component component, int n, boolean bl, boolean bl2) throws ChangeException {
        TaskUpdater taskUpdater = new TaskUpdater(ganttTask, ganttTask2, this, component, n);
        PEAppProjectModel pEAppProjectModel = this.getProjectModel(ganttTask2.getProjectId());
        GanttWBS ganttWBS = ganttTask != null ? (GanttWBS)ganttTask.getParent() : null;
        GanttWBS ganttWBS2 = UString.isEmpty(ganttTask2.getParentHierarchicalId()) ? null : pEAppProjectModel.getWBSByHierarchicalId(ganttTask2.getParentHierarchicalId());
        long l = 0L;
        long l2 = 0L;
        TaskResource[] taskResourceArray = null;
        String string = null;
        if (ganttTask != null) {
            l = ganttTask.getStartDate().getTime();
            l2 = ganttTask.getFinishDate().getTime();
            taskResourceArray = ganttTask.getResources();
            string = ganttTask.getStatus();
        }
        try {
            Change change = taskUpdater.checkComputeAndUpdateOriginal();
            if (!Change.isNullOperation(change)) {
                if (bl) {
                    change.setLinkedToPreviousChange(true);
                }
                if (!bl2) {
                    this.changeManager.addChange(change);
                }
                if (change.getOperation() == 1) {
                    pEAppProjectModel.addNodeToInternalLists(ganttTask2);
                    this.fireStructureChanged();
                } else {
                    if (change.getOperation() == 0) {
                        pEAppProjectModel.updateResourceMaps(ganttTask, l, l2, taskResourceArray, string);
                    }
                    if (ganttWBS != null && ganttWBS != ganttWBS2) {
                        this.fireStructureChanged();
                    } else {
                        this.fireNodeChanged(ganttTask);
                    }
                }
                pEAppProjectModel.updateBackwardSchedule(change);
            }
            return true;
        }
        catch (ChangeCanceledException changeCanceledException) {
            return false;
        }
    }

    @Override
    public void checkComputeAndUpdateWBSValues(GanttWBS ganttWBS, GanttWBS ganttWBS2, Component component) throws ChangeException {
        this.checkComputeAndUpdateWBSValues(ganttWBS, ganttWBS2, component, false, false);
    }

    public void checkComputeAndUpdateWBSValues(GanttWBS ganttWBS, GanttWBS ganttWBS2, Component component, boolean bl, boolean bl2) throws ChangeException {
        WBSUpdater wBSUpdater = new WBSUpdater(ganttWBS, ganttWBS2, this, component);
        PEAppProjectModel pEAppProjectModel = this.getProjectModel(ganttWBS2.getProjectId());
        GanttWBS ganttWBS3 = UString.isEmpty(ganttWBS2.getParentHierarchicalId()) ? null : pEAppProjectModel.getWBSByHierarchicalId(ganttWBS2.getParentHierarchicalId());
        GanttWBS ganttWBS4 = ganttWBS != null ? (GanttWBS)ganttWBS.getParent() : null;
        String string = ganttWBS == null ? null : ganttWBS.getHierarchicalId();
        try {
            Change change = wBSUpdater.checkComputeAndUpdateOriginal();
            if (!Change.isNullOperation(change)) {
                if (bl) {
                    change.setLinkedToPreviousChange(true);
                }
                if (!bl2) {
                    this.changeManager.addChange(change);
                }
                if (change.getOperation() == 1) {
                    pEAppProjectModel.addNodeToInternalLists(ganttWBS2);
                    ArrayList<TGNode> arrayList = ganttWBS2.getAllChildrenAndSubChildren(false);
                    for (int i = 0; i < arrayList.size(); ++i) {
                        TGNode tGNode = arrayList.get(i);
                        if (!(tGNode instanceof GanttNode)) continue;
                        pEAppProjectModel.addNodeToInternalLists((GanttNode)tGNode);
                    }
                    this.fireStructureChanged();
                } else {
                    if (!(change.getOperation() == 0 && change.getFieldModifications().isEmpty() || ganttWBS4 == null || ganttWBS4 == ganttWBS3)) {
                        pEAppProjectModel.updateWBSMap(ganttWBS, string);
                        this.fireStructureChanged();
                        return;
                    }
                    this.fireNodeChanged(ganttWBS);
                }
            }
        }
        catch (ChangeCanceledException changeCanceledException) {
            // empty catch block
        }
    }

    @Override
    public EmptyNode newEmptyNode() {
        String string = AppScheduleComputation.newObjectId("Dummy_");
        EmptyNode emptyNode = new EmptyNode(string);
        emptyNode.setNodeContext(this.getMainProjectModel().getProjectContext());
        return emptyNode;
    }

    @Override
    public String newTaskUid() {
        return AppScheduleComputation.newObjectId("Task_");
    }

    @Override
    public String newWBSUid() {
        return AppScheduleComputation.newObjectId("Wbs_");
    }

    @Override
    public GanttTask newGanttTask(GanttWBS ganttWBS, GanttNode ganttNode) {
        if (ganttWBS == null) {
            ganttWBS = (GanttWBS)this.getRootNode();
        }
        PEAppProjectModel pEAppProjectModel = this.getProjectModel(ganttWBS.getProjectId());
        String string = this.newTaskUid();
        String string2 = ganttWBS.getHierarchicalId();
        int n = ganttNode != null ? ganttNode.getSubId() + 1 : this.getNextTaskSubId(ganttWBS);
        String string3 = string2 + '.' + n;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        ((Calendar)gregorianCalendar).add(5, 1);
        this.resetHours(gregorianCalendar);
        Date date = gregorianCalendar.getTime();
        ScheduleCalendar[] scheduleCalendarArray = new ScheduleCalendar[]{pEAppProjectModel.getProjectContext().getProjectCalendar()};
        date = CalendarUtil.getFirstStartDate(date, scheduleCalendarArray);
        if (ganttWBS != null && ganttWBS.getStartDate().after(date)) {
            date = (Date)ganttWBS.getStartDate().clone();
            date = CalendarUtil.getFirstStartDate(date, scheduleCalendarArray);
        }
        gregorianCalendar.setTime(date);
        this.resetHours(gregorianCalendar);
        date = gregorianCalendar.getTime();
        Date date2 = (Date)date.clone();
        String string4 = AppGanttChart.NLS_BUNDLE.getString("newTaskName");
        GanttTask ganttTask = new GanttTask(null, string3, string4, string, date, date2);
        ganttTask.setNodeContext(ganttWBS.getNodeContext());
        ganttTask.setStatus(Status.PENDING.getCode());
        ganttTask.setSchedulingMode(pEAppProjectModel.getProjectSchedulingMode());
        PETimeUnits pETimeUnits = Workbench.get().getTimeUnits();
        ganttTask.setDurationFormat(pETimeUnits.getDayTimeUnit().getCode());
        ganttTask.setDurationDisplay(1.0);
        ganttTask.setWorkFormat(pETimeUnits.getHourTimeUnit().getCode());
        ganttTask.setWorkDisplay(pEAppProjectModel.getProjectHoursPerDay());
        ganttTask.setParent(ganttWBS);
        return ganttTask;
    }

    @Override
    public TransformWBSIntoTaskChange transformWBSIntoTask(GanttWBS ganttWBS) throws ChangeException {
        try {
            String string = ganttWBS.getUid();
            string = "Task" + string.substring(string.indexOf(95));
            GanttWBS ganttWBS2 = (GanttWBS)ganttWBS.getParent();
            Date date = (Date)ganttWBS.getStartDate().clone();
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(date);
            this.resetHours(gregorianCalendar);
            date = gregorianCalendar.getTime();
            GanttTask ganttTask = this.newGanttTask(ganttWBS2, null);
            ganttTask.setUid(string);
            ganttTask.setName(ganttWBS.getName());
            ganttTask.setHierarchicalId(ganttWBS.getHierarchicalId());
            ganttTask.setStartDate(date);
            ganttTask.setFinishDate((Date)date.clone());
            ganttTask.setNodeDescription(ganttWBS.getNodeDescription());
            Resource[] resourceArray = ganttWBS.getResources();
            TaskResource[] taskResourceArray = new TaskResource[resourceArray.length];
            for (int i = 0; i < taskResourceArray.length; ++i) {
                taskResourceArray[i] = new TaskResource(resourceArray[i], 100);
            }
            ganttTask.setResources(taskResourceArray);
            ganttTask.setAdditionalCost(ganttWBS.getAdditionalCost());
            ganttTask.setAdditionalCostDescription(ganttWBS.getAdditionalCostDescription());
            ganttTask.setSpecifiedActualAdditionalCost(ganttWBS.getSpecifiedActualAdditionalCost());
            NodeSocialData nodeSocialData = ganttWBS.getSocialData();
            ganttTask.getSocialData().updateSummary(nodeSocialData.getBookmarkCount(), nodeSocialData.getCommentCount(), nodeSocialData.getLastCommentDate(), nodeSocialData.getDeliverableCount());
            TaskUpdater taskUpdater = new TaskUpdater(null, ganttTask, this, null, 0);
            taskUpdater.checkAndCompute();
            taskUpdater.beforeUpdate();
            PEAppProjectModel pEAppProjectModel = this.getProjectModel(ganttWBS.getProjectId());
            pEAppProjectModel.addNodeToInternalLists(ganttTask);
            pEAppProjectModel.removeNodeOfInternalLists(ganttWBS);
            ganttWBS2.removeSubtask(ganttWBS);
            ganttWBS2.addSubtask(ganttTask);
            pEAppProjectModel.getScheduleComputation().onPostUpdateTaskValues(ganttTask, false, null);
            TransformWBSIntoTaskChange transformWBSIntoTaskChange = new TransformWBSIntoTaskChange(ganttWBS, ganttTask);
            pEAppProjectModel.updateBackwardSchedule(transformWBSIntoTaskChange);
            if (this.isSelectedNode(ganttWBS)) {
                TGNode[] tGNodeArray = this.getSelectedNodes();
                if (tGNodeArray.length > 1) {
                    for (int i = 0; i < tGNodeArray.length; ++i) {
                        if (ganttWBS != tGNodeArray[i]) continue;
                        tGNodeArray[i] = ganttTask;
                        break;
                    }
                    this.setSelectedNodes(tGNodeArray);
                } else {
                    this.setSelectedNodes(ganttTask);
                }
            }
            this.fireStructureChanged();
            return transformWBSIntoTaskChange;
        }
        catch (ChangeException changeException) {
            throw changeException;
        }
        catch (Exception exception) {
            throw new UnexpectedChangeException(exception);
        }
    }

    private void resetHours(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    @Override
    protected void updateSuccessorsOfDeletedTasksAndSchedule(HashMap<String, GanttNode> hashMap, GanttWBS ganttWBS, Change change) throws ChangeException {
        super.updateSuccessorsOfDeletedTasksAndSchedule(hashMap, ganttWBS, change);
    }

    @Override
    protected GanttWBS cloneWBS(GanttWBS ganttWBS, GanttWBS ganttWBS2, Map<String, String> map) throws ChangeException {
        return super.cloneWBS(ganttWBS, ganttWBS2, map);
    }

    @Override
    protected synchronized void fireStructureChanged() {
        super.fireStructureChanged();
    }

    @Override
    protected GanttTask cloneTaskInternal(GanttTask ganttTask, GanttWBS ganttWBS, String string) throws ChangeException {
        GanttTask ganttTask2 = super.cloneTaskInternal(ganttTask, ganttWBS, string);
        TaskUpdater taskUpdater = new TaskUpdater(null, ganttTask2, this, null, 0);
        try {
            taskUpdater.checkComputeAndUpdateOriginal();
        }
        catch (ChangeCanceledException changeCanceledException) {
            throw new UnexpectedChangeException(changeCanceledException);
        }
        return ganttTask2;
    }

    @Override
    public boolean touchSession() throws Exception {
        return this.getMainProjectModel().getProjectContext().getWSHelper().touchSession();
    }

    @Override
    public Date adjustStartDateForTask(GanttTask ganttTask, Date date) {
        ScheduleCalendar[] scheduleCalendarArray;
        ScheduleCalendar scheduleCalendar;
        CalendarAccessor calendarAccessor = this.getProjectModel(ganttTask.getProjectId()).getCalendarAccessor();
        ScheduleCalendar scheduleCalendar2 = calendarAccessor.getProjectCalendar();
        if (AppScheduleComputation.isWorkingDay(date, scheduleCalendar2, scheduleCalendar = calendarAccessor.getTaskCalendar(ganttTask), scheduleCalendarArray = calendarAccessor.getTaskCalendars(ganttTask))) {
            return date;
        }
        if (scheduleCalendar2.isWorkingDay(date)) {
            return date;
        }
        Date date2 = (Date)date.clone();
        for (int i = 0; i < 3; ++i) {
            date2.setDate(date2.getDate() + 1);
            if (AppScheduleComputation.isWorkingDay(date2, scheduleCalendar2, scheduleCalendar, scheduleCalendarArray)) {
                return date2;
            }
            if (!scheduleCalendar2.isWorkingDay(date2)) continue;
            return date;
        }
        return date;
    }

    private void getLoadedSubprojects(TGNode tGNode, Collection<NodeRef> collection) {
        Serializable serializable;
        GanttWBS ganttWBS;
        int n = tGNode.getAllSubTaskCount();
        if (tGNode instanceof GanttWBS && (ganttWBS = (GanttWBS)tGNode).isSubProject() && n > 0) {
            serializable = new NodeRef(ganttWBS);
            collection.add((NodeRef)serializable);
        }
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                serializable = tGNode.getSubtaskInAll(i);
                this.getLoadedSubprojects((TGNode)serializable, collection);
            }
        }
    }

    private class ObjectsRefByProjetId {
        private HashMap<String, HashSet<ObjectRef>> objectsRefByPrjId = new HashMap();

        protected ObjectsRefByProjetId() {
        }

        public void add(ObjectRef objectRef) {
            HashSet<ObjectRef> hashSet = this.objectsRefByPrjId.get(objectRef.projectId);
            if (hashSet == null) {
                hashSet = new HashSet();
            }
            hashSet.add(objectRef);
            this.objectsRefByPrjId.put(objectRef.projectId, hashSet);
        }

        public boolean isObjectsRefForProjectIdEmpty(String string) {
            HashSet<ObjectRef> hashSet = this.objectsRefByPrjId.get(string);
            return hashSet == null || hashSet.isEmpty();
        }

        public String[] getObjectIdsArrayForProjectId(String string) {
            HashSet<ObjectRef> hashSet = this.objectsRefByPrjId.get(string);
            if (hashSet == null || hashSet.isEmpty()) {
                return new String[0];
            }
            String[] stringArray = new String[hashSet.size()];
            Iterator<ObjectRef> iterator = hashSet.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                stringArray[n] = iterator.next().id;
                ++n;
            }
            return stringArray;
        }

        public boolean isEmpty() {
            return this.objectsRefByPrjId.isEmpty();
        }
    }
}

