/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.pe.app;

import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.project.components.resourceeditor.ProjectResource;

public class ChangeResult
extends com.triloggroup.pe.webservices.gantt.ChangeResult {
    public ChangeResult() {
    }

    public ChangeResult(String string, int n, String string2, String string3) {
        super(string, n, string2, string3);
    }

    public String getMessage() {
        if (super.getMessage() != null) {
            return AppGanttChart.NLS_BUNDLE.getString(super.getMessage());
        }
        if (this.resultCode <= 0) {
            return null;
        }
        String string = null;
        if ("task".equals(this.targetType)) {
            string = ChangeResult.getTaskErrorMessageKey(this.resultCode);
        } else if ("wbs".equals(this.targetType)) {
            string = ChangeResult.getWBSErrorMessageKey(this.resultCode);
        } else if (ProjectResource.TYPE.code.equals(this.targetType)) {
            string = ChangeResult.getResourceErrorMessageKey(this.resultCode);
        }
        if (string == null) {
            string = "task_save_error_unknown";
        }
        return AppGanttChart.NLS_BUNDLE.getString(string);
    }

    public static String getTaskErrorMessageKey(int n) {
        if (n <= 0) {
            return null;
        }
        switch (n) {
            case 1: {
                return "task_save_error_1";
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return "task_save_error_" + n;
            }
            case 20: {
                return "task_save_error_predecessor_loop";
            }
            case 21: {
                return "task_save_error_predecessor_deleted";
            }
            case 111: {
                return "save_error_parent_wbs_not_found";
            }
            case 100: {
                return "task_save_error_reschedule";
            }
            case 0x7FFFFFFE: {
                return "task_save_error_doc_not_found";
            }
            case 0x7FFFFFFD: {
                return "task_save_error_doc_locked";
            }
            case 0x7FFFFFFC: {
                return "task_save_error_doc_modified";
            }
        }
        return "task_save_error_unknown";
    }

    public static String getWBSErrorMessageKey(int n) {
        if (n <= 0) {
            return null;
        }
        switch (n) {
            case 1: {
                return "task_save_error_1";
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return "wbs_save_error_" + n;
            }
            case 111: {
                return "save_error_parent_wbs_not_found";
            }
            case 0x7FFFFFFE: {
                return "wbs_save_error_doc_not_found";
            }
            case 0x7FFFFFFD: {
                return "wbs_save_error_doc_locked";
            }
            case 0x7FFFFFFC: {
                return "wbs_save_error_doc_modified";
            }
        }
        return "wbs_save_error_unknown";
    }

    public static String getResourceErrorMessageKey(int n) {
        switch (n) {
            case 0x1000011: 
            case 0x1000012: 
            case 0x1000013: 
            case 0x1000014: {
                return "resources_max_users_exceeded";
            }
            case 0x1000021: {
                return "resources_cannot_disable_yourself";
            }
            case 0x1000041: {
                return "resources_cannot_disable_admin";
            }
            case 16777282: {
                return "resources_cannot_disable_site_manager";
            }
            case 16777283: {
                return "resources_cannot_disable_super_user";
            }
            case 0x1000031: {
                return "resources_cannot_enable_user_disabled_at_higher_level";
            }
        }
        return null;
    }
}

