/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.pe.app;

import com.flowbuilder.util.TString;
import com.triloggroup.gantt.Debug;
import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.GanttWBS;
import com.triloggroup.gantt.Resource;
import com.triloggroup.gantt.TaskResource;
import com.triloggroup.gantt.app.financial.SubprojectFinancialData;
import com.triloggroup.gantt.pe.app.AppScheduleComputation;
import com.triloggroup.gantt.pe.app.CalendarAccessor;
import com.triloggroup.gantt.pe.app.PEAppProjectContext;
import com.triloggroup.gantt.pe.app.PEAppProjectModel;
import com.triloggroup.pe.timesheet.ItemTimeSheetData;
import com.triloggroup.project.components.resourceeditor.ProjectResource;
import com.triloggroup.project.financial.CostRates;
import com.triloggroup.project.financial.FinancialComputation;
import com.triloggroup.project.financial.FinancialSettings;
import com.triloggroup.project.schedule.ITaskResource;
import com.triloggroup.project.schedule.ScheduleCalendar;
import java.util.Date;

public class AppFinancialComputation
extends FinancialComputation {
    private PEAppProjectModel model;
    private double budgetDelta;

    public AppFinancialComputation(PEAppProjectModel pEAppProjectModel) {
        this.model = pEAppProjectModel;
    }

    public void process() {
        this.budgetDelta = 0.0;
        super.process();
        if (this.getDeclaredBudget() == 0.0) {
            this.model.getProjectContext().setComputedBudget(this.getComputedBudget());
        }
    }

    protected CostRates getCostRates(ITaskResource iTaskResource) {
        Resource resource = ((TaskResource)iTaskResource).getResource();
        if (resource instanceof ProjectResource) {
            return ((ProjectResource)resource).getCostRates();
        }
        return null;
    }

    protected CostRates getCostRates(String string) {
        ProjectResource projectResource = this.model.getProjectResource(string);
        return projectResource != null ? projectResource.getCostRates() : null;
    }

    protected double getProjectHoursPerDay() {
        return this.model.getProjectHoursPerDay();
    }

    protected double getProjectHoursPerWeek() {
        return this.model.getProjectHoursPerWeek();
    }

    protected double getProjectHoursPerMonth() {
        return this.model.getProjectHoursPerMonth();
    }

    protected Date getProjectStartDate() {
        return this.model.getProjectStartDate();
    }

    protected GanttWBS getRoot() {
        return this.model.getRootNode();
    }

    protected ItemTimeSheetData getTimeSheetData(FinancialComputation.IFinancialTask iFinancialTask) {
        return ((GanttTask)iFinancialTask).getTimeSheetData();
    }

    protected boolean isActualWorkComputationModeTimesheet() {
        return this.model.getProjectContext().isActualWorkComputationModeTimesheet();
    }

    protected double computeResourceCostBasedOnAssignments(FinancialComputation.IFinancialTask iFinancialTask) {
        ITaskResource[] iTaskResourceArray = iFinancialTask.getTaskResources();
        if (iTaskResourceArray.length > 1) {
            for (ITaskResource iTaskResource : iTaskResourceArray) {
                if (!(iTaskResource.getWork() < 0.0)) continue;
                this.initResourcesWork((GanttTask)iFinancialTask);
                break;
            }
        }
        return super.computeResourceCostBasedOnAssignments(iFinancialTask);
    }

    protected boolean processSubproject(FinancialComputation.IFinancialWBS iFinancialWBS) {
        GanttWBS ganttWBS = (GanttWBS)iFinancialWBS;
        if (GanttNode.isLoadedSubprojectLink(ganttWBS)) {
            GanttWBS ganttWBS2 = (GanttWBS)ganttWBS.getSubtaskInAll(0);
            PEAppProjectContext pEAppProjectContext = (PEAppProjectContext)ganttWBS2.getProjectContext();
            AppFinancialComputation appFinancialComputation = new AppFinancialComputation((PEAppProjectModel)pEAppProjectContext.getModel());
            appFinancialComputation.process();
            iFinancialWBS.setNodeActualAdditionalCost(ganttWBS2.getNodeActualAdditionalCost());
            iFinancialWBS.setActualAdditionalCost(ganttWBS2.getActualAdditionalCost());
            iFinancialWBS.setProjectedAdditionalCost(ganttWBS2.getProjectedAdditionalCost());
            iFinancialWBS.setInitiallyPlannedAdditionalCost(ganttWBS2.getInitiallyPlannedAdditionalCost());
            iFinancialWBS.setActualResourceCost(ganttWBS2.getActualResourceCost());
            iFinancialWBS.setProjectedResourceCost(ganttWBS2.getProjectedResourceCost());
            iFinancialWBS.setInitiallyPlannedResourceCost(ganttWBS2.getInitiallyPlannedResourceCost());
            if (appFinancialComputation.getDeclaredBudget() > 0.0) {
                this.budgetDelta += appFinancialComputation.getDeclaredBudget() - appFinancialComputation.getInitiallyPlannedCost();
            }
            return !"Pending".equals(pEAppProjectContext.getProjectStatus());
        }
        SubprojectFinancialData subprojectFinancialData = this.model.getGlobalContext().getSubprojectFinancialData(ganttWBS.getSubProject().getId());
        if (subprojectFinancialData != null && subprojectFinancialData.getDeclaredBudget() > 0.0 && TString.equals(subprojectFinancialData.getSettings().getCurrencyISOCode(), this.getFinancialSettings().getCurrencyISOCode())) {
            this.budgetDelta += subprojectFinancialData.getDeclaredBudget() - ganttWBS.getInitiallyPlannedAdditionalCost() - ganttWBS.getInitiallyPlannedResourceCost();
        }
        return !((GanttWBS)iFinancialWBS).isPending();
    }

    protected void processSubprojectNoRollup(FinancialComputation.IFinancialWBS iFinancialWBS) {
        GanttWBS ganttWBS = (GanttWBS)iFinancialWBS;
        if (GanttNode.isLoadedSubprojectLink(ganttWBS)) {
            this.processWBSIgnoreSubproject(ganttWBS);
        }
    }

    private void initResourcesWork(GanttTask ganttTask) {
        block12: {
            TaskResource[] taskResourceArray = ganttTask.getResources();
            if (taskResourceArray.length == 0) {
                return;
            }
            if (taskResourceArray.length == 1) {
                if (taskResourceArray[0].getWork() < 0.0) {
                    taskResourceArray[0].setWork(ganttTask.getWorkInHours());
                }
                return;
            }
            if (ganttTask.getWorkInHours() == 0.0) {
                for (int i = 0; i < taskResourceArray.length; ++i) {
                    taskResourceArray[i].setWork(0.0);
                }
                return;
            }
            GanttTask ganttTask2 = ganttTask.clone();
            AppScheduleComputation appScheduleComputation = this.model.getScheduleComputation();
            CalendarAccessor calendarAccessor = this.model.getCalendarAccessor();
            ScheduleCalendar scheduleCalendar = calendarAccessor.getProjectCalendar();
            ScheduleCalendar scheduleCalendar2 = calendarAccessor.getTaskCalendar(ganttTask);
            ScheduleCalendar[] scheduleCalendarArray = calendarAccessor.getTaskCalendars(ganttTask);
            try {
                double d;
                appScheduleComputation.calculateTaskComputedValues(ganttTask2, scheduleCalendar, scheduleCalendar2, scheduleCalendarArray);
                for (int i = 0; i < taskResourceArray.length; ++i) {
                    double d2 = ganttTask.getWorkInHours() / ganttTask2.getWorkInHours();
                    if (d2 != 1.0) {
                        System.out.println("Ratio: " + d2);
                    }
                    taskResourceArray[i].setWork(ganttTask2.getResources()[i].getWork() * d2);
                }
                if (!Debug.DEBUG) break block12;
                double d3 = 0.0;
                for (int i = 0; i < taskResourceArray.length; ++i) {
                    d3 += taskResourceArray[i].getWork();
                }
                if (d3 == ganttTask.getWorkInHours() || !((d = d3 / ganttTask.getWorkInHours()) < 0.99) && !(d > 1.01)) break block12;
                System.out.println("WARNING! " + d3 + '/' + ganttTask.getWorkInHours());
            }
            catch (Exception exception) {
                int n = 0;
                for (int i = 0; i < taskResourceArray.length; ++i) {
                    n += taskResourceArray[i].getUnit();
                }
                double d = ganttTask.getWorkInHours();
                for (int i = 0; i < taskResourceArray.length; ++i) {
                    taskResourceArray[i].setWork(d * (double)taskResourceArray[i].getUnit() / (double)n);
                }
            }
        }
    }

    public double getComputedBudget() {
        return this.getInitiallyPlannedCost() + this.budgetDelta;
    }

    protected FinancialSettings getFinancialSettings() {
        return this.model.getProjectContext().getFinancialSettings();
    }

    protected ScheduleCalendar getCalendar(String string) {
        return this.model.getCalendarAccessor().getCalendar(string);
    }

    protected String getProjectCalendarId() {
        return this.model.getProjectCalendar().getCalendarId();
    }

    protected String getResourceCalendarId(ITaskResource iTaskResource) {
        Resource resource = ((TaskResource)iTaskResource).getResource();
        return resource != null ? resource.getCalendarId() : null;
    }
}

