/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.ui;

import com.triloggroup.gantt.app.ui.WDUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class WDExpandableSection
extends JPanel {
    protected Icon expandIcon = WDUtil.getIcon("expand_section.gif");
    protected Icon collapseIcon = WDUtil.getIcon("collapse_section.gif");
    protected Insets emptyInsets = new Insets(0, 0, 0, 0);
    protected JLabel iconLabel;
    protected JLabel titleLabel;
    protected JSeparator separator = new JSeparator();
    protected JComponent content;
    protected GridBagConstraints contentConstraint = new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 18, 1, this.emptyInsets, 0, 0);
    protected int scrollWidth = UIManager.getInt("ScrollBar.width");

    public WDExpandableSection(String string, JComponent jComponent) {
        this.iconLabel = new JLabel(this.expandIcon);
        this.titleLabel = new JLabel(string);
        this.content = jComponent;
        this.setLayout(new GridBagLayout());
        this.add((Component)this.iconLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, this.emptyInsets, 0, 0));
        this.add((Component)this.titleLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, this.emptyInsets, 0, 0));
        this.add((Component)this.separator, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 17, 2, this.emptyInsets, 0, 0));
        this.iconLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (WDExpandableSection.this.isExpanded()) {
                    WDExpandableSection.this.collapse();
                } else {
                    WDExpandableSection.this.expand();
                }
            }
        });
    }

    public boolean isExpanded() {
        return this.content.getParent() != null;
    }

    public void expand() {
        if (this.content.getParent() == null) {
            this.add((Component)this.content, this.contentConstraint);
            this.iconLabel.setIcon(this.collapseIcon);
            this.revalidate();
            this.autoscroll();
        }
    }

    public void collapse() {
        this.remove(this.content);
        this.iconLabel.setIcon(this.expandIcon);
        this.revalidate();
    }

    private void autoscroll() {
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof JViewport)) continue;
            Dimension dimension = this.getPreferredSize();
            Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
            rectangle = SwingUtilities.convertRectangle(this, rectangle, container);
            rectangle.x = 0;
            ((JViewport)container).scrollRectToVisible(rectangle);
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (!this.isExpanded()) {
            dimension.width = Math.max(dimension.width, this.content.getPreferredSize().width + this.scrollWidth);
        }
        return dimension;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        if (!this.isExpanded()) {
            dimension.width = Math.max(dimension.width, this.content.getPreferredSize().width + this.scrollWidth);
        }
        return dimension;
    }
}

