/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.ui;

import com.greef.ui.calendar.DateSelectionEvent;
import com.greef.ui.calendar.DateSelectionListener;
import com.greef.ui.calendar.DateSelectionModel;
import com.greef.ui.calendar.DefaultDateSelectionModel;
import com.greef.ui.calendar.JCalendar;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.ui.WDButton;
import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.gantt.app.ui.WDUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.text.DateFormatSymbols;
import java.util.Date;
import java.util.Locale;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class WDCalendarDialog
extends WDDialog
implements DateSelectionListener,
WindowFocusListener {
    private JCalendar calendar;
    private Date selectedDate;
    private CallBack callBack;

    public static WDCalendarDialog create(Component component, Locale locale) {
        return WDCalendarDialog.create(component, locale, null);
    }

    public static WDCalendarDialog create(Component component, Locale locale, CallBack callBack) {
        Window window = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
        GraphicsConfiguration graphicsConfiguration = WDUtil.getGraphicsConfiguration(component);
        return new WDCalendarDialog(window, locale, graphicsConfiguration, callBack);
    }

    protected WDCalendarDialog(Window window, Locale locale, GraphicsConfiguration graphicsConfiguration) {
        this(window, locale, graphicsConfiguration, null);
    }

    protected WDCalendarDialog(Window window, Locale locale, GraphicsConfiguration graphicsConfiguration, CallBack callBack) {
        super(window, graphicsConfiguration);
        this.init(locale, callBack);
    }

    protected void init(Locale locale, CallBack callBack) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.calendar = new JCalendar(AppGanttChart.NLS_BUNDLE.getString("today_link"));
        this.calendar.setShowControls(true);
        this.calendar.setControlsPosition(1);
        this.calendar.setDateFormatSymbols(new DateFormatSymbols(locale));
        this.calendar.setShowHorizontalLines(true);
        this.calendar.setShowVerticalLines(true);
        this.calendar.setShowCellTooltips(true);
        this.calendar.setColor("Calendar.Today.Foreground", Color.RED);
        this.calendar.setSelectionMode(0);
        this.calendar.setWeekDayDisplayType(2);
        DefaultDateSelectionModel defaultDateSelectionModel = new DefaultDateSelectionModel();
        defaultDateSelectionModel.addDateSelectionListener((DateSelectionListener)this);
        this.calendar.setDateSelectionModel((DateSelectionModel)defaultDateSelectionModel);
        this.setDragHeader(true);
        this.setHighlightBorder(false);
        this.setDefaultCloseOperation(1);
        this.setMaximizable(false);
        this.getContentPane().setBackground(Color.WHITE);
        this.getContentPane().add((Component)this.calendar, "Center");
        JPanel jPanel = new JPanel(new FlowLayout(1, 5, 10));
        WDButton wDButton = WDUtil.createCancelButton();
        wDButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WDCalendarDialog.this.setVisible(false);
            }
        });
        jPanel.add(wDButton);
        this.getContentPane().add((Component)jPanel, "South");
        if (callBack != null) {
            this.callBack = callBack;
            this.setModal(false);
        }
    }

    public void windowGainedFocus(WindowEvent windowEvent) {
    }

    public void windowLostFocus(WindowEvent windowEvent) {
        this.setVisible(false);
    }

    public Date showDialog(Date date, Component component) {
        this.setCurrentValue(date);
        this.setVisible(-1, -1, -1, -1, component);
        return this.selectedDate;
    }

    public Date showDialog() {
        return this.showDialog(0L);
    }

    public Date showDialog(long l) {
        this.setVisibleDisableMouseEvents(l);
        return this.selectedDate;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (this.callBack != null) {
            if (bl) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        WDCalendarDialog.this.requestFocus();
                        WDCalendarDialog.this.addWindowFocusListener(WDCalendarDialog.this);
                    }
                });
            } else {
                this.removeWindowFocusListener(this);
            }
        }
    }

    public void setCurrentValue(Date date) {
        if (date != null) {
            this.calendar.setYear(date.getYear() + 1900);
            this.calendar.setMonth(date.getMonth());
            Date date2 = new Date(date.getYear(), date.getMonth(), date.getDate());
            this.calendar.getDateSelectionModel().setSelectionInterval(date2, null);
        }
    }

    public void changed(DateSelectionEvent dateSelectionEvent) {
        if (this.isVisible()) {
            Date date = this.calendar.getSelectedDate();
            if (date != null) {
                this.selectedDate = date;
                this.setVisible(false);
                if (this.callBack != null) {
                    this.callBack.dateSelected(date);
                }
            } else {
                int n = (int)this.calendar.getPreferredSize().getHeight() - this.calendar.getHeight();
                if (n != 0) {
                    this.pack();
                }
            }
        }
    }

    public static interface CallBack {
        public void dateSelected(Date var1);
    }
}

