/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.treetable;

import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.ITimeUnits;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.TimeUnit;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.AppGanttChartModel;
import com.triloggroup.gantt.app.AppProjectModel;
import com.triloggroup.gantt.app.treetable.AppGanttTreeTable;
import com.triloggroup.gantt.app.treetable.PredecessorsRenderer;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.project.components.ui.table.TextCellEditor;
import com.triloggroup.project.schedule.IPredecessor;
import com.triloggroup.project.schedule.Predecessor;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.swing.JTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredecessorsEditor
extends TextCellEditor {
    private ArrayList<IPredecessor> originalValue;
    private ArrayList<Predecessor> newValue;
    private AppGanttTreeTable ganttTable;
    private GanttTask editedNode;

    @Override
    public Object getCellEditorValue() {
        return this.newValue;
    }

    @Override
    protected String getTextValue(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.originalValue = (ArrayList)object;
        this.ganttTable = (AppGanttTreeTable)jTable;
        TGNode tGNode = this.ganttTable.getModel().nodeForRow(n);
        this.editedNode = tGNode instanceof GanttTask ? (GanttTask)tGNode : null;
        return PredecessorsRenderer.format(this.originalValue, this.ganttTable, (GanttNode)tGNode);
    }

    @Override
    public boolean stopCellEditing() {
        String string = this.getTextComponent().getText();
        try {
            this.newValue = this.parse(string);
        }
        catch (ParseException parseException) {
            String string2;
            this.getTextComponent().setBorder(ERROR_BORDER);
            this.getTextComponent().setCaretPosition(parseException.getErrorOffset());
            String string3 = null;
            if (parseException.getCause() != null && (string2 = parseException.getCause().getMessage()) != null && (string3 = AppGanttChart.NLS_BUNDLE.getString(parseException.getCause().getMessage())) == string2) {
                string3 = null;
            }
            if (string3 == null) {
                string3 = this.createErrorTooltipText();
            }
            this.getTextComponent().setToolTipText(string3);
            return false;
        }
        this.fireEditingStopped();
        return true;
    }

    private ArrayList<Predecessor> parse(String string) throws ParseException {
        int n;
        if (string == null || string.length() == 0) {
            return null;
        }
        LinkedHashMap<String, Predecessor> linkedHashMap = new LinkedHashMap<String, Predecessor>();
        int n2 = 0;
        do {
            char c;
            for (n = n2; n < string.length() && (c = string.charAt(n)) != ';' && c != ','; ++n) {
            }
            String string2 = string.substring(n2, n);
            try {
                IPredecessor iPredecessor = this.parsePredecessor(string2);
                if (linkedHashMap.put(((Predecessor)iPredecessor).getId(), (Predecessor)iPredecessor) != null) {
                    throw new ParseException(string2, 0);
                }
            }
            catch (ParseException parseException) {
                ParseException parseException2 = new ParseException(string, n2 + parseException.getErrorOffset());
                if (parseException.getCause() != null) {
                    parseException2.initCause(parseException.getCause());
                }
                throw parseException2;
            }
        } while ((n2 = n + 1) > 0 && n2 <= string.length());
        ArrayList<Predecessor> arrayList = new ArrayList<Predecessor>();
        if (this.originalValue != null) {
            for (IPredecessor iPredecessor : this.originalValue) {
                Predecessor predecessor = (Predecessor)linkedHashMap.remove(iPredecessor.getId());
                if (predecessor == null) continue;
                if (predecessor.getLag() == 0 && predecessor.getLagFormat() != iPredecessor.getLagFormat()) {
                    predecessor = new Predecessor(predecessor.getId(), predecessor.getType(), 0, iPredecessor.getLagFormat());
                }
                arrayList.add(predecessor);
            }
        }
        arrayList.addAll(linkedHashMap.values());
        return arrayList;
    }

    private void checkNodeCanBePredecessor(GanttNode ganttNode, AppGanttChartModel appGanttChartModel) {
        if (!(ganttNode instanceof GanttTask)) {
            throw new IllegalStateException("predecessor_invalid_not_task");
        }
        if (ganttNode == this.editedNode) {
            throw new IllegalStateException("predecessor_invalid_itself");
        }
        if (!ganttNode.isReadeable()) {
            throw new IllegalStateException();
        }
        if (appGanttChartModel.isSuccessor(this.editedNode, (GanttTask)ganttNode)) {
            throw new IllegalStateException("predecessor_invalid_already_successor");
        }
    }

    private Predecessor parsePredecessor(String string) throws ParseException {
        int n;
        GanttNode ganttNode;
        int n2;
        int n3;
        AppGanttChartModel appGanttChartModel = this.ganttTable.getGanttControler().getModel();
        ITimeUnits iTimeUnits = appGanttChartModel.getGlobalContext().getTimeUnits();
        int n4 = 1;
        int n5 = 0;
        int n6 = iTimeUnits.getHourTimeUnit().getCode();
        boolean bl = false;
        for (n3 = 0; n3 < string.length() && string.charAt(n3) == ' '; ++n3) {
        }
        for (n2 = n3; n2 < string.length(); ++n2) {
            char c = string.charAt(n2);
            if (c >= '0' && c <= '9') continue;
            if (c != '.') break;
            if (n2 == n3 || string.charAt(n2 - 1) == '.') {
                throw new ParseException(string, n2);
            }
            bl = true;
        }
        if (n2 == n3) {
            throw new ParseException(string, n2);
        }
        String string2 = string.substring(n3, n2);
        AppProjectModel appProjectModel = appGanttChartModel.getProjectModel(this.editedNode.getProjectId());
        if (bl) {
            ganttNode = appProjectModel.getNodeByHierarchicalId(string2);
        } else {
            n = Integer.parseInt(string2);
            ganttNode = appProjectModel.getNodeByLineId(n);
        }
        try {
            this.checkNodeCanBePredecessor(ganttNode, appGanttChartModel);
        }
        catch (IllegalStateException illegalStateException) {
            ParseException parseException = new ParseException(string, n3);
            if (illegalStateException.getMessage() != null) {
                parseException.initCause(illegalStateException);
            }
            throw parseException;
        }
        for (n3 = n2; n3 < string.length() && string.charAt(n3) == ' '; ++n3) {
        }
        for (n2 = n3; n2 < string.length() && (n = (int)string.charAt(n2)) != 43 && n != 45 && n != 32; ++n2) {
        }
        if (n2 > n3) {
            String string3 = string.substring(n3, n2);
            try {
                n4 = this.getType(string3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ParseException(string, n3);
            }
        }
        for (n3 = n2; n3 < string.length() && string.charAt(n3) == ' '; ++n3) {
        }
        if (n3 < string.length()) {
            boolean bl2;
            char c = string.charAt(n3);
            if (c == '+') {
                bl2 = false;
            } else if (c == '-') {
                bl2 = true;
            } else {
                throw new ParseException(string, n3);
            }
            for (n2 = ++n3; n2 < string.length() && (c = string.charAt(n2)) >= '0' && c <= '9'; ++n2) {
            }
            n5 = Integer.parseInt(string.substring(n3, n2));
            if (bl2) {
                n5 = -n5;
            }
            while (n2 < string.length() && string.charAt(n2) == ' ') {
                ++n2;
            }
            String string4 = string.substring(n2);
            try {
                TimeUnit timeUnit = this.getUnit(string4.trim(), iTimeUnits);
                n6 = timeUnit.getCode();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ParseException(string, n2);
            }
        }
        Predecessor predecessor = new Predecessor(ganttNode.getUid(), n4, n5, n6);
        return predecessor;
    }

    private int getType(String string) throws IllegalArgumentException {
        int n;
        String[] stringArray = Predecessor.getPredecessorTypesAsString();
        for (n = 0; n < stringArray.length; ++n) {
            String string2 = AppGanttChart.NLS_BUNDLE.getString(stringArray[n] + "Abbr");
            if (!string2.equalsIgnoreCase(string)) continue;
            return Predecessor.predecessorTypeAsInt(stringArray[n]);
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].equalsIgnoreCase(string)) continue;
            return Predecessor.predecessorTypeAsInt(stringArray[n]);
        }
        throw new IllegalArgumentException(string);
    }

    private TimeUnit getUnit(String string, ITimeUnits iTimeUnits) throws IllegalArgumentException {
        TimeUnit[] timeUnitArray = iTimeUnits.getAllTimeUnitsForLag();
        return TimeUnit.readUnit(string, timeUnitArray);
    }

    private String createErrorTooltipText() {
        StringBuilder stringBuilder = new StringBuilder();
        AppGanttChartModel appGanttChartModel = this.ganttTable.getGanttControler().getModel();
        this.appendExample("12", 1, 0, 0, appGanttChartModel, stringBuilder);
        stringBuilder.append(';');
        this.appendExample("13", 1, 0, 0, appGanttChartModel, stringBuilder);
        stringBuilder.append('\n');
        this.appendExample("12", 3, 3, 7, appGanttChartModel, stringBuilder);
        stringBuilder.append('\n');
        this.appendExample("8", 1, -5, 8, appGanttChartModel, stringBuilder);
        stringBuilder.append('\n');
        String string = WDUtil.swingHtmlEscape(stringBuilder.toString());
        return AppGanttChart.NLS_BUNDLE.getString("predecessors_editHelp", string);
    }

    private void appendExample(String string, int n, int n2, int n3, AppGanttChartModel appGanttChartModel, StringBuilder stringBuilder) {
        Predecessor predecessor = new Predecessor(string, n, n2, n3);
        PredecessorsRenderer.format(new PredecessorsRenderer.PredecessorData(predecessor, null), appGanttChartModel, stringBuilder, true);
    }
}

