/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.treetable;

import com.triloggroup.gantt.ITimeUnits;
import com.triloggroup.gantt.TGComputableDuration;
import com.triloggroup.gantt.TGDuration;
import com.triloggroup.gantt.TimeUnit;
import com.triloggroup.project.components.ui.Workbench;
import com.triloggroup.project.components.ui.table.TextCellEditor;
import com.triloggroup.project.components.util.format.TGDecimalFormat;
import com.triloggroup.util.UString;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import javax.swing.JTable;

public class DurationEditor2
extends TextCellEditor {
    protected TGDuration duration;
    protected ITimeUnits units;
    protected NumberFormat format;
    protected TimeUnit defaultUnit;

    public DurationEditor2(ITimeUnits iTimeUnits) {
        this.units = iTimeUnits;
        this.defaultUnit = iTimeUnits.getHourTimeUnit();
        this.format = TGDecimalFormat.getTGInstance(Workbench.get().getFormatLocale());
        this.getTextComponent().setHorizontalAlignment(4);
    }

    protected String getTextValue(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.duration = (TGDuration)object;
        return this.toString(this.duration);
    }

    protected String toString(TGDuration tGDuration) {
        if (tGDuration == null) {
            return "";
        }
        double d = tGDuration.getValue();
        String string = d > 1.0 ? this.duration.getUnit().getShortLabelPlural() : this.duration.getUnit().getShortLabel();
        return this.format.format(d) + ' ' + string;
    }

    public Object getCellEditorValue() {
        return this.duration;
    }

    public boolean stopCellEditing() {
        String string = this.getTextComponent().getText();
        try {
            if (UString.isEmpty(string) && this.duration instanceof TGComputableDuration) {
                this.duration = null;
            } else if (this.duration == null || !string.equals(this.toString(this.duration))) {
                this.duration = this.parseDuration(string.trim());
            }
        }
        catch (Exception exception) {
            this.getTextComponent().setBorder(ERROR_BORDER);
            return false;
        }
        return super.stopCellEditing();
    }

    private TGDuration parseDuration(String string) throws ParseException {
        Object object;
        if (string == null || string.length() == 0) {
            return null;
        }
        TimeUnit timeUnit = null;
        if (this.duration != null) {
            timeUnit = this.duration.getUnit();
        }
        if (timeUnit == null) {
            timeUnit = this.defaultUnit;
        }
        ParsePosition parsePosition = new ParsePosition(0);
        Number number = this.format.parse(string, parsePosition);
        int n = parsePosition.getIndex();
        if (n == 0) {
            throw new ParseException("Unparseable number: \"" + string + "\"", parsePosition.getErrorIndex());
        }
        while (n < string.length() && Character.isWhitespace(string.charAt(n))) {
            ++n;
        }
        if (n < string.length()) {
            object = string.substring(n);
            try {
                timeUnit = TimeUnit.readUnit((String)object, this.units.getAllTimeUnits());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ParseException(string, n);
            }
        }
        object = new TGDuration(number.doubleValue(), timeUnit);
        return object;
    }

    public TimeUnit getDefaultUnit() {
        return this.defaultUnit;
    }

    public void setDefaultUnit(TimeUnit timeUnit) {
        this.defaultUnit = timeUnit;
    }
}

