/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.treetable;

import com.triloggroup.gantt.app.ui.WDCalendarDialog;
import com.triloggroup.gantt.app.ui.WDCmdButton;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.project.components.ui.table.CellEditorWithLabel;
import com.triloggroup.project.components.ui.table.TextCellEditor;
import com.triloggroup.util.date.TGDateTimeFormat;
import com.triloggroup.util.date.TGTime;
import com.triloggroup.util.date.UDateFormat;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class DateEditor
extends TextCellEditor
implements FocusListener,
WDCalendarDialog.CallBack {
    protected JPanel panel;
    protected WDCmdButton button;
    protected WDCalendarDialog calendar;
    protected Locale locale;
    protected DateFormat dateFormat;
    protected Date date;
    protected boolean skipParsing = false;

    public DateEditor(Locale locale) {
        this(locale, UDateFormat.getDateInstance(locale));
    }

    public DateEditor(Locale locale, DateFormat dateFormat) {
        super(new CellEditorWithLabel.TextField());
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.locale = locale;
        this.getTextComponent().setBorder(BorderFactory.createEmptyBorder());
        this.panel = new JPanel(new BorderLayout()){

            protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
                return ((CellEditorWithLabel.TextField)DateEditor.this.getTextComponent()).processKeyBinding(keyStroke, keyEvent, n, bl);
            }
        };
        this.button = new WDCmdButton(WDUtil.getIcon("calendar.gif"));
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DateEditor.this.showDialogCalendar();
            }
        });
        this.panel.add((Component)this.getTextComponent(), "Center");
        this.panel.add((Component)this.button, "East");
        this.panel.addFocusListener(this);
        this.panel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.dateFormat = dateFormat;
    }

    protected void showDialogCalendar() {
        if (this.calendar == null) {
            this.calendar = WDCalendarDialog.create(this.panel, this.locale, this);
        }
        this.calendar.setCurrentValue(this.date);
        this.calendar.pack();
        Dimension dimension = this.calendar.getSize();
        Point point = new Point(0, 0);
        SwingUtilities.convertPointToScreen(point, this.panel);
        int n = point.x + (this.panel.getWidth() - (int)dimension.getWidth()) / 2;
        Rectangle rectangle = WDUtil.getDisplayBounds(this.panel);
        int n2 = this.panel.getHeight();
        for (Container container = this.panel.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof JViewport)) continue;
            Point point2 = SwingUtilities.convertPoint(this.panel, 0, 0, container);
            if (point2.y < -n2) {
                Point point3 = new Point(0, 0);
                SwingUtilities.convertPointToScreen(point3, container);
                point.y = point3.y;
                n2 = 0;
                break;
            }
            if (point2.y + this.panel.getHeight() <= container.getHeight()) break;
            Point point4 = new Point(0, container.getHeight());
            SwingUtilities.convertPointToScreen(point4, container);
            point.y = point4.y;
            n2 = 0;
            break;
        }
        if ((double)(point.y + n2 + dimension.height) <= rectangle.getMaxY()) {
            this.calendar.setLocation(n, point.y + n2);
        } else {
            this.calendar.setLocation(n, point.y - dimension.height);
        }
        this.calendar.showDialog(500L);
    }

    public void dateSelected(Date date) {
        if (date != null) {
            TGTime tGTime;
            this.date = date;
            if (this.dateFormat instanceof TGDateTimeFormat && (tGTime = ((TGDateTimeFormat)this.dateFormat).getDefaultTime()) != null) {
                this.date = tGTime.applyTime(date, this.dateFormat.getTimeZone());
            }
            this.skipParsing = true;
            this.stopCellEditing();
        }
    }

    public Object getCellEditorValue() {
        return this.date;
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        this.date = (Date)object;
        return this.panel;
    }

    protected String getTextValue(JTable jTable, Object object, boolean bl, int n, int n2) {
        return object == null ? "" : this.dateFormat.format((Date)object);
    }

    public boolean stopCellEditing() {
        if (!this.skipParsing) {
            String string = this.getTextComponent().getText();
            try {
                this.date = UDateFormat.parseFullString(string, this.dateFormat);
            }
            catch (ParseException parseException) {
                this.panel.setBorder(BorderFactory.createLineBorder(Color.RED));
                return false;
            }
        }
        this.skipParsing = false;
        return super.stopCellEditing();
    }

    public void focusGained(FocusEvent focusEvent) {
        this.getTextComponent().requestFocus();
    }

    public void focusLost(FocusEvent focusEvent) {
    }
}

