/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.treetable;

import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GanttProjectContext;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.treetable.AppGanttTreeTable;
import com.triloggroup.gantt.treetable.TGTreeTableModel;
import com.triloggroup.project.components.ui.UIConstants;
import com.triloggroup.project.components.ui.table.TGTableCellNumberRenderer;
import com.triloggroup.project.components.util.format.FormatUtil;
import com.triloggroup.project.financial.FinancialSettings;
import javax.swing.JComponent;
import javax.swing.JTable;

public class CostRenderer
extends TGTableCellNumberRenderer {
    private boolean initialized = false;
    protected boolean disabled = false;

    public JComponent getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Object object2;
        Object object3;
        Object object4;
        if (!this.initialized) {
            this.init(jTable);
        }
        FinancialSettings financialSettings = null;
        GanttNode ganttNode = null;
        if (!this.disabled && (object4 = jTable.getModel()) instanceof TGTreeTableModel && (object3 = ((TGTreeTableModel)(object2 = (TGTreeTableModel)object4)).nodeForRow(n)) instanceof GanttNode && (financialSettings = ((GanttProjectContext)(ganttNode = (GanttNode)object3).getProjectContext()).getFinancialSettings()) != null && financialSettings.getCurrencyFractionDigit() != this.format.getMinimumFractionDigits()) {
            int n3 = financialSettings.getCurrencyFractionDigit();
            this.format.setMinimumFractionDigits(n3);
            this.format.setMaximumFractionDigits(n3);
        }
        object4 = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (!this.disabled && ganttNode != null) {
            if (!ganttNode.isRollupFinancialDataToMainProject()) {
                ((JComponent)object4).setForeground(UIConstants.INVALID_ROW_FOREGROUND);
            }
            if (financialSettings != null) {
                object2 = financialSettings.getCurrencySymbol();
                object3 = this.getText();
                object3 = "before".equals(financialSettings.getCurrencySymbolPlacement()) ? (String)object2 + ' ' + (String)object3 : (String)object3 + ' ' + (String)object2;
                this.setText((String)object3);
            } else {
                this.setText("");
            }
        }
        return object4;
    }

    private void init(JTable jTable) {
        this.initialized = true;
        AppGanttChart appGanttChart = ((AppGanttTreeTable)jTable).getGanttControler();
        if (appGanttChart.getModel().getGlobalContext().hasFinancialModule()) {
            this.format = FormatUtil.getCostFormat(appGanttChart.getDateLocale(), appGanttChart.getModel().getMainProjectModel().getProjectContext().getFinancialSettings());
        } else {
            this.disabled = true;
        }
    }

    protected void setValue(Object object) {
        if (this.disabled) {
            String string = AppGanttChart.NLS_BUNDLE.getString("slack_NotApplicable");
            this.setText(string);
        } else {
            super.setValue(object);
        }
    }
}

