/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.treetable;

import com.triloggroup.gantt.EmptyNode;
import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GanttProjectContext;
import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.GanttWBS;
import com.triloggroup.gantt.ITimeUnits;
import com.triloggroup.gantt.Resource;
import com.triloggroup.gantt.TGChart;
import com.triloggroup.gantt.TGChartModel;
import com.triloggroup.gantt.TGDuration;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.TaskResource;
import com.triloggroup.gantt.TimeUnit;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.AppGanttChartModel;
import com.triloggroup.gantt.app.AppProjectModel;
import com.triloggroup.gantt.app.Status;
import com.triloggroup.gantt.app.dialog.StartEditWithPredecessorQuestionDialog;
import com.triloggroup.gantt.app.dialog.WorkOrDurationEditQuestionDialog;
import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.gantt.pe.app.SchedulingMode;
import com.triloggroup.gantt.treetable.GanttTreeTableModel;
import com.triloggroup.project.financial.FinancialSettings;
import com.triloggroup.project.schedule.IPredecessor;
import com.triloggroup.util.date.TGTime;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public abstract class AppGanttTreeTableModel
extends GanttTreeTableModel {
    protected JTable view;
    TGNode newNode = null;

    public AppGanttTreeTableModel(AppGanttChartModel appGanttChartModel, Locale locale, String[] stringArray) {
        super(appGanttChartModel, AppGanttChart.NLS_BUNDLE, locale, stringArray);
    }

    public void setView(JTable jTable) {
        this.view = jTable;
    }

    public String[] getDefaultColumnKeyNames(TGChartModel tGChartModel) {
        AppGanttChartModel appGanttChartModel = (AppGanttChartModel)tGChartModel;
        return new String[]{"Name", "StartDate", "EndDate", appGanttChartModel.getMainProjectModel().isDefaultDurationDriven() ? "Duration" : "Work", "Resources"};
    }

    public void setVisibleColumns(String[] stringArray) {
        int n;
        if (!((AppGanttChartModel)this.chartModel).getGlobalContext().hasFinancialModule()) {
            for (n = 0; n < stringArray.length; ++n) {
                if (!stringArray[n].endsWith("CostSum") && !stringArray[n].equals("AdditionalCost") && !stringArray[n].equals("ActualAdditionalCost") && !stringArray[n].equals("AdditionalCostDescription")) continue;
                stringArray = this.removeIndex(stringArray, n);
                --n;
            }
        }
        if (!((AppGanttChartModel)this.chartModel).getGlobalContext().hasTimesheetModule()) {
            for (n = 0; n < stringArray.length; ++n) {
                if (!stringArray[n].equals("WorkedHours")) continue;
                stringArray = this.removeIndex(stringArray, n);
                break;
            }
        }
        super.setVisibleColumns(stringArray);
    }

    private String[] removeIndex(String[] stringArray, int n) {
        String[] stringArray2 = new String[stringArray.length - 1];
        if (n > 0) {
            System.arraycopy(stringArray, 0, stringArray2, 0, n);
        }
        if (n < stringArray2.length) {
            System.arraycopy(stringArray, n + 1, stringArray2, n, stringArray2.length - n);
        }
        return stringArray2;
    }

    public boolean isCellEditable(Object object, int n) {
        if (!this.chartModel.isEditable()) {
            return false;
        }
        if (object instanceof GanttNode && !this.getChartModel().isProjectScheduleEditable((GanttNode)object)) {
            return false;
        }
        if (object instanceof GanttTask) {
            String string = this.columnKeyNames[n];
            if (string == "Name") {
                return true;
            }
            if (string == "Description") {
                return true;
            }
            if (string == "Status") {
                return true;
            }
            if (string == "Progress") {
                return true;
            }
            GanttTask ganttTask = (GanttTask)object;
            if (string == "AdditionalCost" || string == "ActualAdditionalCost" || string == "AdditionalCostDescription") {
                return ((GanttProjectContext)ganttTask.getProjectContext()).isFinancialEditable();
            }
            if (string == "ActualWork") {
                return !ganttTask.isPending() && (ganttTask.getSpecifiedActualWork() >= 0.0 || !ganttTask.getProjectContext().isActualWorkComputationModeTimesheet());
            }
            if (string == "ActualFinish") {
                return true;
            }
            if (ganttTask.isDone()) {
                return false;
            }
            if (string == "Priority") {
                return true;
            }
            if (string == "Deadline") {
                return true;
            }
            if (string == "Duration") {
                return ganttTask.getSchedulingMode() == 1 || ganttTask.getSchedulingMode() == 0;
            }
            if (string == "Work") {
                return true;
            }
            if (string == "StartDate") {
                int n2 = ganttTask.getSchedulingMode();
                return n2 == 0 || n2 == 1 || n2 == 2;
            }
            if (string == "EndDate") {
                int n3 = ganttTask.getSchedulingMode();
                if (n3 == 2 || n3 == 3) {
                    return true;
                }
                IPredecessor[] iPredecessorArray = ganttTask.getPredecessors();
                for (int i = 0; i < iPredecessorArray.length; ++i) {
                    if (iPredecessorArray[i].getType() != 0 && iPredecessorArray[i].getType() != 2) continue;
                    return false;
                }
                return true;
            }
            if (string == "ActualStart") {
                return true;
            }
            if (string == "RemainingWork") {
                return true;
            }
            if (string == "Resources") {
                return true;
            }
            if (string == "schedulingConstraint") {
                return true;
            }
            if (string == "predecessors") {
                int n4 = ganttTask.getSchedulingMode();
                return n4 == 1 || n4 == 0;
            }
        } else if (object instanceof GanttWBS) {
            String string = this.columnKeyNames[n];
            if (((GanttWBS)object).isSubProject()) {
                return false;
            }
            if (string == "Name") {
                return true;
            }
            if (string == "Description") {
                return true;
            }
            if (string == "Resources") {
                return true;
            }
            if (string == "AdditionalCost" || string == "ActualAdditionalCost" || string == "AdditionalCostDescription") {
                AppProjectModel appProjectModel = ((AppGanttChartModel)this.chartModel).getProjectModel(((GanttWBS)object).getProjectId());
                return appProjectModel.getProjectContext().isFinancialEditable();
            }
        } else if (object instanceof EmptyNode) {
            String string = this.columnKeyNames[n];
            if (string == "Name") {
                return true;
            }
            if (string == "Description") {
                return true;
            }
            if (string == "Status") {
                return true;
            }
            if (string == "Progress") {
                return true;
            }
            if (string == "Priority") {
                return true;
            }
            if (string == "Deadline") {
                return true;
            }
            if (string == "Duration") {
                return true;
            }
            if (string == "Work") {
                return true;
            }
            if (string == "StartDate") {
                return true;
            }
            if (string == "EndDate") {
                return true;
            }
            if (string == "ActualStart") {
                return true;
            }
            return string == "ActualFinish";
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValueAt(Object object, Object object2, int n, int n2) {
        this.newNode = null;
        try {
            if (object2 instanceof GanttTask) {
                GanttTask ganttTask = (GanttTask)object2;
                GanttTask ganttTask2 = ganttTask.clone();
                String string = this.columnKeyNames[n2];
                if (string == "Name") {
                    ganttTask2.setName((String)object);
                } else if (string == "Description") {
                    ganttTask2.setNodeDescription((String)object);
                } else if (string == "Priority") {
                    Number number = (Number)object;
                    ganttTask2.setPriority(number.intValue());
                } else if (string == "Deadline") {
                    if (!this.getChartModel().getGlobalContext().isTimePrecision()) {
                        object = new TGTime(23, 59, 59).applyTime((Date)object, this.getChartModel().getGlobalContext().getTimeZone());
                    }
                    ganttTask2.setDeadlineDate((Date)object);
                } else if (string == "Status") {
                    Status status = (Status)object;
                    if (status == Status.PENDING) {
                        ganttTask2.setPercentComplete(0.0);
                        ganttTask2.setActualStartDate(null);
                        ganttTask2.setActualFinishDate(null);
                        ganttTask2.setStatus(status.getCode());
                    } else if (status == Status.DONE) {
                        ganttTask2.setPercentComplete(1.0);
                    } else {
                        double d = ganttTask2.getProgress();
                        if (d == 1.0) {
                            ganttTask2.setPercentComplete(0.99);
                        } else if (d == 0.0 && ganttTask2.getActualStartDate() == null) {
                            AppProjectModel appProjectModel = this.getChartModel().getProjectModel(ganttTask2.getProjectId());
                            Date date = appProjectModel.isAutomaticReschedule() ? (Date)ganttTask2.getStartDate().clone() : this.getChartModel().getGlobalContext().convertToServerTimeZone(this.getChartModel().getGlobalContext().getServerTime());
                            ganttTask2.setActualStartDate(date);
                        }
                    }
                } else if (string == "Progress") {
                    Number number = (Number)object;
                    ganttTask2.setPercentage(number.intValue());
                } else if (string == "Duration") {
                    TGDuration tGDuration = (TGDuration)object;
                    if (ganttTask2.getSchedulingMode() == 0) {
                        if (tGDuration.getValue() == ganttTask2.getDurationDisplay() && tGDuration.getUnit().getCode() == ganttTask2.getDurationFormat()) {
                            return;
                        }
                        WorkOrDurationEditQuestionDialog workOrDurationEditQuestionDialog = WorkOrDurationEditQuestionDialog.create(this.view, false);
                        this.setDialogLocation(workOrDurationEditQuestionDialog);
                        workOrDurationEditQuestionDialog.setVisible(true);
                        if (workOrDurationEditQuestionDialog.getResult() == 2) {
                            this.setWorkFromDuration(ganttTask2, tGDuration);
                        } else {
                            if (workOrDurationEditQuestionDialog.getResult() != 1) return;
                            ganttTask2.setSchedulingMode(1);
                            ganttTask2.setDurationDisplay(tGDuration.getValue());
                            ganttTask2.setDurationFormat(tGDuration.getUnit().getCode());
                        }
                    } else {
                        ganttTask2.setDurationDisplay(tGDuration.getValue());
                        ganttTask2.setDurationFormat(tGDuration.getUnit().getCode());
                    }
                } else if (string == "Work") {
                    TGDuration tGDuration = (TGDuration)object;
                    if (ganttTask2.getSchedulingMode() == 1) {
                        if (tGDuration.getValue() == ganttTask2.getWorkDisplay() && tGDuration.getUnit().getCode() == ganttTask2.getWorkFormat()) {
                            return;
                        }
                        WorkOrDurationEditQuestionDialog workOrDurationEditQuestionDialog = WorkOrDurationEditQuestionDialog.create(this.view, true);
                        this.setDialogLocation(workOrDurationEditQuestionDialog);
                        workOrDurationEditQuestionDialog.setVisible(true);
                        if (workOrDurationEditQuestionDialog.getResult() == 2) {
                            this.setDurationFromWork(ganttTask2, tGDuration);
                        } else {
                            if (workOrDurationEditQuestionDialog.getResult() != 1) return;
                            ganttTask2.setSchedulingMode(0);
                            ganttTask2.setWorkDisplay(tGDuration.getValue());
                            ganttTask2.setWorkFormat(tGDuration.getUnit().getCode());
                        }
                    } else {
                        ganttTask2.setWorkDisplay(tGDuration.getValue());
                        ganttTask2.setWorkFormat(tGDuration.getUnit().getCode());
                    }
                } else if (string == "StartDate") {
                    if (object == null || ((Date)object).equals(ganttTask2.getStartDate())) {
                        return;
                    }
                    if (ganttTask.getPredecessorsCount() > 0) {
                        if (!this.getChartModel().getGlobalContext().isTimePrecision() && this.isSameDay((Date)object, ganttTask2.getStartDate(), ganttTask2.getProjectId())) {
                            return;
                        }
                        StartEditWithPredecessorQuestionDialog startEditWithPredecessorQuestionDialog = StartEditWithPredecessorQuestionDialog.create(this.view);
                        this.setDialogLocation(startEditWithPredecessorQuestionDialog);
                        startEditWithPredecessorQuestionDialog.setVisible(true);
                        if (startEditWithPredecessorQuestionDialog.getResult() != 1) return;
                        ganttTask2.getPredecessorsList().clear();
                    }
                    if (!this.validateWorkingDay(ganttTask, (Date)object, true)) {
                        return;
                    }
                    ganttTask2.setStartDate((Date)object);
                } else if (string == "EndDate") {
                    if (object == null || ((Date)object).equals(ganttTask2.getFinishDate())) {
                        return;
                    }
                    int n3 = ganttTask.getSchedulingMode();
                    if (n3 == 1 || n3 == 0) {
                        Date date = (Date)object;
                        if (!this.getChartModel().getGlobalContext().isTimePrecision() && this.isSameDay(date, ganttTask2.getFinishDate(), ganttTask2.getProjectId())) {
                            return;
                        }
                        if (date.before(ganttTask2.getStartDate())) {
                            TGTime tGTime = new TGTime(date);
                            if (!this.isSameDay(date, ganttTask2.getStartDate(), ganttTask2.getProjectId()) || tGTime.hours != 0 && tGTime.minutes != 0) {
                                WDDialog wDDialog = WDDialog.createMsgDialog((Component)this.view, AppGanttChart.NLS_BUNDLE.getString("startAfterEnd"));
                                this.setDialogLocation(wDDialog);
                                wDDialog.setVisible(true);
                                wDDialog.dispose();
                                return;
                            }
                        }
                        if (!this.validateWorkingDay(ganttTask, (Date)object, false)) {
                            return;
                        }
                        this.setDurationFromDates(ganttTask2, date);
                    } else {
                        if (!this.validateWorkingDay(ganttTask, (Date)object, false)) {
                            return;
                        }
                        ganttTask2.setFinishDate((Date)object);
                    }
                } else if (string == "ActualStart") {
                    ganttTask2.setActualStartDate((Date)object);
                } else if (string == "ActualFinish") {
                    ganttTask2.setActualFinishDate((Date)object);
                } else if (string == "ActualWork") {
                    TGDuration tGDuration = (TGDuration)object;
                    ganttTask2.setSpecifiedActualWork(tGDuration == null ? -1.0 : tGDuration.getValue());
                } else if (string == "RemainingWork") {
                    TGDuration tGDuration = (TGDuration)object;
                    ganttTask2.setSpecifiedRemainingWork(tGDuration == null ? -1.0 : tGDuration.getValue());
                } else if (string == "Resources") {
                    ganttTask2.setResources((TaskResource[])object);
                } else if (string == "predecessors") {
                    ganttTask2.setPredecessors((ArrayList)object);
                } else if (string == "schedulingConstraint") {
                    int n4 = ((SchedulingMode)object).getCode();
                    if ((object == SchedulingMode.DEADLINE_DRIVEN || object == SchedulingMode.FORCE_DATES) && ganttTask2.hasPredecessors()) {
                        if (!WDDialog.showYesNoDialog(this.view, AppGanttChart.NLS_BUNDLE.getString("scheduling_constraint_no_predecessor"))) {
                            return;
                        }
                        ganttTask2.getPredecessorsList().clear();
                    }
                    ganttTask2.setSchedulingMode(n4);
                } else if (string == "AdditionalCost") {
                    double d = object == null ? 0.0 : ((Number)object).doubleValue();
                    ganttTask2.setAdditionalCost(d);
                } else if (string == "ActualAdditionalCost") {
                    ganttTask2.setSpecifiedActualAdditionalCost((Double)object);
                } else if (string == "AdditionalCostDescription") {
                    ganttTask2.setAdditionalCostDescription((String)object);
                } else {
                    System.out.println("unknown Task field edited: " + string + ";value=" + object);
                    return;
                }
                this.getChartModel().checkComputeAndUpdateTaskValues(ganttTask, ganttTask2, this.view, 50);
                return;
            } else if (object2 instanceof GanttWBS) {
                GanttWBS ganttWBS = (GanttWBS)object2;
                GanttWBS ganttWBS2 = ganttWBS.clone();
                String string = this.columnKeyNames[n2];
                if (string == "Name") {
                    ganttWBS2.setName((String)object);
                } else if (string == "Description") {
                    ganttWBS2.setNodeDescription((String)object);
                } else if (string == "Resources") {
                    ganttWBS2.setResources((Resource[])object);
                } else if (string == "AdditionalCost") {
                    double d = object == null ? 0.0 : ((Number)object).doubleValue();
                    ganttWBS2.setAdditionalCost(d);
                } else if (string == "ActualAdditionalCost") {
                    ganttWBS2.setSpecifiedActualAdditionalCost((Double)object);
                } else if (string == "AdditionalCostDescription") {
                    ganttWBS2.setAdditionalCostDescription((String)object);
                } else {
                    System.out.println("unknown WBS field edited: " + string + ";value=" + object);
                    return;
                }
                this.getChartModel().checkComputeAndUpdateWBSValues(ganttWBS, ganttWBS2, this.view);
                return;
            } else {
                Object object3;
                TGNode tGNode;
                if (!(object2 instanceof EmptyNode)) return;
                if (object == null || object.equals("")) {
                    return;
                }
                AppGanttChartModel appGanttChartModel = this.getChartModel();
                Object object4 = null;
                if (n > 0) {
                    tGNode = this.nodeForRow(n - 1);
                    if (tGNode instanceof GanttTask) {
                        object4 = (GanttWBS)((GanttTask)tGNode).getParent();
                    } else if (tGNode instanceof GanttWBS) {
                        object3 = (GanttWBS)tGNode;
                        Object object5 = object4 = ((TGNode)object3).isExpanded() && !((GanttWBS)object3).isSubProject() ? object3 : (GanttWBS)TGChart.getUIParentNode((TGNode)object3);
                    }
                }
                if (!this.getChartModel().isProjectScheduleEditable((GanttNode)object4)) {
                    object4 = null;
                }
                tGNode = appGanttChartModel.newGanttTask((GanttWBS)object4, null);
                object3 = this.columnKeyNames[n2];
                if (object3 == "Name") {
                    tGNode.setName((String)object);
                } else if (object3 == "Description") {
                    tGNode.setNodeDescription((String)object);
                } else if (object3 == "Priority") {
                    Number number = (Number)object;
                    ((GanttTask)tGNode).setPriority(number.intValue());
                } else if (object3 == "Deadline") {
                    ((GanttTask)tGNode).setDeadlineDate((Date)object);
                } else if (object3 == "Status") {
                    Status status = (Status)object;
                    if (status == Status.DONE) {
                        tGNode.setPercentComplete(1.0);
                    } else if (status == Status.IN_PROGRESS) {
                        AppProjectModel appProjectModel = this.getChartModel().getProjectModel(((GanttNode)tGNode).getProjectId());
                        Date date = appProjectModel.isAutomaticReschedule() ? (Date)tGNode.getStartDate().clone() : this.getChartModel().getGlobalContext().convertToServerTimeZone(this.getChartModel().getGlobalContext().getServerTime());
                        ((GanttTask)tGNode).setActualStartDate(date);
                    }
                } else if (object3 == "Progress") {
                    Number number = (Number)object;
                    ((GanttTask)tGNode).setPercentage(number.intValue());
                } else if (object3 == "Duration") {
                    if (((GanttTask)tGNode).getSchedulingMode() != 1) {
                        ((GanttTask)tGNode).setSchedulingMode(1);
                    }
                    TGDuration tGDuration = (TGDuration)object;
                    ((GanttNode)tGNode).setDurationDisplay(tGDuration.getValue());
                    if (tGDuration.getUnit() != null) {
                        ((GanttTask)tGNode).setDurationFormat(tGDuration.getUnit().getCode());
                    }
                } else if (object3 == "Work") {
                    if (((GanttTask)tGNode).getSchedulingMode() == 1) {
                        ((GanttTask)tGNode).setSchedulingMode(0);
                    }
                    TGDuration tGDuration = (TGDuration)object;
                    ((GanttNode)tGNode).setWorkDisplay(tGDuration.getValue());
                    if (tGDuration.getUnit() != null) {
                        ((GanttTask)tGNode).setWorkFormat(tGDuration.getUnit().getCode());
                    }
                } else if (object3 == "StartDate") {
                    if (((GanttTask)tGNode).getSchedulingMode() == 3) {
                        ((GanttTask)tGNode).setSchedulingMode(0);
                    }
                    tGNode.setStartDate((Date)object);
                } else if (object3 == "EndDate") {
                    if (((GanttTask)tGNode).getSchedulingMode() != 3) {
                        ((GanttTask)tGNode).setSchedulingMode(3);
                    }
                    tGNode.setFinishDate((Date)object);
                } else if (object3 == "ActualStart") {
                    ((GanttTask)tGNode).setActualStartDate((Date)object);
                } else if (object3 == "ActualFinish") {
                    ((GanttTask)tGNode).setActualFinishDate((Date)object);
                } else if (object3 == "Resources") {
                    ((GanttTask)tGNode).setResources((TaskResource[])object);
                }
                appGanttChartModel.checkComputeAndUpdateTaskValues(null, (GanttTask)tGNode, this.view, 0);
                this.newNode = tGNode;
            }
            return;
        }
        catch (Exception exception) {
            WDDialog.showErrorMsgDialog(this.view, exception);
        }
    }

    protected boolean validateWorkingDay(GanttTask ganttTask, Date date, boolean bl) {
        return true;
    }

    public Object getValueAt(Object object, int n) {
        String string = this.columnKeyNames[n];
        if (string == "Status") {
            if (object instanceof GanttNode) {
                return Status.fromCode(((GanttNode)object).getStatus());
            }
            return null;
        }
        if (string == "schedulingConstraint") {
            if (object instanceof GanttTask) {
                int n2 = ((GanttTask)object).getSchedulingMode();
                return SchedulingMode.fromCode(n2);
            }
            return null;
        }
        if (object instanceof GanttNode) {
            GanttNode ganttNode = (GanttNode)object;
            if (string == "InitiallyPlannedCostSum") {
                if (!this.hasFinancialModule(ganttNode)) {
                    return null;
                }
                return new Double(ganttNode.getInitiallyPlannedResourceCost() + ganttNode.getInitiallyPlannedAdditionalCost());
            }
            if (string == "ProjectedCostSum") {
                if (!this.hasFinancialModule(ganttNode)) {
                    return null;
                }
                return new Double(ganttNode.getProjectedResourceCost() + ganttNode.getProjectedAdditionalCost());
            }
            if (string == "ActualCostSum") {
                if (!this.hasFinancialModule(ganttNode)) {
                    return null;
                }
                return new Double(ganttNode.getActualResourceCost() + ganttNode.getActualAdditionalCost());
            }
            if (string == "InitiallyPlannedAdditionalCostSum") {
                if (!this.hasFinancialModule(ganttNode)) {
                    return null;
                }
                return new Double(ganttNode.getInitiallyPlannedAdditionalCost());
            }
            if (string == "ProjectedAdditionalCostSum") {
                if (!this.hasFinancialModule(ganttNode)) {
                    return null;
                }
                return new Double(ganttNode.getProjectedAdditionalCost());
            }
            if (string == "ActualAdditionalCostSum") {
                if (!this.hasFinancialModule(ganttNode)) {
                    return null;
                }
                return new Double(ganttNode.getActualAdditionalCost());
            }
            if (string == "InitiallyPlannedResourceCostSum") {
                if (!this.hasFinancialModule(ganttNode)) {
                    return null;
                }
                return new Double(ganttNode.getInitiallyPlannedResourceCost());
            }
            if (string == "ProjectedResourceCostSum") {
                if (!this.hasFinancialModule(ganttNode)) {
                    return null;
                }
                return new Double(ganttNode.getProjectedResourceCost());
            }
            if (string == "ActualResourceCostSum") {
                if (!this.hasFinancialModule(ganttNode)) {
                    return null;
                }
                return new Double(ganttNode.getActualResourceCost());
            }
        }
        if (object instanceof EmptyNode) {
            if (string == "Resources") {
                return TaskResource.EMPTY_ARRAY;
            }
            return null;
        }
        return super.getValueAt(object, n);
    }

    private boolean hasFinancialModule(GanttNode ganttNode) {
        FinancialSettings financialSettings = ((GanttProjectContext)ganttNode.getProjectContext()).getFinancialSettings();
        return financialSettings != null;
    }

    protected abstract void setWorkFromDuration(GanttTask var1, TGDuration var2) throws Exception;

    protected abstract void setDurationFromWork(GanttTask var1, TGDuration var2) throws Exception;

    protected abstract void setDurationFromDates(GanttTask var1, Date var2) throws Exception;

    protected abstract boolean isSameDay(Date var1, Date var2, String var3);

    protected void setDialogLocation(WDDialog wDDialog) {
        Cloneable cloneable;
        wDDialog.pack();
        int n = this.view.getEditingColumn();
        int n2 = this.view.getEditingRow();
        if (n < 0 || n2 < 0) {
            wDDialog.setLocationRelativeTo(this.view);
            return;
        }
        Dimension dimension = wDDialog.getSize();
        Rectangle rectangle = this.view.getCellRect(n2, n, false);
        Serializable serializable = new Point(0, 0);
        SwingUtilities.convertPointToScreen((Point)serializable, this.view);
        rectangle.x += ((Point)serializable).x;
        rectangle.y += ((Point)serializable).y;
        for (serializable = this.view.getParent(); serializable != null; serializable = ((Component)serializable).getParent()) {
            if (!(serializable instanceof JViewport)) continue;
            cloneable = rectangle.getLocation();
            SwingUtilities.convertPointFromScreen((Point)cloneable, (Component)serializable);
            if (((Point)cloneable).y < -rectangle.height) {
                Point point = new Point(0, 0);
                SwingUtilities.convertPointToScreen(point, (Component)serializable);
                rectangle.y = point.y;
                rectangle.height = 0;
                break;
            }
            if (!((double)((Point)cloneable).y + rectangle.getHeight() > (double)((Component)serializable).getHeight())) break;
            Point point = new Point(0, ((Component)serializable).getHeight());
            SwingUtilities.convertPointToScreen(point, (Component)serializable);
            rectangle.y = point.y;
            rectangle.height = 0;
            break;
        }
        cloneable = WDUtil.getDisplayBounds(rectangle.getLocation());
        if (rectangle.y - dimension.height >= cloneable.y) {
            wDDialog.setLocation(rectangle.x, rectangle.y - dimension.height);
        } else {
            wDDialog.setLocation(rectangle.x, rectangle.y + rectangle.height);
        }
    }

    protected TGDuration getSlack(GanttNode ganttNode, double d, ITimeUnits iTimeUnits, TimeUnit timeUnit) {
        if (timeUnit == iTimeUnits.getHourTimeUnit()) {
            return new TGDuration(d, timeUnit);
        }
        return new TGDuration(this.convertHours(ganttNode, d, timeUnit.getCode()), timeUnit);
    }

    private double convertHours(GanttNode ganttNode, double d, int n) {
        if (d == 0.0) {
            return 0.0;
        }
        AppProjectModel appProjectModel = this.getChartModel().getProjectModel(ganttNode.getProjectId());
        switch (n) {
            case 3: 
            case 4: {
                return d * 60.0;
            }
            case 5: 
            case 6: {
                return d;
            }
            case 7: {
                double d2 = appProjectModel.getProjectHoursPerDay();
                return d / d2;
            }
            case 8: {
                return d / 24.0;
            }
            case 9: {
                double d3 = appProjectModel.getProjectHoursPerWeek();
                return d / d3;
            }
            case 10: {
                return d / 7.0 / 24.0;
            }
            case 11: {
                double d4 = appProjectModel.getProjectHoursPerMonth();
                return d / d4;
            }
            case 12: {
                return d / 30.0 / 24.0;
            }
        }
        return d;
    }

    public AppGanttChartModel getChartModel() {
        return (AppGanttChartModel)this.chartModel;
    }
}

