/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.social;

import com.triloggroup.gantt.app.social.BookmarksAndCommentsDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import javax.swing.border.Border;

public abstract class CommentBorder
implements Border {
    protected boolean first;
    protected boolean isResponse;
    protected Insets insets;

    static Border create(boolean bl, boolean bl2) {
        return new CommentBorderIC4(bl, bl2);
    }

    public CommentBorder(boolean bl, boolean bl2) {
        this.first = bl;
        this.isResponse = bl2;
        this.updateInsets();
    }

    protected abstract void updateInsets();

    public Insets getBorderInsets(Component component) {
        return this.insets;
    }

    public boolean isBorderOpaque() {
        return true;
    }

    void setFirst(boolean bl) {
        if (this.first != bl) {
            this.first = bl;
            this.updateInsets();
        }
    }

    private static class CommentBorderIC4
    extends CommentBorder {
        private static final int TRIANGLE_HEIGHT = 9;
        private static final int TRIANGLE_X1 = 45;
        private static final int TRIANGLE_X2 = 54;
        private static final int RESPONSE_XOFFSET = 45;
        private static final Color BORDER_COLOR = new Color(221, 221, 221);

        public CommentBorderIC4(boolean bl, boolean bl2) {
            super(bl, bl2);
        }

        protected void updateInsets() {
            this.insets = new Insets(this.first ? 9 : 0, this.isResponse ? 45 : 1, 1, 1);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (this.first) {
                graphics.setColor(Color.WHITE);
                graphics.fillRect(n, n2, n3, 9);
                n2 += 9;
                n4 -= 9;
            }
            graphics.setColor(BORDER_COLOR);
            graphics.drawLine(n, n2, n, n2 + n4 - 1);
            graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
            graphics.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
            if (this.isResponse) {
                graphics.setColor(BookmarksAndCommentsDialog.COMMENT_BACKGROUND_COLOR);
                graphics.fillRect(n + 1, n2, 45, n4 - 1);
            }
            if (this.first) {
                int[] nArray = new int[]{n + 45, n + 45, n + 54};
                int[] nArray2 = new int[]{(n2 -= 9) + 9, n2, n2 + 9};
                graphics.setColor(BookmarksAndCommentsDialog.COMMENT_BACKGROUND_COLOR);
                graphics.fillPolygon(nArray, nArray2, 3);
                graphics.setColor(BORDER_COLOR);
                graphics.drawLine(n + 1, nArray2[0], nArray[0], nArray2[0]);
                graphics.drawLine(nArray[0], nArray2[0], nArray[1], nArray2[1]);
                graphics.drawLine(nArray[1], nArray2[1], nArray[2], nArray2[2]);
                graphics.drawLine(nArray[2], nArray2[2], n + n3 - 1, nArray2[2]);
            }
        }
    }

    private static class DefaultCommentBorder
    extends CommentBorder {
        private static final int TRIANGLE_HEIGHT = 12;
        private static final int TRIANGLE_X1 = 16;
        private static final int TRIANGLE_X2 = 23;
        private static final int RESPONSE_XOFFSET = 45;

        public DefaultCommentBorder(boolean bl, boolean bl2) {
            super(bl, bl2);
        }

        protected void updateInsets() {
            this.insets = new Insets(this.first ? 12 : 1, this.isResponse ? 45 : 1, 0, 1);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(Color.WHITE);
            if (this.isResponse) {
                graphics.fillRect(n, n2, 45, n4);
                n += 45;
                n3 -= 45;
            }
            if (this.first) {
                Polygon polygon = new Polygon();
                polygon.addPoint(n + 16, n2);
                polygon.addPoint(n + 23, n2 + 12);
                polygon.addPoint(n + 16, n2 + 12);
                graphics.fillRect(n, n2, n3, 12);
                graphics.setColor(BookmarksAndCommentsDialog.COMMENT_BACKGROUND_COLOR);
                graphics.fillPolygon(polygon);
            } else {
                graphics.drawLine(n, n2, n + n3 - 1, n2);
            }
        }
    }
}

