/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.social;

import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.app.social.BookmarksAndCommentsDialog;
import com.triloggroup.gantt.app.social.CustomBookmarkSupport;
import com.triloggroup.gantt.app.social.XSPSocialActions;
import com.triloggroup.gantt.app.ui.ULabel;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.gantt.treetable.TGTreeTableCellRenderer;
import com.triloggroup.project.components.resourceeditor.ProjectResource;
import com.triloggroup.project.components.ui.DoubleIcon;
import com.triloggroup.project.social.Bookmark;
import com.triloggroup.util.UString;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

class BookmarkPanel
extends JPanel {
    private static final GridBagConstraints pictureCst;
    private static final GridBagConstraints titleCst;
    private static final GridBagConstraints subtitleCst;
    private static final GridBagConstraints deleteCst;
    private static ImageIcon deleteIcon;
    private final BookmarksAndCommentsDialog dialog;
    final Bookmark bookmark;

    BookmarkPanel(BookmarksAndCommentsDialog bookmarksAndCommentsDialog, Bookmark bookmark, IDeleteBookmark iDeleteBookmark) {
        this.dialog = bookmarksAndCommentsDialog;
        this.bookmark = bookmark;
        this.init(iDeleteBookmark);
    }

    private void init(final IDeleteBookmark iDeleteBookmark) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.setOpaque(false);
        this.setBorder(new EmptyBorder(2, 2, 2, 2));
        Icon icon = null;
        GanttNode ganttNode = null;
        if (this.bookmark.type == 3) {
            ganttNode = this.getBookmarkedGanttNode(this.bookmark);
            boolean bl = this.bookmark.isTargetValid = ganttNode != null;
            if (ganttNode != null) {
                this.bookmark.title = ganttNode.getName();
                this.bookmark.date = ganttNode.getStartDate();
                object5 = this.dialog.gantt.getTreeTable().getTreeCellRenderer();
                icon = ((TGTreeTableCellRenderer)object5).getHealthIconForNode(ganttNode);
            }
        }
        if (icon == null) {
            icon = this.getIcon(this.bookmark);
        }
        if (this.bookmark.deliverable) {
            icon = new DoubleIcon(WDUtil.getIcon("social/deliverable.gif"), icon);
        }
        object5 = this.getTooltip(this.bookmark);
        JLabel jLabel = new JLabel(icon);
        jLabel.setToolTipText((String)object5);
        gridBagLayout.setConstraints(jLabel, pictureCst);
        this.add(jLabel);
        JLabel jLabel2 = null;
        if (this.bookmark.isTargetValid) {
            if (this.bookmark.type == 3) {
                object4 = this.dialog.scheduleBookmarkDateFormat.format(this.bookmark.date);
                object3 = this.dialog.nls().getString("startsOn", object4);
            } else {
                String string;
                object4 = this.dialog.bookmarkDateFormat.format(this.bookmark.date);
                object2 = this.dialog.gantt.getModel().getProjectModel(this.dialog.getNode().getProjectId());
                ProjectResource projectResource = UString.isEmpty(this.bookmark.authorDn) ? null : object2.getProjectResource(this.bookmark.authorDn);
                object = projectResource == null ? this.bookmark.authorCn : projectResource.getCn();
                switch (this.bookmark.type) {
                    case 4: {
                        string = "issueCreatedByOn";
                        break;
                    }
                    case 5: {
                        string = "changeCreatedByOn";
                        break;
                    }
                    case 1: {
                        string = "documentCreatedByOn";
                        break;
                    }
                    case 7: {
                        string = "activityCreatedByOn";
                        break;
                    }
                    default: {
                        string = "createdByOn";
                    }
                }
                object3 = this.dialog.nls().getString(string, object, object4);
            }
            object = this.dialog.createSubtitleJLabel((String)object3);
            gridBagLayout.setConstraints((Component)object, subtitleCst);
            this.add((Component)object);
            if (this.bookmark.type == 1 && !UString.isEmpty(this.bookmark.contentUrl)) {
                jLabel2 = new JLabel(WDUtil.getIcon("social/downloadfile.png"));
                jLabel2.setCursor(ULabel.HAND_CURSOR);
                jLabel2.addMouseListener(new ULabel.LinkHoverMouseAdapter(true){

                    public void mouseClicked(MouseEvent mouseEvent) {
                        XSPSocialActions xSPSocialActions = BookmarkPanel.this.dialog.getXSPSocialActions();
                        if (xSPSocialActions.downloadDocument(BookmarkPanel.this.bookmark.contentUrl)) {
                            BookmarkPanel.this.dialog.close();
                        }
                    }
                });
            }
        }
        object3 = ULabel.createLinkJLabel(this.bookmark.title, false);
        ((JComponent)object3).setToolTipText((String)object5);
        if (this.bookmark.isTargetValid) {
            jLabel.setCursor(ULabel.HAND_CURSOR);
            object4 = new ULabel.LinkHoverMouseAdapter(true){

                public void mouseClicked(MouseEvent mouseEvent) {
                    BookmarkPanel.this.dialog.openBookmark(BookmarkPanel.this.bookmark, mouseEvent);
                }
            };
            jLabel.addMouseListener((MouseListener)object4);
            ((Component)object3).addMouseListener((MouseListener)object4);
        } else {
            ((Component)object3).setCursor(Cursor.getDefaultCursor());
            ULabel.setStriked((Component)object3, true);
        }
        object4 = object3;
        if (jLabel2 != null) {
            object4 = new JPanel(new BorderLayout(5, 5));
            ((JComponent)object4).setOpaque(false);
            ((Container)object4).add((Component)object3, "Center");
            ((Container)object4).add(jLabel2, "East");
        }
        gridBagLayout.setConstraints((Component)object4, titleCst);
        this.add((Component)object4);
        if (iDeleteBookmark != null) {
            object = new JLabel(BookmarkPanel.getDeleteBookmarkIcon());
            ((JComponent)object).setToolTipText(this.dialog.nls().getString("delete_button"));
            ((Component)object).setCursor(ULabel.HAND_CURSOR);
            object2 = new ULabel.LinkHoverMouseAdapter(true){

                public void mouseClicked(MouseEvent mouseEvent) {
                    iDeleteBookmark.deleteBookmark(BookmarkPanel.this);
                }
            };
            ((Component)object).addMouseListener((MouseListener)object2);
            gridBagLayout.setConstraints((Component)object, deleteCst);
            this.add((Component)object);
        }
    }

    private Icon getIcon(Bookmark bookmark) {
        switch (bookmark.type) {
            case 3: {
                return WDUtil.getIcon("social/task.gif");
            }
            case 5: {
                return WDUtil.getIcon("social/change.gif");
            }
            case 4: {
                return WDUtil.getIcon("social/issue.gif");
            }
            case 6: {
                return WDUtil.getIcon("social/url.gif");
            }
            case 7: {
                return WDUtil.getIcon("social/activity.gif");
            }
            case 1: {
                int n = bookmark.title.lastIndexOf(46);
                if (n < 0) break;
                String string = bookmark.title.substring(n + 1);
                if (string.equals("doc") || string.equals("docx")) {
                    return WDUtil.getIcon("social/doc.gif");
                }
                if (string.equals("xls") || string.equals("xslx") || string.equals("csv")) {
                    return WDUtil.getIcon("social/xls.gif");
                }
                if (string.equals("ort")) {
                    return WDUtil.getIcon("social/ort.gif");
                }
                if (string.equals("ppt") || string.equals("pps")) {
                    return WDUtil.getIcon("social/ppt.gif");
                }
                if (!string.equals("pdf")) break;
                return WDUtil.getIcon("social/pdf.gif");
            }
        }
        if (bookmark.type >= 100) {
            return new CustomBookmarkSupport(this.dialog.getNode()).getBookmarkIcon(bookmark);
        }
        return WDUtil.getIcon("social/default.gif");
    }

    static Icon getDeleteBookmarkIcon() {
        if (deleteIcon == null) {
            deleteIcon = WDUtil.getIcon("social/deleteicon.gif");
        }
        return deleteIcon;
    }

    private GanttNode getBookmarkedGanttNode(Bookmark bookmark) {
        GanttNode ganttNode = this.dialog.gantt.getModel().getProjectModel(this.dialog.getNode().getProjectId()).getNodeByUid(bookmark.peId);
        return ganttNode;
    }

    private String getTooltip(Bookmark bookmark) {
        switch (bookmark.type) {
            case 3: {
                return this.dialog.nls().getString("task");
            }
            case 5: {
                return this.dialog.nls().getString("changeRequest");
            }
            case 4: {
                return this.dialog.nls().getString("issue");
            }
            case 6: {
                return this.dialog.nls().getString("link") + ": " + bookmark.url;
            }
            case 7: {
                return this.dialog.nls().getString("activity");
            }
            case 1: {
                return this.dialog.nls().getString("document");
            }
        }
        return null;
    }

    static {
        Insets insets = new Insets(2, 2, 2, 2);
        pictureCst = new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 10, 3, insets, 0, 0);
        titleCst = new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        subtitleCst = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0);
        deleteCst = new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
    }

    static interface IDeleteBookmark {
        public void deleteBookmark(BookmarkPanel var1);
    }
}

