/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.schedule;

import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.GanttWBS;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.TaskPredecessor;
import com.triloggroup.gantt.app.AppGanttChartModel;
import com.triloggroup.gantt.app.AppProjectModel;
import com.triloggroup.gantt.app.UnexpectedChangeException;
import com.triloggroup.gantt.app.change.Change;
import com.triloggroup.gantt.app.change.ChangeException;
import com.triloggroup.project.components.ui.Workbench;
import com.triloggroup.project.schedule.IPredecessor;
import com.triloggroup.project.schedule.Predecessor;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import org.jfree.data.time.TimePeriod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatesMover {
    private static final int CAN_MOVE_START_DATE = 1;
    private static final int CAN_MOVE_END_DATE = 16;
    private static final int CAN_MOVE_DATES = 256;
    private static final long MS_MINUTE = 60000L;
    private static final long MS_HOUR = 3600000L;
    private static final long MS_DAY = 86400000L;
    private AppGanttChartModel model;
    private boolean moveDeadline = false;

    public DatesMover(AppGanttChartModel appGanttChartModel) {
        this.model = appGanttChartModel;
    }

    public boolean isMoveDeadline() {
        return this.moveDeadline;
    }

    public void setMoveDeadline(boolean bl) {
        this.moveDeadline = bl;
    }

    public boolean canMoveDates(GanttNode[] ganttNodeArray) {
        if (!this.model.isEditable()) {
            return false;
        }
        boolean bl = false;
        for (GanttNode ganttNode : ganttNodeArray) {
            if (ganttNode.isDone()) {
                return false;
            }
            int n = this.canMoveDates(ganttNode);
            if (n < 0) {
                return false;
            }
            bl |= n > 0;
        }
        return bl;
    }

    private int canMoveDates(GanttNode ganttNode) {
        if (ganttNode instanceof GanttWBS) {
            GanttWBS ganttWBS = (GanttWBS)ganttNode;
            if (ganttWBS.isSubProject() && ganttWBS.getAllSubTaskCount() == 0 && !ganttWBS.isBrokenSubprojectLink()) {
                return -1;
            }
            int n = 0;
            for (int i = 0; i < ganttWBS.getAllSubTaskCount(); ++i) {
                int n2 = this.canMoveDates(ganttWBS.getSubtaskInAll(i));
                if (n2 < 0) {
                    return n2;
                }
                n += n2;
            }
            return n;
        }
        if (ganttNode instanceof GanttTask) {
            return (this.getMoveDatesAvailableActions((GanttTask)ganttNode) & 0x100) == 256 ? 1 : -1;
        }
        return -1;
    }

    public Date getLowestStartDate(GanttNode[] ganttNodeArray) {
        if (ganttNodeArray == null) {
            return null;
        }
        Date date = null;
        for (GanttNode ganttNode : ganttNodeArray) {
            if (date != null && !ganttNode.getStartDate().before(date)) continue;
            date = ganttNode.getStartDate();
        }
        return date;
    }

    private HashSet<GanttTask> getAllSubTasksNotDone(GanttNode[] ganttNodeArray) {
        HashSet<GanttTask> hashSet = new HashSet<GanttTask>();
        for (GanttNode ganttNode : ganttNodeArray) {
            this.addAllSubtasksNotDone(ganttNode, hashSet);
        }
        return hashSet;
    }

    private void addAllSubtasksNotDone(GanttNode ganttNode, HashSet<GanttTask> hashSet) {
        if (ganttNode instanceof GanttWBS) {
            GanttWBS ganttWBS = (GanttWBS)ganttNode;
            for (int i = 0; i < ganttWBS.getAllSubTaskCount(); ++i) {
                this.addAllSubtasksNotDone(ganttWBS.getSubtaskInAll(i), hashSet);
            }
        } else if (ganttNode instanceof GanttTask && !ganttNode.isDone()) {
            hashSet.add((GanttTask)ganttNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveDates(GanttNode[] ganttNodeArray, int n) throws ChangeException {
        Object object;
        long l = (long)n * 86400000L;
        Change change = this.model.getChangeManager().getLastChange();
        try {
            object = this.getAllSubTasksNotDone(ganttNodeArray);
            Iterator<GanttTask> iterator = ((HashSet)object).iterator();
            while (iterator.hasNext()) {
                GanttTask ganttTask = iterator.next();
                if (this.hasPredecessorInTasksSet(ganttTask, (HashSet<GanttTask>)object)) continue;
                this.moveTaskDates(ganttTask, l, false, PredecessorAction.ADD_LAG, null);
            }
        }
        finally {
            object = Workbench.getNLSString("moveDates", new Object[0]);
            if (ganttNodeArray.length == 1) {
                object = (String)object + " (\"" + ganttNodeArray[0].getName() + "\")";
            }
            this.model.getChangeManager().linkChangesAfter(change, (String)object);
        }
    }

    private boolean hasPredecessorInTasksSet(GanttTask ganttTask, HashSet<GanttTask> hashSet) {
        IPredecessor[] iPredecessorArray;
        AppProjectModel appProjectModel = this.model.getProjectModel(ganttTask);
        for (IPredecessor iPredecessor : iPredecessorArray = ganttTask.getPredecessors()) {
            GanttTask ganttTask2 = (GanttTask)appProjectModel.getNodeByUid(iPredecessor.getId());
            if (hashSet.contains(ganttTask2)) {
                return true;
            }
            if (ganttTask2.isDone() || !this.hasPredecessorInTasksSet(ganttTask2, hashSet)) continue;
            return true;
        }
        return false;
    }

    private int getMoveDatesAvailableActions(GanttTask ganttTask) {
        if (!this.model.isProjectScheduleEditable(ganttTask)) {
            return 0;
        }
        switch (ganttTask.getSchedulingMode()) {
            case 3: {
                return 256;
            }
            case 2: {
                return 273;
            }
            case 0: 
            case 1: {
                return 256;
            }
        }
        return 0;
    }

    public void moveTaskStartDate(GanttTask ganttTask, long l, boolean bl, Component component) throws ChangeException {
        if ((this.getMoveDatesAvailableActions(ganttTask) & 1) != 1) {
            throw new ChangeException("operation_not_available");
        }
        TimePeriod timePeriod = ganttTask.getDuration();
        Date date = this.model.shiftDate(timePeriod.getStart(), l, bl);
        if (date == null) {
            return;
        }
        try {
            GanttTask ganttTask2 = ganttTask.clone();
            ganttTask2.getDuration().getStart().setTime(date.getTime());
            this.model.checkComputeAndUpdateTaskValues(ganttTask, ganttTask2, component, 0);
        }
        catch (ChangeException changeException) {
            throw changeException;
        }
        catch (Exception exception) {
            throw new UnexpectedChangeException(exception);
        }
    }

    public void moveTaskEndDate(GanttTask ganttTask, long l, boolean bl, Component component) throws ChangeException {
        if ((this.getMoveDatesAvailableActions(ganttTask) & 0x10) != 16) {
            throw new ChangeException("operation_not_available");
        }
        TimePeriod timePeriod = ganttTask.getDuration();
        Date date = this.model.shiftDate(timePeriod.getEnd(), l, bl);
        if (date == null) {
            return;
        }
        try {
            GanttTask ganttTask2 = ganttTask.clone();
            ganttTask2.getDuration().getEnd().setTime(date.getTime());
            this.model.checkComputeAndUpdateTaskValues(ganttTask, ganttTask2, component, 0);
        }
        catch (ChangeException changeException) {
            throw changeException;
        }
        catch (Exception exception) {
            throw new UnexpectedChangeException(exception);
        }
    }

    public void moveTaskStartEndDates(GanttTask ganttTask, long l, boolean bl, Component component) throws ChangeException {
        this.moveTaskDates(ganttTask, l, bl, PredecessorAction.REMOVE, component);
    }

    private void moveTaskDates(GanttTask ganttTask, long l, boolean bl, PredecessorAction predecessorAction, Component component) throws ChangeException {
        int n;
        if ((this.getMoveDatesAvailableActions(ganttTask) & 0x100) != 256) {
            throw new ChangeException("operation_not_available");
        }
        TimePeriod timePeriod = ganttTask.getDuration();
        Date date = null;
        Date date2 = null;
        switch (ganttTask.getSchedulingMode()) {
            case 3: {
                date2 = this.model.shiftDate(timePeriod.getEnd(), l, bl);
                break;
            }
            case 2: {
                date = this.model.shiftDate(timePeriod.getStart(), l, bl);
                if (date == null) break;
                long l2 = date.getTime() - timePeriod.getStart().getTime();
                n = (int)(l2 / 86400000L);
                if (l2 > 0L) {
                    ++n;
                }
                date2 = this.shiftDays(timePeriod.getEnd(), n);
                break;
            }
            case 0: 
            case 1: {
                date = this.model.shiftDate(timePeriod.getStart(), l, bl);
                if (date == null) break;
                date = this.model.adjustStartDateForTask(ganttTask, date);
            }
        }
        if (date == null && date2 == null) {
            return;
        }
        try {
            GanttTask ganttTask2 = ganttTask.clone();
            if (ganttTask2.getPredecessorsCount() > 0) {
                if (predecessorAction == PredecessorAction.REMOVE) {
                    ganttTask2.getPredecessorsList().clear();
                } else if (predecessorAction == PredecessorAction.ADD_LAG) {
                    ArrayList<Predecessor> arrayList = ganttTask2.getPredecessorsList();
                    for (n = 0; n < arrayList.size(); ++n) {
                        Predecessor predecessor = arrayList.get(n);
                        arrayList.set(n, this.updateLag(new TaskPredecessor(ganttTask, predecessor), l));
                    }
                }
            }
            if (date != null) {
                ganttTask2.getDuration().getStart().setTime(date.getTime());
            }
            if (date2 != null) {
                ganttTask2.getDuration().getEnd().setTime(date2.getTime());
            }
            if (this.moveDeadline) {
                this.moveDeadline(ganttTask2, l, bl);
            }
            this.model.checkComputeAndUpdateTaskValues(ganttTask, ganttTask2, component, 0);
        }
        catch (ChangeException changeException) {
            throw changeException;
        }
        catch (Exception exception) {
            throw new UnexpectedChangeException(exception);
        }
    }

    private void moveDeadline(GanttTask ganttTask, long l, boolean bl) {
        Date date = ganttTask.getDeadlineDate();
        if (date == null) {
            return;
        }
        if ((date = this.model.shiftDate(date, l, bl)) == null) {
            return;
        }
        ganttTask.setDeadlineDate(date);
    }

    private Date shiftDays(Date date, int n) {
        if (n == 0) {
            return null;
        }
        Calendar calendar = Calendar.getInstance(this.model.getGlobalContext().getTimeZone());
        calendar.setTimeInMillis(date.getTime());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.add(5, n);
        return calendar.getTime();
    }

    private Predecessor updateLag(TaskPredecessor taskPredecessor, long l) {
        Object object;
        long l2;
        Predecessor predecessor = taskPredecessor.predecessor;
        if (predecessor.getLag() == 0) {
            int n;
            int n2;
            long l3 = l % 86400000L;
            if (l3 < 60000L || 86400000L - l3 < 60000L) {
                n2 = 8;
                n = (int)(l / 86400000L);
            } else if ((l3 %= 3600000L) < 60000L || 86400000L - l3 < 60000L) {
                n2 = 6;
                n = (int)(l / 3600000L);
            } else {
                n2 = 4;
                n = (int)(l / 60000L);
            }
            return new Predecessor(predecessor.getId(), predecessor.getType(), n, n2);
        }
        AppProjectModel appProjectModel = this.model.getProjectModel(taskPredecessor.task);
        int n = predecessor.getLagFormat();
        if (n == 12 || n == 10 || n == 8 || n == 6 || n == 4) {
            try {
                l2 = appProjectModel.getScheduleComputation().getDurationInMilliseconds(predecessor.getLag(), predecessor.getLagFormat());
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        } else {
            object = appProjectModel.getNodeByUid(predecessor.getId());
            if (object == null) {
                l2 = 0L;
            } else {
                Date date;
                Date date2;
                if (predecessor.getType() == 1) {
                    date2 = ((TGNode)object).getFinishDate();
                    date = taskPredecessor.task.getStartDate();
                } else if (predecessor.getType() == 3) {
                    date2 = ((TGNode)object).getStartDate();
                    date = taskPredecessor.task.getStartDate();
                } else if (predecessor.getType() == 0) {
                    date2 = ((TGNode)object).getFinishDate();
                    date = taskPredecessor.task.getFinishDate();
                } else {
                    date2 = ((TGNode)object).getStartDate();
                    date = taskPredecessor.task.getFinishDate();
                }
                l2 = date.getTime() - date2.getTime();
            }
        }
        object = new Predecessor(predecessor.getId(), predecessor.getType(), 0, predecessor.getLagFormat());
        return this.updateLag(new TaskPredecessor(taskPredecessor.task, (Predecessor)object), l + l2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PredecessorAction {
        REMOVE,
        ADD_LAG,
        KEEP;

    }
}

