/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.print;

import com.triloggroup.gantt.EmptyNode;
import com.triloggroup.gantt.GanttCategoryPlot;
import com.triloggroup.gantt.GanttChartHeader;
import com.triloggroup.gantt.TGChart;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.treetable.AppGanttTreeTable;
import com.triloggroup.gantt.treetable.TGTreeTable;
import com.triloggroup.ui.ErrorDialog;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jfree.data.gantt.TaskSeries;

public class PrintableChart
implements Printable,
Pageable {
    public static final int PRINT_TABLE_ONLY = 0;
    public static final int PRINT_CHART_ONLY = 1;
    public static final int PRINT_ALL = 2;
    private static final int MIN_CHART_WIDTH = 400;
    private static final int MIN_X_MARGIN = 34;
    private static final int MIN_Y_MARGIN = 34;
    private static final int PRINTER_MARGIN_SECURITY = 5;
    private static final int FOOTER_MARGIN = 10;
    private static boolean SHOW_LINE_NUMBERS = true;
    protected final AppGanttChart chart;
    protected final int printOption;
    protected int pageCountX;
    protected int pageCountY;
    protected int mexRowsPerPage;
    protected int rowCount;
    protected PageFormat pageFormat;
    protected boolean chartOnSeparatePage = false;
    protected boolean splitTableColumns = false;
    protected int[] tableX0;
    protected int[] tableX1;
    protected double dataScale = 0.65;
    protected int chartWidth = 0;
    protected Point2D dataOrigin;
    protected Dimension dataDimension;
    protected Rectangle2D footerArea;
    protected int totalChartHeight;
    private Font footerFont;
    private Date currentDate;
    private PrinterJob printJob;

    public PrintableChart(AppGanttChart appGanttChart, int n) {
        this.chart = appGanttChart;
        this.printOption = n;
        this.footerFont = new Font("sansserif", 0, 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print() {
        block8: {
            this.printJob = PrinterJob.getPrinterJob();
            try {
                this.printJob.setJobName("ProjExec");
                this.printJob.setPageable(this);
                if (!this.printJob.printDialog()) break block8;
                try {
                    this.init(this.printJob.defaultPage());
                    this.printJob.print();
                }
                catch (Exception exception) {
                    ErrorDialog.showError(this.chart.getView(), exception);
                    exception.printStackTrace();
                }
                finally {
                    this.release();
                }
            }
            finally {
                this.printJob = null;
            }
        }
    }

    protected void init(PageFormat pageFormat) {
        this.pageFormat = pageFormat;
        this.currentDate = new Date();
        double d = Math.max(pageFormat.getImageableX() + 5.0, 34.0);
        double d2 = Math.max(pageFormat.getImageableY() + 5.0, 34.0);
        this.dataOrigin = new Point2D.Double(d, d2);
        double d3 = pageFormat.getWidth() - pageFormat.getImageableWidth() - pageFormat.getImageableX();
        d3 = Math.max(d3 + 5.0, 34.0);
        double d4 = pageFormat.getWidth() - d3;
        double d5 = pageFormat.getHeight() - pageFormat.getImageableHeight() - pageFormat.getImageableY();
        d5 = Math.max(d5 + 5.0, 34.0);
        double d6 = pageFormat.getHeight() - d5;
        int n = 24;
        this.footerArea = new Rectangle2D.Double(d, d6 - (double)n, d4 - d, n);
        this.dataDimension = new Dimension();
        this.dataDimension.setSize((d4 - d) / this.dataScale, (d6 - (double)n - d2) / this.dataScale);
        AppGanttTreeTable appGanttTreeTable = (AppGanttTreeTable)this.chart.getTreeTable();
        this.pageCountX = 1;
        int n2 = 0;
        if (this.printOption == 2 || this.printOption == 0) {
            int n3;
            int n4 = appGanttTreeTable.getPreferredWidth();
            int n5 = 0;
            if (SHOW_LINE_NUMBERS) {
                n5 = (int)appGanttTreeTable.getRowHeaderComponent().getPreferredSize().getWidth();
            }
            if (n4 > (n3 = this.dataDimension.width - n5)) {
                int n6;
                this.splitTableColumns = true;
                TableColumnModel tableColumnModel = appGanttTreeTable.getColumnModel();
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                arrayList.add(new Integer(0));
                int n7 = 0;
                for (n6 = 0; n6 < appGanttTreeTable.getColumnCount(); ++n6) {
                    TableColumn tableColumn = tableColumnModel.getColumn(n6);
                    int n8 = tableColumn.getWidth();
                    if ((n2 += n8) > n3) {
                        if (n8 > n3) {
                            if (n2 == n8) {
                                arrayList2.add(new Integer(n7 + n3));
                                if (n6 == appGanttTreeTable.getColumnCount() - 1) {
                                    n2 = n3;
                                    break;
                                }
                                n2 = 0;
                                arrayList.add(new Integer(n7 + n8));
                                ++this.pageCountX;
                            } else {
                                arrayList2.add(new Integer(n7));
                                arrayList.add(new Integer(n7));
                                ++this.pageCountX;
                                arrayList2.add(new Integer(n7 + n3));
                                if (n6 == appGanttTreeTable.getColumnCount() - 1) {
                                    n2 = n3;
                                    break;
                                }
                                ++this.pageCountX;
                                n2 = 0;
                                arrayList.add(new Integer(n7 + n8));
                            }
                        } else {
                            n2 = n8;
                            arrayList2.add(new Integer(n7));
                            arrayList.add(new Integer(n7));
                            ++this.pageCountX;
                        }
                    }
                    n7 += n8;
                }
                if (arrayList2.size() < arrayList.size()) {
                    arrayList2.add(new Integer(n4));
                }
                this.tableX0 = new int[arrayList.size()];
                this.tableX1 = new int[arrayList.size()];
                for (n6 = 0; n6 < this.tableX0.length; ++n6) {
                    this.tableX0[n6] = (Integer)arrayList.get(n6);
                    this.tableX1[n6] = (Integer)arrayList2.get(n6);
                }
            } else {
                n2 = n4;
                this.tableX0 = new int[]{0};
                this.tableX1 = new int[]{n4};
            }
            n2 += n5;
        }
        if (this.printOption == 2 || this.printOption == 1) {
            this.chartWidth = this.dataDimension.width - n2;
            if (n2 > 0 && this.chartWidth < 400) {
                this.chartWidth = this.dataDimension.width;
                ++this.pageCountX;
                this.chartOnSeparatePage = true;
            }
            this.totalChartHeight = this.chart.getCurrentPreferredHeight();
        }
        this.mexRowsPerPage = this.dataDimension.height / TGChart.getRowHeight() - 1;
        TaskSeries taskSeries = this.chart.getTaskSeries();
        this.rowCount = taskSeries.getItemCount();
        while (taskSeries.get(this.rowCount - 1) instanceof EmptyNode) {
            --this.rowCount;
        }
        this.pageCountY = this.rowCount / this.mexRowsPerPage;
        if (this.rowCount % this.mexRowsPerPage != 0) {
            ++this.pageCountY;
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        int n2;
        if (n >= this.getNumberOfPages()) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.printFooter(graphics2D, n);
        int n3 = n / this.pageCountX;
        int n4 = n % this.pageCountX;
        int n5 = this.printOption;
        if (this.chartOnSeparatePage) {
            n5 = n4 == this.pageCountX - 1 ? 1 : 0;
        } else if (this.splitTableColumns && n4 != this.pageCountX - 1) {
            n5 = 0;
        }
        graphics2D.translate(this.dataOrigin.getX(), this.dataOrigin.getY());
        if (this.dataScale != 1.0) {
            graphics2D.scale(this.dataScale, this.dataScale);
        }
        Shape shape = graphics2D.getClip();
        int n6 = TGChart.getRowHeight();
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        JComponent jComponent = null;
        if (SHOW_LINE_NUMBERS) {
            jComponent = ((AppGanttTreeTable)this.chart.getTreeTable()).getRowHeaderComponent();
            n9 = (int)jComponent.getPreferredSize().getWidth();
        }
        if (n5 == 0 || n5 == 2) {
            n7 = this.tableX0[n4];
            n8 = this.tableX1[n4] - this.tableX0[n4];
            if (SHOW_LINE_NUMBERS) {
                graphics2D.setColor(Color.GRAY);
                graphics2D.setStroke(new BasicStroke());
                graphics2D.drawLine(1, n6 - 1, n9 - 1, n6 - 1);
                graphics2D.drawLine(n9 - 1, 1, n9 - 1, n6 - 1);
                graphics2D.translate(n9, 0);
            }
            graphics2D.clipRect(0, 0, n8, n6);
            graphics2D.translate(-n7, 0);
            this.printTableHeader(graphics2D);
            graphics2D.translate(n7 - n9, 0);
            graphics2D.setClip(shape);
            if (n5 == 2) {
                graphics2D.translate(n8 + n9, 0);
            }
        }
        if (n5 == 1 || n5 == 2) {
            this.printChartHeader(graphics2D, this.chartWidth);
            if (n5 == 2) {
                graphics2D.translate(-n8 - n9, 0);
            }
        }
        graphics2D.translate(0, n6);
        int n10 = this.rowCount - n3 * this.mexRowsPerPage;
        if (n10 > this.mexRowsPerPage) {
            n10 = this.mexRowsPerPage;
        }
        int n11 = n10 * n6;
        int n12 = 0;
        graphics2D.clipRect(1, 1, this.dataDimension.width - 2, n11 - 2);
        if (n3 > 0) {
            n2 = this.mexRowsPerPage * n6 * n3;
            graphics2D.translate(0, -n2);
        }
        if (n5 == 0 || n5 == 2) {
            Shape shape2 = graphics2D.getClip();
            if (SHOW_LINE_NUMBERS) {
                jComponent.print(graphics2D);
                graphics2D.translate(n9, 0);
            }
            graphics2D.clipRect(0, this.mexRowsPerPage * n6 * n3, n8, n11);
            graphics2D.translate(-n7, 0);
            this.printTable(graphics2D);
            graphics2D.translate(n7, 0);
            graphics2D.setClip(shape2);
            n12 += n8 + n9;
            if (n5 == 2) {
                graphics2D.translate(n8, 0);
            } else {
                graphics2D.translate(-n9, 0);
            }
        }
        if (n5 == 1 || n5 == 2) {
            this.printChart(graphics2D, this.chartWidth);
            n12 += this.chartWidth;
            if (n5 == 2) {
                graphics2D.translate(-n8 - n9, 0);
            }
        }
        graphics2D.translate(0, -n6);
        if (n3 > 0) {
            n2 = this.mexRowsPerPage * n6 * n3;
            graphics2D.translate(0, n2);
        }
        graphics2D.setClip(shape);
        graphics2D.setColor(Color.BLACK);
        graphics2D.setStroke(new BasicStroke());
        graphics2D.drawRect(0, 0, n12 - 1, n11 + n6 - 1);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void printChartHeader(Graphics2D graphics2D, int n) {
        GanttCategoryPlot ganttCategoryPlot = (GanttCategoryPlot)this.chart.getChart().getPlot();
        try {
            ganttCategoryPlot.setPrinting(true);
            GanttChartHeader ganttChartHeader = this.chart.getChartHeader();
            ganttChartHeader.print(graphics2D, n);
        }
        finally {
            ganttCategoryPlot.setPrinting(false);
        }
    }

    protected void printTableHeader(Graphics2D graphics2D) {
        JTableHeader jTableHeader = this.chart.getTreeTable().getTableHeader();
        jTableHeader.printAll(graphics2D);
    }

    protected void printFooter(Graphics2D graphics2D, int n) {
        String string;
        int n2;
        int n3;
        int n4;
        Serializable serializable;
        int n5;
        graphics2D.setColor(Color.BLACK);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(this.footerFont);
        int n6 = (int)this.footerArea.getMaxY() - fontMetrics.getMaxDescent();
        graphics2D.setFont(this.footerFont);
        String string2 = AppGanttChart.NLS_BUNDLE.getString("Page " + (n + 1) + '/' + this.getNumberOfPages());
        int n7 = (int)this.footerArea.getMaxX() - 1 - fontMetrics.stringWidth(string2);
        graphics2D.drawString(string2, n7, n6);
        int n8 = n5 = (int)this.footerArea.getMinX() + 1;
        String string3 = this.chart.getModel().getMainProjectModel().getProjectContext().getProjectName();
        if (string3 == null && (serializable = this.chart.getModel().getRootNode()) != null) {
            string3 = ((TGNode)serializable).getName();
        }
        if (string3 != null) {
            int n9 = fontMetrics.stringWidth(string3);
            while (n5 + n9 + 10 > n7) {
                if (string3.length() < 5) {
                    return;
                }
                string3 = string3.substring(0, string3.length() - 4) + "...";
                n9 = fontMetrics.stringWidth(string3);
            }
            graphics2D.drawString(string3, n5, n6);
            n8 = n5 + n9;
        }
        if ((n4 = n8 + 10) > (n3 = n7 - 10 - (n2 = fontMetrics.stringWidth(string = ((DateFormat)(serializable = DateFormat.getDateInstance(3))).format(this.currentDate))))) {
            return;
        }
        int n10 = (int)this.footerArea.getCenterX() - n2 / 2;
        if (n10 < n4) {
            n10 = n4;
        } else if (n10 > n3) {
            n10 = n3;
        }
        graphics2D.drawString(string, n10, n6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printChart(Graphics2D graphics2D, int n) {
        GanttCategoryPlot ganttCategoryPlot = (GanttCategoryPlot)this.chart.getChart().getPlot();
        try {
            ganttCategoryPlot.setPrinting(true);
            int n2 = this.totalChartHeight;
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, n, n2);
            this.chart.getChart().draw(graphics2D, (Rectangle2D)double_);
        }
        finally {
            ganttCategoryPlot.setPrinting(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printTable(Graphics2D graphics2D) {
        TGTreeTable tGTreeTable = this.chart.getTreeTable();
        boolean bl = PrintableChart.disableDoubleBuffering(tGTreeTable);
        try {
            tGTreeTable.printAll(graphics2D);
        }
        finally {
            if (bl) {
                PrintableChart.enableDoubleBuffering(tGTreeTable);
            }
        }
    }

    public static boolean disableDoubleBuffering(Component component) {
        if (component.isDoubleBuffered()) {
            RepaintManager repaintManager = RepaintManager.currentManager(component);
            repaintManager.setDoubleBufferingEnabled(false);
            return true;
        }
        return false;
    }

    public static void enableDoubleBuffering(Component component) {
        RepaintManager repaintManager = RepaintManager.currentManager(component);
        repaintManager.setDoubleBufferingEnabled(true);
    }

    private void release() {
    }

    public int getNumberOfPages() {
        if (this.pageFormat == null) {
            return -1;
        }
        return this.pageCountX * this.pageCountY;
    }

    public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
        return this.pageFormat;
    }

    public Printable getPrintable(int n) throws IndexOutOfBoundsException {
        return this;
    }
}

