/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.filter;

import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.Resource;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.AppProjectModel;
import com.triloggroup.gantt.app.NodeRef;
import com.triloggroup.gantt.app.Status;
import com.triloggroup.gantt.app.TablePanel;
import com.triloggroup.gantt.app.filter.AndOr;
import com.triloggroup.gantt.app.filter.Criteria;
import com.triloggroup.gantt.app.filter.CriteriaDef;
import com.triloggroup.gantt.app.filter.FinancialHealth;
import com.triloggroup.gantt.app.filter.Operator;
import com.triloggroup.gantt.app.filter.ProgressHealth;
import com.triloggroup.gantt.app.filter.ValueType;
import com.triloggroup.gantt.app.treetable.DateEditor;
import com.triloggroup.gantt.app.treetable.DurationEditor2;
import com.triloggroup.gantt.app.treetable.StatusEditor;
import com.triloggroup.gantt.treetable.DurationRenderer;
import com.triloggroup.project.components.ui.Workbench;
import com.triloggroup.project.components.ui.table.ComboEditor;
import com.triloggroup.project.components.ui.table.DateTableCellRenderer;
import com.triloggroup.project.components.ui.table.DoubleCellEditor;
import com.triloggroup.project.components.ui.table.ITGTableModel;
import com.triloggroup.project.components.ui.table.IntegerCellEditor;
import com.triloggroup.project.components.ui.table.LabelBooleanEditor;
import com.triloggroup.project.components.ui.table.LabelBooleanRenderer;
import com.triloggroup.project.components.ui.table.ListItemsEditor;
import com.triloggroup.project.components.ui.table.TGTable;
import com.triloggroup.project.components.ui.table.TGTableCellRenderer;
import com.triloggroup.project.components.ui.table.TextCellEditor;
import com.triloggroup.util.NLSBundle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CriteriaPanel
extends TablePanel {
    private ArrayList<Criteria> criteria = new ArrayList();
    private Locale formatLocale;

    public CriteriaPanel(AppGanttChart appGanttChart, List<Criteria> list) {
        super(appGanttChart, null);
        if (list != null) {
            for (Criteria criteria : list) {
                this.criteria.add(criteria.clone());
            }
        }
        this.addButton.setEnabled(true);
        this.deleteButton.setEnabled(!this.criteria.isEmpty());
    }

    void setFormatLocale(Locale locale) {
        this.formatLocale = locale;
    }

    private Locale getFormatLocale() {
        return this.formatLocale == null ? Locale.getDefault() : this.formatLocale;
    }

    @Override
    protected boolean isUseScrollPane() {
        return true;
    }

    @Override
    protected void initTable() {
        CriteriaTableModel criteriaTableModel = new CriteriaTableModel();
        TGTable tGTable = new TGTable(criteriaTableModel){
            private DateTableCellRenderer dateTableCellRenderer;
            private TGTableCellRenderer wbsRenderer;
            private DurationRenderer durationRenderer;
            private TGTableCellRenderer negationRenderer;
            private Color NEGATION_COLOR;
            {
                this.editCellOnlyWhenFocused = false;
                this.negationRenderer = new LabelBooleanRenderer(AppGanttChart.NLS_BUNDLE.getString("filter_NOT"), "");
                this.NEGATION_COLOR = new Color(255, 235, 235);
            }

            public TableCellEditor getCellEditor(int n, int n2) {
                if (n2 == 0) {
                    return new ComboEditor(new Object[]{AndOr.AND, AndOr.OR});
                }
                if (n2 == 1) {
                    return new LabelBooleanEditor();
                }
                if (n2 == 2) {
                    return new ComboEditor(CriteriaDef.getAvailableCriteria(CriteriaPanel.this.ganttChart.getModel().getGlobalContext()));
                }
                Criteria criteria = (Criteria)CriteriaPanel.this.criteria.get(n);
                if (n2 == 3) {
                    return new ComboEditor((Object[])criteria.def.getAvailableOperators());
                }
                boolean bl = criteria.operator != null && criteria.operator.isMultiple;
                boolean bl2 = false;
                switch (criteria.def.getValueType()) {
                    case STRING: {
                        return new TextCellEditor();
                    }
                    case STATUS: {
                        if (bl) {
                            ListItemsEditor listItemsEditor = new ListItemsEditor(new Object[]{Status.PENDING, Status.IN_PROGRESS, Status.DONE});
                            listItemsEditor.setTitle(AppGanttChart.NLS_BUNDLE.getString("Status"));
                            return listItemsEditor;
                        }
                        return StatusEditor.getStatusEditor();
                    }
                    case INT: {
                        return new IntegerCellEditor(CriteriaPanel.this.getFormatLocale(), true);
                    }
                    case DOUBLE: {
                        return new DoubleCellEditor(CriteriaPanel.this.getFormatLocale(), true);
                    }
                    case DATE: {
                        return new DateEditor(CriteriaPanel.this.getFormatLocale());
                    }
                    case PROGRESS_HEALTH: {
                        if (bl) {
                            ListItemsEditor listItemsEditor = new ListItemsEditor((Object[])ProgressHealth.values());
                            listItemsEditor.setTitle(AppGanttChart.NLS_BUNDLE.getString("progressHealth"));
                            return listItemsEditor;
                        }
                        return new ComboEditor((Object[])ProgressHealth.values());
                    }
                    case FINANCIAL_HEALTH: {
                        if (bl) {
                            ListItemsEditor listItemsEditor = new ListItemsEditor((Object[])FinancialHealth.values());
                            return listItemsEditor;
                        }
                        return new ComboEditor((Object[])FinancialHealth.values());
                    }
                    case NULLABLE_RESOURCE: {
                        bl2 = true;
                    }
                    case RESOURCE: {
                        String string;
                        Object object;
                        Object[] objectArray = CriteriaPanel.this.ganttChart.getModel().getMainProjectModel().getProjectResources();
                        Arrays.sort(objectArray);
                        if (bl2) {
                            object = objectArray;
                            objectArray = new Resource[((Object[])object).length + 1];
                            System.arraycopy(object, 0, objectArray, 1, ((Object[])object).length);
                            objectArray[0] = ValueType.NO_RESOURCE;
                        }
                        if (bl) {
                            object = new ListItemsEditor(objectArray);
                            ((ListItemsEditor)object).setTitle(AppGanttChart.NLS_BUNDLE.getString("Name"));
                            ((ListItemsEditor)object).setAllowSelectValueNotInAllValues(true);
                            return object;
                        }
                        object = this.getModel().getValueAt(n, n2);
                        if (object != null && object instanceof Resource && (string = ((Resource)object).getDn()) != null) {
                            boolean bl3 = false;
                            for (Object object2 : objectArray) {
                                if (!string.equals(((Resource)object2).getDn())) continue;
                                bl3 = true;
                                break;
                            }
                            if (!bl3) {
                                Object[] objectArray2 = objectArray;
                                objectArray = new Resource[objectArray2.length + 1];
                                System.arraycopy(objectArray2, 0, objectArray, 0, objectArray2.length);
                                objectArray[objectArray2.length] = (Resource)object;
                            }
                        }
                        return new ComboEditor(objectArray);
                    }
                    case WBS: {
                        GanttNode[] ganttNodeArray = CriteriaPanel.this.ganttChart.getModel().getMainProjectModel().getAllWBS().toArray(new GanttNode[0]);
                        Object[] objectArray = new Object[ganttNodeArray.length];
                        for (int i = 0; i < ganttNodeArray.length; ++i) {
                            objectArray[i] = new NodeRef(ganttNodeArray[i]);
                        }
                        Arrays.sort(objectArray);
                        if (bl) {
                            ListItemsEditor listItemsEditor = new ListItemsEditor(objectArray);
                            listItemsEditor.setTitle(AppGanttChart.NLS_BUNDLE.getString("Name"));
                            return listItemsEditor;
                        }
                        return new ComboEditor(objectArray);
                    }
                    case DURATION: {
                        return new DurationEditor2(CriteriaPanel.this.ganttChart.getModel().getGlobalContext().getTimeUnits());
                    }
                }
                return super.getCellEditor(n, n2);
            }

            public TableCellRenderer getCellRenderer(int n, int n2) {
                Criteria criteria;
                if (n2 == 1) {
                    return this.negationRenderer;
                }
                if (n2 == 4 && (criteria = (Criteria)CriteriaPanel.this.criteria.get(n)) != null && criteria.def != null) {
                    ValueType valueType = criteria.def.getValueType();
                    if (valueType == ValueType.DATE) {
                        if (this.dateTableCellRenderer == null) {
                            this.dateTableCellRenderer = new DateTableCellRenderer(CriteriaPanel.this.getFormatLocale(), Workbench.get().getTimeZone());
                        }
                        return this.dateTableCellRenderer;
                    }
                    if (valueType == ValueType.WBS) {
                        if (this.wbsRenderer == null) {
                            this.wbsRenderer = new TGTableCellRenderer(){

                                protected void setValue(Object object) {
                                    this.setToolTipText(null);
                                    if (object == null) {
                                        this.setText("");
                                    } else {
                                        Object[] objectArray = (Object[])object;
                                        int n = objectArray.length;
                                        if (n == 0) {
                                            this.setText("");
                                        } else {
                                            StringBuilder stringBuilder = new StringBuilder();
                                            boolean bl = false;
                                            AppProjectModel appProjectModel = CriteriaPanel.this.ganttChart.getModel().getMainProjectModel();
                                            for (int i = 0; i < n; ++i) {
                                                NodeRef nodeRef;
                                                if (stringBuilder.length() > 0) {
                                                    stringBuilder.append(", ");
                                                }
                                                if ((nodeRef = (NodeRef)objectArray[i]).existsOnProject(appProjectModel)) {
                                                    stringBuilder.append(nodeRef.toString(appProjectModel));
                                                    continue;
                                                }
                                                bl = true;
                                            }
                                            this.setText(stringBuilder.toString());
                                            if (bl) {
                                                this.setToolTipText(AppGanttChart.NLS_BUNDLE.getString("filter_wbsNotExistInProject"));
                                            }
                                        }
                                    }
                                }
                            };
                        }
                        return this.wbsRenderer;
                    }
                    if (valueType == ValueType.DURATION) {
                        if (this.durationRenderer == null) {
                            this.durationRenderer = new DurationRenderer(CriteriaPanel.this.ganttChart.getDateLocale());
                        }
                        return this.durationRenderer;
                    }
                }
                return super.getCellRenderer(n, n2);
            }

            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Criteria criteria;
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (n2 > 1 && (criteria = (Criteria)CriteriaPanel.this.criteria.get(n)) != null && criteria.negation) {
                    component.setBackground(this.NEGATION_COLOR);
                }
                return component;
            }
        };
        super.initTable(tGTable);
        TableColumnModel tableColumnModel = tGTable.getColumnModel();
        JLabel jLabel = new JLabel();
        int n = 20;
        int n2 = this.getPreferredColWidth(jLabel, (Object[])AndOr.values());
        tableColumnModel.getColumn(0).setPreferredWidth(n2 + n);
        n2 = this.getPreferredColWidth(jLabel, new Object[]{AppGanttChart.NLS_BUNDLE.getString("filter_NOT")});
        tableColumnModel.getColumn(1).setPreferredWidth(n2);
        n2 = this.getPreferredColWidth(jLabel, CriteriaDef.getAvailableCriteria(this.ganttChart.getModel().getGlobalContext()));
        tableColumnModel.getColumn(2).setPreferredWidth(n2 + n);
        n2 = this.getPreferredColWidth(jLabel, (Object[])Operator.values());
        tableColumnModel.getColumn(3).setPreferredWidth(n2 + n);
        tableColumnModel.getColumn(4).setPreferredWidth(200);
        Dimension dimension = tGTable.getPreferredSize();
        dimension.height = tGTable.getRowHeight() * 5;
        tGTable.setPreferredScrollableViewportSize(dimension);
    }

    protected int getPreferredColWidth(JLabel jLabel, Object[] objectArray) {
        int n = 0;
        for (Object object : objectArray) {
            if (object == null) continue;
            jLabel.setText(object.toString());
            n = Math.max(n, jLabel.getPreferredSize().width);
        }
        return n;
    }

    @Override
    protected void doAdd() {
        CriteriaTableModel criteriaTableModel = (CriteriaTableModel)this.table.getModel();
        criteriaTableModel.addRow();
        int n = criteriaTableModel.getRowCount();
        this.selectRow(n - 1);
        this.deleteButton.setEnabled(true);
    }

    @Override
    protected void doDelete() {
        int n;
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        CriteriaTableModel criteriaTableModel = (CriteriaTableModel)this.table.getModel();
        for (n = nArray.length - 1; n > -1; --n) {
            criteriaTableModel.removeRow(nArray[n]);
        }
        n = criteriaTableModel.getRowCount();
        if (n == 0) {
            this.deleteButton.setEnabled(false);
        } else if (nArray.length == 1) {
            int n2 = nArray[0];
            if (n > n2) {
                this.selectRow(n2);
            } else {
                this.selectRow(n2 - 1);
            }
        }
    }

    ArrayList<Criteria> getCriteria() {
        return this.criteria;
    }

    private class CriteriaTableModel
    extends AbstractTableModel
    implements ITGTableModel {
        NLSBundle nls = AppGanttChart.NLS_BUNDLE;
        private String[] columnNames = new String[]{"", "", this.nls.getString("filter_field"), this.nls.getString("filter_operator"), this.nls.getString("filter_value")};

        public int getColumnCount() {
            return 5;
        }

        public int getRowCount() {
            return CriteriaPanel.this.criteria == null ? 0 : CriteriaPanel.this.criteria.size();
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            Criteria criteria = (Criteria)CriteriaPanel.this.criteria.get(n);
            switch (n2) {
                case 0: {
                    return n == 0 ? null : criteria.andOr;
                }
                case 1: {
                    return criteria.negation;
                }
                case 2: {
                    return criteria.def == null ? null : criteria.def;
                }
                case 3: {
                    return criteria.operator;
                }
                case 4: {
                    if (criteria.operator != null && !criteria.operator.isMultiple) {
                        return criteria.getFirstValue();
                    }
                    return criteria.value;
                }
            }
            return null;
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 0 && n == 0) {
                return false;
            }
            if (n2 > 2) {
                Criteria criteria = (Criteria)CriteriaPanel.this.criteria.get(n);
                if (criteria.def == null) {
                    return false;
                }
                if (n2 == 4 && criteria.operator == null) {
                    return false;
                }
            }
            return true;
        }

        public void setValueAt(Object object, int n, int n2) {
            Criteria criteria = (Criteria)CriteriaPanel.this.criteria.get(n);
            switch (n2) {
                case 0: {
                    if (object == null) {
                        object = AndOr.AND;
                    }
                    criteria.andOr = (AndOr)((Object)object);
                    break;
                }
                case 1: {
                    criteria.negation = (Boolean)object;
                    break;
                }
                case 2: {
                    if (criteria.def == object) break;
                    criteria.def = (CriteriaDef)object;
                    if (object != null) {
                        Operator[] operatorArray = criteria.def.getAvailableOperators();
                        criteria.operator = operatorArray.length == 1 ? operatorArray[0] : null;
                    }
                    criteria.value = null;
                    break;
                }
                case 3: {
                    if (criteria.operator == object) break;
                    boolean bl = criteria.operator != null && criteria.operator.isMultiple;
                    criteria.operator = (Operator)((Object)object);
                    if (!bl || criteria.operator.isMultiple || criteria.value == null || criteria.value.length <= 1) break;
                    criteria.value = new Object[]{criteria.value[0]};
                    break;
                }
                case 4: {
                    criteria.value = object == null || object.getClass().isArray() ? (Object[])object : new Object[]{object};
                }
            }
            this.fireTableRowsUpdated(n, n);
        }

        public void removeRow(int n) {
            CriteriaPanel.this.criteria.remove(n);
            this.fireTableRowsDeleted(n, n);
        }

        public void addRow() {
            Criteria criteria = new Criteria();
            criteria.andOr = AndOr.AND;
            CriteriaPanel.this.criteria.add(criteria);
            this.fireTableRowsInserted(this.getRowCount(), this.getRowCount());
        }

        public boolean isEditable() {
            return true;
        }

        public boolean isLeaf(int n) {
            return true;
        }

        public boolean isValidElement(int n) {
            return true;
        }
    }
}

