/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.applet;

import com.triloggroup.gantt.Debug;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.AppGlobalContext;
import com.triloggroup.gantt.app.GanttWorkbenchPage;
import com.triloggroup.gantt.app.applet.IJSCallBack;
import com.triloggroup.gantt.app.applet.JSCallBack;
import com.triloggroup.gantt.app.change.ChangeManager;
import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.gantt.app.ui.WDLookAndFeelConfig;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.gantt.pe.app.ws.TestWSHelper;
import com.triloggroup.gantt.pe.app.ws.WebServiceHelper;
import com.triloggroup.project.components.ui.Workbench;
import com.triloggroup.util.NLSBundle;
import com.triloggroup.util.UString;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.html.parser.ParserDelegator;
import org.jdom.Element;
import org.jfree.chart.util.ResourceBundleWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GanttAppletBase
extends JApplet
implements ChangeListener {
    public static final String PARAM_SITE_ID = "siteId";
    public static final String PARAM_PROJECT_ID = "projectId";
    public static final String PARAM_TIMEZONE = "timeZone";
    public static final String PARAM_LOCALE = "locale";
    private static final String PARAM_SERVER_BASE_URL = "serverBaseUrl";
    protected static final String PARAM_WS_SESSION_ID = "wsSessionId";
    private static final String PARAM_COOKIES = "wsContext";
    public static final String PARAM_TOUCH_SESSION_INTERVAL = "touchSessionInterval";
    public static final String PARAM_TOUCH_SESSION_URL = "touchSessionURL";
    public static final String PARAM_BROWSER_WS_CALLS = "browserwscalls";
    protected static final TimeZone clientTZ = TimeZone.getDefault();
    protected String htmlTagId;
    private AppGanttChart ganttChart;
    private boolean hasPendingChange = false;
    private String cookies;
    protected IJSCallBack callBack;
    private CallBackThread callBackThread = new CallBackThread();
    protected Boolean isLiveConnectEnabled;

    @Override
    public void init() {
        String string = this.getParameter(PARAM_TIMEZONE);
        TimeZone timeZone = TimeZone.getTimeZone(string);
        Workbench.get().setTimeZone(timeZone);
        TimeZone.setDefault(timeZone);
        String string2 = this.getParameter(PARAM_LOCALE);
        String[] stringArray = UString.splitString(string2, '_');
        Locale locale = stringArray.length == 1 ? new Locale(string2) : (stringArray.length == 2 ? new Locale(stringArray[0], stringArray[1]) : new Locale(stringArray[0], stringArray[1], stringArray[2]));
        Workbench.get().setLocale(locale);
        this.htmlTagId = this.getParameter("id");
        Debug.log("url: " + this.getServerBaseUrl());
        this.cookies = this.getParameter(PARAM_COOKIES);
        this.cookies = UString.isEmpty(this.cookies) ? null : this.enc(this.cookies);
        new Thread(new AutoTest()).run();
        ResourceBundleWrapper.removeCodeBase((URL)this.getCodeBase(), (URLClassLoader)((URLClassLoader)this.getClass().getClassLoader()));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                WDLookAndFeelConfig.installLookAndFeel();
                ParserDelegator parserDelegator = new ParserDelegator();
                GanttAppletBase.this.createLoadingGUI();
            }
        });
        NLSBundle.FORCE_LOAD_DEFAULT_LANG = true;
        this.initNLSBundle(locale);
        new Element("dummy");
    }

    protected GanttWorkbenchPage createGanttWorkbenchPage(GanttWorkbenchPage.Mode mode) {
        return new GanttWorkbenchPage(this.ganttChart, mode);
    }

    protected void createLoadingGUI() {
        this.getContentPane().setBackground(Color.WHITE);
        ImageIcon imageIcon = WDUtil.getIcon("loading.gif");
        if (imageIcon == null) {
            return;
        }
        JLabel jLabel = new JLabel(imageIcon);
        jLabel.setBackground(WDUtil.PE_BLUE);
        jLabel.setOpaque(true);
        jLabel.setPreferredSize(new Dimension(100, 100));
        this.getContentPane().removeAll();
        this.getContentPane().add((Component)jLabel, "North");
        this.getContentPane().validate();
    }

    public String getServerBaseUrl() {
        String string = this.getParameter(PARAM_SERVER_BASE_URL);
        return string;
    }

    public String getCookies() {
        return this.cookies;
    }

    public void relogin() {
        Debug.log("---- relogin ------");
        this.hideFullScreen(false);
        final AppGlobalContext appGlobalContext = this.ganttChart.getModel().getGlobalContext();
        JSCallBack jSCallBack = new JSCallBack(){

            public void actionPerformed(String string) {
                Debug.log("relogin callback actionPerformed: " + string);
                String[] stringArray = UString.splitString(string, '|');
                if (stringArray != null && stringArray.length >= 3) {
                    if (UString.equalsIgnoreCase(stringArray[1], appGlobalContext.getCurrentUserDn())) {
                        appGlobalContext.setCurrentUser(stringArray[0], stringArray[1]);
                        appGlobalContext.setWSSessionId(stringArray[2]);
                        if (stringArray.length > 3) {
                            String string2;
                            if (stringArray.length == 4) {
                                string2 = stringArray[3];
                            } else {
                                int n = 0;
                                for (int i = 0; i < 3; ++i) {
                                    n = string.indexOf(124, n) + 1;
                                }
                                string2 = string.substring(n);
                            }
                            GanttAppletBase.this.cookies = UString.isEmpty(string2) ? null : GanttAppletBase.this.enc(string2);
                        }
                    } else {
                        WDDialog.showMsgDialog(GanttAppletBase.this, Workbench.getNLSString("relogin_different_user", new Object[0]));
                        appGlobalContext.setWSSessionId("");
                    }
                } else {
                    WDDialog.showMsgDialog(GanttAppletBase.this, Workbench.getNLSString("login_failed", new Object[0]));
                    appGlobalContext.setWSSessionId("");
                }
            }
        };
        this.callJS("tg_pe_ganttReLogin('" + this.getHtmlTagId() + "', '" + appGlobalContext.getCurrentUserDn() + "');", jSCallBack);
    }

    public AppGanttChart getGanttChart() {
        return this.ganttChart;
    }

    protected void setGanttChart(AppGanttChart appGanttChart) {
        this.ganttChart = appGanttChart;
        appGanttChart.getModel().getChangeManager().addChangeListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        ChangeManager changeManager;
        if (changeEvent.getSource() instanceof ChangeManager && this.hasPendingChange != (changeManager = (ChangeManager)changeEvent.getSource()).canUndo()) {
            this.hasPendingChange = !this.hasPendingChange;
            this.callJS("tg_gantt_setPendingChange(" + this.hasPendingChange + ");");
        }
    }

    public void beforeUnload() {
        this.runPrivilegedAction(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                GanttAppletBase.this.internalBeforeUnload();
                return null;
            }
        });
    }

    protected abstract void internalBeforeUnload();

    public void hideFullScreen(boolean bl) {
        this.getGanttChart().getWorkbenchPage().hideFullScreen();
    }

    private void initNLSBundle(Locale locale) {
        if (Workbench.get().getNLSBundle() != null) {
            return;
        }
        NLSBundle.setBaseUrl(this.getCodeBase());
        NLSBundle.addIgnoreBaseUrlForLocales("fr", "en", "");
        NLSBundle.addIgnoreLocales("fr_FR", "en_US");
        NLSBundle nLSBundle = NLSBundle.getBundle("com/triloggroup/gantt/resources/gantt", locale);
        NLSBundle nLSBundle2 = NLSBundle.getBundle("com/triloggroup/gantt/app/resources/GanttChartApp", locale, nLSBundle);
        Workbench.get().setNLSBundle(nLSBundle2);
    }

    protected void runPrivilegedAction(PrivilegedAction<?> privilegedAction) {
        try {
            AccessController.doPrivileged(privilegedAction);
        }
        catch (SecurityException securityException) {
            Debug.log("doPrivileged failed with SecurityException. Retry without privileges.");
            privilegedAction.run();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void callJS(String string) {
        this.callJS(string, null);
    }

    public void callJS(String string, IJSCallBack iJSCallBack) {
        this.callJS(string, iJSCallBack, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callJS(String string, IJSCallBack iJSCallBack, boolean bl) {
        Object object = this.callBackThread;
        synchronized (object) {
            this.callBack = iJSCallBack;
            if (!bl && iJSCallBack != null && this.isLiveConnectEnabled != Boolean.TRUE) {
                if (!this.callBackThread.isAlive()) {
                    this.callBackThread.start();
                } else {
                    this.callBackThread.notify();
                }
            }
        }
        try {
            object = new URL("javascript:" + string);
            this.getAppletContext().showDocument((URL)object);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    public void callBack(String string) {
        this.doCallBack(false, string);
    }

    public void callBackActionEnded() {
        this.doCallBack(true, null);
    }

    private void doCallBack(final boolean bl, final String string) {
        this.runPrivilegedAction(new PrivilegedAction<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() {
                CallBackThread callBackThread = GanttAppletBase.this.callBackThread;
                synchronized (callBackThread) {
                    if (GanttAppletBase.this.callBack != null) {
                        try {
                            if (bl) {
                                GanttAppletBase.this.callBack.actionCancelled();
                            } else {
                                GanttAppletBase.this.callBack.actionPerformed(string);
                            }
                        }
                        finally {
                            GanttAppletBase.this.callBack = null;
                        }
                    }
                }
                return null;
            }
        });
    }

    public String getHtmlTagId() {
        return this.htmlTagId;
    }

    public Object callJSWithResult(String string, Object ... objectArray) {
        try {
            Class<?> clazz = Class.forName("netscape.javascript.JSObject");
            Method method = clazz.getMethod("getWindow", Applet.class);
            Object object = method.invoke(null, this);
            if (object == null) {
                Debug.log("jsObject is null");
                return null;
            }
            Method method2 = object.getClass().getMethod("call", String.class, Object[].class);
            return method2.invoke(object, string, objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private String enc(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = this.enc(string.charAt(n - i - 1));
        }
        return new String(cArray);
    }

    private char enc(char c) {
        if (c < ' ' || c > '~') {
            return c;
        }
        int n = 158 - c;
        return (char)n;
    }

    private class AutoTest
    extends JSCallBack
    implements Runnable {
        private static final boolean PERFORM_LIVE_CONNECT_TEST = false;
        private volatile String jsCallBackResult = null;
        private long t0;

        private AutoTest() {
        }

        public void run() {
            Debug.logDebug("Start auto-test");
            try {
                Object object;
                boolean bl = false;
                String string = (String)GanttAppletBase.this.callJSWithResult("tg_Hello", new Object[0]);
                boolean bl2 = "Hello World".equals(string);
                if (bl2) {
                    Debug.logDebug("javascript call test successful");
                } else {
                    Debug.log("javascript call test failed: " + string);
                }
                try {
                    object = new TestWSHelper(GanttAppletBase.this, GanttAppletBase.this.getParameter(GanttAppletBase.PARAM_WS_SESSION_ID), GanttAppletBase.this.getCookies());
                    bl = ((WebServiceHelper)object).touchSession();
                    if (bl) {
                        Debug.logDebug("WS call test successful");
                    } else {
                        Debug.log("WS call test failed");
                        if (GanttAppletBase.this.cookies != null) {
                            GanttAppletBase.this.cookies = null;
                            bl = ((WebServiceHelper)object).touchSession();
                            if (bl) {
                                Debug.logDebug("WS call test successful after cookies update");
                            } else {
                                Debug.log("WS call test failed");
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                boolean bl3 = true;
                if (!(bl2 && bl3 && bl)) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("The Gantt Chart might not work, or not optimally, due to a configuration issue.");
                    if (!bl) {
                        ((StringBuilder)object).append("\nThe server did not respond.");
                    }
                    if (!bl3) {
                        ((StringBuilder)object).append("\nLiveConnect javascript to applet is not enabled.");
                    }
                    SwingUtilities.invokeLater(new Runnable((StringBuilder)object){
                        final /* synthetic */ StringBuilder val$sb;
                        {
                            this.val$sb = stringBuilder;
                        }

                        public void run() {
                            JOptionPane.showMessageDialog(GanttAppletBase.this, this.val$sb.toString(), "Warning", 2);
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                Debug.log("Auto test failed.");
                throwable.printStackTrace();
            }
            Debug.log("End of auto-test");
        }

        public synchronized void actionPerformed(String string) {
            this.jsCallBackResult = string;
            Debug.logDebug("LiveConnectTest.actionPerformed: " + string + " in " + (System.currentTimeMillis() - this.t0) + "ms");
            GanttAppletBase.this.isLiveConnectEnabled = "Hello".equals(string);
            this.notifyAll();
        }
    }

    private class CallBackThread
    extends Thread {
        private CallBackThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (true) {
                    Debug.logDebug("call tg_appletGetResult");
                    String string = (String)GanttAppletBase.this.callJSWithResult("tg_appletGetResult", new Object[0]);
                    if (string != null && string.length() > 0) {
                        Debug.logDebug("tg_appletGetResult: " + string);
                        CallBackThread callBackThread = this;
                        synchronized (callBackThread) {
                            if (GanttAppletBase.this.callBack != null) {
                                char c = string.charAt(0);
                                if (c == '-') {
                                    GanttAppletBase.this.callBack.actionCancelled();
                                } else if (c == '+') {
                                    String string2 = string.substring(1);
                                    GanttAppletBase.this.callBack.actionPerformed(string2);
                                } else {
                                    Debug.log("Invalid result for callback: " + string);
                                }
                                GanttAppletBase.this.callBack = null;
                            }
                            this.wait();
                        }
                    }
                    Thread.sleep(500L);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }
}

