/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app;

import com.triloggroup.gantt.Resource;
import com.triloggroup.gantt.app.AppProjectModel;
import com.triloggroup.gantt.app.ui.WDButton;
import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.project.components.resourceeditor.ProjectResource;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;

public class ResourcePickerDialog
extends WDDialog
implements ActionListener {
    private WDButton okButton;
    private Resource[] selection;
    private JList list;
    private boolean excludeDisabled = false;

    public static ResourcePickerDialog create(Component component) {
        Window window = SwingUtilities.getWindowAncestor(component);
        GraphicsConfiguration graphicsConfiguration = WDUtil.getGraphicsConfiguration(component);
        return new ResourcePickerDialog(window, graphicsConfiguration);
    }

    protected ResourcePickerDialog(Window window, GraphicsConfiguration graphicsConfiguration) {
        super(window, graphicsConfiguration);
    }

    public void setExcludeDisabled(boolean bl) {
        this.excludeDisabled = bl;
    }

    public void init(AppProjectModel appProjectModel, boolean bl) {
        this.init(appProjectModel, null, bl);
    }

    public void init(AppProjectModel appProjectModel, Resource[] resourceArray, boolean bl) {
        int n;
        Resource[] resourceArray2 = appProjectModel.getProjectResources();
        HashSet hashSet = null;
        if (resourceArray != null) {
            hashSet = new HashSet(resourceArray.length);
            Collections.addAll(hashSet, resourceArray);
        }
        int n2 = 0;
        for (n = 0; n < resourceArray2.length; ++n) {
            if ((!this.excludeDisabled || resourceArray2[n].isEnabled()) && (hashSet == null || !hashSet.contains(resourceArray2[n]))) continue;
            resourceArray2[n] = null;
            ++n2;
        }
        Arrays.sort(resourceArray2, Resource.COMPARATOR);
        if (n2 > 0) {
            n = resourceArray2.length - n2;
            ProjectResource[] projectResourceArray = new ProjectResource[n];
            System.arraycopy(resourceArray2, n2, projectResourceArray, 0, n);
            resourceArray2 = projectResourceArray;
        }
        this.init(resourceArray2, bl);
    }

    public void init(Resource[] resourceArray, boolean bl) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.list = new JList<Resource>(resourceArray);
        this.list.setSelectionMode(bl ? 2 : 0);
        this.list.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                String string;
                Resource resource = (Resource)object;
                String string2 = string = resource == null ? null : resource.getEmail();
                if ("".equals(string)) {
                    string = null;
                }
                this.setToolTipText(string);
                return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            }
        });
        jPanel.add(this.list);
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        this.okButton = WDUtil.createOkButton();
        jPanel2.add(this.okButton);
        this.okButton.addActionListener(this);
        WDButton wDButton = WDUtil.createCancelButton();
        jPanel2.add(wDButton);
        wDButton.addActionListener(this);
        this.getContentPane().add((Component)jPanel2, "South");
        this.getContentPane().add((Component)new JScrollPane(jPanel, 20, 31), "Center");
        this.setDragHeader(true);
        this.setMaximizable(false);
    }

    public Resource[] getSelection() {
        return this.selection;
    }

    public void selectResources(Resource[] resourceArray) {
        if (resourceArray == null) {
            this.list.clearSelection();
            return;
        }
        int[] nArray = new int[resourceArray.length];
        ListModel listModel = this.list.getModel();
        block0: for (int i = 0; i < resourceArray.length; ++i) {
            nArray[i] = -1;
            for (int j = 0; j < listModel.getSize(); ++j) {
                if (resourceArray[i] != listModel.getElementAt(j)) continue;
                nArray[i] = j;
                continue block0;
            }
        }
        this.list.setSelectedIndices(nArray);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            Object[] objectArray = this.list.getSelectedValues();
            this.selection = new Resource[objectArray.length];
            System.arraycopy(objectArray, 0, this.selection, 0, objectArray.length);
        }
        this.dispose();
    }
}

