/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app;

import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.ProjectModel;
import com.triloggroup.project.ObjectRef;
import com.triloggroup.util.UString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeRef
extends ObjectRef
implements Comparable<NodeRef> {
    public String toStringLabel;

    public NodeRef(GanttNode ganttNode) {
        super(ganttNode.getGlobalContext().getSiteId(), ganttNode.getProjectContext().getProjectId(), ganttNode.getUid());
        this.toStringLabel = ganttNode.getName();
    }

    public NodeRef(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    public boolean isOnProject(ProjectModel projectModel) {
        return UString.equals(this.siteId, projectModel.getSiteId()) && UString.equals(this.projectId, projectModel.getProjectContext().getProjectId());
    }

    public boolean existsOnProject(ProjectModel projectModel) {
        return this.isOnProject(projectModel) && projectModel.getNodeByUid(this.id) != null;
    }

    @Override
    public String toString() {
        if (this.toStringLabel != null) {
            return this.toStringLabel;
        }
        return "NodeRef#" + this.id;
    }

    public String toString(ProjectModel projectModel) {
        GanttNode ganttNode;
        if (this.isOnProject(projectModel) && (ganttNode = projectModel.getNodeByUid(this.id)) != null) {
            return ganttNode.toString();
        }
        return "?";
    }

    @Override
    public int compareTo(NodeRef nodeRef) {
        return this.toString().compareTo(nodeRef.toString());
    }
}

