/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app;

import com.triloggroup.gantt.Debug;
import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.ProjectContext;
import com.triloggroup.gantt.TaskPredecessor;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.AppGanttChartModel;
import com.triloggroup.gantt.app.AppProjectModel;
import com.triloggroup.gantt.app.FullScreenAction;
import com.triloggroup.gantt.app.FullScreenActionForEmbedded;
import com.triloggroup.gantt.app.GanttKeyStrokes;
import com.triloggroup.gantt.app.GanttView;
import com.triloggroup.gantt.app.UserPreferences;
import com.triloggroup.gantt.app.applet.GanttAppletBase;
import com.triloggroup.gantt.app.change.ChangeException;
import com.triloggroup.gantt.app.change.ChangeManager;
import com.triloggroup.gantt.app.print.PrintableChart;
import com.triloggroup.gantt.app.ui.UToolBar;
import com.triloggroup.gantt.app.ui.WDCmdButton;
import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.gantt.app.xsp.XSPActions;
import com.triloggroup.gantt.event.GanttModelSelectionEvent;
import com.triloggroup.gantt.event.GanttModelSelectionListener;
import com.triloggroup.project.components.IProjectResourceModel;
import com.triloggroup.project.components.resourceeditor.ResourceView;
import com.triloggroup.project.components.ui.IView;
import com.triloggroup.project.components.ui.Workbench;
import com.triloggroup.project.components.ui.WorkbenchPage;
import com.triloggroup.util.NLSBundle;
import com.triloggroup.util.UString;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;

public class GanttWorkbenchPage
extends WorkbenchPage
implements ChangeListener,
GanttModelSelectionListener {
    private static final String TUTORIAL_URL_KEY = "projexec.gantt.tutorialURL";
    private GanttView ganttView;
    private ResourceView resourceView;
    private ProjectContext currentProject;
    protected Mode mode;
    protected Action printAction;
    protected WDCmdButton printButton;
    protected Action newAction;
    protected WDCmdButton newButton;
    protected Action deleteAction;
    protected WDCmdButton deleteButton;
    protected Action undoAction;
    protected Action reloadAction;
    protected Action saveAction;

    public GanttWorkbenchPage(AppGanttChart appGanttChart, Mode mode) {
        this.mode = mode;
        this.ganttView = new GanttView(appGanttChart);
        this.createResourceView(appGanttChart.getModel());
        this.initActions(mode);
        this.addView(this.ganttView, 0);
        this.addView(this.resourceView, 1);
        if (appGanttChart.getModel().getMainProjectModel().getProjectResources().length > 1) {
            this.setViewState(this.ganttView, IView.STATE_MAXIMIZED);
        }
        appGanttChart.getModel().addSelectionListener(this);
    }

    private AppGanttChart getChart() {
        return this.ganttView.getChart();
    }

    protected void createResourceView(AppGanttChartModel appGanttChartModel) {
        this.resourceView = new ResourceView(appGanttChartModel, appGanttChartModel.getMainProjectModel());
        this.resourceView.setSametimeSupport(this.getChart().getSametimeSupport());
    }

    public UserPreferences getUserPreferences() {
        return this.getChart().getUserPreferences();
    }

    public void selectionChanged(GanttModelSelectionEvent ganttModelSelectionEvent) {
        Object object;
        ProjectContext projectContext = null;
        int n = ganttModelSelectionEvent.getNewSelectionType();
        if (n == 1) {
            object = ganttModelSelectionEvent.getNewSelection();
            for (int i = 0; i < ((Object[])object).length; ++i) {
                if (!(object[i] instanceof GanttNode)) continue;
                GanttNode ganttNode = (GanttNode)object[i];
                if (projectContext == null) {
                    projectContext = ganttNode.getProjectContext();
                    continue;
                }
                if (projectContext == ganttNode.getProjectContext()) continue;
                projectContext = null;
                break;
            }
        } else if (n == 2 && (object = ganttModelSelectionEvent.getNewSelection()) != null && ((Object[])object).length > 0) {
            TaskPredecessor taskPredecessor = (TaskPredecessor)object[0];
            projectContext = taskPredecessor.task.getProjectContext();
        }
        if (projectContext == null) {
            projectContext = this.getChart().getModel().getMainProjectModel().getProjectContext();
        }
        if (projectContext != this.currentProject) {
            this.currentProject = projectContext;
            object = this.getChart().getModel().getProjectModel(this.currentProject.getProjectId());
            this.resourceView.setProject((IProjectResourceModel)object);
            this.ganttView.setTitle(Workbench.getNLSString("gantt_view_title", new Object[0]) + " - " + ((AppProjectModel)object).getProjectContext().getProjectName());
        }
    }

    public void setUserActive(boolean bl) {
        this.getChart().setUserActive();
    }

    public void setActiveView(IView iView) {
        if (iView == this.activeView) {
            return;
        }
        super.setActiveView(iView);
        Action action = null;
        Action action2 = null;
        if (iView != null) {
            action = iView.getAction(2);
            action2 = iView.getAction(1);
        }
        if (this.getChart().isEditable()) {
            if (action2 == null) {
                this.deleteButton.setAction(this.deleteAction);
                this.deleteAction.setEnabled(false);
            } else {
                this.deleteButton.setAction(action2);
                this.deleteAction.setEnabled(true);
            }
            if (action == null) {
                this.newButton.setAction(this.newAction);
                this.newAction.setEnabled(false);
            } else {
                this.newButton.setAction(action);
                this.newAction.setEnabled(true);
            }
        }
    }

    protected void initActions(Mode mode) {
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
        ArrayList<JComponent> arrayList2 = new ArrayList<JComponent>();
        NLSBundle nLSBundle = AppGanttChart.NLS_BUNDLE;
        if (this.getChart().isEditable()) {
            arrayList.add(this.initSaveButton(nLSBundle));
        }
        arrayList.add(this.initRelaodButton(nLSBundle));
        if (this.getChart().isEditable()) {
            arrayList.add(this.initUndoButton(nLSBundle));
            arrayList.add(UToolBar.createSeparator());
            this.initNewButton(nLSBundle);
            arrayList.add(this.newButton);
            this.initDeleteButton(nLSBundle);
            arrayList.add(this.deleteButton);
        }
        arrayList.add(UToolBar.createSeparator());
        WDCmdButton wDCmdButton = this.initTutorialButton(nLSBundle);
        if (wDCmdButton != null) {
            arrayList2.add(wDCmdButton);
        }
        this.initPrintButton(nLSBundle);
        arrayList2.add(this.printButton);
        arrayList2.add(this.initFontButton(nLSBundle));
        AbstractAction abstractAction = mode == Mode.EMBEDDED_APPLET ? new FullScreenActionForEmbedded(this) : new FullScreenAction(this.getChart());
        arrayList2.add(new WDCmdButton(abstractAction));
        WDCmdButton wDCmdButton2 = this.initTestButton();
        if (wDCmdButton2 != null) {
            arrayList2.add(wDCmdButton2);
        }
        this.header.setLeftItems1(UToolBar.disableFocus(arrayList));
        this.header.setRightItems(UToolBar.disableFocus(arrayList2));
        this.getChart().getModel().getChangeManager().addChangeListener(this);
        ActionMap actionMap = this.getComponent().getActionMap();
        InputMap inputMap = this.getComponent().getInputMap(2);
        this.registerAction(actionMap, inputMap, "delete", this.deleteAction, GanttKeyStrokes.DELETE);
        this.registerAction(actionMap, inputMap, "save", this.saveAction, GanttKeyStrokes.SAVE);
        this.registerAction(actionMap, inputMap, "undo", this.undoAction, GanttKeyStrokes.UNDO);
        this.registerAction(actionMap, inputMap, "print", this.printAction, GanttKeyStrokes.PRINT);
        this.registerAction(actionMap, inputMap, "fullScreen", abstractAction, null);
    }

    protected void registerAction(ActionMap actionMap, InputMap inputMap, Object object, Action action, KeyStroke keyStroke) {
        if (action == null) {
            return;
        }
        actionMap.put(object, action);
        inputMap.put(keyStroke, object);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.saveAction == null) {
            return;
        }
        if (changeEvent.getSource() instanceof ChangeManager) {
            ChangeManager changeManager = (ChangeManager)changeEvent.getSource();
            this.undoAction.setEnabled(changeManager.canUndo());
            String string = changeManager.getUndoText();
            if (string != null) {
                String string2 = GanttKeyStrokes.formatCommand(string, GanttKeyStrokes.UNDO);
                this.undoAction.putValue("ShortDescription", string2);
            } else {
                this.setActionText(this.undoAction, "undo_button", GanttKeyStrokes.UNDO);
            }
            this.saveAction.setEnabled(changeManager.canUndo());
        }
    }

    protected WDCmdButton initTutorialButton(NLSBundle nLSBundle) {
        final String string = Workbench.get().getStringProperty(TUTORIAL_URL_KEY);
        if (UString.isEmpty(string)) {
            return null;
        }
        ImageIcon imageIcon = WDUtil.getIcon("tutorial.png");
        final WDCmdButton wDCmdButton = new WDCmdButton(imageIcon);
        wDCmdButton.setToolTipText(nLSBundle.getString("tutorial_button"));
        wDCmdButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XSPActions xSPActions = new XSPActions(wDCmdButton, GanttWorkbenchPage.this.getApplet());
                xSPActions.openBrowserTab(string);
            }
        });
        return wDCmdButton;
    }

    protected void initPrintButton(final NLSBundle nLSBundle) {
        ImageIcon imageIcon = WDUtil.getIcon("print.png");
        this.printAction = new AbstractAction(null, imageIcon){

            public void actionPerformed(ActionEvent actionEvent) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                JMenuItem jMenuItem = new JMenuItem(nLSBundle.getString("print_all"));
                JMenuItem jMenuItem2 = new JMenuItem(nLSBundle.getString("print_table"));
                JMenuItem jMenuItem3 = new JMenuItem(nLSBundle.getString("print_chart"));
                jMenuItem.addActionListener(new PrintActionListener(2));
                jMenuItem2.addActionListener(new PrintActionListener(0));
                jMenuItem3.addActionListener(new PrintActionListener(1));
                jPopupMenu.add(jMenuItem);
                jPopupMenu.add(jMenuItem3);
                jPopupMenu.add(jMenuItem2);
                jPopupMenu.show(GanttWorkbenchPage.this.printButton, 0, GanttWorkbenchPage.this.printButton.getHeight());
            }
        };
        this.setActionText(this.printAction, "print_button", GanttKeyStrokes.PRINT);
        this.printButton = new WDCmdButton(this.printAction);
    }

    protected WDCmdButton initFontButton(final NLSBundle nLSBundle) {
        ImageIcon imageIcon = WDUtil.getIcon("font.png");
        final WDCmdButton wDCmdButton = new WDCmdButton(imageIcon);
        wDCmdButton.setToolTipText(nLSBundle.getString("font_button"));
        wDCmdButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(new FontSizeAction(nLSBundle.getString("font_size1"), 11));
                JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem(new FontSizeAction(nLSBundle.getString("font_size2"), 12));
                JRadioButtonMenuItem jRadioButtonMenuItem3 = new JRadioButtonMenuItem(new FontSizeAction(nLSBundle.getString("font_size3"), 13));
                int n = GanttWorkbenchPage.this.getUserPreferences().getFontSize();
                if (n == 13) {
                    jRadioButtonMenuItem3.setSelected(true);
                } else if (n == 12) {
                    jRadioButtonMenuItem2.setSelected(true);
                } else if (n == 11) {
                    jRadioButtonMenuItem.setSelected(true);
                }
                jPopupMenu.add(jRadioButtonMenuItem3);
                jPopupMenu.add(jRadioButtonMenuItem2);
                jPopupMenu.add(jRadioButtonMenuItem);
                jPopupMenu.show(wDCmdButton, 0, wDCmdButton.getHeight());
            }
        });
        return wDCmdButton;
    }

    protected WDCmdButton initSaveButton(NLSBundle nLSBundle) {
        ImageIcon imageIcon = WDUtil.getIcon("save.png");
        this.saveAction = new AbstractAction(null, imageIcon){

            public void actionPerformed(ActionEvent actionEvent) {
                GanttWorkbenchPage.this.stopEditInProgress(true);
                GanttWorkbenchPage.this.getChart().saveChanges();
            }
        };
        this.saveAction.setEnabled(false);
        this.setActionText(this.saveAction, "save_button", GanttKeyStrokes.SAVE);
        return new WDCmdButton(this.saveAction);
    }

    protected void initNewButton(NLSBundle nLSBundle) {
        ImageIcon imageIcon = WDUtil.getIcon("new.png");
        this.newAction = new AbstractAction(null, imageIcon){

            public void actionPerformed(ActionEvent actionEvent) {
                Action action;
                if (GanttWorkbenchPage.this.activeView != null && (action = GanttWorkbenchPage.this.activeView.getAction(2)) != null && action.isEnabled()) {
                    action.actionPerformed(actionEvent);
                }
            }
        };
        this.newAction.setEnabled(false);
        this.setActionText(this.newAction, "new_button", null);
        this.newButton = new WDCmdButton(this.newAction);
    }

    protected void initDeleteButton(NLSBundle nLSBundle) {
        ImageIcon imageIcon = WDUtil.getIcon("delete.png");
        this.deleteAction = new AbstractAction(null, imageIcon){

            public void actionPerformed(ActionEvent actionEvent) {
                Action action;
                if (GanttWorkbenchPage.this.activeView != null && (action = GanttWorkbenchPage.this.activeView.getAction(1)) != null && action.isEnabled()) {
                    action.actionPerformed(actionEvent);
                }
            }
        };
        this.deleteAction.setEnabled(false);
        this.setActionText(this.deleteAction, "delete_button", GanttKeyStrokes.DELETE);
        this.deleteButton = new WDCmdButton(this.deleteAction);
    }

    protected WDCmdButton initUndoButton(NLSBundle nLSBundle) {
        ImageIcon imageIcon = WDUtil.getIcon("undo.png");
        this.undoAction = new AbstractAction(null, imageIcon){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    GanttWorkbenchPage.this.undoLastChange();
                }
                catch (Exception exception) {
                    WDDialog.showErrorMsgDialog(GanttWorkbenchPage.this.getComponent(), exception);
                }
            }
        };
        this.undoAction.setEnabled(false);
        this.setActionText(this.undoAction, "undo_button", GanttKeyStrokes.UNDO);
        return new WDCmdButton(this.undoAction);
    }

    public void undoLastChange() throws ChangeException {
        TableCellEditor tableCellEditor = this.getCurrentTableEditor();
        if (tableCellEditor != null) {
            tableCellEditor.cancelCellEditing();
            return;
        }
        this.getChart().getModel().getChangeManager().undo();
    }

    protected WDCmdButton initRelaodButton(NLSBundle nLSBundle) {
        ImageIcon imageIcon = WDUtil.getIcon("reload.png");
        this.reloadAction = new AbstractAction(null, imageIcon){

            public void actionPerformed(ActionEvent actionEvent) {
                GanttWorkbenchPage.this.getChart().reloadData();
            }
        };
        this.reloadAction.putValue("ShortDescription", nLSBundle.getString("reload_button"));
        return new WDCmdButton(this.reloadAction);
    }

    protected void setActionText(Action action, String string, KeyStroke keyStroke) {
        String string2 = GanttKeyStrokes.formatCommand(AppGanttChart.NLS_BUNDLE.getString(string), keyStroke);
        action.putValue("ShortDescription", string2);
    }

    protected WDCmdButton initTestButton() {
        if (!Debug.DEBUG) {
            return null;
        }
        WDCmdButton wDCmdButton = new WDCmdButton("TEST");
        wDCmdButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        return wDCmdButton;
    }

    public void reloadAll() {
        this.reloadAction.actionPerformed(null);
    }

    public boolean stopEditInProgress(boolean bl) {
        if (!this.getChart().getTreeTable().stopCellEditing(bl)) {
            return false;
        }
        return this.resourceView.getMainTable().stopCellEditing(bl);
    }

    protected TableCellEditor getCurrentTableEditor() {
        TableCellEditor tableCellEditor = this.getChart().getTreeTable().getCellEditor();
        if (tableCellEditor == null) {
            tableCellEditor = this.resourceView.getMainTable().getCellEditor();
        }
        return tableCellEditor;
    }

    public GanttAppletBase getApplet() {
        return this.ganttView.getChart().getModel().getGlobalContext().getApplet();
    }

    public boolean isApplet() {
        return this.getApplet() != null;
    }

    public void hideFullScreen() {
        Action action = this.getComponent().getActionMap().get("fullScreen");
        if (action instanceof FullScreenAction) {
            ((FullScreenAction)action).hideFullScreen();
        }
    }

    protected class FontSizeAction
    extends AbstractAction {
        int size;

        FontSizeAction(String string, int n) {
            super(string, null);
            this.size = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GanttWorkbenchPage.this.getUserPreferences().setFontSize(this.size);
            GanttWorkbenchPage.this.getChart().updateFonts();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        STANDALONE,
        APPLET,
        EMBEDDED_APPLET;

    }

    protected class PrintActionListener
    implements ActionListener {
        private int printOption;

        PrintActionListener(int n) {
            this.printOption = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PrintableChart printableChart = new PrintableChart(GanttWorkbenchPage.this.getChart(), this.printOption);
            printableChart.print();
        }
    }
}

