/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app;

import com.triloggroup.gantt.app.ui.WDUtil;
import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;

public class GanttKeyStrokes {
    public static final KeyStroke DELETE = KeyStroke.getKeyStroke(127, 0);
    public static final KeyStroke COPY = KeyStroke.getKeyStroke(67, 128);
    public static final KeyStroke PASTE = KeyStroke.getKeyStroke(86, 128);
    public static final KeyStroke SAVE = KeyStroke.getKeyStroke(83, 128);
    public static final KeyStroke UNDO = KeyStroke.getKeyStroke(90, 128);
    public static final KeyStroke NEW_TASK;
    public static final KeyStroke ADD_RESOURCE;
    public static final KeyStroke NEW_MILESTONE;
    public static final KeyStroke NEW_WBS;
    public static final KeyStroke PRINT;
    public static final KeyStroke ZOOM_IN;
    public static final KeyStroke ZOOM_IN2;
    public static final KeyStroke ZOOM_OUT;
    public static final KeyStroke ZOOM_OUT2;
    public static final KeyStroke ZOOM_OUT3;
    public static final KeyStroke NEXT;
    public static final KeyStroke PREVIOUS;
    public static final KeyStroke COLUMNS;
    public static final KeyStroke SHOW_NODE_DETAIL;
    public static final KeyStroke SCROLL_TO_NODE;
    public static final KeyStroke EXPAND;
    public static final KeyStroke EXPAND2;
    public static final KeyStroke COLLAPSE;
    public static final KeyStroke COLLAPSE2;
    public static final KeyStroke COLLAPSE3;
    public static final KeyStroke SELECT_UP;
    public static final KeyStroke SELECT_DOWN;
    public static final KeyStroke INDENT;
    public static final KeyStroke OUTDENT;
    public static final KeyStroke FIND;
    public static final KeyStroke FIND_NEXT;
    public static final KeyStroke REPLACE;
    public static final KeyStroke OK_PRESSED;
    public static final KeyStroke OK_RELEASED;
    public static final KeyStroke CANCEL_PRESSED;
    public static final KeyStroke CANCEL_RELEASED;

    public static String formatCommand(String string, KeyStroke keyStroke) {
        int n;
        if (keyStroke == null) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append(WDUtil.swingHtmlEscape(string));
        stringBuilder.append(" <font size=-2><i>");
        int n2 = keyStroke.getModifiers();
        if (n2 > 0) {
            stringBuilder.append(KeyEvent.getKeyModifiersText(n2));
            stringBuilder.append('-');
        }
        if ((n = keyStroke.getKeyCode()) != 0) {
            stringBuilder.append(KeyEvent.getKeyText(n));
        } else {
            stringBuilder.append(keyStroke.getKeyChar());
        }
        stringBuilder.append(" </i></font></html>");
        return stringBuilder.toString();
    }

    static {
        ADD_RESOURCE = NEW_TASK = KeyStroke.getKeyStroke(155, 0);
        NEW_MILESTONE = KeyStroke.getKeyStroke(155, 512);
        NEW_WBS = KeyStroke.getKeyStroke(155, 128);
        PRINT = KeyStroke.getKeyStroke(80, 128);
        ZOOM_IN = KeyStroke.getKeyStroke(107, 128);
        ZOOM_IN2 = KeyStroke.getKeyStroke(61, 192);
        ZOOM_OUT = KeyStroke.getKeyStroke(109, 128);
        ZOOM_OUT2 = KeyStroke.getKeyStroke(45, 128);
        ZOOM_OUT3 = KeyStroke.getKeyStroke(54, 128);
        NEXT = KeyStroke.getKeyStroke(39, 512);
        PREVIOUS = KeyStroke.getKeyStroke(37, 512);
        COLUMNS = KeyStroke.getKeyStroke(114, 512);
        SHOW_NODE_DETAIL = KeyStroke.getKeyStroke(113, 64);
        SCROLL_TO_NODE = KeyStroke.getKeyStroke(116, 192);
        EXPAND = KeyStroke.getKeyStroke(107, 576);
        EXPAND2 = KeyStroke.getKeyStroke(61, 576);
        COLLAPSE = KeyStroke.getKeyStroke(109, 576);
        COLLAPSE2 = KeyStroke.getKeyStroke(45, 576);
        COLLAPSE3 = KeyStroke.getKeyStroke(54, 576);
        SELECT_UP = KeyStroke.getKeyStroke(38, 0);
        SELECT_DOWN = KeyStroke.getKeyStroke(40, 0);
        INDENT = KeyStroke.getKeyStroke(39, 576);
        OUTDENT = KeyStroke.getKeyStroke(37, 576);
        FIND = KeyStroke.getKeyStroke(70, 128);
        FIND_NEXT = KeyStroke.getKeyStroke(114, 0);
        REPLACE = KeyStroke.getKeyStroke(82, 128);
        OK_PRESSED = KeyStroke.getKeyStroke(10, 0, false);
        OK_RELEASED = KeyStroke.getKeyStroke(10, 0, true);
        CANCEL_PRESSED = KeyStroke.getKeyStroke(27, 0, false);
        CANCEL_RELEASED = KeyStroke.getKeyStroke(27, 0, true);
    }
}

