/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app;

import com.triloggroup.gantt.CriticalPathRuntimeConf;
import com.triloggroup.gantt.EmptyNode;
import com.triloggroup.gantt.GanttChart;
import com.triloggroup.gantt.GanttChartException;
import com.triloggroup.gantt.GanttChartHeader;
import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.GanttWBS;
import com.triloggroup.gantt.IDateMover;
import com.triloggroup.gantt.INodeFilter;
import com.triloggroup.gantt.ProjectContext;
import com.triloggroup.gantt.TGChart;
import com.triloggroup.gantt.TGChartModel;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.TaskPredecessor;
import com.triloggroup.gantt.TimeUnit;
import com.triloggroup.gantt.app.AppGanttChartModel;
import com.triloggroup.gantt.app.AppGlobalContext;
import com.triloggroup.gantt.app.AppProjectModel;
import com.triloggroup.gantt.app.Cursors;
import com.triloggroup.gantt.app.ExpandCollapseAction;
import com.triloggroup.gantt.app.GanttChartPanel;
import com.triloggroup.gantt.app.GanttKeyStrokes;
import com.triloggroup.gantt.app.GanttWorkbenchPage;
import com.triloggroup.gantt.app.IActionCallback;
import com.triloggroup.gantt.app.UserPreferences;
import com.triloggroup.gantt.app.change.Change;
import com.triloggroup.gantt.app.change.ChangeException;
import com.triloggroup.gantt.app.dialog.MoveDatesDialog;
import com.triloggroup.gantt.app.filter.AdvancedFilter;
import com.triloggroup.gantt.app.schedule.DatesMover;
import com.triloggroup.gantt.app.social.GanttActionsWithSocial;
import com.triloggroup.gantt.app.social.ISocialDataProvider;
import com.triloggroup.gantt.app.social.SocialManager;
import com.triloggroup.gantt.app.treetable.AppGanttTreeTable;
import com.triloggroup.gantt.app.treetable.AppGanttTreeTableModel;
import com.triloggroup.gantt.app.ui.AsyncActionRunner;
import com.triloggroup.gantt.app.ui.TwinSplits;
import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.gantt.app.ui.WDLookAndFeelConfig;
import com.triloggroup.gantt.app.xsp.XSPActions;
import com.triloggroup.gantt.event.GanttModelEvent;
import com.triloggroup.gantt.event.GanttModelSelectionEvent;
import com.triloggroup.gantt.renderer.GanttNodeRenderer;
import com.triloggroup.gantt.treetable.GanttTreeTableModel;
import com.triloggroup.gantt.treetable.TGTreeTableModel;
import com.triloggroup.project.components.st.SametimeSupport;
import com.triloggroup.project.components.ui.UIConstants;
import com.triloggroup.project.components.ui.WDSplitPane;
import com.triloggroup.project.components.ui.Workbench;
import com.triloggroup.project.schedule.IPredecessor;
import com.triloggroup.project.schedule.Predecessor;
import com.triloggroup.util.NLSBundle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.plaf.FontUIResource;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.data.gantt.Task;
import org.jfree.data.gantt.TaskSeries;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AppGanttChart
extends GanttChart
implements IDateMover {
    private static final boolean SHOW_WELCOME_PANEL = false;
    private static final int MIN_NB_EMPTY_ROWS = 10;
    private static final int PING_MINUTES_INTERVAL = 3;
    public static NLSBundle NLS_BUNDLE;
    protected JComponent mainComponent;
    protected JComponent header;
    protected GanttActionsWithSocial actions;
    protected GanttChartPanel chartPanel;
    private GanttNode[] clipboardData;
    protected UserPreferences userPreferences;
    private long lastUserActive;
    private Timer timer = new Timer();
    protected boolean dataLoadedNotConsistent = false;
    private SametimeSupport stSupport;
    private SocialManager socialManager;

    public AppGanttChart() {
        super(Workbench.get().getLocale(), Workbench.get().getFormatLocale(), Workbench.get().getTimeZone());
        isServerMode = false;
        if (SametimeSupport.ENABLED) {
            new Thread(){

                public void run() {
                    AppGanttChart.this.initSametimeSupport();
                }
            }.start();
        }
    }

    public abstract ISocialDataProvider getSocialDataProvider(ProjectContext var1);

    @Override
    protected void afterCreateTaskSeries(TaskSeries taskSeries) {
        if (this.isEditable()) {
            int n;
            int n2 = 0;
            try {
                n = Toolkit.getDefaultToolkit().getScreenSize().height;
                n2 = n / TGChart.getRowHeight() - 3 - taskSeries.getItemCount();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n2 < 10) {
                n2 = 10;
            }
            for (n = 0; n < n2; ++n) {
                taskSeries.add((Task)this.getModel().newEmptyNode());
            }
        }
    }

    @Override
    protected TaskSeries createTaskSeries() {
        this.getModel().updateLineIds();
        return super.createTaskSeries();
    }

    public synchronized void initTouchSessionThread(final int n, final URL uRL) {
        TimerTask timerTask = new TimerTask(){
            int sinceLastAdditionalURLCall = 0;

            public void run() {
                if (AppGanttChart.this.getModel() != null) {
                    try {
                        new XSPActions(AppGanttChart.this.getView(), AppGanttChart.this.getWorkbenchPage().getApplet()).pingServer();
                        boolean bl = AppGanttChart.this.getModel().touchSession();
                        System.out.println("Session touched: " + bl);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if (n > 0 && uRL != null) {
                    this.sinceLastAdditionalURLCall += 3;
                    if (this.sinceLastAdditionalURLCall >= n) {
                        try {
                            int n4;
                            Object object;
                            URLConnection uRLConnection = uRL.openConnection();
                            uRLConnection.setIfModifiedSince(0L);
                            if (uRLConnection instanceof HttpURLConnection) {
                                int n2 = ((HttpURLConnection)uRLConnection).getResponseCode();
                                object = ((HttpURLConnection)uRLConnection).getResponseMessage();
                                System.out.println("touch - " + n2);
                                if (n2 != 200) {
                                    throw new Exception("HttpURLConnection error: " + n2 + " - " + (String)object);
                                }
                            }
                            InputStream inputStream = uRLConnection.getInputStream();
                            object = new byte[128];
                            int n3 = 0;
                            while ((n4 = inputStream.read((byte[])object)) > 0) {
                                n3 += n4;
                            }
                            inputStream.close();
                            this.sinceLastAdditionalURLCall = 0;
                            System.out.println(uRL + " called - read: " + n3);
                        }
                        catch (Exception exception) {
                            System.out.println("Failed to call " + uRL);
                            exception.printStackTrace();
                        }
                    }
                }
            }
        };
        int n2 = 180000;
        this.timer.schedule(timerTask, n2, (long)n2);
    }

    public void setUserActive() {
        this.lastUserActive = System.currentTimeMillis();
    }

    public boolean isUserActive(long l) {
        return System.currentTimeMillis() - this.lastUserActive < l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initSametimeSupport() {
        try {
            this.stSupport = new SametimeSupport();
            this.stSupport.init();
            if (!this.stSupport.isEnabled()) return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public SametimeSupport getSametimeSupport() {
        return this.stSupport;
    }

    @Override
    protected NLSBundle createNLSBundle(Locale locale) {
        if (NLS_BUNDLE == null) {
            NLS_BUNDLE = Workbench.get().getNLSBundle();
        }
        return NLS_BUNDLE;
    }

    @Override
    public void setModel(TGChartModel tGChartModel) throws GanttChartException {
        CriticalPathRuntimeConf criticalPathRuntimeConf;
        AppGanttChartModel appGanttChartModel = this.getModel();
        AppGanttChartModel appGanttChartModel2 = (AppGanttChartModel)tGChartModel;
        try {
            this.dataLoadedNotConsistent = false;
            appGanttChartModel2.checkDataConsistency();
        }
        catch (Exception exception) {
            this.dataLoadedNotConsistent = true;
            exception.printStackTrace();
            appGanttChartModel2.getGlobalContext().setEditable(false);
        }
        super.setModel(tGChartModel);
        UserPreferences userPreferences = this.getUserPreferences();
        AdvancedFilter advancedFilter = userPreferences.getDefaultFilter();
        if (advancedFilter != null) {
            tGChartModel.setFilter(advancedFilter);
        }
        if ((criticalPathRuntimeConf = userPreferences.getCriticalPathConf()) != null) {
            TimeUnit timeUnit;
            AppGlobalContext appGlobalContext = appGanttChartModel2.getGlobalContext();
            appGlobalContext.setCriticalPathConf(criticalPathRuntimeConf);
            if (criticalPathRuntimeConf.getDisplayNearCritical() && (timeUnit = appGlobalContext.getTimeUnits().fromCode(criticalPathRuntimeConf.getNearCriticalSlackUnitCode())) != null) {
                double d;
                try {
                    d = appGanttChartModel2.getMainProjectModel().getDurationInHours(criticalPathRuntimeConf.getNearCriticalSlackValue(), timeUnit);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    d = 0.0;
                }
                criticalPathRuntimeConf.setNearCriticalSlackHours(d);
            }
            if (userPreferences.isPaintDeadline()) {
                this.getNodeRenderer().setPaintDeadline(true);
            }
            if (userPreferences.isPaintActualDates()) {
                this.getNodeRenderer().setPaintActualDates(true);
            }
            try {
                this.getModel().runFullBackwardSchedule();
            }
            catch (Exception exception) {
                if (exception instanceof GanttChartException) {
                    throw (GanttChartException)exception;
                }
                throw new GanttChartException(0, "Error computing critical path", exception);
            }
        }
        if (this.chartPanel == null) {
            this.initGraphic();
        }
        this.actions.updateModel(appGanttChartModel, this.getModel());
    }

    private GanttNodeRenderer getNodeRenderer() {
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        return (GanttNodeRenderer)categoryPlot.getRenderer();
    }

    @Override
    public AppGanttChartModel getModel() {
        return (AppGanttChartModel)super.getModel();
    }

    public boolean isEditable() {
        return this.getModel().isEditable();
    }

    protected GanttNode[] getClipboardData() {
        return this.clipboardData;
    }

    protected void setClipboardData(GanttNode[] ganttNodeArray) {
        GanttNode[] ganttNodeArray2 = this.clipboardData;
        this.clipboardData = ganttNodeArray;
        this.actions.clipboardDataChanged(ganttNodeArray2, ganttNodeArray);
    }

    public void chartMadeVisible() {
        if (this.dataLoadedNotConsistent) {
            WDDialog.showMsgDialog(this.getView(), NLS_BUNDLE.getString("invalidProject_error"));
            return;
        }
        this.treeTable.requestFocus();
    }

    protected void initGraphic() {
        this.chartPanel = new GanttChartPanel(this.chart);
        this.chartPanel.setGanttControler(this);
        WDSplitPane wDSplitPane = new WDSplitPane(1);
        wDSplitPane.setLeftComponent(this.getTreeTable().getTableHeader());
        wDSplitPane.setRightComponent(this.dateAxis.createSeparateAxisComponent(this));
        this.header = wDSplitPane;
        MainSplitPane mainSplitPane = new MainSplitPane();
        new TwinSplits(wDSplitPane, mainSplitPane);
        wDSplitPane.setDividerLocation(this.getTreeTable().getPreferredWidth());
        this.mainComponent = mainSplitPane;
        this.actions = new GanttActionsWithSocial(this, this.getView());
    }

    @Override
    protected void initChart() {
        super.initChart();
        this.chart.getPlot().setOutlineVisible(false);
        ((CategoryPlot)this.chart.getPlot()).getFixedRangeAxisSpace().setTop(0.0);
    }

    @Override
    protected void createTreeTable(TGTreeTableModel tGTreeTableModel) {
        if (this.treeTable == null) {
            int n = this.getUserPreferences().getWbsLevel();
            AppGanttTreeTableModel appGanttTreeTableModel = (AppGanttTreeTableModel)tGTreeTableModel;
            this.treeTable = new AppGanttTreeTable(appGanttTreeTableModel, this.formatLocale, this.timeZone);
            ((AppGanttTreeTable)this.treeTable).setGanttControler(this);
            this.treeTable.computePreferredWidth();
            appGanttTreeTableModel.setView(this.treeTable);
            this.expandNodeToLevelNoEvent(this.getModel().getRootNode(), n);
            this.updateTaskSeries();
        } else {
            System.out.println("WARNING: createGanttTreeTable called again");
            this.treeTable.setModel(tGTreeTableModel);
        }
    }

    @Override
    public void selectionChanged(GanttModelSelectionEvent ganttModelSelectionEvent) {
        this.chartPanel.forceRepaint(1);
        super.selectionChanged(ganttModelSelectionEvent);
    }

    public boolean expandCollapseNode(GanttWBS ganttWBS) {
        if (ganttWBS.isExpanded()) {
            return this.collapseNode(ganttWBS);
        }
        return this.expandNode(ganttWBS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expandNodeToLevel(TGNode tGNode, int n, boolean bl) {
        if (tGNode == null) {
            tGNode = this.model.getRootNode();
        }
        if (tGNode.isLeaf()) {
            return;
        }
        try {
            this.expandNodeToLevelNoEvent(tGNode, n, bl);
        }
        finally {
            if (n == 0) {
                this.getModel().fireNodeCollapsed(tGNode);
            } else {
                this.getModel().fireNodeExpanded(tGNode);
            }
        }
    }

    protected void expandNodeToLevelNoEvent(TGNode tGNode, int n, boolean bl) {
        if (tGNode != null) {
            if (n >= 0 && GanttNode.isHiddenSubprojectLink(tGNode)) {
                ++n;
            } else if (n != 0 && GanttNode.isSubprojectLinkNotLoaded(tGNode)) {
                this.loadSubproject((GanttWBS)tGNode, n);
                return;
            }
            if (n == 0) {
                tGNode.setExpanded(false);
            } else {
                tGNode.setExpanded(true);
                --n;
            }
            Enumeration<TGNode> enumeration = tGNode.children();
            while (enumeration.hasMoreElements()) {
                TGNode tGNode2 = enumeration.nextElement();
                if (tGNode2.isLeaf()) continue;
                this.expandNodeToLevelNoEvent(tGNode2, n, bl);
            }
        }
    }

    public AsyncActionRunner loadSubproject(GanttWBS ganttWBS) {
        return this.loadSubproject(ganttWBS, this.getUserPreferences().getWbsLevel());
    }

    public abstract AsyncActionRunner loadSubproject(GanttWBS var1, int var2);

    public abstract void showNodeDetail(GanttNode var1, Point var2, IActionCallback var3);

    public void showNodeDetail(GanttNode ganttNode, Point point) {
        this.showNodeDetail(ganttNode, point, null);
    }

    public abstract void showNewTaskDetail(GanttWBS var1, Point var2, GanttNode var3);

    public abstract void createNewTask(GanttWBS var1, GanttNode var2);

    public abstract void showNewMilestoneDetail(GanttWBS var1, Point var2, GanttNode var3);

    public abstract void createNewMilestone(GanttWBS var1, GanttNode var2);

    public abstract void showNewWBSDetail(GanttWBS var1, Point var2, GanttNode var3);

    public abstract void createNewWBS(GanttWBS var1, GanttNode var2);

    public abstract void showNewSubprojectDetail(GanttWBS var1, Point var2, GanttNode var3);

    protected void selectAndEditNodeInline(final GanttNode ganttNode) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AppGanttChart.this.setSelectedNode(ganttNode);
                int n = AppGanttChart.this.model.getRowIndex(ganttNode);
                AppGanttChart.this.getTreeTable().requestFocus();
                AppGanttChart.this.scrollToNode(ganttNode);
                int n2 = AppGanttChart.this.getTreeTable().getModel().getColumnIndex("Name");
                if (n2 < 0) {
                    n2 = 0;
                }
                n2 = AppGanttChart.this.getTreeTable().convertColumnIndexToView(n2);
                AppGanttChart.this.getTreeTable().getSelectionModel().setSelectionInterval(n, n);
                AppGanttChart.this.getTreeTable().getColumnModel().getSelectionModel().setSelectionInterval(n2, n2);
                AppGanttChart.this.getTreeTable().editCellAt(n, n2);
            }
        });
    }

    public JPopupMenu getPopupMenuForSelectedNodes(final Point point) {
        JMenuItem jMenuItem;
        JMenuItem jMenuItem2;
        Object object;
        Object object2;
        GanttNode ganttNode;
        TGNode[] tGNodeArray = this.getSelectedNodes();
        if (tGNodeArray == null || tGNodeArray.length == 0) {
            return null;
        }
        boolean bl = false;
        if (tGNodeArray.length == 1 && tGNodeArray[0] instanceof EmptyNode) {
            tGNodeArray = new TGNode[]{};
            bl = true;
        } else {
            for (int i = 0; i < tGNodeArray.length; ++i) {
                if (tGNodeArray[i] instanceof GanttNode) continue;
                return null;
            }
        }
        final GanttNode[] ganttNodeArray = new GanttNode[tGNodeArray.length];
        System.arraycopy(tGNodeArray, 0, ganttNodeArray, 0, tGNodeArray.length);
        boolean bl2 = this.getModel().areAllNodesOnEditableProject(ganttNodeArray);
        JPopupMenu jPopupMenu = new JPopupMenu();
        GanttNode ganttNode2 = ganttNode = ganttNodeArray == null || ganttNodeArray.length != 1 ? null : ganttNodeArray[0];
        final GanttWBS ganttWBS = ganttNode == null ? (bl ? (GanttWBS)this.getModel().getRootNode() : null) : (GanttWBS)ganttNode.getParent();
        boolean bl3 = true;
        for (GanttNode serializable2 : ganttNodeArray) {
            if (serializable2 instanceof GanttTask) continue;
            bl3 = false;
            break;
        }
        if (this.getModel().isEditable()) {
            GanttTask[] ganttTaskArray;
            Object object3;
            Object object4;
            JMenuItem jMenuItem3;
            JMenuItem jMenuItem4;
            if (bl) {
                jMenuItem4 = null;
                jMenuItem3 = null;
                object2 = null;
            } else {
                object2 = new JMenuItem(NLS_BUNDLE.getString("copy_node"));
                ((JMenuItem)object2).setAccelerator(GanttKeyStrokes.COPY);
                if (this.actions.isCopyEnabled()) {
                    ((AbstractButton)object2).addActionListener(this.actions.copyAction);
                } else {
                    ((JMenuItem)object2).setEnabled(false);
                }
                jMenuItem3 = new JMenuItem(NLS_BUNDLE.getString("delete_button"));
                jMenuItem3.setAccelerator(GanttKeyStrokes.DELETE);
                if (this.actions.deleteAction.isEnabled()) {
                    jMenuItem3.addActionListener(this.actions.deleteAction);
                } else {
                    jMenuItem3.setEnabled(false);
                }
                jMenuItem4 = new JMenuItem(NLS_BUNDLE.getString("paste_fields"));
                if (this.actions.pasteFieldsAction.isEnabled()) {
                    jMenuItem4.addActionListener(this.actions.pasteFieldsAction);
                } else {
                    jMenuItem4.setEnabled(false);
                }
            }
            JMenuItem jMenuItem5 = new JMenuItem();
            object = this.getClipboardData();
            if (object != null && this.getModel().canCloneNodes((GanttNode[])object, ganttWBS)) {
                jMenuItem5.addActionListener(new ActionListener((GanttNode[])object, ganttWBS, ganttNode){
                    final /* synthetic */ GanttNode[] val$toBeCloned;
                    final /* synthetic */ GanttWBS val$singleSelectionParent;
                    final /* synthetic */ GanttNode val$singleSelection;
                    {
                        this.val$toBeCloned = ganttNodeArray;
                        this.val$singleSelectionParent = ganttWBS;
                        this.val$singleSelection = ganttNode;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            AppGanttChart.this.cloneNodes(this.val$toBeCloned, this.val$singleSelectionParent, this.val$singleSelection);
                        }
                        catch (Exception exception) {
                            WDDialog.showErrorMsgDialog(AppGanttChart.this.getView(), exception);
                        }
                    }
                });
            } else {
                jMenuItem5.setEnabled(false);
            }
            jMenuItem2 = new JMenu(NLS_BUNDLE.getString("create_node"));
            if (ganttWBS == null || ganttNode != null && ganttNode.getProjectContext() != ganttWBS.getProjectContext() || !bl2) {
                jMenuItem2.setEnabled(false);
            }
            jMenuItem = new JMenuItem(NLS_BUNDLE.getString("task"));
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AppGanttChart.this.showNewTaskDetail(ganttWBS, point, ganttNode);
                }
            });
            JMenuItem jMenuItem6 = new JMenuItem(NLS_BUNDLE.getString("milestone"));
            jMenuItem6.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AppGanttChart.this.showNewMilestoneDetail(ganttWBS, point, ganttNode);
                }
            });
            JMenuItem jMenuItem7 = new JMenuItem(NLS_BUNDLE.getString("wbsEntry"));
            jMenuItem7.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AppGanttChart.this.showNewWBSDetail(ganttWBS, point, ganttNode);
                }
            });
            JMenuItem jMenuItem8 = new JMenuItem(NLS_BUNDLE.getString("subproject"));
            jMenuItem8.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AppGanttChart.this.showNewSubprojectDetail(ganttWBS, point, ganttNode);
                }
            });
            ((JMenu)jMenuItem2).add(jMenuItem);
            ((JMenu)jMenuItem2).add(jMenuItem6);
            ((JMenu)jMenuItem2).add(jMenuItem7);
            ((JMenu)jMenuItem2).add(jMenuItem8);
            JMenuItem jMenuItem9 = null;
            JMenu jMenu = null;
            JMenuItem jMenuItem10 = null;
            if (ganttNode instanceof GanttWBS) {
                object4 = (GanttWBS)ganttNode;
                jMenuItem3.setText(NLS_BUNDLE.getString(((GanttWBS)object4).isSubProject() ? "delete_subproject" : "delete_wbs"));
                jMenuItem9 = new JMenuItem();
                object3 = "paste_node";
                String string = "paste_node_sibling";
                if (object != null && ((Object)object).length == 1) {
                    ganttTaskArray = object[0];
                    if (ganttTaskArray instanceof GanttTask) {
                        string = "paste_task_sibling";
                        object3 = "paste_task";
                    } else if (ganttTaskArray instanceof GanttWBS) {
                        string = "paste_wbs_sibling";
                        object3 = "paste_wbs";
                    }
                }
                jMenuItem5.setText(NLS_BUNDLE.getString(string));
                jMenuItem9.setText(NLS_BUNDLE.getString((String)object3));
                if (object != null && this.getModel().canCloneNodes((GanttNode[])object, (GanttWBS)object4)) {
                    jMenuItem9.addActionListener(new ActionListener((GanttNode[])object, (GanttWBS)object4){
                        final /* synthetic */ GanttNode[] val$toBeCloned;
                        final /* synthetic */ GanttWBS val$wbs;
                        {
                            this.val$toBeCloned = ganttNodeArray;
                            this.val$wbs = ganttWBS;
                        }

                        public void actionPerformed(ActionEvent actionEvent) {
                            try {
                                AppGanttChart.this.cloneNodes(this.val$toBeCloned, this.val$wbs, null);
                            }
                            catch (Exception exception) {
                                WDDialog.showErrorMsgDialog(AppGanttChart.this.getView(), exception);
                            }
                        }
                    });
                } else {
                    jMenuItem9.setEnabled(false);
                }
                jMenuItem9.setAccelerator(GanttKeyStrokes.PASTE);
                if (!((GanttWBS)object4).isSubProject()) {
                    jMenu = new JMenu(NLS_BUNDLE.getString("create_node"));
                    if (bl2) {
                        ganttTaskArray = new JMenuItem(NLS_BUNDLE.getString("task"));
                        ganttTaskArray.addActionListener(new ActionListener((GanttWBS)object4, point){
                            final /* synthetic */ GanttWBS val$wbs;
                            final /* synthetic */ Point val$screenLocation;
                            {
                                this.val$wbs = ganttWBS;
                                this.val$screenLocation = point;
                            }

                            public void actionPerformed(ActionEvent actionEvent) {
                                AppGanttChart.this.showNewTaskDetail(this.val$wbs, this.val$screenLocation, null);
                            }
                        });
                        JMenuItem jMenuItem11 = new JMenuItem(NLS_BUNDLE.getString("milestone"));
                        jMenuItem11.addActionListener(new ActionListener((GanttWBS)object4, point){
                            final /* synthetic */ GanttWBS val$wbs;
                            final /* synthetic */ Point val$screenLocation;
                            {
                                this.val$wbs = ganttWBS;
                                this.val$screenLocation = point;
                            }

                            public void actionPerformed(ActionEvent actionEvent) {
                                AppGanttChart.this.showNewMilestoneDetail(this.val$wbs, this.val$screenLocation, null);
                            }
                        });
                        JMenuItem jMenuItem12 = new JMenuItem(NLS_BUNDLE.getString("wbsEntry"));
                        jMenuItem12.addActionListener(new ActionListener((GanttWBS)object4, point){
                            final /* synthetic */ GanttWBS val$wbs;
                            final /* synthetic */ Point val$screenLocation;
                            {
                                this.val$wbs = ganttWBS;
                                this.val$screenLocation = point;
                            }

                            public void actionPerformed(ActionEvent actionEvent) {
                                AppGanttChart.this.showNewWBSDetail(this.val$wbs, this.val$screenLocation, null);
                            }
                        });
                        JMenuItem jMenuItem13 = new JMenuItem(NLS_BUNDLE.getString("subproject"));
                        jMenuItem13.addActionListener(new ActionListener((GanttWBS)object4, point){
                            final /* synthetic */ GanttWBS val$wbs;
                            final /* synthetic */ Point val$screenLocation;
                            {
                                this.val$wbs = ganttWBS;
                                this.val$screenLocation = point;
                            }

                            public void actionPerformed(ActionEvent actionEvent) {
                                AppGanttChart.this.showNewSubprojectDetail(this.val$wbs, this.val$screenLocation, null);
                            }
                        });
                        jMenu.add((JMenuItem)ganttTaskArray);
                        jMenu.add(jMenuItem11);
                        jMenu.add(jMenuItem12);
                        jMenu.add(jMenuItem13);
                        ganttTaskArray.setAccelerator(GanttKeyStrokes.NEW_TASK);
                        jMenuItem11.setAccelerator(GanttKeyStrokes.NEW_MILESTONE);
                        jMenuItem12.setAccelerator(GanttKeyStrokes.NEW_WBS);
                    } else {
                        jMenu.setEnabled(false);
                    }
                }
                jMenuItem2.setText(NLS_BUNDLE.getString("create_node_sibling"));
            } else if (ganttNode instanceof GanttTask || bl) {
                if (jMenuItem3 != null) {
                    jMenuItem3.setText(NLS_BUNDLE.getString("delete_task"));
                }
                jMenuItem.setAccelerator(GanttKeyStrokes.NEW_TASK);
                jMenuItem6.setAccelerator(GanttKeyStrokes.NEW_MILESTONE);
                jMenuItem7.setAccelerator(GanttKeyStrokes.NEW_WBS);
                object4 = "paste_node";
                if (object != null && ((Object)object).length == 1) {
                    object3 = object[0];
                    if (object3 instanceof GanttTask) {
                        object4 = "paste_task";
                    } else if (object3 instanceof GanttWBS) {
                        object4 = "paste_wbs";
                    }
                }
                jMenuItem5.setText(NLS_BUNDLE.getString((String)object4));
                jMenuItem5.setAccelerator(GanttKeyStrokes.PASTE);
            }
            if (object2 != null) {
                jPopupMenu.add((JMenuItem)object2);
            }
            if (ganttNodeArray.length > 1 && bl3) {
                object4 = new JMenuItem(this.nlsBundle.getString("link_tasks"));
                object3 = new JMenuItem(this.nlsBundle.getString("unlink_tasks"));
                boolean bl4 = bl2;
                if (bl4) {
                    ganttTaskArray = ganttNodeArray[0].getProjectContext();
                    for (GanttNode ganttNode3 : ganttNodeArray) {
                        if (ganttNode3.getProjectContext() == ganttTaskArray) continue;
                        bl4 = false;
                        break;
                    }
                }
                if (bl4) {
                    ganttTaskArray = new GanttTask[ganttNodeArray.length];
                    System.arraycopy(ganttNodeArray, 0, ganttTaskArray, 0, ganttNodeArray.length);
                    ((AbstractButton)object4).addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            Arrays.sort(ganttTaskArray, TGNode.sortedIdComparator);
                            AppGanttChart.this.linkTasks(ganttTaskArray);
                        }
                    });
                    ((AbstractButton)object3).addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            AppGanttChart.this.unlinkTasks(ganttTaskArray);
                        }
                    });
                } else {
                    ((JMenuItem)object4).setEnabled(false);
                    ((JMenuItem)object3).setEnabled(false);
                }
                jPopupMenu.addSeparator();
                jPopupMenu.add((JMenuItem)object4);
                jPopupMenu.add((JMenuItem)object3);
            }
            if (!bl && bl2) {
                jMenuItem10 = new JMenuItem(NLS_BUNDLE.getString("insert_parent_WBS"));
                object4 = this.getModel().replaceSubprojectRootsByHiddenSubprojectLink(ganttNodeArray);
                if (this.getModel().areOnlyContiguousSiblingTasksOrWBSAndNotRoot((GanttNode[])object4)) {
                    jMenuItem10.addActionListener(new ActionListener((GanttNode[])object4, point){
                        final /* synthetic */ GanttNode[] val$adjustedSelection;
                        final /* synthetic */ Point val$screenLocation;
                        {
                            this.val$adjustedSelection = ganttNodeArray;
                            this.val$screenLocation = point;
                        }

                        public void actionPerformed(ActionEvent actionEvent) {
                            AppGanttChart.this.insertParentWBS(this.val$adjustedSelection, this.val$screenLocation);
                        }
                    });
                } else {
                    jMenuItem10.setEnabled(false);
                }
            }
            if (jMenuItem9 != null) {
                jPopupMenu.add(jMenuItem9);
            }
            if (jMenuItem5 != null) {
                jPopupMenu.add(jMenuItem5);
            }
            if (jMenuItem4 != null) {
                jPopupMenu.add(jMenuItem4);
            }
            jPopupMenu.addSeparator();
            if (jMenu != null) {
                jPopupMenu.add(jMenu);
            }
            if (jMenuItem2 != null) {
                jPopupMenu.add(jMenuItem2);
            }
            if (jMenuItem10 != null) {
                jPopupMenu.add(jMenuItem10);
            }
            if (jMenuItem3 != null) {
                jPopupMenu.add(jMenuItem3);
            }
        }
        if (bl) {
            return jPopupMenu;
        }
        object2 = new JMenuItem(NLS_BUNDLE.getString("show_node_detail"));
        ((JMenuItem)object2).setAccelerator(GanttKeyStrokes.SHOW_NODE_DETAIL);
        if (ganttNode != null) {
            ((AbstractButton)object2).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AppGanttChart.this.showNodeDetail(ganttNode, point);
                }
            });
        } else {
            ((JMenuItem)object2).setEnabled(false);
        }
        jPopupMenu.add((JMenuItem)object2);
        jPopupMenu.addSeparator();
        if (this.getModel().isEditable() && bl2) {
            JMenuItem jMenuItem13 = new JMenuItem(NLS_BUNDLE.getString("moveDates") + "...");
            final DatesMover datesMover = new DatesMover(this.getModel());
            if (datesMover.canMoveDates(ganttNodeArray)) {
                jMenuItem13.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = MoveDatesDialog.showDialog(AppGanttChart.this.getTreeTable(), datesMover.getLowestStartDate(ganttNodeArray));
                        if (n != 0) {
                            try {
                                datesMover.setMoveDeadline(true);
                                datesMover.moveDates(ganttNodeArray, n);
                            }
                            catch (ChangeException changeException) {
                                WDDialog.showErrorMsgDialog(AppGanttChart.this.getTreeTable(), changeException);
                            }
                        }
                    }
                });
            } else {
                jMenuItem13.setEnabled(false);
            }
            jPopupMenu.add(jMenuItem13);
            jPopupMenu.addSeparator();
            JMenuItem jMenuItem14 = new JMenuItem(this.actions.getActionByKey("indent"));
            jMenuItem14.setAccelerator(GanttKeyStrokes.INDENT);
            jPopupMenu.add(jMenuItem14);
            object = new JMenuItem(this.actions.getActionByKey("outdent"));
            ((JMenuItem)object).setAccelerator(GanttKeyStrokes.OUTDENT);
            jPopupMenu.add((JMenuItem)object);
            jPopupMenu.addSeparator();
            jMenuItem2 = new JMenuItem(this.actions.getActionByKey("moveUp"));
            jPopupMenu.add(jMenuItem2);
            jMenuItem = new JMenuItem(this.actions.getActionByKey("moveDown"));
            jPopupMenu.add(jMenuItem);
            jPopupMenu.addSeparator();
        }
        JMenuItem jMenuItem14 = new JMenuItem(new AbstractAction(this.nlsBundle.getString("center_chart_on_item"), null){

            public void actionPerformed(ActionEvent actionEvent) {
                AppGanttChart.this.centerGraphOnNode(ganttNode);
            }
        });
        if (ganttNode == null) {
            jMenuItem14.setEnabled(false);
        }
        jMenuItem14.setAccelerator(GanttKeyStrokes.SCROLL_TO_NODE);
        jPopupMenu.add(jMenuItem14);
        if (ganttNode != null && !ganttNode.isLeaf()) {
            JMenu jMenu = new JMenu(this.nlsBundle.getString("expandcollapse_button"));
            if (ganttWBS != null) {
                JMenuItem jMenuItem15 = new JMenuItem(new ExpandCollapseAction(ganttNode, 0, this));
                jMenu.add(jMenuItem15);
            }
            JMenuItem jMenuItem16 = new JMenuItem(new ExpandCollapseAction(ganttNode, -1, this));
            jMenu.add(jMenuItem16);
            for (int i = 1; i < 9; ++i) {
                jMenuItem2 = new JMenuItem(new ExpandCollapseAction(ganttNode, i, this));
                jMenu.add(jMenuItem2);
            }
            jPopupMenu.add(jMenu);
        }
        if (ganttNode != null) {
            jPopupMenu.addSeparator();
            if (this.getSocialManager().canAddComment()) {
                JMenuItem jMenuItem15 = new JMenuItem(NLS_BUNDLE.getString("addComment"), SocialManager.MESSAGE_ICON);
                jMenuItem15.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        SocialManager socialManager = AppGanttChart.this.getSocialManager();
                        if (socialManager.checkOnServer(ganttNode)) {
                            AppGanttChart.this.actions.showSocialData(ganttNode, true);
                        }
                    }
                });
                jPopupMenu.add(jMenuItem15);
            }
            if (this.getSocialManager().canAddBookmark()) {
                JMenu jMenu = this.actions.createNewBookmarkMenu(ganttNode, null);
                jPopupMenu.add(jMenu);
            }
        }
        return jPopupMenu;
    }

    protected JPopupMenu getPopupMenu(final TaskPredecessor taskPredecessor) {
        if (taskPredecessor == null || !this.getModel().isEditable()) {
            return null;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(NLS_BUNDLE.getString("delete_predecessor"));
        jMenuItem.setAccelerator(GanttKeyStrokes.DELETE);
        if (taskPredecessor.task.isDone()) {
            jMenuItem.setEnabled(false);
        } else {
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        AppGanttChart.this.deletePredecessor(taskPredecessor);
                    }
                    catch (Exception exception) {
                        WDDialog.showErrorMsgDialog(AppGanttChart.this.getView(), exception);
                    }
                }
            });
        }
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    private void unlinkTasks(GanttTask[] ganttTaskArray) {
        try {
            HashSet<String> hashSet = new HashSet<String>();
            for (GanttTask ganttTask : ganttTaskArray) {
                hashSet.add(ganttTask.getUid());
            }
            boolean bl = false;
            block3: for (GanttTask ganttTask : ganttTaskArray) {
                ArrayList<Predecessor> serializable = ganttTask.getPredecessorsList();
                if (serializable == null) continue;
                for (Predecessor predecessor : serializable) {
                    if (!hashSet.contains(predecessor.getId())) continue;
                    if (ganttTask.isDone()) {
                        WDDialog.showMsgDialog(this.getView(), this.nlsBundle.getString("operation_not_available_status_done"));
                        return;
                    }
                    bl = true;
                    continue block3;
                }
            }
            if (!bl) {
                return;
            }
            boolean bl2 = false;
            for (GanttTask ganttTask : ganttTaskArray) {
                Object object;
                ArrayList<Predecessor> arrayList = ganttTask.getPredecessorsCopy();
                boolean bl3 = false;
                if (arrayList == null) continue;
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    object = (Predecessor)iterator.next();
                    if (!hashSet.contains(((Predecessor)object).getId())) continue;
                    bl3 = true;
                    iterator.remove();
                }
                if (!bl3) continue;
                object = ganttTask.clone();
                ((GanttTask)object).setPredecessors(arrayList);
                this.getModel().checkComputeAndUpdateTaskValues(ganttTask, (GanttTask)object, this.getView(), 0, bl2);
                if (bl2) continue;
                ArrayList<Change> arrayList2 = this.getModel().getChangeManager().getAllChanges();
                Change change = arrayList2.get(arrayList2.size() - 1);
                change.setText(this.nlsBundle.getString("link_tasks"));
                bl2 = true;
            }
        }
        catch (Exception exception) {
            WDDialog.showErrorMsgDialog(this.getView(), exception);
        }
    }

    private void linkTasks(GanttTask[] ganttTaskArray) {
        boolean bl = false;
        try {
            String string;
            IPredecessor iPredecessor;
            Serializable serializable;
            int n;
            for (n = ganttTaskArray.length - 1; n > 0; --n) {
                serializable = ganttTaskArray[n];
                GanttTask ganttTask = ganttTaskArray[n - 1];
                iPredecessor = ((GanttTask)serializable).getPredecessor(ganttTask.getUid());
                if (iPredecessor != null || (string = this.getModel().getCreatePredecessorNotPossibleMsgKey((GanttTask)serializable, ganttTask)) == null) continue;
                WDDialog.showMsgDialog(this.getView(), this.nlsBundle.getString(string));
                return;
            }
            if (ganttTaskArray.length > 2) {
                HashSet<GanttTask> hashSet = new HashSet<GanttTask>();
                for (int i = 2; i < ganttTaskArray.length; ++i) {
                    hashSet.add(ganttTaskArray[i]);
                }
                try {
                    serializable = new HashSet();
                    for (int i = 0; i < ganttTaskArray.length - 2; ++i) {
                        this.checkNoPredecessorPath(ganttTaskArray[i], hashSet, (HashSet<GanttTask>)serializable);
                        ((HashSet)serializable).clear();
                        hashSet.remove(ganttTaskArray[i + 2]);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    WDDialog.showMsgDialog(this.getView(), this.nlsBundle.getString("predecessor_invalid_already_successor"));
                    return;
                }
            }
            for (n = ganttTaskArray.length - 1; n > 0; --n) {
                serializable = ganttTaskArray[n];
                GanttTask ganttTask = ganttTaskArray[n - 1];
                iPredecessor = ((GanttTask)serializable).getPredecessor(ganttTask.getUid());
                if (iPredecessor != null) continue;
                string = this.getModel().getCreatePredecessorNotPossibleMsgKey((GanttTask)serializable, ganttTask);
                if (string != null) {
                    if (bl) {
                        this.getModel().getChangeManager().undo();
                    }
                    WDDialog.showMsgDialog(this.getView(), this.nlsBundle.getString(string));
                    return;
                }
                GanttTask ganttTask2 = ((GanttTask)serializable).clone();
                ganttTask2.addPredecessor(ganttTask.getUid(), 1);
                this.getModel().checkComputeAndUpdateTaskValues((GanttTask)serializable, ganttTask2, this.getView(), 0, bl);
                if (bl) continue;
                ArrayList<Change> arrayList = this.getModel().getChangeManager().getAllChanges();
                Change change = arrayList.get(arrayList.size() - 1);
                change.setText(this.nlsBundle.getString("link_tasks"));
                bl = true;
            }
        }
        catch (Exception exception) {
            WDDialog.showErrorMsgDialog(this.getView(), exception);
        }
    }

    private void checkNoPredecessorPath(GanttTask ganttTask, HashSet<GanttTask> hashSet, HashSet<GanttTask> hashSet2) {
        if (hashSet2.contains(ganttTask)) {
            return;
        }
        hashSet2.add(ganttTask);
        if (hashSet.contains(ganttTask)) {
            throw new IllegalStateException("Prodecessors path exist to task " + ganttTask.getHierarchicalId() + ": " + ganttTask);
        }
        ArrayList<Predecessor> arrayList = ganttTask.getPredecessorsList();
        AppProjectModel appProjectModel = this.getModel().getProjectModel(ganttTask.getProjectContext().getProjectId());
        if (arrayList != null) {
            for (Predecessor predecessor : arrayList) {
                GanttTask ganttTask2 = (GanttTask)appProjectModel.getNodeByUid(predecessor.getId());
                this.checkNoPredecessorPath(ganttTask2, hashSet, hashSet2);
            }
        }
    }

    public JComponent getHeader() {
        return this.header;
    }

    public GanttChartHeader getChartHeader() {
        return this.dateAxis.getHeader();
    }

    public JComponent getView() {
        return this.mainComponent;
    }

    @Override
    public void applyFilter(INodeFilter iNodeFilter) {
        super.applyFilter(iNodeFilter);
        this.ensureVisibleNode();
    }

    public void ensureVisibleNode() {
        for (Container container = this.getView().getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof JViewport)) continue;
            Point point = ((JViewport)container).getViewPosition();
            TGNode tGNode = this.getNodeFromY(point.y);
            if (tGNode instanceof EmptyNode) {
                ((JViewport)container).setViewPosition(new Point(point.x, 0));
            }
            return;
        }
    }

    public void applyDatesChangeCommand(String string) {
        try {
            this.doDatesChangeCommand(string, 0.0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.chartPanel.forceRepaint(8);
    }

    @Override
    public void moveDates(long l) {
        long l2 = this.displayStartDate.getTime() + l;
        long l3 = this.displayEndDate.getTime() + l;
        this.setGraphDates(l2, l3);
        this.chartPanel.forceRepaint(8);
    }

    @Override
    public Cursor getMoveDatesCursor() {
        return Cursors.moveChartTimeCursor;
    }

    protected void centerGraphOnDate(long l) {
        long l2 = this.displayStartDate.getTime();
        long l3 = this.displayEndDate.getTime();
        long l4 = l - (l2 + l3) / 2L;
        this.setGraphDates(l2 + l4, l3 + l4);
        this.chartPanel.forceRepaint(8);
    }

    public void centerGraphOnNode(TGNode tGNode) {
        long l = (tGNode.getDuration().getStart().getTime() + tGNode.getDuration().getEnd().getTime()) / 2L;
        this.centerGraphOnDate(l);
    }

    public void scrollToNode(TGNode tGNode) {
        int n = AppGanttChart.getRowHeight();
        int n2 = this.getIndexOfNodeInTaskSeries(tGNode) * n;
        Rectangle rectangle = new Rectangle(0, n2, 1, n);
        for (Container container = this.getView().getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof JViewport)) continue;
            rectangle = SwingUtilities.convertRectangle(this.chartPanel, rectangle, container);
            ((JViewport)container).scrollRectToVisible(rectangle);
            return;
        }
    }

    public void selectPreviousVisibleNode(TGNode tGNode) {
        int n = this.getIndexOfNodeInTaskSeries(tGNode);
        if (n > 0) {
            TGNode tGNode2 = (TGNode)this.getTaskSeries().get(n - 1);
            this.setSelectedNode(tGNode2);
        }
    }

    public void selectNextVisibleNode(TGNode tGNode) {
        int n = this.getIndexOfNodeInTaskSeries(tGNode);
        if (n < this.getTaskSeries().getItemCount() - 1) {
            TGNode tGNode2 = (TGNode)this.getTaskSeries().get(n + 1);
            this.setSelectedNode(tGNode2);
        }
    }

    protected int getIndexOfNodeInTaskSeries(TGNode tGNode) {
        TaskSeries taskSeries = this.getTaskSeries();
        int n = taskSeries.getItemCount();
        for (int i = 0; i < n; ++i) {
            if (tGNode != taskSeries.get(i)) continue;
            return i;
        }
        return -1;
    }

    public void moveTaskStartDate(GanttTask ganttTask, long l, boolean bl) throws ChangeException {
        new DatesMover(this.getModel()).moveTaskStartDate(ganttTask, l, bl, this.getView());
    }

    public void moveTaskEndDate(GanttTask ganttTask, long l, boolean bl) throws ChangeException {
        new DatesMover(this.getModel()).moveTaskEndDate(ganttTask, l, bl, this.getView());
    }

    public void moveTaskStartEndDates(GanttTask ganttTask, long l, boolean bl) throws ChangeException {
        new DatesMover(this.getModel()).moveTaskStartEndDates(ganttTask, l, bl, this.getView());
    }

    public void cloneNodes(GanttNode[] ganttNodeArray, GanttWBS ganttWBS, GanttNode ganttNode) throws ChangeException {
        GanttNode[] ganttNodeArray2 = this.getClipboardData();
        this.getModel().cloneNodes(ganttNodeArray, ganttWBS, ganttNode);
        this.setClipboardData(ganttNodeArray2);
    }

    public void deletePredecessor(TaskPredecessor taskPredecessor) throws ChangeException {
        this.getModel().removePredecessor(taskPredecessor, this.getView());
        if (taskPredecessor == this.getSelectedPredecessor()) {
            this.setSelectedPredecessor(null);
        }
    }

    public void addPredecessor(GanttTask ganttTask, GanttTask ganttTask2, int n) throws ChangeException {
        this.getModel().addPredecessor(ganttTask, ganttTask2, n, this.getView());
    }

    protected void insertParentWBS(GanttNode[] ganttNodeArray, Point point) {
        try {
            if (ganttNodeArray[0].isProjectRoot()) {
                throw new IllegalStateException("Can not insert a parent to the root");
            }
            GanttWBS ganttWBS = (GanttWBS)ganttNodeArray[0].getParent();
            String string = this.getModel().newWBSUid();
            String string2 = ganttNodeArray[0].getParentHierarchicalId();
            int n = this.getModel().getNextTaskSubId(ganttWBS);
            String string3 = string2 + '.' + n;
            Date date = (Date)this.getOldestStartDate(ganttNodeArray).clone();
            Date date2 = (Date)this.getFurthestEndDate(ganttNodeArray).clone();
            String string4 = ganttNodeArray.length == 1 ? ganttNodeArray[0].getName() : NLS_BUNDLE.getString("newWBSName");
            GanttWBS ganttWBS2 = new GanttWBS(null, string3, string4, string, date, date2);
            ganttWBS2.setNodeDescription(ganttNodeArray[0].getNodeDescription());
            ganttWBS2.setNodeContext(ganttNodeArray[0].getNodeContext());
            ganttWBS2.setParent(ganttWBS);
            this.getModel().checkComputeAndUpdateWBSValues(null, ganttWBS2, this.getView());
            int n2 = ganttNodeArray[0].getSubId();
            this.getModel().reorderNodeToPosition(ganttWBS2, n2, true);
            for (GanttNode ganttNode : ganttNodeArray) {
                if (ganttNode instanceof GanttTask) {
                    this.getModel().changeParentTask((GanttTask)ganttNode, ganttWBS2, this.getView(), true);
                    continue;
                }
                if (ganttNode.isProjectRoot()) {
                    throw new IllegalStateException("Can not insert a parent to the root");
                }
                this.getModel().changeParentWBS((GanttWBS)ganttNode, ganttWBS2, this.getView());
                Change change = this.getModel().getChangeManager().getLastChange();
                change.setLinkedToPreviousChange(true);
            }
            IActionCallback iActionCallback = new IActionCallback(){

                public void actionCancelled() {
                    try {
                        AppGanttChart.this.getModel().getChangeManager().undo();
                    }
                    catch (Exception exception) {
                        WDDialog.showErrorMsgDialog(AppGanttChart.this.getView(), exception);
                    }
                }

                public void actionDone() {
                    AppGanttChart.this.getModel().getChangeManager().getLastChange().setLinkedToPreviousChange(true);
                }
            };
            this.showNodeDetail(ganttWBS2, point, iActionCallback);
        }
        catch (Exception exception) {
            WDDialog.showErrorMsgDialog(this.getView(), exception);
        }
    }

    protected Date getOldestStartDate(GanttNode[] ganttNodeArray) {
        if (ganttNodeArray != null && ganttNodeArray.length > 0) {
            Date date = ganttNodeArray[0].getStartDate();
            for (GanttNode ganttNode : ganttNodeArray) {
                if (!ganttNode.getStartDate().before(date)) continue;
                date = ganttNode.getStartDate();
            }
            return date;
        }
        return null;
    }

    protected Date getFurthestEndDate(GanttNode[] ganttNodeArray) {
        if (ganttNodeArray != null && ganttNodeArray.length > 0) {
            Date date = ganttNodeArray[0].getFinishDate();
            for (GanttNode ganttNode : ganttNodeArray) {
                if (!ganttNode.getFinishDate().after(date)) continue;
                date = ganttNode.getFinishDate();
            }
            return date;
        }
        return null;
    }

    public void setTaskCompletion(GanttTask ganttTask, double d, Component component) throws ChangeException {
        this.getModel().setTaskCompletion(ganttTask, d, component);
    }

    public abstract AsyncActionRunner saveChanges();

    public abstract AsyncActionRunner reloadData();

    public boolean stopCellEditing(boolean bl) {
        return this.getWorkbenchPage().stopEditInProgress(bl);
    }

    protected abstract void loadUserPreferences();

    public UserPreferences getUserPreferences() {
        if (this.userPreferences == null) {
            this.loadUserPreferences();
        }
        return this.userPreferences;
    }

    @Override
    public void nodesChanged(GanttModelEvent ganttModelEvent) {
        super.nodesChanged(ganttModelEvent);
        this.chartPanel.forceRepaint(16);
        this.treeTable.repaint();
    }

    @Override
    public void structureChanged(GanttModelEvent ganttModelEvent) {
        boolean bl;
        Collection<Object> collection;
        Object object;
        super.structureChanged(ganttModelEvent);
        this.updateSize();
        Object[] objectArray = this.getSelectedNodes();
        if (objectArray != null) {
            object = this.getTaskSeries().getTasks();
            collection = new ArrayList();
            bl = false;
            for (int i = 0; i < objectArray.length; ++i) {
                if (object.contains(objectArray[i])) {
                    ((ArrayList)collection).add(objectArray[i]);
                    continue;
                }
                bl = true;
            }
            if (bl) {
                this.setSelectedNodes(((ArrayList)collection).toArray(new TGNode[0]));
            } else {
                GanttModelSelectionEvent ganttModelSelectionEvent = new GanttModelSelectionEvent(this.getModel(), 1, objectArray, 1, objectArray);
                this.selectionChanged(ganttModelSelectionEvent);
            }
        }
        if ((object = this.getClipboardData()) != null && ((GanttNode[])object).length > 0) {
            collection = this.getModel().getProjectModel(object[0].getProjectContext().getProjectId()).getAllNodes();
            bl = false;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 0; i < ((Object)object).length; ++i) {
                if (!collection.contains(object[i])) {
                    arrayList.add(object[i]);
                    continue;
                }
                bl = true;
            }
            if (bl) {
                this.setClipboardData(arrayList.toArray(new GanttNode[0]));
            }
        }
    }

    @Override
    public void nodeCollapsed(GanttModelEvent ganttModelEvent) {
        super.nodeCollapsed(ganttModelEvent);
        this.updateSize();
    }

    @Override
    public void nodeExpanded(GanttModelEvent ganttModelEvent) {
        super.nodeExpanded(ganttModelEvent);
        this.updateSize();
    }

    private void updateSize() {
        if (this.mainComponent != null && this.mainComponent.getParent() != null) {
            this.mainComponent.getParent().doLayout();
            this.chartPanel.forceRepaint(4);
            this.treeTable.repaint();
        }
    }

    public void printChart(Graphics2D graphics2D, int n) {
        int n2 = this.getCurrentPreferredHeight();
        GanttChartHeader ganttChartHeader = this.dateAxis.getHeader();
        if (ganttChartHeader != null) {
            Shape shape = graphics2D.getClip();
            if (shape.getBounds().y < ganttChartHeader.getHeight()) {
                graphics2D.clipRect(0, 0, n, ganttChartHeader.getHeight());
                ganttChartHeader.print(graphics2D);
                graphics2D.setClip(shape);
            }
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, ganttChartHeader.getHeight(), n, n2);
            this.getChart().draw(graphics2D, (Rectangle2D)double_);
            n2 += ganttChartHeader.getHeight();
        } else {
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, n, n2);
            this.getChart().draw(graphics2D, (Rectangle2D)double_);
        }
        graphics2D.setColor(Color.GRAY);
        graphics2D.setStroke(new BasicStroke());
        graphics2D.draw(new Rectangle(0, 0, n, n2 - 1));
    }

    public void updateFonts() {
        int n = this.getUserPreferences().getFontSize();
        Font font = new Font("sansserif", 0, n);
        Font font2 = new Font("sansserif", 1, n);
        UIConstants.DEFAULT_FONT = font;
        UIConstants.BOLD_FONT = font2;
        FontUIResource fontUIResource = new FontUIResource(font);
        FontUIResource fontUIResource2 = new FontUIResource(font2);
        WDLookAndFeelConfig.setFontUI(fontUIResource, fontUIResource2);
        JComponent jComponent = this.getView();
        if (jComponent != null) {
            this.chartPanel.forceRepaint(1);
            Component component = SwingUtilities.getRoot(jComponent);
            if (component != null) {
                SwingUtilities.updateComponentTreeUI(component);
            }
        }
    }

    public void unload() {
        if (this.treeTable != null) {
            GanttTreeTableModel ganttTreeTableModel = (GanttTreeTableModel)this.treeTable.getModel();
            String[] stringArray = new String[ganttTreeTableModel.getColumnCount()];
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                int n = this.treeTable.convertColumnIndexToModel(i);
                if (n != i) {
                    bl = true;
                }
                stringArray[i] = ganttTreeTableModel.getColumnKeyName(n);
            }
            if (bl) {
                this.getUserPreferences().setTableColumns(stringArray);
            }
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocialManager getSocialManager() {
        if (this.socialManager == null) {
            AppGanttChart appGanttChart = this;
            synchronized (appGanttChart) {
                if (this.socialManager == null) {
                    this.socialManager = new SocialManager(this);
                }
            }
        }
        return this.socialManager;
    }

    public GanttActionsWithSocial getActions() {
        return this.actions;
    }

    public GanttWorkbenchPage getWorkbenchPage() {
        return (GanttWorkbenchPage)this.treeTable.getView().getWorkbenchPage();
    }

    private class MainSplitPane
    extends WDSplitPane
    implements Scrollable {
        public MainSplitPane() {
            super(1);
            this.setOneTouchExpandable(true);
            this.setLeftComponent(AppGanttChart.this.getTreeTable());
            this.setRightComponent(AppGanttChart.this.chartPanel);
        }

        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        public boolean getScrollableTracksViewportHeight() {
            return this.getParent().getHeight() > AppGanttChart.this.getCurrentPreferredHeight();
        }

        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            return AppGanttChart.this.chartPanel.getScrollableUnitIncrement(rectangle, n, n2);
        }

        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            return AppGanttChart.this.chartPanel.getScrollableBlockIncrement(rectangle, n, n2);
        }
    }
}

