/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.allocation;

import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.Resource;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.TaskResource;
import com.triloggroup.gantt.allocation.IAllocationGlobalContext;
import com.triloggroup.gantt.allocation.ResourceAllocationsNode;
import com.triloggroup.gantt.util.ValueInterval;
import com.triloggroup.gantt.util.ValueIntervals;
import com.triloggroup.ui.UGraphic;
import java.awt.Color;
import java.util.Date;
import java.util.List;
import org.jfree.data.gantt.Task;
import org.jfree.data.time.TimePeriod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AllocationsNode
extends TGNode {
    private static final Color EVEN_BACKGROUND_COLOR = new Color(250, 250, 220);
    private static final Color EVEN_TRANS_BACKGROUND_COLOR = UGraphic.getColorWithAlphaForWhiteBackground(EVEN_BACKGROUND_COLOR, 128);
    private static final Color ODD_BACKGROUND_COLOR = new Color(245, 235, 225);
    private static final Color ODD_TRANS_BACKGROUND_COLOR = UGraphic.getColorWithAlphaForWhiteBackground(ODD_BACKGROUND_COLOR, 128);
    protected ValueIntervals intervals;
    protected boolean intervalsUpToDate = false;

    public AllocationsNode(String string, String string2, String string3, String string4, Date date, Date date2) {
        super(string, string2, string3, string4, date, date2);
    }

    public Color getTranslucentBackgroundColor() {
        if (this.parentNode == null) {
            return null;
        }
        if (!this.getGlobalContext().isGanttResource() && this.parentNode != null && this.parentNode instanceof AllocationsNode) {
            return ((AllocationsNode)this.parentNode).getTranslucentBackgroundColor();
        }
        int n = this.parentNode.getIndex(this);
        if (n % 2 == 0) {
            return EVEN_TRANS_BACKGROUND_COLOR;
        }
        return ODD_TRANS_BACKGROUND_COLOR;
    }

    public Color getBackgroundColor() {
        if (this.parentNode == null) {
            return null;
        }
        if (!this.getGlobalContext().isGanttResource() && this.parentNode != null && this.parentNode instanceof AllocationsNode) {
            return ((AllocationsNode)this.parentNode).getBackgroundColor();
        }
        int n = this.parentNode.getIndex(this);
        if (n % 2 == 0) {
            return EVEN_BACKGROUND_COLOR;
        }
        return ODD_BACKGROUND_COLOR;
    }

    public ValueIntervals getIntervals() {
        if (!this.intervalsUpToDate) {
            this.computeIntervals();
        }
        return this.intervals;
    }

    public void computeIntervals() {
        if (!this.getGlobalContext().isGanttResource()) {
            int n = this.getAllSubTaskCount();
            this.intervals = new ValueIntervals();
            for (int i = 0; i < n; ++i) {
                List<ValueInterval> list = this.getChildIntervalsAt(i);
                if (list == null) continue;
                for (int j = 0; j < list.size(); ++j) {
                    this.intervals.addInterval(list.get(j));
                }
            }
            this.intervalsUpToDate = true;
        }
    }

    protected abstract List<ValueInterval> getChildIntervalsAt(int var1);

    protected ValueInterval getValueIntervalForResource(GanttTask ganttTask, Resource resource) {
        TaskResource[] taskResourceArray = ganttTask.getResources();
        if (taskResourceArray != null) {
            for (int i = 0; i < taskResourceArray.length; ++i) {
                if (!taskResourceArray[i].getResource().equals(resource)) continue;
                int n = taskResourceArray[i].getUnit();
                TimePeriod timePeriod = ganttTask.getDuration();
                if (timePeriod != null) {
                    long l = timePeriod.getStart().getTime();
                    long l2 = timePeriod.getEnd().getTime();
                    if (l2 > l) {
                        return new ValueInterval(l, l2, n);
                    }
                }
                return null;
            }
        }
        return null;
    }

    public Resource getParentResource() {
        for (TGNode tGNode = this; tGNode != null; tGNode = tGNode.getParent()) {
            if (!(tGNode instanceof ResourceAllocationsNode)) continue;
            return ((ResourceAllocationsNode)tGNode).getResource();
        }
        return null;
    }

    @Override
    public IAllocationGlobalContext getGlobalContext() {
        return (IAllocationGlobalContext)super.getGlobalContext();
    }

    @Override
    public void addSubtask(Task task) {
        this.intervalsUpToDate = false;
        super.addSubtask(task);
    }

    @Override
    public void removeSubtask(Task task) {
        this.intervalsUpToDate = false;
        super.removeSubtask(task);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }
}

