/*
 * Decompiled with CFR 0.152.
 */
package com.flowbuilder.util;

import com.flowbuilder.util.TString;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class TStringBuffer {
    private char[] value;
    private int count;
    private static final int DELTA = 128;
    private int indentLevel;
    private String prtIndent;

    public TStringBuffer() {
        this(128);
    }

    public TStringBuffer(int n) {
        this.value = new char[n];
        this.count = 0;
    }

    public TStringBuffer(char[] cArray, int n) {
        if (cArray == null) {
            throw new IllegalArgumentException("Can't pass null value");
        }
        this.value = cArray;
        this.count = n < 0 ? 0 : n;
    }

    public TStringBuffer(String string) {
        this(string.length() + 128);
        this.append(string);
    }

    public final int length() {
        return this.count;
    }

    public final int capacity() {
        return this.value.length;
    }

    private final void expandCapacity(int n) {
        int n2 = Math.max((this.value.length + 1) * 2, n);
        if (n2 - this.value.length < 128) {
            n2 = this.value.length + 128;
        }
        char[] cArray = new char[n2];
        System.arraycopy(this.value, 0, cArray, 0, this.count);
        this.value = cArray;
    }

    public final char charAt(int n) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return this.value[n];
    }

    public final void getChars(int n, int n2, char[] cArray, int n3) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 < 0 || n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n < n2) {
            System.arraycopy(this.value, n, cArray, n3, n2 - n);
        }
    }

    public final void setCharAt(int n, char c) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        this.value[n] = c;
    }

    public final TStringBuffer append(Object object) {
        return this.append(String.valueOf(object));
    }

    public final TStringBuffer append(String string) {
        int n;
        int n2;
        if (string == null) {
            string = String.valueOf(string);
        }
        if ((n2 = this.count + (n = string.length())) > this.value.length) {
            this.expandCapacity(n2);
        }
        string.getChars(0, n, this.value, this.count);
        this.count = n2;
        return this;
    }

    public final TStringBuffer append(char[] cArray) {
        int n = cArray.length;
        int n2 = this.count + n;
        if (n2 > this.value.length) {
            this.expandCapacity(n2);
        }
        System.arraycopy(cArray, 0, this.value, this.count, n);
        this.count = n2;
        return this;
    }

    public final TStringBuffer append(char[] cArray, int n, int n2) {
        int n3 = this.count + n2;
        if (n3 > this.value.length) {
            this.expandCapacity(n3);
        }
        System.arraycopy(cArray, n, this.value, this.count, n2);
        this.count = n3;
        return this;
    }

    public final TStringBuffer append(boolean bl) {
        return this.append(String.valueOf(bl));
    }

    public final TStringBuffer append(char c) {
        int n = this.count + 1;
        if (n > this.value.length) {
            this.expandCapacity(n);
        }
        this.value[this.count++] = c;
        return this;
    }

    public final TStringBuffer append(int n) {
        return this.append(String.valueOf(n));
    }

    public final TStringBuffer append(long l) {
        return this.append(String.valueOf(l));
    }

    public final TStringBuffer append(float f) {
        return this.append(String.valueOf(f));
    }

    public final TStringBuffer append(double d) {
        return this.append(String.valueOf(d));
    }

    public final TStringBuffer insert(int n, Object object) {
        return this.insert(n, String.valueOf(object));
    }

    public final TStringBuffer insert(int n, String string) {
        if (n < 0 || n > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        int n2 = string.length();
        int n3 = this.count + n2;
        if (n3 > this.value.length) {
            this.expandCapacity(n3);
        }
        System.arraycopy(this.value, n, this.value, n + n2, this.count - n);
        string.getChars(0, n2, this.value, n);
        this.count = n3;
        return this;
    }

    public final TStringBuffer insert(int n, char[] cArray) {
        if (n < 0 || n > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        int n2 = cArray.length;
        int n3 = this.count + n2;
        if (n3 > this.value.length) {
            this.expandCapacity(n3);
        }
        System.arraycopy(this.value, n, this.value, n + n2, this.count - n);
        System.arraycopy(cArray, 0, this.value, n, n2);
        this.count = n3;
        return this;
    }

    public final TStringBuffer insert(int n, boolean bl) {
        return this.insert(n, String.valueOf(bl));
    }

    public final TStringBuffer insert(int n, char c) {
        int n2 = this.count + 1;
        if (n2 > this.value.length) {
            this.expandCapacity(n2);
        }
        System.arraycopy(this.value, n, this.value, n + 1, this.count - n);
        this.value[n] = c;
        this.count = n2;
        return this;
    }

    public final TStringBuffer insert(int n, int n2) {
        return this.insert(n, String.valueOf(n2));
    }

    public final TStringBuffer insert(int n, long l) {
        return this.insert(n, String.valueOf(l));
    }

    public final TStringBuffer insert(int n, float f) {
        return this.insert(n, String.valueOf(f));
    }

    public final TStringBuffer insert(int n, double d) {
        return this.insert(n, String.valueOf(d));
    }

    public final TStringBuffer reverse() {
        int n = this.count - 1;
        for (int i = n - 1 >> 1; i >= 0; --i) {
            char c = this.value[i];
            this.value[i] = this.value[n - i];
            this.value[n - i] = c;
        }
        return this;
    }

    public String toString() {
        return new String(this.value, 0, this.count);
    }

    public TStringBuffer(String string, int n, int n2) {
        this(128 + n2 - n);
        this.append(string, n, n2);
    }

    public final void clear() {
        this.count = 0;
    }

    public boolean equals(String string) {
        if (string != null && string.length() == this.count) {
            for (int i = 0; i < this.count; ++i) {
                if (this.value[i] == string.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final boolean startsWith(char c) {
        return this.count > 0 && this.value[0] == c;
    }

    public final void repeat(String string, int n) {
        for (int i = 0; i < n; ++i) {
            this.append(string);
        }
    }

    public final void repeat(char c, int n) {
        for (int i = 0; i < n; ++i) {
            this.append(c);
        }
    }

    public final TStringBuffer append(TStringBuffer tStringBuffer, int n, int n2) {
        if (tStringBuffer == null) {
            return this;
        }
        if (n >= n2) {
            return this;
        }
        int n3 = this.count + n2 - n;
        if (n3 > this.value.length) {
            this.expandCapacity(n3);
        }
        tStringBuffer.getChars(n, n2, this.value, this.count);
        this.count = n3;
        return this;
    }

    public final TStringBuffer append(TStringBuffer tStringBuffer) {
        if (tStringBuffer != null) {
            this.append(tStringBuffer, 0, tStringBuffer.length());
        }
        return this;
    }

    public final TStringBuffer append(String string, int n, int n2) {
        int n3;
        if (string == null) {
            string = String.valueOf(string);
        }
        if ((n3 = this.count + n2 - n) > this.value.length) {
            this.expandCapacity(n3);
        }
        string.getChars(n, n2, this.value, this.count);
        this.count = n3;
        return this;
    }

    public final TStringBuffer load(Reader reader) {
        this.clear();
        return this.append(reader);
    }

    public final TStringBuffer append(Reader reader) {
        char[] cArray = new char[8192];
        int n = 0;
        try {
            while ((n = reader.read(cArray)) > 0) {
                this.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return this;
    }

    public final void save(Writer writer) {
        try {
            writer.write(this.value, 0, this.count);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public final TStringBuffer appendFormat(String string, Object object, Object object2, Object object3, Object object4, Object object5) {
        if (string != null) {
            int n = 0;
            int n2 = string.length();
            while (true) {
                int n3;
                int n4;
                if ((n4 = string.indexOf(37, n)) < 0) {
                    n4 = n2;
                }
                if (n4 > n) {
                    n3 = this.count + n4 - n;
                    if (n3 > this.value.length) {
                        this.expandCapacity(n3);
                    }
                    string.getChars(n, n4, this.value, this.count);
                    this.count = n3;
                    n = n4;
                }
                if (n >= n2) break;
                if (++n >= string.length()) continue;
                n3 = string.charAt(n++);
                switch (n3) {
                    case 49: {
                        if (object == null) break;
                        this.append(TString.toString(object));
                        break;
                    }
                    case 50: {
                        if (object2 == null) break;
                        this.append(TString.toString(object2));
                        break;
                    }
                    case 51: {
                        if (object3 == null) break;
                        this.append(TString.toString(object3));
                        break;
                    }
                    case 52: {
                        if (object4 == null) break;
                        this.append(TString.toString(object4));
                        break;
                    }
                    case 53: {
                        if (object5 == null) break;
                        this.append(TString.toString(object5));
                        break;
                    }
                    case 37: {
                        this.append('%');
                    }
                }
            }
        }
        return this;
    }

    public final TStringBuffer appendFormat(String string, Object object, Object object2, Object object3, Object object4) {
        return this.appendFormat(string, object, object2, object3, object4, null);
    }

    public final TStringBuffer appendFormat(String string, Object object, Object object2, Object object3) {
        return this.appendFormat(string, object, object2, object3, null, null);
    }

    public final TStringBuffer appendFormat(String string, Object object, Object object2) {
        return this.appendFormat(string, object, object2, null, null, null);
    }

    public final TStringBuffer appendFormat(String string, Object object) {
        return this.appendFormat(string, object, null, null, null, null);
    }

    public final TStringBuffer appendFormat(String string) {
        return this.appendFormat(string, null, null, null, null, null);
    }

    public final TStringBuffer prt(String string, Object object, Object object2, Object object3, Object object4, Object object5) {
        if (this.prtIndent != null) {
            this.append(this.prtIndent);
        }
        this.appendFormat(string, object, object2, object3, object4, object5);
        this.append('\n');
        return this;
    }

    public final TStringBuffer prt(String string, Object object, Object object2, Object object3, Object object4) {
        return this.prt(string, object, object2, object3, object4, null);
    }

    public final TStringBuffer prt(String string, Object object, Object object2, Object object3) {
        return this.prt(string, object, object2, object3, null, null);
    }

    public final TStringBuffer prt(String string, Object object, Object object2) {
        return this.prt(string, object, object2, null, null, null);
    }

    public final TStringBuffer prt(String string, Object object) {
        return this.prt(string, object, null, null, null, null);
    }

    public final TStringBuffer prt(String string) {
        return this.prt(string, null, null, null, null, null);
    }

    public final TStringBuffer prtNoFormatting(String string) {
        if (this.prtIndent != null) {
            this.append(this.prtIndent);
        }
        this.append(string);
        this.append('\n');
        return this;
    }

    public void incIndent() {
        ++this.indentLevel;
        this.setPrtIndent(TStringBuffer.getIndentString(this.indentLevel));
    }

    public void decIndent() {
        --this.indentLevel;
        this.setPrtIndent(TStringBuffer.getIndentString(this.indentLevel));
    }

    public int getIndentLevel() {
        return this.indentLevel;
    }

    public static String getIndentString(int n) {
        switch (n) {
            case 0: {
                return "";
            }
            case 1: {
                return "  ";
            }
            case 2: {
                return "    ";
            }
            case 3: {
                return "      ";
            }
            case 4: {
                return "        ";
            }
        }
        return TString.repeat("  ", n);
    }

    public TStringBuffer prtIndent() {
        if (this.prtIndent != null) {
            this.append(this.prtIndent);
        }
        return this;
    }

    public String getPrtIndent() {
        return this.prtIndent;
    }

    public void setPrtIndent(String string) {
        this.prtIndent = string;
    }

    public final char[] toCharArray() {
        char[] cArray = new char[this.count];
        System.arraycopy(this.value, 0, cArray, 0, this.count);
        return cArray;
    }

    public final String substring(int n, int n2) {
        return new String(this.value, n, n2 - n);
    }

    public final TStringBuffer addFieldDef(String string, String string2, String string3) {
        if (this.length() != 0) {
            this.append(string3);
        }
        if (string != null) {
            this.append(string);
            this.append("=");
        }
        this.append(string2);
        return this;
    }

    public final TStringBuffer addFieldDef(String string, String string2) {
        return this.addFieldDef(string, string2, ";");
    }

    public final TStringBuffer addSymbolic(boolean bl, String string, String string2) {
        if (bl) {
            this.addFieldDef(null, string, string2);
        }
        return this;
    }

    public final TStringBuffer addSymbolic(boolean bl, String string) {
        return this.addSymbolic(bl, string, "|");
    }

    public final TStringBuffer addSymbolic(int n, int n2, String string, String string2) {
        return this.addSymbolic((n & n2) != 0, string, string2);
    }

    public final TStringBuffer addSymbolic(int n, int n2, String string) {
        return this.addSymbolic(n, n2, string, "|");
    }

    public final void delete(int n, int n2) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 < 0 || n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n2 < n) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n < n2) {
            System.arraycopy(this.value, n2, this.value, n, this.count - n2);
            this.count -= n2 - n;
        }
    }

    public final void replace(int n, int n2, String string) {
        this.delete(n, n2);
        this.insert(n, string);
    }

    public final void replace(int n, int n2, char[] cArray) {
        this.delete(n, n2);
        this.insert(n, cArray);
    }

    public final void replace(int n, int n2, TStringBuffer tStringBuffer) {
        this.delete(n, n2);
        this.insert(n, tStringBuffer.toString());
    }

    public final void replace(String string, String string2) {
        for (int i = 0; i < this.length(); i += string2.length()) {
            if ((i = this.indexOf(string, i)) >= 0) {
                this.replace(i, i + string.length(), string2);
                continue;
            }
            return;
        }
    }

    public int indexOf(char c, int n) {
        for (int i = n; i < this.count; ++i) {
            if (this.value[i] != c) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(char c) {
        return this.indexOf(c, 0);
    }

    public int indexOf(String string, int n) {
        int n2 = string.length();
        if (n2 > 0) {
            char c = string.charAt(0);
            block0: for (int i = n; i <= this.count - n2; ++i) {
                if (this.value[i] != c) continue;
                for (int j = 1; j < n2; ++j) {
                    if (this.value[i + j] != string.charAt(j)) continue block0;
                }
                return i;
            }
        }
        return -1;
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int lastIndexOf(char c, int n) {
        for (int i = n; i >= 0; --i) {
            if (this.value[i] != c) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(char c) {
        return this.lastIndexOf(c, this.count - 1);
    }

    public char getLastChar() {
        if (this.count > 0) {
            return this.value[this.count - 1];
        }
        return '\u0000';
    }

    public void appendList(String[] stringArray, String string, String string2, String string3) {
        if (string2 != null) {
            this.append(string2);
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    this.append(string);
                }
                this.append(stringArray[i]);
            }
        }
        if (string3 != null) {
            this.append(string3);
        }
    }

    public TStringBuffer appendJavaString(String string, boolean bl) {
        if (bl) {
            this.append('\"');
        }
        int n = string.length();
        block10: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\b': {
                    this.append("\\b");
                    continue block10;
                }
                case '\t': {
                    this.append("\\t");
                    continue block10;
                }
                case '\n': {
                    this.append("\\n");
                    continue block10;
                }
                case '\f': {
                    this.append("\\f");
                    continue block10;
                }
                case '\r': {
                    this.append("\\r");
                    continue block10;
                }
                case '\'': {
                    this.append("\\'");
                    continue block10;
                }
                case '\"': {
                    this.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    this.append("\\\\");
                    continue block10;
                }
                default: {
                    if (c < ' ' || c > '\u00ff') {
                        this.append("\\u");
                        this.append(TString.toUnsignedHex(c, 4));
                        continue block10;
                    }
                    this.append(c);
                }
            }
        }
        if (bl) {
            this.append('\"');
        }
        return this;
    }
}

