/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.quickr.doclib;

import com.flowbuilder.util.TDiag;
import com.flowbuilder.util.TString;
import com.flowbuilder.xsp.servlet.Context;
import com.triloggroup.lotus.ClientServiceConnector;
import com.triloggroup.lotus.IServiceConnector;
import com.triloggroup.lotus.ImportExportDocUtil;
import com.triloggroup.lotus.ServletServiceConnector;
import com.triloggroup.quickr.QuickrUtil;
import com.triloggroup.quickr.XSPServiceConnector;
import com.triloggroup.quickr.doclib.UDocumentLibrary;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.ZipOutputStream;

public class DocumentLibraryExport {
    private Context xspContext;
    private IServiceConnector serviceConnector;
    private ImportExportDocUtil exportDocUtil;
    private ImportExportDocUtil.Node libNode;
    private ZipOutputStream zipOutput = null;
    private ImportExportDocUtil.Result result;
    private String[] entriesContentUrlToExport = null;

    public DocumentLibraryExport(Context context) {
        this.xspContext = context;
        this.serviceConnector = new XSPServiceConnector(context);
    }

    public DocumentLibraryExport(IServiceConnector iServiceConnector) {
        this.serviceConnector = iServiceConnector;
    }

    public ImportExportDocUtil.Result exportCurrentLibrary(OutputStream outputStream) throws Exception {
        return this.exportLibrary(QuickrUtil.getCurrentDocumentLibraryHrefId(this.xspContext), outputStream);
    }

    public ImportExportDocUtil.Result exportEntriesOfCurrentLibary(String[] stringArray, OutputStream outputStream) throws Exception {
        return this.exportEntriesOfLibrary(stringArray, QuickrUtil.getCurrentDocumentLibraryHrefId(this.xspContext), outputStream);
    }

    public ImportExportDocUtil.Result exportLibrary(String string, OutputStream outputStream) throws Exception {
        return this.exportEntriesOfLibrary(null, string, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImportExportDocUtil.Result exportEntriesOfLibrary(String[] stringArray, String string, OutputStream outputStream) throws Exception {
        UDocumentLibrary.Library library;
        this.result = new ImportExportDocUtil.Result();
        this.libNode = null;
        this.exportDocUtil = new ImportExportDocUtil();
        this.entriesContentUrlToExport = stringArray;
        if (this.entriesContentUrlToExport != null && this.entriesContentUrlToExport.length > 0) {
            Arrays.sort(this.entriesContentUrlToExport);
        }
        if ((library = UDocumentLibrary.getLibraryInfo(this.serviceConnector, string)) != null) {
            library.url = this.convertQuickrProxyRestUrlToServer_QD85ProxyPatch(library.url);
            this.zipOutput = new ZipOutputStream(outputStream);
            try {
                this.libNode = new ImportExportDocUtil.Node();
                this.libNode.docId = library.title;
                int n = 1;
                UDocumentLibrary.ListResult listResult = UDocumentLibrary.getLibraryContent(this.serviceConnector, library, null, n, 100);
                UDocumentLibrary.Entry[] entryArray = listResult.entries;
                while (listResult.hasNext) {
                    listResult = UDocumentLibrary.getLibraryContent(this.serviceConnector, library, null, ++n, 100);
                    if (listResult.entries == null || listResult.entries.length <= 0) continue;
                    UDocumentLibrary.Entry[] entryArray2 = new UDocumentLibrary.Entry[entryArray.length + listResult.entries.length];
                    System.arraycopy(entryArray, 0, entryArray2, 0, entryArray.length);
                    System.arraycopy(listResult.entries, 0, entryArray2, entryArray.length, listResult.entries.length);
                    entryArray = entryArray2;
                }
                this.listAllEntries(entryArray, this.libNode);
                this.exportDocUtil.writeQuickrLibraryTreeStructure(this.zipOutput, this.libNode);
            }
            finally {
                if (this.zipOutput != null) {
                    this.zipOutput.close();
                }
            }
            return this.result;
        }
        throw new Exception("Could not access library to import " + string);
    }

    private boolean listAllEntries(UDocumentLibrary.Entry[] entryArray, ImportExportDocUtil.Node node) throws Exception {
        boolean bl = false;
        if (entryArray != null) {
            for (int i = 0; i < entryArray.length; ++i) {
                ImportExportDocUtil.Leaf leaf;
                this.convertQuickrProxyRestUrlToServer_QD85ProxyPatch(entryArray[i]);
                if (TString.equals((String)entryArray[i].category, (String)"folder")) {
                    leaf = new ImportExportDocUtil.Node();
                    leaf.quickrData = entryArray[i];
                    try {
                        UDocumentLibrary.Entry[] entryArray2 = this.getFullFolderContent(entryArray[i]);
                        node.children.add(leaf);
                        if (!this.listAllEntries(entryArray2, (ImportExportDocUtil.Node)leaf)) continue;
                        bl = true;
                    }
                    catch (Exception exception) {
                        this.result.unexportedFolder.add(entryArray[i]);
                        TDiag.exception((Throwable)exception, (String)("ERROR: Could not get full content of the folder " + entryArray[i].title + " with url " + entryArray[i].contentUrl));
                        TDiag.error((String)(entryArray[i].title + " folder will not be exported"));
                        TDiag.error((String)("...Summary: " + entryArray[i].summary));
                        TDiag.error((String)("...Entry url: " + entryArray[i].entryUrl));
                    }
                    continue;
                }
                if (!this.isEntryToExport(entryArray[i])) continue;
                bl = true;
                leaf = new ImportExportDocUtil.Leaf();
                leaf.docId = this.getUidFromUrl(entryArray[i]);
                leaf.quickrData = entryArray[i];
                node.children.add(leaf);
                this.addDocumentToZip(entryArray[i]);
            }
        }
        return bl;
    }

    private boolean isEntryToExport(UDocumentLibrary.Entry entry) {
        if (this.entriesContentUrlToExport == null || this.entriesContentUrlToExport.length == 0) {
            return true;
        }
        return Arrays.binarySearch(this.entriesContentUrlToExport, entry.contentUrl) >= 0;
    }

    private UDocumentLibrary.Entry[] getFullFolderContent(UDocumentLibrary.Entry entry) throws Exception {
        int n = 1;
        UDocumentLibrary.ListResult listResult = UDocumentLibrary.getFolderContent(this.serviceConnector, entry.contentUrl, n, 100);
        UDocumentLibrary.Entry[] entryArray = listResult.entries;
        while (listResult.hasNext) {
            listResult = UDocumentLibrary.getFolderContent(this.serviceConnector, entry.contentUrl, ++n, 100);
            if (listResult.entries == null || listResult.entries.length <= 0) continue;
            UDocumentLibrary.Entry[] entryArray2 = new UDocumentLibrary.Entry[entryArray.length + listResult.entries.length];
            System.arraycopy(entryArray, 0, entryArray2, 0, entryArray.length);
            System.arraycopy(listResult.entries, 0, entryArray2, entryArray.length, listResult.entries.length);
            entryArray = entryArray2;
        }
        return entryArray;
    }

    private void addDocumentToZip(UDocumentLibrary.Entry entry) {
        String string = this.getUidFromUrl(entry);
        this.exportDocUtil.addDocumentToZip(entry, string, this.serviceConnector, this.zipOutput);
    }

    private String getUidFromUrl(UDocumentLibrary.Entry entry) {
        int n = entry.entryUrl.lastIndexOf(47);
        String string = entry.entryUrl.substring(0, n);
        n = string.lastIndexOf(47);
        string = string.substring(n + 1);
        return string;
    }

    private String convertQuickrProxyRestUrlToServer_QD85ProxyPatch(String string) {
        if (this.xspContext != null) {
            return QuickrUtil.convertQuickrProxyRestUrlToServer(this.xspContext, string);
        }
        if (this.serviceConnector instanceof ServletServiceConnector) {
            return QuickrUtil.convertQuickrProxyRestUrlToServer(((ServletServiceConnector)this.serviceConnector).getHttpServletRequest(), string);
        }
        return string;
    }

    private void convertQuickrProxyRestUrlToServer_QD85ProxyPatch(UDocumentLibrary.Entry entry) {
        entry.url = this.convertQuickrProxyRestUrlToServer_QD85ProxyPatch(entry.url);
        entry.entryUrl = this.convertQuickrProxyRestUrlToServer_QD85ProxyPatch(entry.entryUrl);
        entry.contentUrl = this.convertQuickrProxyRestUrlToServer_QD85ProxyPatch(entry.contentUrl);
    }

    public static void main(String[] stringArray) {
        try {
            ClientServiceConnector clientServiceConnector = new ClientServiceConnector("http://belouga.triloggroup.com/", "pcollins", "floflo");
            DocumentLibraryExport documentLibraryExport = new DocumentLibraryExport(clientServiceConnector);
            String string = "%5B%40Ppe29%2F%40RMain.nsf%5D";
            FileOutputStream fileOutputStream = new FileOutputStream("C:\\tmp\\projexec\\testExportPrj\\docLibPe29.zip");
            documentLibraryExport.exportLibrary(string, fileOutputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

