/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.quickr;

import com.flowbuilder.util.TProperties;
import com.flowbuilder.util.TString;
import com.flowbuilder.util.net.UrlObject;
import com.triloggroup.lotus.ClientServiceConnector;
import com.triloggroup.lotus.IServiceConnector;
import com.triloggroup.lotus.UService;
import java.io.Serializable;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;

public class UPlaceService
extends UService {
    private static UPlaceService singleton = new UPlaceService();

    private UPlaceService() {
    }

    public static boolean isServiceAvailable(IServiceConnector iServiceConnector) {
        try {
            String string = UPlaceService.getPlacesServiceBaseUrl(iServiceConnector) + "?pageSize=10";
            Document document = singleton.callService(string, iServiceConnector, null);
            if (document == null || document.getRootElement() == null) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static Place[] getAllPlaces(IServiceConnector iServiceConnector) throws Exception {
        return UPlaceService.getAllPlaces(iServiceConnector, false);
    }

    public static Place[] getAllPlaces(IServiceConnector iServiceConnector, boolean bl) throws Exception {
        Document document;
        String string = UPlaceService.getPlacesServiceBaseUrl(iServiceConnector) + "?pageSize=50000&page=1&filter=all";
        if (bl) {
            string = string + "&mode=admin";
        }
        if ((document = singleton.callService(string, iServiceConnector, null)) == null || document.getRootElement() == null) {
            return null;
        }
        return UPlaceService.readEntries(iServiceConnector, document);
    }

    public static String[] getAllPlaceIds(IServiceConnector iServiceConnector) throws Exception {
        String string = UPlaceService.getPlacesServiceBaseUrl(iServiceConnector) + "?pageSize=500000&page=1&filter=all";
        Document document = singleton.callService(string, iServiceConnector, null);
        if (document == null || document.getRootElement() == null) {
            return null;
        }
        Element element = document.getRootElement();
        List list = element.getChildren("entry", atomNs);
        if (list != null) {
            String[] stringArray = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Element element2 = (Element)list.get(i);
                String string2 = UPlaceService.getChildText(element2, "id", atomNs);
                stringArray[i] = singleton.extractId(string2);
            }
        }
        return new String[0];
    }

    public static Place getPlaceInfo(IServiceConnector iServiceConnector, String string) throws Exception {
        String string2 = UPlaceService.getPlaceServiceUrl(iServiceConnector, string);
        Document document = singleton.callService(string2, iServiceConnector);
        if (document == null || document.getRootElement() == null) {
            return null;
        }
        Element element = document.getRootElement();
        if (!element.getName().equals("entry") || TString.isEmpty((String)string2)) {
            return null;
        }
        return UPlaceService.readEntryElement(iServiceConnector, element);
    }

    public static Place getPlaceInfoDomino(IServiceConnector iServiceConnector, String string) throws Exception {
        String string2 = UPlaceService.getPlacesServiceBaseUrl(iServiceConnector) + "?pageSize=50000&page=1&filter=all";
        Document document = singleton.callService(string2, iServiceConnector, null);
        if (document == null || document.getRootElement() == null) {
            return null;
        }
        Element element = document.getRootElement();
        List list = element.getChildren("entry", atomNs);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Element element2 = (Element)list.get(i);
                String string3 = UPlaceService.getChildText(element2, "id", atomNs);
                if (!TString.equalsIgnoreCase((String)(string3 = singleton.extractId(string3)), (String)string)) continue;
                return UPlaceService.readEntryElement(iServiceConnector, element2);
            }
        }
        return null;
    }

    public static Place createPlace(IServiceConnector iServiceConnector, String string, String string2, String string3) throws Exception {
        String string4 = UPlaceService.getPlacesServiceBaseUrl(iServiceConnector);
        String string5 = UPlaceService.getCreationPlaceXmlStr(string, string2, "text", string3, "applications");
        String[][] stringArray = new String[1][2];
        stringArray[0][0] = "Accept-Language";
        stringArray[0][1] = "en";
        Document document = singleton.callService(string4, iServiceConnector, string5, stringArray);
        if (document == null || document.getRootElement() == null) {
            return null;
        }
        Element element = document.getRootElement();
        if (!element.getName().equals("entry")) {
            return null;
        }
        return UPlaceService.readEntryElement(iServiceConnector, element);
    }

    private static String getCreationPlaceXmlStr(String string, String string2, String string3, String string4, String string5) {
        StringBuffer stringBuffer = new StringBuffer("<entry xmlns=\"http://www.w3.org/2005/Atom\" xmlns:td=\"urn:ibm.com/td\">\n");
        stringBuffer.append(" <title type=\"text\">").append(TString.toXMLString((String)string)).append("</title>\n");
        if (TString.isEmpty((String)string3) || !TString.equals((String)string3, (String)"text") || !TString.equals((String)string3, (String)"html")) {
            string3 = "text";
        }
        stringBuffer.append(" <summary type=\"").append(string3).append("\">");
        if (TString.isEmpty((String)string2) || string2.startsWith("{fr=")) {
            stringBuffer.append(" ");
        } else {
            stringBuffer.append(TString.toXMLString((String)string2));
        }
        stringBuffer.append("</summary>\n");
        stringBuffer.append(" <td:template>").append(string4).append("</td:template>\n");
        stringBuffer.append(" <td:category>").append(string5).append("</td:category>");
        stringBuffer.append("</entry>");
        return stringBuffer.toString();
    }

    public static void updatePlace(IServiceConnector iServiceConnector, String string, String string2, String string3) throws Exception {
        String string4 = UPlaceService.getPlaceServiceUrl(iServiceConnector, string);
        String string5 = UPlaceService.getUpdatePlaceXmlStr(string2, string3, "text");
        String[][] stringArray = new String[1][2];
        stringArray[0][0] = "X-Method-Override";
        stringArray[0][1] = "PUT";
        Document document = singleton.callService(string4, iServiceConnector, string5, stringArray);
    }

    private static String getUpdatePlaceXmlStr(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer("<entry xmlns=\"http://www.w3.org/2005/Atom\" xmlns:td=\"urn:ibm.com/td\">\n");
        stringBuffer.append(" <title type=\"text\">").append(TString.toXMLString((String)string)).append("</title>\n");
        if (!TString.isEmpty((String)string2)) {
            if (TString.isEmpty((String)string3) || !TString.equals((String)string3, (String)"text") || !TString.equals((String)string3, (String)"html")) {
                string3 = "text";
            }
            stringBuffer.append(" <summary type=\"").append(string3).append("\">").append(TString.toXMLString((String)string2)).append("</summary>\n");
        }
        stringBuffer.append("</entry>");
        return stringBuffer.toString();
    }

    public static void deletePlace(IServiceConnector iServiceConnector, String string) throws Exception {
        String string2 = UPlaceService.getPlaceServiceUrl(iServiceConnector, string);
        String[][] stringArray = new String[1][2];
        stringArray[0][0] = "X-Method-Override";
        stringArray[0][1] = "DELETE";
        singleton.callService(string2, iServiceConnector, null, stringArray, false);
    }

    public static Role[] getPlaceRoles(IServiceConnector iServiceConnector, String string) throws Exception {
        String[][] stringArray;
        String string2 = iServiceConnector.getBaseUrl() + "myqcs/rest/place/" + string + "/roles";
        Document document = singleton.callService(string2, iServiceConnector, null, stringArray = new String[][]{{"Accept-Language", "en"}});
        if (document == null || document.getRootElement() == null) {
            return null;
        }
        Element element = document.getRootElement();
        List list = element.getChildren("entry", atomNs);
        ArrayList<Role> arrayList = new ArrayList<Role>();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Element element2 = (Element)list.get(i);
                Role role = new Role();
                role.title = UPlaceService.getChildText(element2, "title", atomNs);
                String string3 = UPlaceService.getChildText(element2, "id", atomNs);
                role.id = singleton.extractId(string3);
                arrayList.add(role);
            }
        }
        Role[] roleArray = new Role[arrayList.size()];
        roleArray = arrayList.toArray(roleArray);
        return roleArray;
    }

    public static Role[] getPlaceRolesDomino(IServiceConnector iServiceConnector, String string) throws Exception {
        String string2 = iServiceConnector.getBaseUrl() + "dm/atom/library/" + string + "/members?action=roles";
        Document document = singleton.callService(string2, iServiceConnector);
        if (document == null || document.getRootElement() == null) {
            return null;
        }
        Element element = document.getRootElement();
        List list = element.getChildren("entry", atomNs);
        ArrayList<Role> arrayList = new ArrayList<Role>();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Element element2;
                Element element3 = (Element)list.get(i);
                Role role = new Role();
                role.title = UPlaceService.getChildText(element3, "title", atomNs);
                Element element4 = element3.getChild("content", atomNs);
                if (element4 != null && (element2 = element4.getChild("role", atomNs)) != null) {
                    role.id = element2.getAttributeValue("type");
                }
                if (role.id == null) {
                    role.id = role.title;
                }
                arrayList.add(role);
            }
        }
        Role[] roleArray = new Role[arrayList.size()];
        roleArray = arrayList.toArray(roleArray);
        return roleArray;
    }

    public static String[] getMembersDnByRoleOfPlace(IServiceConnector iServiceConnector, String string, Role role) throws Exception {
        String string2 = iServiceConnector.getBaseUrl() + "myqcs/rest/place/" + string + "/roles/" + role.id + "/members";
        Document document = singleton.callService(string2, iServiceConnector);
        if (document == null || document.getRootElement() == null) {
            return null;
        }
        Element element = document.getRootElement();
        List list = element.getChildren("entry", atomNs);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Element element2 = (Element)list.get(i);
                String string3 = UPlaceService.getMemberDnFromEntryElt(element2);
                if (TString.isEmpty((String)string3)) continue;
                arrayList.add(string3);
            }
        }
        String[] stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        return stringArray;
    }

    public static String[] getMembersDnByRoleOfPlaceDomino(IServiceConnector iServiceConnector, String string, Role role) throws Exception {
        String string2 = iServiceConnector.getBaseUrl() + "dm/atom/library/" + string + "/members?action=members&pageSize=-1&query=" + role.id;
        Document document = singleton.callService(string2, iServiceConnector);
        if (document == null || document.getRootElement() == null) {
            return null;
        }
        Element element = document.getRootElement();
        List list = element.getChildren("entry", atomNs);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Element element2 = (Element)list.get(i);
                String string3 = UPlaceService.getMemberDnFromEntryElt(element2);
                if (TString.isEmpty((String)string3)) continue;
                arrayList.add(string3);
            }
        }
        String[] stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        return stringArray;
    }

    public static String[] getMembersDnOfPlace(IServiceConnector iServiceConnector, String string) throws Exception {
        String string2 = iServiceConnector.getBaseUrl() + "myqcs/rest/place/" + string + "/members";
        Document document = singleton.callService(string2, iServiceConnector);
        if (document == null || document.getRootElement() == null) {
            return null;
        }
        Element element = document.getRootElement();
        List list = element.getChildren("entry", atomNs);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Element element2 = (Element)list.get(i);
                String string3 = UPlaceService.getMemberDnFromEntryElt(element2);
                if (TString.isEmpty((String)string3)) continue;
                arrayList.add(string3);
            }
        }
        String[] stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        return stringArray;
    }

    private static String getMemberDnFromEntryElt(Element element) {
        Element element2 = element.getChild("content", atomNs);
        if (element2 != null) {
            Element element3 = element2.getChild("member", ibmTdNs);
            if (element3 != null) {
                String string = element3.getAttributeValue("DN");
                if (!TString.isEmpty((String)string) && string.indexOf(61) != -1) {
                    if (TProperties.getBoolean((String)"fb.ldap.dn.forceLowerCase")) {
                        return string.toLowerCase();
                    }
                    return string;
                }
            } else {
                String string;
                element3 = element2.getChild("member", atomNs);
                if (element3 == null) {
                    element3 = element2.getChild("member", quickrNs);
                }
                if (element3 != null && !TString.isEmpty((String)(string = element3.getAttributeValue("DN", quickrNs))) && string.indexOf(61) != -1) {
                    if (TProperties.getBoolean((String)"fb.ldap.dn.forceLowerCase")) {
                        return string.toLowerCase();
                    }
                    return string;
                }
            }
        }
        return null;
    }

    private static Member readMemberElement(Element element) {
        Element element2 = element.getChild("content", atomNs);
        if (element2 != null) {
            Element element3 = element2.getChild("member", ibmTdNs);
            if (element3 != null) {
                String string = element3.getAttributeValue("DN");
                if (!TString.isEmpty((String)string) && string.indexOf(61) != -1) {
                    Member member = new Member();
                    member.dn = TProperties.getBoolean((String)"fb.ldap.dn.forceLowerCase") ? string.toLowerCase() : string;
                    Element element4 = element.getChild("id", atomNs);
                    if (element4 != null) {
                        member.id = singleton.extractId(element4.getText());
                    }
                    member.displayName = element3.getAttributeValue("display-name");
                    member.email = element3.getAttributeValue("email");
                    member.type = element3.getAttributeValue("type");
                    return member;
                }
            } else {
                String string;
                element3 = element2.getChild("member", atomNs);
                if (element3 == null) {
                    element3 = element2.getChild("member", quickrNs);
                }
                if (element3 != null && !TString.isEmpty((String)(string = element3.getAttributeValue("DN", quickrNs))) && string.indexOf(61) != -1) {
                    Member member = new Member();
                    member.dn = TProperties.getBoolean((String)"fb.ldap.dn.forceLowerCase") ? string.toLowerCase() : string;
                    Element element5 = element.getChild("id", atomNs);
                    if (element5 != null) {
                        member.id = singleton.extractId(element5.getText());
                    }
                    member.displayName = element3.getAttributeValue("display-name");
                    member.email = element3.getAttributeValue("email");
                    member.type = element3.getAttributeValue("type", quickrNs);
                    return member;
                }
            }
        }
        return null;
    }

    private static String getMembersIdByDn(IServiceConnector iServiceConnector, String string, String string2) throws Exception {
        String string3 = iServiceConnector.getBaseUrl() + "myqcs/rest/place/" + string + "/members";
        Document document = singleton.callService(string3, iServiceConnector);
        if (document == null || document.getRootElement() == null) {
            return null;
        }
        Element element = document.getRootElement();
        List list = element.getChildren("entry", atomNs);
        ArrayList arrayList = new ArrayList();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Element element2 = (Element)list.get(i);
                String string4 = UPlaceService.getMemberDnFromEntryElt(element2);
                if (!TString.equalsIgnoreCase((String)string2, (String)string4)) continue;
                Element element3 = element2.getChild("id", atomNs);
                if (element3 != null) {
                    return singleton.extractId(element3.getText());
                }
                return null;
            }
        }
        return null;
    }

    public static String[] getMembersDnOfPlaceDomino(IServiceConnector iServiceConnector, String string) throws Exception {
        String string2 = iServiceConnector.getBaseUrl() + "dm/atom/library/" + string + "/members?action=members&pageSize=-1";
        Document document = singleton.callService(string2, iServiceConnector);
        if (document == null || document.getRootElement() == null) {
            return null;
        }
        Element element = document.getRootElement();
        List list = element.getChildren("entry", atomNs);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Element element2 = (Element)list.get(i);
                String string3 = UPlaceService.getMemberDnFromEntryElt(element2);
                if (TString.isEmpty((String)string3)) continue;
                arrayList.add(string3);
            }
        }
        String[] stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        return stringArray;
    }

    public static Member[] getMembersOfPlace(IServiceConnector iServiceConnector, String string) throws Exception {
        String string2 = iServiceConnector.getBaseUrl() + "myqcs/rest/place/" + string + "/members";
        return UPlaceService._getMembersOfPlace(iServiceConnector, string, string2);
    }

    public static Member[] getMembersOfPlaceDomino(IServiceConnector iServiceConnector, String string) throws Exception {
        String string2 = iServiceConnector.getBaseUrl() + "dm/atom/library/" + string + "/members?action=members&pageSize=-1";
        return UPlaceService._getMembersOfPlace(iServiceConnector, string, string2);
    }

    private static Member[] _getMembersOfPlace(IServiceConnector iServiceConnector, String string, String string2) throws Exception {
        Document document = singleton.callService(string2, iServiceConnector);
        if (document == null || document.getRootElement() == null) {
            return null;
        }
        Element element = document.getRootElement();
        List list = element.getChildren("entry", atomNs);
        ArrayList<Member> arrayList = new ArrayList<Member>();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Element element2 = (Element)list.get(i);
                Member member = UPlaceService.readMemberElement(element2);
                if (member == null) continue;
                arrayList.add(member);
            }
        }
        Member[] memberArray = new Member[arrayList.size()];
        memberArray = arrayList.toArray(memberArray);
        return memberArray;
    }

    public static Member[] getLocalMembersOfPlaceDomino(IServiceConnector iServiceConnector, String string) throws Exception {
        Member[] memberArray = UPlaceService.getMembersOfPlaceDomino(iServiceConnector, string);
        if (memberArray.length > 0) {
            ArrayList<Member> arrayList = new ArrayList<Member>();
            for (int i = 0; i < memberArray.length; ++i) {
                if (!"localuser".equals(memberArray[i].type)) continue;
                arrayList.add(memberArray[i]);
            }
            Member[] memberArray2 = new Member[arrayList.size()];
            memberArray2 = arrayList.toArray(memberArray2);
            return memberArray2;
        }
        return new Member[0];
    }

    public static boolean isLocalUserOfDominoPlace(IServiceConnector iServiceConnector, String string, String string2) throws Exception {
        Member[] memberArray = UPlaceService.getMembersOfPlaceDomino(iServiceConnector, string);
        if (memberArray.length > 0) {
            for (int i = 0; i < memberArray.length; ++i) {
                if (!TString.equalsIgnoreCase((String)string2, (String)memberArray[i].dn)) continue;
                return "localuser".equals(memberArray[i].type);
            }
        }
        return false;
    }

    public static HashMap getMembersDnAndRolesOfPlace(IServiceConnector iServiceConnector, String string) throws Exception {
        Role[] roleArray = UPlaceService.getPlaceRoles(iServiceConnector, string);
        HashMap<Role, String[]> hashMap = new HashMap<Role, String[]>();
        for (int i = 0; i < roleArray.length; ++i) {
            String[] stringArray = UPlaceService.getMembersDnByRoleOfPlace(iServiceConnector, string, roleArray[i]);
            hashMap.put(roleArray[i], stringArray);
        }
        return hashMap;
    }

    public static HashMap getMembersDnAndRolesOfPlaceDomino(IServiceConnector iServiceConnector, String string) throws Exception {
        Role[] roleArray = UPlaceService.getPlaceRolesDomino(iServiceConnector, string);
        HashMap<Role, String[]> hashMap = new HashMap<Role, String[]>();
        for (int i = 0; i < roleArray.length; ++i) {
            String[] stringArray = UPlaceService.getMembersDnByRoleOfPlaceDomino(iServiceConnector, string, roleArray[i]);
            hashMap.put(roleArray[i], stringArray);
        }
        return hashMap;
    }

    public static void addMemberWithRoleToPlace(IServiceConnector iServiceConnector, String string, Role role, String string2) throws Exception {
        String string3 = iServiceConnector.getBaseUrl() + "myqcs/rest/place/" + string + "/roles/" + role.id + "/members";
        String string4 = UPlaceService.getAddMemberXmlStr(string2);
        Document document = singleton.callService(string3, iServiceConnector, string4);
    }

    private static String getAddMemberXmlStr(String string) {
        StringBuffer stringBuffer = new StringBuffer("<entry xmlns=\"http://www.w3.org/2005/Atom\">\n");
        stringBuffer.append(" <title type=\"text\">").append(TString.toXMLString((String)string)).append("</title>\n");
        stringBuffer.append("</entry>");
        return stringBuffer.toString();
    }

    public static void addMemberWithRoleToPlaceDomino(IServiceConnector iServiceConnector, String string, Role role, String string2) throws Exception {
        String string3 = iServiceConnector.getBaseUrl() + "/dm/atom/library/" + string + "/action?action=member";
        String string4 = UPlaceService.getAddMemberXmlStrDomino(string2, role.id);
        Document document = singleton.callService(string3, iServiceConnector, string4, (String[][])null, false);
    }

    private static String getAddMemberXmlStrDomino(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer("<addMember dnName=\"");
        stringBuffer.append(string);
        stringBuffer.append("\" accessLevel=\"");
        stringBuffer.append(string2);
        stringBuffer.append("\" isPerson=\"1\" isLocal=\"false\"/>");
        return stringBuffer.toString();
    }

    public static void removeMemberOfPlace(IServiceConnector iServiceConnector, String string, String string2) throws Exception {
        String string3 = UPlaceService.getMembersIdByDn(iServiceConnector, string, string2);
        if (TString.isEmpty((String)string3)) {
            throw new Exception("Could not found user " + string2 + " in place " + string);
        }
        String string4 = iServiceConnector.getBaseUrl() + "myqcs/rest/place/" + string + "/members/" + URLEncoder.encode(string3) + "/entry";
        String string5 = UPlaceService.getRemoveMemberXmlStr(string2);
        String[][] stringArray = new String[1][2];
        stringArray[0][0] = "X-Method-Override";
        stringArray[0][1] = "DELETE";
        Document document = singleton.callService(string4, iServiceConnector, string5, stringArray, false);
    }

    private static String getRemoveMemberXmlStr(String string) {
        StringBuffer stringBuffer = new StringBuffer("<entry xmlns=\"http://www.w3.org/2005/Atom\">\n");
        stringBuffer.append(" <title type=\"text\">").append(TString.toXMLString((String)string)).append("</title>\n");
        stringBuffer.append("</entry>");
        return stringBuffer.toString();
    }

    public static void removeMemberOfPlaceDomino(IServiceConnector iServiceConnector, String string, String string2) throws Exception {
        String string3 = iServiceConnector.getBaseUrl() + "/dm/atom/library/" + string + "/action?action=member";
        String string4 = UPlaceService.getRemoveMemberXmlStrDomino(string2);
        Document document = singleton.callService(string3, iServiceConnector, string4, (String[][])null, false);
    }

    private static String getRemoveMemberXmlStrDomino(String string) {
        StringBuffer stringBuffer = new StringBuffer("<deleteMember dnName=\"");
        stringBuffer.append(string);
        stringBuffer.append("\" isPerson=\"1\" isLocal=\"false\"/>");
        return stringBuffer.toString();
    }

    protected static String getPlacesServiceBaseUrl(IServiceConnector iServiceConnector) {
        return iServiceConnector.getBaseUrl() + "myqcs/rest/places/feed";
    }

    protected static String getPlaceServiceUrl(IServiceConnector iServiceConnector, String string) {
        return iServiceConnector.getBaseUrl() + "myqcs/rest/place/" + string + "/entry";
    }

    private static Place[] readEntries(IServiceConnector iServiceConnector, Document document) {
        Element element = document.getRootElement();
        List list = element.getChildren("entry", atomNs);
        if (list != null && list.size() > 0) {
            ArrayList<Place> arrayList = new ArrayList<Place>();
            for (int i = 0; i < list.size(); ++i) {
                Place place = UPlaceService.readEntryElement(iServiceConnector, (Element)list.get(i));
                if (place == null) continue;
                arrayList.add(place);
            }
            Place[] placeArray = new Place[arrayList.size()];
            placeArray = arrayList.toArray(placeArray);
            return placeArray;
        }
        return null;
    }

    private static Place readEntryElement(IServiceConnector iServiceConnector, Element element) {
        Element element2;
        Object object;
        String string = UPlaceService.getChildText(element, "isdeleted", ibmTdNs);
        if (!TString.isEmpty((String)string) && TString.equalsIgnoreCase((String)string, (String)"true")) {
            return null;
        }
        Place place = new Place();
        place.title = UPlaceService.getChildText(element, "title", atomNs);
        place.summary = UPlaceService.getChildText(element, "summary", atomNs);
        String string2 = UPlaceService.getChildText(element, "id", atomNs);
        place.id = singleton.extractId(string2);
        List list = element.getChildren("link", atomNs);
        String string3 = null;
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                object = (Element)list.get(i);
                String string4 = object.getAttributeValue("rel");
                if (TString.equals((String)string4, (String)"alternate")) {
                    place.url = object.getAttributeValue("href");
                    continue;
                }
                if (!TString.equals((String)string4, (String)"documentLibraries")) continue;
                string3 = object.getAttributeValue("href");
            }
        }
        if ((element2 = element.getChild("author", atomNs)) != null) {
            place.author = UPlaceService.getChildText(element2, "name", atomNs);
            object = UPlaceService.getChildText(element2, "uri", atomNs);
            if (!TString.isEmpty((String)object)) {
                place.authorDn = URLDecoder.decode((String)object);
                if (TProperties.getBoolean((String)"fb.ldap.dn.forceLowerCase")) {
                    place.authorDn = place.authorDn.toLowerCase();
                }
            }
            place.authorEmail = UPlaceService.getChildText(element2, "email ", atomNs);
        }
        place.template = UPlaceService.getChildText(element, "template", ibmTdNs);
        if (!TString.isEmpty(string3)) {
            place.libHrefId = UPlaceService.getDocumentLibraryHrefId(iServiceConnector, string3, place.id);
        }
        return place;
    }

    private static String getDocumentLibraryHrefId(IServiceConnector iServiceConnector, String string, String string2) {
        Document document;
        try {
            Element element;
            List list;
            document = singleton.callService(string, iServiceConnector);
            if (document != null && document.getRootElement() != null && (list = (element = document.getRootElement()).getChildren("entry", atomNs)) != null && list.size() > 0) {
                Element element2 = (Element)list.get(0);
                String string3 = UPlaceService.getChildText(element2, "id", atomNs);
                return singleton.extractId(string3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!TString.isEmpty((String)string2)) {
            return string2;
        }
        document = new UrlObject(string);
        if (DEV_ENV) {
            System.out.println("Created Doc Lib Id = " + document.getParameter("placeId"));
        }
        return document.getParameter("placeId");
    }

    public static void dump(Place place) {
        System.out.println("Id      : " + place.id);
        System.out.println("Title   : " + place.title);
        System.out.println("Summary : " + place.summary);
        System.out.println("Url     : " + place.url);
        System.out.println("Template: " + place.template);
        System.out.println("libHrefId: " + place.libHrefId);
        System.out.println("Author   : " + place.author);
        System.out.println("AuthorDn : " + place.authorDn);
        System.out.println("AuthorEmail: " + place.authorEmail);
    }

    public static void dump(Member member) {
        System.out.println(" Member.displayName :  " + member.displayName);
        System.out.println(" .......dn = " + member.dn);
        System.out.println(" .......email= " + member.email);
        System.out.println(" .......type = " + member.type);
        System.out.println(" .......id = " + member.id);
    }

    public static void main(String[] stringArray) {
        try {
            String[] stringArray2;
            ClientServiceConnector clientServiceConnector = new ClientServiceConnector("http://tgqj85fr.triloggroup.com:10040/", "philip Collins", "flafla");
            Locale.setDefault(new Locale("es"));
            Place place = UPlaceService.createPlace(clientServiceConnector, "Test Place Projexec with es Locale", "Place created by REST API", "ProjExec Project Place");
            System.out.println("---- Created place ---- ");
            UPlaceService.dump(place);
            System.exit(0);
            Role[] roleArray = UPlaceService.getPlaceRoles(clientServiceConnector, place.id);
            if (roleArray != null) {
                System.out.println("Nb roles = " + roleArray.length);
                for (int i = 0; i < roleArray.length; ++i) {
                    System.out.println("Name: " + roleArray[i].title + "       id: " + roleArray[i].id);
                    stringArray2 = UPlaceService.getMembersDnByRoleOfPlace(clientServiceConnector, place.id, roleArray[i]);
                    if (stringArray2 != null) {
                        System.out.println("...members:");
                        for (int j = 0; j < stringArray2.length; ++j) {
                            System.out.println("......." + stringArray2[j]);
                        }
                        continue;
                    }
                    System.out.println("...no member");
                }
            } else {
                System.out.println("No roles found!!!");
            }
            Role role = roleArray[3];
            UPlaceService.addMemberWithRoleToPlace(clientServiceConnector, place.id, role, "uid=pcollins,o=defaultwimfilebasedrealm");
            System.exit(0);
            stringArray2 = UPlaceService.getMembersDnAndRolesOfPlace(clientServiceConnector, place.id);
            for (Map.Entry entry : stringArray2.entrySet()) {
                Role role2 = (Role)entry.getKey();
                String[] stringArray3 = (String[])entry.getValue();
                System.out.println("-> Role : " + role2.title);
                if (stringArray3 != null && stringArray3.length > 0) {
                    System.out.println("----- members : ");
                    for (int i = 0; i < stringArray3.length; ++i) {
                        System.out.println("        " + stringArray3[i]);
                    }
                    continue;
                }
                System.out.println("----- No members!");
            }
            System.out.println("---------- get Members of place -------------");
            Member[] memberArray = UPlaceService.getMembersOfPlace(clientServiceConnector, place.id);
            if (memberArray == null || memberArray.length == 0) {
                System.out.println("----- No members!");
            } else {
                for (int i = 0; i < memberArray.length; ++i) {
                    UPlaceService.dump(memberArray[i]);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static class Member
    implements Serializable {
        public String dn;
        public String displayName;
        public String email;
        public String type;
        public String id;
    }

    public static class Role
    implements Serializable {
        public String id;
        public String title;
    }

    public static class Place
    implements Serializable {
        public String id;
        public String title;
        public String summary;
        public String author;
        public String authorDn;
        public String authorEmail;
        public String url;
        public String template;
        public String libHrefId;
    }
}

