/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.quickr;

import com.flowbuilder.Application;
import com.flowbuilder.util.TDiag;
import com.flowbuilder.util.TString;
import com.flowbuilder.util.io.vfs.VFS;
import com.flowbuilder.xsp.servlet.Context;
import com.triloggroup.lotus.IServiceConnector;
import com.triloggroup.lotus.LotusUtil;
import com.triloggroup.lotus.UService;
import com.triloggroup.quickr.IProviderQuickrUtil;
import com.triloggroup.quickr.XSPServiceConnector;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Document;
import org.jdom.Element;

public class QuickrUtil {
    private static IProviderQuickrUtil provider;
    private static int isInQuickrJ2ee;
    private static int isInQuickrDomino;
    private static int isInQuickrDomino85;
    public static boolean DEBUG;
    private static final String CURRENT_PLATFORM_KEY = "currentPlatform";
    private static final String QUICKR_DOMINO_PLATFORM = "QuickrDomino";
    private static final String QUICKR_J2EE_PLATFORM = "QuickrJ2ee";
    public static final String QUICKR_SERVER_HOST = "quickr.server.host";
    public static final String QUICKR_SERVER_PORT = "quickr.server.port";
    public static final String QUICKR_SERVER_PROTOCOL = "quickr.server.protocol";
    public static final String QUICKR_SERVER_REST_URL_PREFIX = "quickr.server.rest.url.prefix";
    public static final String QUICKR_SERVER_IIOP_TCP_HOST = "quickr.server.iiop.tcp.host";
    public static final String QUICKR_SERVER_IIOP_TCP_PORT = "quickr.server.iiop.tcp.port";
    public static final String PROXY_QUICKR_SERVER_HOST = "proxy.quickr.server.host";
    public static final String PROXY_QUICKR_SERVER_PORT = "proxy.quickr.server.port";
    public static final String PROXY_QUICKR_SERVER_PROTOCOL = "proxy.quickr.server.protocol";
    public static final String PROXY_QUICKR_SERVER_REST_URL_PREFIX = "proxy.quickr.server.rest.url.prefix";
    private static final String QJ85_PROVIDER_CLASSNAME = "com.triloggroup.quickr.ProviderQuickrUtilJSR168Portal61";
    private static final String QPVERSION_JS_KEY = "QPVersion=";

    protected QuickrUtil() {
    }

    private static IProviderQuickrUtil getProvider(Context context) {
        if (provider == null) {
            try {
                if ((context == null || context != null && !context.isPortlet()) && QuickrUtil.isInQuickrDomino()) {
                    Class<?> clazz = Class.forName("com.triloggroup.quickr.ProviderQuickrUtilDomino");
                    provider = (IProviderQuickrUtil)clazz.newInstance();
                } else if (QuickrUtil.isIBMPortlet(context)) {
                    Class<?> clazz = Class.forName("com.triloggroup.quickr.ProviderQuickrUtilIBM");
                    provider = (IProviderQuickrUtil)clazz.newInstance();
                } else {
                    try {
                        Class<?> clazz = Class.forName("com.ibm.portal.app.service.TemplateCatalogServiceHome");
                        clazz = Class.forName(QJ85_PROVIDER_CLASSNAME);
                        provider = (IProviderQuickrUtil)clazz.newInstance();
                    }
                    catch (Throwable throwable) {
                        if (DEBUG) {
                            throwable.printStackTrace();
                        }
                        Class<?> clazz = Class.forName("com.triloggroup.quickr.ProviderQuickrUtilJSR168");
                        provider = (IProviderQuickrUtil)clazz.newInstance();
                    }
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return provider;
    }

    public static String getQuickrServerHost(Context context) {
        return QuickrUtil.getQuickrServerHost(QuickrUtil.getHttpServletRequest(context));
    }

    public static String getQuickrServerHost(HttpServletRequest httpServletRequest) {
        String string = QuickrUtil.getProjExecProperty(QUICKR_SERVER_HOST);
        if (TString.isEmpty((String)string) && httpServletRequest != null) {
            string = httpServletRequest.getServerName();
        }
        return string;
    }

    public static String getQuickrServerHostProxy(Context context) {
        return QuickrUtil.getQuickrServerHostProxy(QuickrUtil.getHttpServletRequest(context));
    }

    public static String getQuickrServerHostProxy(HttpServletRequest httpServletRequest) {
        String string = QuickrUtil.getProjExecProperty(PROXY_QUICKR_SERVER_HOST);
        if (TString.isEmpty((String)string) && httpServletRequest != null) {
            string = httpServletRequest.getServerName();
        }
        return string;
    }

    public static String getQuickrServerPort(Context context) {
        return QuickrUtil.getQuickrServerPort(QuickrUtil.getHttpServletRequest(context));
    }

    public static String getQuickrServerPort(HttpServletRequest httpServletRequest) {
        String string = QuickrUtil.getProjExecProperty(QUICKR_SERVER_PORT);
        if (TString.isEmpty((String)string) && httpServletRequest != null) {
            string = String.valueOf(httpServletRequest.getServerPort());
        }
        return string;
    }

    public static String getQuickrServerPortProxy(Context context) {
        return QuickrUtil.getQuickrServerPortProxy(QuickrUtil.getHttpServletRequest(context));
    }

    public static String getQuickrServerPortProxy(HttpServletRequest httpServletRequest) {
        String string = QuickrUtil.getProjExecProperty(PROXY_QUICKR_SERVER_PORT);
        if (TString.isEmpty((String)string) && httpServletRequest != null) {
            string = String.valueOf(httpServletRequest.getServerPort());
        }
        return string;
    }

    public static String getQuickrServerProtocol(Context context) {
        return QuickrUtil.getQuickrServerProtocol(QuickrUtil.getHttpServletRequest(context));
    }

    public static String getQuickrServerProtocol(HttpServletRequest httpServletRequest) {
        String string = QuickrUtil.getProjExecProperty(QUICKR_SERVER_PROTOCOL);
        if (TString.isEmpty((String)string) && httpServletRequest != null) {
            string = httpServletRequest.getScheme();
        }
        return string;
    }

    public static String getQuickrServerProtocolProxy(Context context) {
        return QuickrUtil.getQuickrServerProtocolProxy(QuickrUtil.getHttpServletRequest(context));
    }

    public static String getQuickrServerProtocolProxy(HttpServletRequest httpServletRequest) {
        String string = QuickrUtil.getProjExecProperty(PROXY_QUICKR_SERVER_PROTOCOL);
        if (TString.isEmpty((String)string) && httpServletRequest != null) {
            string = httpServletRequest.getScheme();
        }
        return string;
    }

    public static String getQuickrServerIiopTcpHost() {
        String string = QuickrUtil.getProjExecProperty(QUICKR_SERVER_IIOP_TCP_HOST);
        if (string == null) {
            string = "";
        }
        return string;
    }

    public static String getQuickrServerIiopTcpPort() {
        String string = QuickrUtil.getProjExecProperty(QUICKR_SERVER_IIOP_TCP_PORT);
        if (string == null) {
            string = "";
        }
        return string;
    }

    public static String getQuickrServerRestUrlPrefix() {
        return QuickrUtil.getProjExecProperty(QUICKR_SERVER_REST_URL_PREFIX);
    }

    public static String getQuickrServerRestUrlPrefixProxy() {
        return QuickrUtil.getProjExecProperty(PROXY_QUICKR_SERVER_REST_URL_PREFIX);
    }

    public static String getQuickrServerBaseUrl(Context context) {
        return QuickrUtil.getQuickrServerBaseUrl(QuickrUtil.getHttpServletRequest(context));
    }

    public static String getQuickrServerBaseUrl(HttpServletRequest httpServletRequest) {
        String string = QuickrUtil.getQuickrServerProtocol(httpServletRequest);
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append("://");
        stringBuffer.append(QuickrUtil.getQuickrServerHost(httpServletRequest));
        String string2 = QuickrUtil.getQuickrServerPort(httpServletRequest);
        if (!"80".equals(string2) && "http".equalsIgnoreCase(string) || !"443".equals(string2) && "https".equalsIgnoreCase(string)) {
            stringBuffer.append(":");
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static String getQuickrServerBaseUrlProxy(Context context) {
        return QuickrUtil.getQuickrServerBaseUrlProxy(QuickrUtil.getHttpServletRequest(context));
    }

    public static String getQuickrServerBaseUrlProxy(HttpServletRequest httpServletRequest) {
        String string = QuickrUtil.getQuickrServerProtocolProxy(httpServletRequest);
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append("://");
        stringBuffer.append(QuickrUtil.getQuickrServerHostProxy(httpServletRequest));
        String string2 = QuickrUtil.getQuickrServerPortProxy(httpServletRequest);
        if (!"80".equals(string2) && "http".equalsIgnoreCase(string) || !"443".equals(string2) && "https".equalsIgnoreCase(string)) {
            stringBuffer.append(":");
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static String getQuickrServerBaseRestUrl(Context context) {
        return QuickrUtil.getQuickrServerBaseRestUrl(QuickrUtil.getHttpServletRequest(context));
    }

    public static String getQuickrServerBaseRestUrl(HttpServletRequest httpServletRequest) {
        String string = QuickrUtil.getQuickrServerBaseUrl(httpServletRequest);
        String string2 = QuickrUtil.getQuickrServerRestUrlPrefix();
        if (!TString.isEmpty((String)string2)) {
            if (!string2.startsWith("/")) {
                string = string + "/";
            }
            string = string + string2;
        }
        return string;
    }

    public static String getQuickrServerBaseRestUrlProxy(Context context) {
        return QuickrUtil.getQuickrServerBaseRestUrlProxy(QuickrUtil.getHttpServletRequest(context));
    }

    public static String getQuickrServerBaseRestUrlProxy(HttpServletRequest httpServletRequest) {
        String string = QuickrUtil.getQuickrServerBaseUrlProxy(httpServletRequest);
        String string2 = QuickrUtil.getQuickrServerRestUrlPrefixProxy();
        if (!TString.isEmpty((String)string2)) {
            if (!string2.startsWith("/")) {
                string = string + "/";
            }
            string = string + string2;
        }
        return string;
    }

    public static String convertQuickrServerRestUrlToProxy(Context context, String string) {
        return QuickrUtil.convertQuickrServerRestUrlToProxy(QuickrUtil.getHttpServletRequest(context), string);
    }

    public static String convertQuickrServerRestUrlToProxy(HttpServletRequest httpServletRequest, String string) {
        String string2 = QuickrUtil.getQuickrServerBaseRestUrl(httpServletRequest);
        String string3 = QuickrUtil.getQuickrServerBaseRestUrlProxy(httpServletRequest);
        return QuickrUtil.convertUrl(string, string2, string3, QuickrUtil.getQuickrServerRestUrlPrefix(), QuickrUtil.getQuickrServerHost(httpServletRequest));
    }

    protected static String convertUrl(String string, String string2, String string3, String string4, String string5) {
        int n;
        int n2;
        if (TString.isEmpty((String)string) || string2.equalsIgnoreCase(string3) || string.startsWith(string3)) {
            return string;
        }
        if (!string.startsWith("http:") && !string.startsWith("https:")) {
            return string3 + string;
        }
        String string6 = null;
        if (!TString.isEmpty((String)string4) && (n2 = string.indexOf(string4)) != -1) {
            string6 = string3 + string.substring(n2 + string4.length());
        }
        if (string6 == null && (n = string.indexOf(47, (n2 = string.indexOf("://")) + 3 + string5.length())) != -1) {
            string6 = string3 + string.substring(n);
        }
        if (string6 == null) {
            System.out.println("Not able to convert Url : " + string);
            return string;
        }
        return string6;
    }

    public static String convertQuickrProxyRestUrlToServer(Context context, String string) {
        return QuickrUtil.convertQuickrProxyRestUrlToServer(QuickrUtil.getHttpServletRequest(context), string);
    }

    public static String convertQuickrProxyRestUrlToServer(HttpServletRequest httpServletRequest, String string) {
        String string2 = QuickrUtil.getQuickrServerBaseRestUrl(httpServletRequest);
        String string3 = QuickrUtil.getQuickrServerBaseRestUrlProxy(httpServletRequest);
        String string4 = QuickrUtil.convertUrl(string, string3, string2, QuickrUtil.getQuickrServerRestUrlPrefixProxy(), QuickrUtil.getQuickrServerHostProxy(httpServletRequest));
        return string4;
    }

    public static String convertQuickrServerUrlToProxy(Context context, String string) {
        return QuickrUtil.convertQuickrServerUrlToProxy(QuickrUtil.getHttpServletRequest(context), string);
    }

    public static String convertQuickrServerUrlToProxy(HttpServletRequest httpServletRequest, String string) {
        String string2 = QuickrUtil.getQuickrServerBaseUrl(httpServletRequest);
        String string3 = QuickrUtil.getQuickrServerBaseUrlProxy(httpServletRequest);
        String string4 = QuickrUtil.convertUrl(string, string2, string3, null, QuickrUtil.getQuickrServerHost(httpServletRequest));
        return string4;
    }

    public static String convertQuickrProxyUrlToServer(Context context, String string) {
        return QuickrUtil.convertQuickrProxyRestUrlToServer(QuickrUtil.getHttpServletRequest(context), string);
    }

    public static String convertQuickrProxyUrlToServer(HttpServletRequest httpServletRequest, String string) {
        String string2 = QuickrUtil.getQuickrServerBaseUrl(httpServletRequest);
        String string3 = QuickrUtil.getQuickrServerBaseUrlProxy(httpServletRequest);
        String string4 = QuickrUtil.convertUrl(string, string3, string2, null, QuickrUtil.getQuickrServerHostProxy(httpServletRequest));
        return string4;
    }

    public static boolean isInQuickr() {
        return QuickrUtil.isInQuickrJ2ee() || QuickrUtil.isInQuickrDomino();
    }

    public static boolean isInQuickrJ2ee() {
        if (isInQuickrJ2ee == -1) {
            File file;
            Object object;
            block11: {
                String string = QuickrUtil.getProjExecProperty(CURRENT_PLATFORM_KEY);
                if (!TString.isEmpty((String)string)) {
                    if (string.startsWith(QUICKR_J2EE_PLATFORM)) {
                        isInQuickrJ2ee = 1;
                        return true;
                    }
                    isInQuickrJ2ee = 0;
                    return false;
                }
                String string2 = System.getProperty("portal.properties.dir");
                if (!TString.isEmpty((String)string2)) {
                    try {
                        object = new File(string2);
                        if (((File)object).exists() && ((File)object).isDirectory() && (file = new File(((File)object).getParent(), "wcm/shared/app/config/wcmservices/WCMConfigService.properties")).exists()) {
                            Properties properties = new Properties();
                            properties.load(new FileInputStream(file));
                            String string3 = (String)properties.get("quickr.installation");
                            if (TString.equalsIgnoreCase((String)string3, (String)"true")) {
                                isInQuickrJ2ee = 1;
                                return true;
                            }
                            isInQuickrJ2ee = 0;
                            return false;
                        }
                    }
                    catch (Exception exception) {
                        if (!DEBUG) break block11;
                        exception.printStackTrace();
                    }
                }
            }
            object = Application.get().getVFS();
            file = object.getSystemBaseDirectory();
            try {
                File file2;
                String string = file.getCanonicalPath();
                int n = string.lastIndexOf(File.separatorChar);
                if (n != -1 && (n = (string = string.substring(0, n)).lastIndexOf(File.separatorChar)) != -1 && (n = (string = string.substring(0, n)).lastIndexOf(File.separatorChar)) != -1 && (file2 = new File(string.substring(0, n), "QPG")).exists()) {
                    isInQuickrJ2ee = 1;
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            isInQuickrJ2ee = 0;
            return false;
        }
        return isInQuickrJ2ee == 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isInQuickrJ2ee85(Context context) {
        if (!QuickrUtil.isInQuickrJ2ee()) return false;
        IProviderQuickrUtil iProviderQuickrUtil = QuickrUtil.getProvider(context);
        if (iProviderQuickrUtil == null) {
            try {
                Class<?> clazz = Class.forName("com.ibm.portal.app.service.TemplateCatalogServiceHome");
                return true;
            }
            catch (Throwable throwable) {
                if (!DEBUG) return false;
                throwable.printStackTrace();
                return false;
            }
        } else {
            if (!QJ85_PROVIDER_CLASSNAME.equals(iProviderQuickrUtil.getClass().getName())) return false;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInQuickrDomino() {
        if (isInQuickrDomino == -1) {
            block23: {
                String string = QuickrUtil.getProjExecProperty(CURRENT_PLATFORM_KEY);
                if (!TString.isEmpty((String)string)) {
                    if (string.startsWith(QUICKR_DOMINO_PLATFORM)) {
                        isInQuickrDomino = 1;
                        return true;
                    }
                    isInQuickrDomino = 0;
                    return false;
                }
                try {
                    Object object;
                    VFS vFS = Application.get().getVFS();
                    File file = vFS.getSystemBaseDirectory();
                    String string2 = file.getCanonicalPath();
                    int n = string2.lastIndexOf(File.separatorChar);
                    if (n == -1 || !(string2 = string2.substring(0, n)).endsWith(File.separatorChar + "xsp")) break block23;
                    n = string2.lastIndexOf(File.separatorChar);
                    File file2 = new File(string2 = string2.substring(0, n), "notes.ini");
                    if (!file2.isFile()) {
                        return false;
                    }
                    String string3 = "Directory=";
                    String string4 = "QuickPlaceSubdirectory=";
                    File file3 = null;
                    String string5 = null;
                    BufferedReader bufferedReader = null;
                    try {
                        bufferedReader = new BufferedReader(new FileReader(file2));
                        while ((object = bufferedReader.readLine()) != null) {
                            if (((String)object).startsWith(string4)) {
                                string5 = ((String)object).substring(string4.length());
                            } else if (((String)object).startsWith(string3)) {
                                String string6 = ((String)object).substring(string3.length());
                                file3 = new File(string6);
                            }
                            if (string5 == null || file3 == null) continue;
                            break;
                        }
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        if (bufferedReader != null) {
                            try {
                                bufferedReader.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    if (file3 != null && file3.exists() && string5 != null && ((File)(object = new File(file3, string5))).exists()) {
                        isInQuickrDomino = 1;
                        return true;
                    }
                }
                catch (Throwable throwable) {
                    System.out.println("Cannot check is Quickr Domino " + throwable.getMessage());
                    if (!DEBUG) break block23;
                    throwable.printStackTrace();
                }
            }
            isInQuickrDomino = 0;
            return false;
        }
        return isInQuickrDomino == 1;
    }

    public static boolean isInQuickrDomino85(Context context) {
        return QuickrUtil.isInQuickrDomino85(new XSPServiceConnector(context), QuickrUtil.getQuickrServerBaseRestUrl(context), QuickrUtil.getQuickrServerBaseUrl(context));
    }

    public static boolean isInQuickrDomino85(IServiceConnector iServiceConnector, String string, String string2) {
        if (QuickrUtil.isInQuickrDomino()) {
            isInQuickrDomino85 = 1;
            if (isInQuickrDomino85 == -1) {
                String string3 = null;
                try {
                    string3 = QuickrUtil.getQuickrDominoVersion(iServiceConnector, string);
                    TDiag.println((String)("QD Version from generator tag = " + string3));
                    if (!TString.isEmpty((String)string3)) {
                        isInQuickrDomino85 = QuickrUtil.compareVersionNumber(string3, "8.5.0") < 0 ? 0 : 1;
                    }
                }
                catch (Exception exception) {
                    TDiag.println((String)"Could not get QD version from generator tag");
                }
                if (string3 == null) {
                    try {
                        string3 = QuickrUtil.getQuickrDominoVersionFromClientPage(iServiceConnector, string2);
                        TDiag.println((String)("QD Version from client page = " + string3));
                        if (!TString.isEmpty((String)string3)) {
                            isInQuickrDomino85 = QuickrUtil.compareVersionNumber(string3, "850000.000000") < 0 ? 0 : 1;
                        }
                    }
                    catch (Exception exception) {
                        TDiag.println((String)"Could not get QD Version from client page");
                    }
                }
            }
            return isInQuickrDomino85 == 1;
        }
        return false;
    }

    private static String getQuickrDominoVersion(IServiceConnector iServiceConnector, String string) throws Exception {
        UService uService = new UService();
        String string2 = string + "/myqcs/rest/places/feed?pageSize=1&page=1&filter=all";
        Document document = uService.callService(string2, iServiceConnector, null);
        if (document == null || document.getRootElement() == null) {
            return null;
        }
        Element element = document.getRootElement();
        Element element2 = element.getChild("generator", UService.atomNs);
        if (element2 != null) {
            String string3 = element2.getText();
            for (int i = 0; i < string3.length(); ++i) {
                char c = string3.charAt(i);
                if (!Character.isDigit(c)) continue;
                return string3.substring(i).trim();
            }
        } else {
            return "8.2";
        }
        return null;
    }

    private static String getQuickrDominoVersionFromClientPage(IServiceConnector iServiceConnector, String string) throws Exception {
        int n;
        UService uService = new UService();
        String string2 = string + "/LotusQuickr/lotusquickr/main.nsf";
        String string3 = uService.callUrl(string2, iServiceConnector, true);
        if (!TString.isEmpty((String)string3) && (n = string3.indexOf(QPVERSION_JS_KEY)) != -1) {
            for (int i = n += QPVERSION_JS_KEY.length(); i < string3.length(); ++i) {
                char c = string3.charAt(i);
                if (Character.isDigit(c) || c == '.') continue;
                return string3.substring(n, i).trim();
            }
        }
        return null;
    }

    private static int compareVersionNumber(String string, String string2) {
        if (string == null) {
            return string2 == null ? 0 : -1;
        }
        if (string2 == null) {
            return 1;
        }
        int n = string.length();
        int n2 = string2.length();
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            char c;
            char c2 = string.charAt(i);
            if (c2 == (c = string2.charAt(i))) continue;
            if (c2 == '.') {
                return -1;
            }
            if (c == '.') {
                return 1;
            }
            int n4 = c2 - c;
            while (i < n3) {
                c2 = string.charAt(i);
                c = string2.charAt(i);
                if (c2 == '.') {
                    return c == '.' ? n4 : -1;
                }
                if (c == '.') {
                    return 1;
                }
                ++i;
            }
            if (n == n2) {
                return n4;
            }
            if (n > n2) {
                return string.charAt(i) == '.' ? n4 : 1;
            }
            return string2.charAt(i) == '.' ? n4 : -1;
        }
        return n - n2;
    }

    public static String getProjExecProperty(String string) {
        return LotusUtil.get().getProjExecProperty(string);
    }

    public static boolean isIBMPortlet(Context context) {
        return LotusUtil.get().isIBMPortlet(context);
    }

    public static boolean addMemberToCurrentTeamSpace(Context context, String string) {
        return QuickrUtil.getProvider(context).addMemberToCurrentTeamSpace(context, string);
    }

    public static boolean addMemberWithRoleToCurrentTeamSpace(Context context, String string, String string2) {
        return QuickrUtil.getProvider(context).addMemberWithRoleToCurrentTeamSpace(context, string, string2);
    }

    public static boolean addMemberToTeamSpace(Context context, String string, String string2) {
        return QuickrUtil.getProvider(context).addMemberToTeamSpace(context, string, string2);
    }

    public static boolean addMemberWithRoleToTeamSpace(Context context, String string, String string2, String string3) {
        return QuickrUtil.getProvider(context).addMemberWithRoleToTeamSpace(context, string, string2, string3);
    }

    public static boolean addMemberWithRoleToTeamSpace(IServiceConnector iServiceConnector, String string, String string2, String string3) {
        return QuickrUtil.getProvider(null).addMemberWithRoleToTeamSpace(iServiceConnector, string, string2, string3);
    }

    public static boolean removeMemberOfCurrentTeamSpace(Context context, String string) {
        return QuickrUtil.getProvider(context).removeMemberOfCurrentTeamSpace(context, string);
    }

    public static boolean removeMemberOfTeamSpace(Context context, String string, String string2) {
        return QuickrUtil.getProvider(context).removeMemberOfTeamSpace(context, string, string2);
    }

    public static String[] getAllMembersDnOfCurrentTeamSpace(Context context) {
        return QuickrUtil.getProvider(context).getAllMembersDnOfCurrentTeamSpace(context);
    }

    public static String[] getAllMembersDnByRoleOfCurrentTeamSpace(Context context, String string) {
        return QuickrUtil.getProvider(context).getAllMembersDnByRoleOfCurrentTeamSpace(context, string);
    }

    public static HashMap getAllMembersDnAndRolesOfCurrentTeamSpace(Context context) {
        return QuickrUtil.getProvider(context).getAllMembersDnAndRolesOfCurrentTeamSpace(context);
    }

    public static HashMap getAllMembersDnAndRolesOfTeamSpace(Context context, String string) {
        return QuickrUtil.getProvider(context).getAllMembersDnAndRolesOfTeamSpace(context, string);
    }

    public static IProviderQuickrUtil.QuickrRole[] getRolesOfPlace(Context context, String string) {
        return QuickrUtil.getProvider(context).getRolesOfPlace(context, string);
    }

    public static String[] getRoleIdsOfPlace(IServiceConnector iServiceConnector, String string) {
        return QuickrUtil.getProvider(null).getRoleIdsOfPlace(iServiceConnector, string);
    }

    public static IProviderQuickrUtil.QuickrRole getRoleOfPlaceById(Context context, String string, String string2) {
        return QuickrUtil.getProvider(context).getRoleOfPlaceById(context, string, string2);
    }

    public static IProviderQuickrUtil.QuickrRole getMemberRoleOfPlace(Context context, String string, String string2) {
        return QuickrUtil.getProvider(context).getMemberRoleOfPlace(context, string, string2);
    }

    public static IProviderQuickrUtil.QuickrRole getMemberRoleOfCurrentPlace(Context context, String string) {
        return QuickrUtil.getProvider(context).getMemberRoleOfCurrentPlace(context, string);
    }

    public static String getCurrentTeamSpaceId(Context context) {
        return QuickrUtil.getProvider(context).getCurrentTeamSpaceId(context);
    }

    public static String[] getAllTeamSpaceIds(Context context) {
        return QuickrUtil.getProvider(context).getAllTeamSpaceIds(context);
    }

    public static String getCurrentTeamSpaceMetaDataValue(Context context, String string) {
        return QuickrUtil.getProvider(context).getCurrentTeamSpaceMetaDataValue(context, string);
    }

    public static String getCurrentDocumentLibraryHrefId(Context context) {
        return QuickrUtil.getDocumentLibraryHrefIdOfTeamSpace(context, QuickrUtil.getCurrentTeamSpaceId(context));
    }

    public static String getDocumentLibraryHrefIdOfTeamSpace(Context context, String string) {
        return QuickrUtil.getProvider(context).getDocumentLibraryHrefIdOfTeamSpace(context, string);
    }

    public static HttpServletRequest getHttpServletRequest(Context context) {
        return LotusUtil.get().getHttpServletRequest(context);
    }

    static {
        isInQuickrJ2ee = -1;
        isInQuickrDomino = -1;
        isInQuickrDomino85 = -1;
        DEBUG = false;
    }
}

