/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.lotus.atom.cmis;

import com.flowbuilder.lib.JDom;
import com.flowbuilder.lib.NamespaceContext;
import com.triloggroup.lotus.atom.cmis.CmisConnection;
import java.util.HashMap;
import org.jdom.Document;
import org.jdom.Element;

public class CmisRepository {
    public String name;
    public String rootUrl;
    private String id;
    private String rootFolderId;
    private String queryCollectionUrl;
    private HashMap<UriTemplateType, String> uriTemplates;

    public String getId() {
        return this.id;
    }

    public String getRootFolderId() {
        return this.rootFolderId;
    }

    public void init(CmisConnection cmisConnection) throws Exception {
        Document document = cmisConnection.callService(cmisConnection.getCmisServiceDocUrl(), cmisConnection.getServiceConnector());
        this.initFromXml(document);
    }

    private void initFromXml(Document document) throws Exception {
        Element element = document.getRootElement();
        if (element == null) {
            throw new Exception("Document is empty");
        }
        Element element2 = element.getChild("workspace", CmisConnection.appNs);
        Element element3 = element2.getChild("repositoryInfo", CmisConnection.CMISRA_NS);
        this.name = element3.getChildText("repositoryName", CmisConnection.CMIS_NS);
        this.id = element3.getChildText("repositoryId", CmisConnection.CMIS_NS);
        this.rootFolderId = element3.getChildText("rootFolderId", CmisConnection.CMIS_NS);
        this.rootUrl = JDom.getStringValue((Element)element2, (String)"app:collection[cmisra:collectionType='root']/@href", (NamespaceContext)CmisConnection.NS_CONTEXT);
        this.queryCollectionUrl = JDom.getStringValue((Element)element2, (String)"app:collection[cmisra:collectionType='query']/@href", (NamespaceContext)CmisConnection.NS_CONTEXT);
        this.uriTemplates = new HashMap();
        for (UriTemplateType uriTemplateType : UriTemplateType.values()) {
            String string = JDom.getStringValue((Element)element2, (String)("cmisra:uritemplate[cmisra:type='" + uriTemplateType.type + "']/cmisra:template"), (NamespaceContext)CmisConnection.NS_CONTEXT);
            this.uriTemplates.put(uriTemplateType, string);
        }
    }

    String getQueryCollectionUrl() {
        return this.queryCollectionUrl;
    }

    String getUriTemplate(UriTemplateType uriTemplateType) {
        return this.uriTemplates.get((Object)uriTemplateType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum UriTemplateType {
        OBJECT_BY_ID("objectbyid"),
        OBJECT_BY_PATH("objectbypath"),
        QUERY("query");

        private final String type;

        private UriTemplateType(String string2) {
            this.type = string2;
        }
    }
}

