/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.lotus.atom.cmis;

import com.flowbuilder.lib.JDom;
import com.flowbuilder.lib.NamespaceContext;
import com.flowbuilder.util.TString;
import com.flowbuilder.util.io.Base64;
import com.triloggroup.lotus.atom.Entry;
import com.triloggroup.lotus.atom.cmis.CmisConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.jdom.Element;

public class CmisEntry
extends Entry {
    public String cmisContentUrl;
    public String cmisObjectId;
    public String cmisBaseTypeId;
    public String cmisTypeId;
    public String cmisParentId;
    public String cmisPath;
    public String cmisContentMimeType;
    public String cmisContentFileName;
    public long cmisContentLength;
    public String aclAccessorUrl;
    private static final int BUFFER_SIZE = 65536;

    public boolean isFile() {
        return "cmis:document".equals(this.cmisBaseTypeId);
    }

    public boolean isFolder() {
        return "cmis:folder".equals(this.cmisBaseTypeId);
    }

    public void initEntryFromXml(Element element) {
        super.initEntryFromXml(element);
        try {
            Element element2 = element.getChild("object", CmisConnection.CMISRA_NS);
            Element element3 = element2.getChild("properties", CmisConnection.CMIS_NS);
            this.cmisObjectId = JDom.getStringValue((Element)element3, (String)"cmis:propertyId[@propertyDefinitionId='cmis:objectId']/cmis:value", (NamespaceContext)CmisConnection.NS_CONTEXT);
            this.cmisTypeId = JDom.getStringValue((Element)element3, (String)"cmis:propertyId[@propertyDefinitionId='cmis:objectTypeId']/cmis:value", (NamespaceContext)CmisConnection.NS_CONTEXT);
            this.cmisBaseTypeId = JDom.getStringValue((Element)element3, (String)"cmis:propertyId[@propertyDefinitionId='cmis:baseTypeId']/cmis:value", (NamespaceContext)CmisConnection.NS_CONTEXT);
            if (this.isFolder()) {
                this.cmisContentUrl = JDom.getStringValue((Element)element, (String)"atom:link[@rel='down']/@href", (NamespaceContext)CmisConnection.NS_CONTEXT);
                this.cmisParentId = JDom.getStringValue((Element)element3, (String)"cmis:propertyId[@propertyDefinitionId='cmis:parentId']/cmis:value", (NamespaceContext)CmisConnection.NS_CONTEXT);
                this.cmisPath = JDom.getStringValue((Element)element3, (String)"cmis:propertyString[@propertyDefinitionId='cmis:path']/cmis:value", (NamespaceContext)CmisConnection.NS_CONTEXT);
            } else if (this.isFile()) {
                this.cmisContentUrl = JDom.getStringValue((Element)element, (String)"atom:content/@src", (NamespaceContext)CmisConnection.NS_CONTEXT);
                this.cmisContentFileName = JDom.getStringValue((Element)element3, (String)"cmis:propertyString[@propertyDefinitionId='cmis:contentStreamFileName']/cmis:value", (NamespaceContext)CmisConnection.NS_CONTEXT);
                this.cmisContentMimeType = JDom.getStringValue((Element)element3, (String)"cmis:propertyString[@propertyDefinitionId='cmis:contentStreamMimeType']/cmis:value", (NamespaceContext)CmisConnection.NS_CONTEXT);
                this.cmisContentLength = JDom.getIntValue((Element)element3, (String)"cmis:propertyInteger[@propertyDefinitionId='cmis:contentStreamLength']/cmis:value", (NamespaceContext)CmisConnection.NS_CONTEXT);
            }
        }
        catch (Exception exception) {
            System.out.println("Unable to read cmis entry");
            try {
                System.out.println(JDom.getXMLString((Element)element));
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new IllegalStateException("Cannot read CmisEntry");
        }
    }

    protected void setLinkUrl(String string, String string2, String string3) {
        super.setLinkUrl(string, string2, string3);
        if (TString.equals((String)string2, (String)"http://docs.oasis-open.org/ns/cmis/link/200908/acl")) {
            this.aclAccessorUrl = string;
        }
    }

    public void dump(PrintWriter printWriter, String string) {
        super.dump(printWriter, string);
        if (string == null) {
            string = "";
        }
        printWriter.println(string + "cmisId=" + this.cmisObjectId);
        printWriter.println(string + "cmisTypeId=" + this.cmisTypeId);
        printWriter.println(string + "cmisBaseTypeId=" + this.cmisBaseTypeId);
        printWriter.println(string + "cmisContentUrl=" + this.cmisContentUrl);
        printWriter.println(string + "aclAccessorUrl=" + this.aclAccessorUrl);
        if (this.isFile()) {
            printWriter.println(string + "cmisContentFileName=" + this.cmisContentFileName);
            printWriter.println(string + "cmisContentMimeType=" + this.cmisContentMimeType);
            printWriter.println(string + "cmisContentLength=" + this.cmisContentLength);
        } else if (this.isFolder()) {
            printWriter.println(string + "cmisPath=" + this.cmisPath);
            printWriter.println(string + "cmisParentId=" + this.cmisParentId);
        }
        printWriter.flush();
    }

    public void writeXmlEntryAtom(Writer writer) throws IOException {
        this.writeXmlEntryAtom(writer, null, null);
    }

    public void writeXmlEntryAtom(Writer writer, String string, InputStream inputStream) throws IOException {
        String string2 = this.title == null ? "" : TString.toXMLString((String)this.title);
        writer.write("<atom:entry xmlns:atom=\"http://www.w3.org/2005/Atom\" xmlns:cmis=\"http://docs.oasis-open.org/ns/cmis/core/200908/\" xmlns:cmisra=\"http://docs.oasis-open.org/ns/cmis/restatom/200908/\">");
        if (!TString.isEmpty((String)this.cmisObjectId)) {
            writer.write("<atom:id>");
            writer.write(TString.toXMLString((String)this.cmisObjectId));
            writer.write("</atom:id>");
        }
        writer.write("<atom:title>");
        writer.write(string2);
        writer.write("</atom:title>");
        String string3 = TString.toXMLString((String)CmisEntry.getUpdated());
        writer.write("<atom:updated>");
        writer.write(string3);
        writer.write("</atom:updated>");
        if (inputStream != null) {
            String string4 = string.toLowerCase();
            if (string4.endsWith("+xml") || string4.endsWith("/xml")) {
                string4 = "application/binary";
                string = "application/binary";
            }
            writer.write("<atom:content type=\"");
            writer.write(TString.toXMLString((String)string));
            writer.write("\">");
            if (string4.equals("text")) {
                this.writeContentText(inputStream, writer);
            } else if (string4.equals("html")) {
                this.writeContentText(inputStream, writer);
            } else if (string4.equals("xhtml")) {
                this.writeContentText(inputStream, writer);
            } else if (string4.endsWith("+xml") || string4.endsWith("/xml")) {
                this.writeContentBase64(inputStream, writer);
            } else if (string4.startsWith("text/")) {
                this.writeContentBase64(inputStream, writer);
            } else {
                this.writeContentBase64(inputStream, writer);
            }
            writer.write("</atom:content>");
        }
        writer.write("<cmisra:object xmlns:ns3=\"http://docs.oasis-open.org/ns/cmis/messaging/200908/\">");
        writer.write("<cmis:properties>");
        if (!TString.isEmpty((String)this.cmisObjectId)) {
            writer.write("<cmis:propertyId propertyDefinitionId=\"cmis:objectId\">");
            writer.write("<cmis:value>");
            writer.write(TString.toXMLString((String)this.cmisObjectId));
            writer.write("</cmis:value>");
            writer.write("</cmis:propertyId>");
        }
        writer.write("<cmis:propertyId propertyDefinitionId=\"cmis:objectTypeId\">");
        writer.write("<cmis:value>");
        writer.write(TString.toXMLString((String)this.cmisTypeId));
        writer.write("</cmis:value>");
        writer.write("</cmis:propertyId>");
        if (!TString.isEmpty((String)this.cmisBaseTypeId)) {
            writer.write("<cmis:propertyId propertyDefinitionId=\"cmis:baseTypeId\">");
            writer.write("<cmis:value>");
            writer.write(TString.toXMLString((String)this.cmisBaseTypeId));
            writer.write("</cmis:value>");
            writer.write("</cmis:propertyId>");
        }
        writer.write("<cmis:propertyString propertyDefinitionId=\"cmis:name\">");
        writer.write("<cmis:value>");
        writer.write(string2);
        writer.write("</cmis:value>");
        writer.write("</cmis:propertyString>");
        writer.write("</cmis:properties>");
        writer.write("</cmisra:object>");
        writer.write("</atom:entry>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeContentBase64(InputStream inputStream, Writer writer) throws IOException {
        try {
            int n;
            Base64.InputStream inputStream2 = new Base64.InputStream(inputStream, true);
            byte[] byArray = new byte[65536];
            while ((n = inputStream2.read(byArray)) > -1) {
                if (n <= 0) continue;
                writer.write(new String(byArray, 0, n, "US-ASCII"));
            }
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeContentText(InputStream inputStream, Writer writer) throws IOException {
        try {
            int n;
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            char[] cArray = new char[65536];
            while ((n = inputStreamReader.read(cArray)) > -1) {
                if (n <= 0) continue;
                String string = new String(cArray, 0, n);
                writer.write(TString.toXMLString((String)string));
            }
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertXmlContent(InputStream inputStream, Writer writer) throws IOException {
        try {
            int n;
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            char[] cArray = new char[65536];
            while ((n = inputStreamReader.read(cArray)) > -1) {
                if (n <= 0) continue;
                writer.write(cArray, 0, n);
            }
        }
        finally {
            inputStream.close();
        }
    }

    public String toXmlEntryAtom() {
        StringWriter stringWriter = new StringWriter();
        try {
            this.writeXmlEntryAtom(stringWriter);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return stringWriter.toString();
    }

    public String toString() {
        return this.title + '@' + this.cmisObjectId;
    }

    private static String getUpdated() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return simpleDateFormat.format(new Date());
    }
}

