/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.lotus.atom.cmis;

import com.flowbuilder.lib.JDom;
import com.flowbuilder.lib.NamespaceContext;
import com.flowbuilder.util.TString;
import com.triloggroup.lotus.IServiceConnector;
import com.triloggroup.lotus.ServiceException;
import com.triloggroup.lotus.UService;
import com.triloggroup.lotus.atom.AbstractConnection;
import com.triloggroup.lotus.atom.cmis.CmisContentAlreadyExistsException;
import com.triloggroup.lotus.atom.cmis.CmisEntry;
import com.triloggroup.lotus.atom.cmis.CmisException;
import com.triloggroup.lotus.atom.cmis.CmisPermission;
import com.triloggroup.lotus.atom.cmis.CmisRepository;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;

public class CmisConnection
extends AbstractConnection {
    private static final String CMISRA_NSPREFIX = "cmisra";
    private static final String CMISRA_NSURI = "http://docs.oasis-open.org/ns/cmis/restatom/200908/";
    static final Namespace CMISRA_NS = Namespace.getNamespace((String)"cmisra", (String)"http://docs.oasis-open.org/ns/cmis/restatom/200908/");
    private static final String CMIS_NSPREFIX = "cmis";
    private static final String CMIS_NSURI = "http://docs.oasis-open.org/ns/cmis/core/200908/";
    static final Namespace CMIS_NS = Namespace.getNamespace((String)"cmis", (String)"http://docs.oasis-open.org/ns/cmis/core/200908/");
    private static final String LCMIS_NSPREFIX = "lcmis";
    private static final String LCMIS_NSURI = "http://www.ibm.com/xmlns/prod/sn/cmis";
    static final Namespace LCMIS_NS = Namespace.getNamespace((String)"lcmis", (String)"http://www.ibm.com/xmlns/prod/sn/cmis");
    static final NamespaceContext NS_CONTEXT = new NamespaceContext();
    private CmisRepository repository;

    public CmisConnection(IServiceConnector iServiceConnector) {
        super(iServiceConnector);
    }

    protected String getCmisServiceDocUrl() {
        return this.getCmisBaseUrl() + "/my/servicedoc";
    }

    protected String getCmisBaseUrl() {
        String string = this.getServiceConnector().getBaseUrl();
        if (!string.endsWith("/")) {
            string = string + '/';
        }
        return string + this.getCmisContextPath();
    }

    protected String getCmisContextPath() {
        return "files/basic/cmis";
    }

    public void init() throws Exception {
        CmisRepository cmisRepository = new CmisRepository();
        cmisRepository.init(this);
        this.repository = cmisRepository;
    }

    public CmisRepository getRepository() {
        return this.repository;
    }

    public CmisEntry[] getFolderContent(CmisEntry cmisEntry) throws Exception {
        String string = cmisEntry == null ? this.repository.rootUrl : cmisEntry.cmisContentUrl;
        Document document = this.callService(string, this.serviceConnector, null);
        Element element = document.getRootElement();
        List list = element.getChildren("entry", UService.atomNs);
        CmisEntry[] cmisEntryArray = new CmisEntry[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            CmisEntry cmisEntry2 = new CmisEntry();
            cmisEntry2.initEntryFromXml((Element)list.get(i));
            cmisEntryArray[i] = cmisEntry2;
        }
        return cmisEntryArray;
    }

    public CmisEntry getObjectById(String string) throws Exception {
        if (string == null) {
            string = this.repository.getRootFolderId();
        }
        String string2 = this.repository.getUriTemplate(CmisRepository.UriTemplateType.OBJECT_BY_ID);
        string2 = TString.replace((String)string2, (String)"{id}", (String)URLEncoder.encode(string, "UTF-8"));
        string2 = TString.replace((String)string2, (String)"{filter}", (String)"");
        string2 = TString.replace((String)string2, (String)"{includeAllowableActions}", (String)"false");
        string2 = TString.replace((String)string2, (String)"{includePolicyIds}", (String)"false");
        string2 = TString.replace((String)string2, (String)"{includeRelationships}", (String)"false");
        string2 = TString.replace((String)string2, (String)"{includeACL}", (String)"false");
        string2 = TString.replace((String)string2, (String)"{renditionFilter}", (String)"false");
        Document document = this.callService(string2, this.serviceConnector, null);
        CmisEntry cmisEntry = new CmisEntry();
        cmisEntry.initEntryFromXml(document.getRootElement());
        return cmisEntry;
    }

    public CmisEntry getObjectByPath(String string, String string2) throws Exception {
        String string3 = string;
        string3 = TString.replace((String)string3, (String)"{path}", (String)URLEncoder.encode(string2, "UTF-8"));
        string3 = TString.replace((String)string3, (String)"{filter}", (String)"");
        string3 = TString.replace((String)string3, (String)"{includeAllowableActions}", (String)"false");
        string3 = TString.replace((String)string3, (String)"{includePolicyIds}", (String)"false");
        string3 = TString.replace((String)string3, (String)"{includeRelationships}", (String)"false");
        string3 = TString.replace((String)string3, (String)"{includeACL}", (String)"false");
        string3 = TString.replace((String)string3, (String)"{renditionFilter}", (String)"false");
        try {
            Document document = this.callService(string3, this.serviceConnector, null);
            CmisEntry cmisEntry = new CmisEntry();
            cmisEntry.initEntryFromXml(document.getRootElement());
            return cmisEntry;
        }
        catch (ServiceException serviceException) {
            if (serviceException.getErrorCode() == 404) {
                return null;
            }
            throw serviceException;
        }
    }

    public CmisEntry getObjectByPath(String string) throws Exception {
        String string2 = this.repository.getUriTemplate(CmisRepository.UriTemplateType.OBJECT_BY_PATH);
        return this.getObjectByPath(string2, string);
    }

    public CmisEntry getObjectByEntryUrl(String string) throws Exception {
        Document document = this.callService(string, this.serviceConnector, null);
        CmisEntry cmisEntry = new CmisEntry();
        cmisEntry.initEntryFromXml(document.getRootElement());
        return cmisEntry;
    }

    public CmisEntry getUserFileByName(String string) throws Exception {
        return this.getObjectByPath("/files/" + string);
    }

    public CmisEntry getCommunityFileByName(String string, String string2) throws Exception {
        String string3 = this.getCmisBaseUrl() + "/repository/co!file!" + string + "/objectp?p={path}";
        return this.getObjectByPath(string3, "/files/" + string2);
    }

    public CmisEntry createFolder(CmisEntry cmisEntry, String string) throws Exception {
        String string2 = cmisEntry.cmisContentUrl;
        CmisEntry cmisEntry2 = new CmisEntry();
        cmisEntry2.title = string;
        cmisEntry2.cmisContentFileName = string;
        cmisEntry2.cmisTypeId = "snx:collection";
        cmisEntry2.id = cmisEntry2.cmisObjectId;
        String string3 = cmisEntry2.toXmlEntryAtom();
        string3 = "<?xml version='1.0' encoding='UTF-8'?>\n" + string3;
        byte[] byArray = string3.getBytes("UTF-8");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Document document = this.callService(string2, this.serviceConnector, string, byteArrayInputStream, "application/atom+xml;type=entry");
        if (document == null) {
            return null;
        }
        CmisEntry cmisEntry3 = new CmisEntry();
        cmisEntry3.initEntryFromXml(document.getRootElement());
        return cmisEntry3;
    }

    public boolean doesEntryExist(String string) {
        try {
            Document document = this.callService(string, this.serviceConnector);
            if (document == null || document.getRootElement() == null) {
                return false;
            }
            System.out.println(JDom.getXMLString((Document)document));
            CmisEntry cmisEntry = new CmisEntry();
            cmisEntry.initEntryFromXml(document.getRootElement());
            return cmisEntry.cmisObjectId != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public CmisEntry createDocumentForCommunity(String string, String string2, String string3, InputStream inputStream) throws Exception {
        String string4 = this.getCmisBaseUrl() + "/repository/co!file!" + string;
        return this.createDocumentImpl(string4, string2, string3, inputStream);
    }

    public CmisEntry createDocumentForUser(String string, String string2, String string3, InputStream inputStream) throws Exception {
        String string4 = this.getCmisBaseUrl() + "/repository/p!" + string;
        return this.createDocumentImpl(string4, string2, string3, inputStream);
    }

    public CmisEntry createDocumentForCurrentUser(String string, String string2, InputStream inputStream) throws Exception {
        String string3 = this.getCmisBaseUrl() + "/repository/" + this.repository.getId();
        return this.createDocumentImpl(string3, string, string2, inputStream);
    }

    private CmisEntry createDocumentImpl(String string, String string2, String string3, InputStream inputStream) throws Exception {
        String string4 = string + "/folderc/snx:files";
        try {
            return this.createDocument(string4, string2, string3, inputStream);
        }
        catch (CmisContentAlreadyExistsException cmisContentAlreadyExistsException) {
            String string5 = string + "/objectp?p={path}";
            CmisEntry cmisEntry = this.getObjectByPath(string5, "/files/" + string2);
            cmisContentAlreadyExistsException.setRepositoryEntry(cmisEntry);
            throw cmisContentAlreadyExistsException;
        }
    }

    public CmisEntry createDocument(CmisEntry cmisEntry, String string, String string2, InputStream inputStream) throws Exception {
        try {
            return this.createDocument(cmisEntry.cmisContentUrl, string, string2, inputStream);
        }
        catch (CmisContentAlreadyExistsException cmisContentAlreadyExistsException) {
            if (cmisContentAlreadyExistsException.getRepositoryEntry() == null) {
                cmisContentAlreadyExistsException.setRepositoryEntry(this.getObjectByPath(cmisEntry.cmisPath + '/' + string));
            }
            throw cmisContentAlreadyExistsException;
        }
    }

    protected CmisEntry createDocument(String string, String string2, String string3, InputStream inputStream) throws Exception {
        try {
            if (TString.isEmpty((String)string3)) {
                string3 = "application/octet-stream";
            }
            CmisEntry cmisEntry = new CmisEntry();
            cmisEntry.title = string2;
            cmisEntry.cmisContentFileName = string2;
            cmisEntry.cmisTypeId = "snx:file";
            cmisEntry.id = cmisEntry.cmisObjectId;
            cmisEntry.cmisContentMimeType = string3;
            StringWriter stringWriter = new StringWriter();
            stringWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            cmisEntry.writeXmlEntryAtom(stringWriter, string3, inputStream);
            byte[] byArray = stringWriter.toString().getBytes("UTF-8");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            Document document = this.callService(string, this.serviceConnector, string2, byteArrayInputStream, "application/atom+xml;type=entry");
            if (document == null) {
                return null;
            }
            CmisEntry cmisEntry2 = new CmisEntry();
            cmisEntry2.initEntryFromXml(document.getRootElement());
            return cmisEntry2;
        }
        catch (ServiceException serviceException) {
            if (serviceException.getMessage().indexOf("<lcmis:code>contentAlreadyExists</lcmis:code>") != -1) {
                throw new CmisContentAlreadyExistsException(string2, serviceException);
            }
            if (serviceException.getMessage().indexOf("<lcmis:code>objectNotFound</lcmis:code>") != -1) {
                throw new CmisException("Parent lib not found", 3, serviceException);
            }
            throw serviceException;
        }
    }

    public CmisEntry createDocumentVersion(String string, InputStream inputStream, boolean bl, String string2) throws Exception {
        CmisEntry cmisEntry = this.getObjectById(string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
        outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        cmisEntry.writeXmlEntryAtom(outputStreamWriter, cmisEntry.cmisContentMimeType, inputStream);
        ((Writer)outputStreamWriter).flush();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        String string3 = cmisEntry.editUrl;
        string3 = string3 + "?checkin=true&major=" + bl + "&checkinComment=" + URLEncoder.encode(string2, "UTF-8");
        Document document = this.callService("PUT", string3, this.serviceConnector, cmisEntry.title, byteArrayInputStream, "application/atom+xml;type=entry");
        CmisEntry cmisEntry2 = new CmisEntry();
        cmisEntry2.initEntryFromXml(document.getRootElement());
        return cmisEntry2;
    }

    public CmisPermission[] getFileACLs(CmisEntry cmisEntry) throws Exception {
        Document document = this.callService(cmisEntry.aclAccessorUrl, this.serviceConnector);
        Element element = document.getRootElement();
        List list = element.getChildren("permission", CMIS_NS);
        if (list != null) {
            CmisPermission[] cmisPermissionArray = new CmisPermission[list.size()];
            for (int i = 0; i < cmisPermissionArray.length; ++i) {
                cmisPermissionArray[i] = (CmisPermission)CmisPermission.readEntry((Element)list.get(i));
            }
            return cmisPermissionArray;
        }
        return new CmisPermission[0];
    }

    public boolean isEntrySharedWithCommunity(CmisEntry cmisEntry, String string) throws Exception {
        return this.isSharedWithCommunity(this.getFileACLs(cmisEntry), string);
    }

    public boolean isSharedWithCommunity(CmisPermission[] cmisPermissionArray, String string) throws Exception {
        if (cmisPermissionArray != null) {
            for (int i = 0; i < cmisPermissionArray.length; ++i) {
                if (!TString.equals((String)string, (String)cmisPermissionArray[i].principal.principalId)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canUserShareEntry(CmisEntry cmisEntry, String string) throws Exception {
        return this.canUserShare(this.getFileACLs(cmisEntry), string);
    }

    public boolean canUserShare(CmisPermission[] cmisPermissionArray, String string) throws Exception {
        boolean bl = false;
        if (cmisPermissionArray != null) {
            for (int i = 0; i < cmisPermissionArray.length; ++i) {
                if (!TString.equals((String)string, (String)cmisPermissionArray[i].principal.principalId)) continue;
                bl = !TString.equals((String)cmisPermissionArray[i].permission, (String)"cmis:read");
                break;
            }
        }
        return bl;
    }

    public CmisEntry shareEntryWithCommunity(String string, String string2) throws Exception {
        return this.shareFileWithCommunity(this.getObjectById(string), string2);
    }

    public CmisEntry shareFileWithCommunity(CmisEntry cmisEntry, String string) throws Exception {
        String string2 = this.getCmisBaseUrl() + "/repository/cs!" + string + "/folderc/snx:community";
        String string3 = cmisEntry.toXmlEntryAtom();
        String[][] stringArray = new String[1][2];
        stringArray[0][0] = "Content-Type";
        stringArray[0][1] = "application/atom+xml;type=entry";
        try {
            Document document = this.callService(string2, this.serviceConnector, string3, stringArray, true);
            CmisEntry cmisEntry2 = new CmisEntry();
            cmisEntry2.initEntryFromXml(document.getRootElement());
            return cmisEntry2;
        }
        catch (ServiceException serviceException) {
            if (serviceException.getMessage().indexOf("<lcmis:code>contentAlreadyExists</lcmis:code>") != -1) {
                System.out.println("shareFileWithCommunity: file already in the community");
                return cmisEntry;
            }
            if (serviceException.getMessage().indexOf("<lcmis:code>changeSharingIntentRestriction</lcmis:code>") != -1) {
                throw new CmisException("User not authorized to share '" + cmisEntry.title + "' file ", 2, serviceException);
            }
            if (serviceException.getMessage().indexOf("<lcmis:code>objectNotFound</lcmis:code>") != -1) {
                throw new CmisException("Parent lib not found", 3, serviceException);
            }
            if (serviceException.getMessage().indexOf("<lcmis:code>permissionDenied</lcmis:code>") != -1) {
                throw new CmisException("User not authorized to share '" + cmisEntry.title + "' file ", 2, serviceException);
            }
            throw serviceException;
        }
    }

    public CmisEntry shareFileWithUsersByEmail(CmisEntry cmisEntry, String[] stringArray, String string) throws Exception {
        CmisPermission[] cmisPermissionArray = new CmisPermission[stringArray.length];
        for (int i = 0; i < cmisPermissionArray.length; ++i) {
            cmisPermissionArray[i] = new CmisPermission();
            cmisPermissionArray[i].permission = string;
            cmisPermissionArray[i].principal.email = stringArray[i];
        }
        return this.shareFile(cmisEntry, cmisPermissionArray);
    }

    public CmisEntry shareFile(CmisEntry cmisEntry, CmisPermission[] cmisPermissionArray) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        stringBuilder.append("<cmis:acl xmlns:cmis=\"http://docs.oasis-open.org/ns/cmis/core/200908/\">");
        for (int i = 0; i < cmisPermissionArray.length; ++i) {
            stringBuilder.append(cmisPermissionArray[i].toXmlEntryAtom());
        }
        stringBuilder.append("</cmis:acl>");
        String[][] stringArray = new String[1][2];
        stringArray[0][0] = "Content-Type";
        stringArray[0][1] = "application/cmisacl+xml";
        Document document = this.callService(cmisEntry.aclAccessorUrl, this.serviceConnector, stringBuilder.toString(), stringArray, "PUT", true);
        return cmisEntry;
    }

    public CmisEntry[] getAllFilesOfUser(String string) throws Exception {
        String string2 = this.getCmisBaseUrl() + "/repository/p!" + string + "/folderc/snx:files?maxItems=500";
        return this.getFilesFromUrl(string2);
    }

    public CmisEntry[] getAllFilesSharedWithUser(String string) throws Exception {
        String string2 = this.getCmisBaseUrl() + "/repository/p!" + string + "/folderc/snx:virtual!.!filessharedwith?maxItems=500";
        return this.getFilesFromUrl(string2);
    }

    public CmisEntry[] getAllFilesSharedByUser(String string) throws Exception {
        String string2 = this.getCmisBaseUrl() + "/repository/p!" + string + "/folderc/snx:virtual!.!filessharedby?maxItems=500";
        return this.getFilesFromUrl(string2);
    }

    public CmisEntry[] getAllCommunityFiles(String string) throws Exception {
        String string2 = this.getCmisBaseUrl() + "/repository/cs!" + string + "/folderc/snx:community?maxItems=500";
        return this.getFilesFromUrl(string2);
    }

    public CmisEntry[] getAllOrganizationFiles(String string) throws Exception {
        String string2 = this.getCmisBaseUrl() + "/repository/p!" + string + "/folderc/snx:virtual!.!filespublic?maxItems=500";
        return this.getFilesFromUrl(string2);
    }

    private CmisEntry[] getFilesFromUrl(String string) throws Exception {
        Document document = this.callService(string, this.serviceConnector);
        Element element = document.getRootElement();
        List list = element.getChildren("entry", UService.atomNs);
        CmisEntry[] cmisEntryArray = new CmisEntry[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            CmisEntry cmisEntry = new CmisEntry();
            cmisEntry.initEntryFromXml((Element)list.get(i));
            cmisEntryArray[i] = cmisEntry;
        }
        return cmisEntryArray;
    }

    public void deleteEntry(CmisEntry cmisEntry) throws Exception {
        String string = cmisEntry.selfUrl;
        this.callDeleteService(string, this.serviceConnector, false);
    }

    public void XXXquery(String string) throws Exception {
        boolean bl = true;
        if (bl) {
            String string2 = this.repository.getQueryCollectionUrl();
            StringWriter stringWriter = new StringWriter();
            stringWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n");
            stringWriter.write("<cmis:query xmlns:cmis=\"http://docs.oasis-open.org/ns/cmis/core/200908/\" xmlns:cmism=\"http://docs.oasis-open.org/ns/cmis/messaging/200908/\" xmlns:atom=\"http://www.w3.org/2005/Atom\" xmlns:app=\"http://www.w3.org/2007/app\" xmlns:cmisra=\"http://docs.oasis-open.org/ns/cmis/restatom/200908/\">");
            stringWriter.write("<cmis:statement>");
            stringWriter.write(TString.toXMLString((String)string));
            stringWriter.write("</cmis:statement>");
            stringWriter.write("<cmis:searchAllVersions>true</cmis:searchAllVersions>");
            stringWriter.write("<cmis:includeAllowableActions>false</cmis:includeAllowableActions>");
            stringWriter.write("<cmis:includeRelationships>none</cmis:includeRelationships>");
            stringWriter.write("<cmis:renditionFilter>*</cmis:renditionFilter>");
            stringWriter.write("<cmis:maxItems>50</cmis:maxItems>");
            stringWriter.write("<cmis:skipCount>0</cmis:skipCount>");
            stringWriter.write("</cmis:query>");
            byte[] byArray = stringWriter.toString().getBytes("UTF-8");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            Document document = this.callService(string2, this.serviceConnector, "", byteArrayInputStream, "application/cmisquery+xml");
            System.out.println(JDom.getXMLString((Document)document));
        } else {
            String string3 = this.repository.getUriTemplate(CmisRepository.UriTemplateType.QUERY);
            string3 = TString.replace((String)string3, (String)"{query}", (String)URLEncoder.encode(string, "UTF-8"));
            string3 = TString.replace((String)string3, (String)"{filter}", (String)"");
            string3 = TString.replace((String)string3, (String)"{includeAllowableActions}", (String)"false");
            string3 = TString.replace((String)string3, (String)"{includePolicyIds}", (String)"false");
            string3 = TString.replace((String)string3, (String)"{includeRelationships}", (String)"false");
            string3 = TString.replace((String)string3, (String)"{includeACL}", (String)"false");
            string3 = TString.replace((String)string3, (String)"{renditionFilter}", (String)"false");
            Document document = this.callService(string3, this.serviceConnector, null);
            System.out.println(JDom.getXMLString((Document)document));
        }
    }

    static {
        NS_CONTEXT.addNamespace(CMISRA_NSPREFIX, CMISRA_NSURI);
        NS_CONTEXT.addNamespace(CMIS_NSPREFIX, CMIS_NSURI);
        NS_CONTEXT.addNamespace(LCMIS_NSPREFIX, LCMIS_NSURI);
        NS_CONTEXT.addNamespace("atom", "http://www.w3.org/2005/Atom");
        NS_CONTEXT.addNamespace("app", "http://www.w3.org/2007/app");
    }
}

