/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.lotus.atom;

import com.flowbuilder.util.TString;
import com.flowbuilder.util.xml.JDOMUtil;
import com.triloggroup.lotus.UService;
import com.triloggroup.lotus.atom.Member;
import java.io.PrintWriter;
import java.util.Date;
import org.jdom.Element;

public class Field {
    public static final String DATE_TYPE = "date";
    public static final String LINK_TYPE = "link";
    public static final String TEXT_TYPE = "text";
    public static final String PERSON_TYPE = "person";
    public static final String FILE_TYPE = "file";
    public String name;
    public String type;
    public Object value;
    public String position;

    public Field() {
    }

    public Field(String string, String string2, Object object, String string3) {
        this.name = string;
        this.type = string2;
        this.value = object;
        this.position = string3;
    }

    public static Field readField(Element element) {
        Field field = new Field();
        field.initFieldFromXml(element);
        return field;
    }

    public void initFieldFromXml(Element element) {
        if (element != null) {
            this.name = element.getAttributeValue("name");
            this.type = element.getAttributeValue("type");
            this.position = element.getAttributeValue("position");
            if (DATE_TYPE.equals(this.type)) {
                this.value = JDOMUtil.parseUtilDate((String)TString.trim((String)element.getText()));
            } else if (LINK_TYPE.equals(this.type)) {
                Element element2 = element.getChild(LINK_TYPE);
                if (element2 != null) {
                    this.value = element2.getAttributeValue("href");
                }
            } else if (TEXT_TYPE.equals(this.type)) {
                Element element3 = element.getChild("summary");
                if (element3 != null) {
                    this.value = TString.trim((String)element3.getText());
                }
            } else if (PERSON_TYPE.equals(this.type)) {
                this.value = new Member();
                ((Member)this.value).name = UService.getChildText(element, "name", null);
                ((Member)this.value).email = UService.getChildText(element, "email", null);
            } else if (FILE_TYPE.equals(this.type)) {
                // empty if block
            }
        }
    }

    public String toXmlAtom() {
        StringBuilder stringBuilder = new StringBuilder(" <snx:field name=\"");
        stringBuilder.append(this.name);
        stringBuilder.append("\" type=\"").append(this.type).append("\" ");
        if (!TString.isEmpty((String)this.position)) {
            stringBuilder.append("position=\"").append(this.position).append("\" ");
        }
        stringBuilder.append(">");
        if (DATE_TYPE.equals(this.type)) {
            stringBuilder.append(JDOMUtil.toString((Date)((Date)this.value)));
        } else if (LINK_TYPE.equals(this.type)) {
            stringBuilder.append("<link href=\"").append(this.value).append("\" />");
        } else if (TEXT_TYPE.equals(this.type)) {
            stringBuilder.append("<summary type=\"text\">").append(TString.toXMLString((String)((String)this.value))).append("</summary>");
        } else if (PERSON_TYPE.equals(this.type)) {
            stringBuilder.append("<name>").append(TString.toXMLString((String)((Member)this.value).name)).append("</name>");
            stringBuilder.append("<email>").append(TString.toXMLString((String)((Member)this.value).email)).append("</email>");
        } else if (FILE_TYPE.equals(this.type)) {
            // empty if block
        }
        stringBuilder.append("</snx:field>");
        return stringBuilder.toString();
    }

    public void dump(String string) {
        this.dump(new PrintWriter(System.out), string);
    }

    public void dump(PrintWriter printWriter, String string) {
        if (string == null) {
            string = "";
        }
        printWriter.println(string + "name = " + this.name);
        printWriter.println(string + "type = " + this.type);
        printWriter.println(string + "value = " + this.value);
        printWriter.println(string + "position = " + this.position);
        printWriter.flush();
    }
}

