/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.lotus;

import com.flowbuilder.util.TDiag;
import com.flowbuilder.util.io.TBase64;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.websphere.security.cred.WSCredential;
import com.triloggroup.lotus.ILTPA;
import javax.security.auth.Subject;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class ULTPAWebsphere
implements ILTPA {
    private static final String LTPA_COOKIE_NAME = "LtpaToken";
    private static final String WASPOSTPARAM_COOKIE_NAME = "WASPostParam";

    public String getCookiesWithLtpaToken(HttpServletRequest httpServletRequest) {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        Cookie[] cookieArray = httpServletRequest.getCookies();
        boolean bl = false;
        if (cookieArray != null) {
            for (int i = 0; i < cookieArray.length; ++i) {
                Cookie cookie = cookieArray[i];
                if (LTPA_COOKIE_NAME.equals(cookie.getName())) {
                    bl = true;
                } else if (WASPOSTPARAM_COOKIE_NAME.equals(cookie.getName())) continue;
                stringBuilder.append(cookie.getName()).append('=').append(cookie.getValue()).append("; ");
            }
        }
        if (!bl && (string = this.getLtpaToken()) != null) {
            stringBuilder.append(LTPA_COOKIE_NAME).append('=').append(string).append(';');
        }
        return stringBuilder.toString();
    }

    public String getCookiesWithoutLtpaToken(HttpServletRequest httpServletRequest) {
        StringBuilder stringBuilder = new StringBuilder();
        Cookie[] cookieArray = httpServletRequest.getCookies();
        if (cookieArray != null) {
            for (int i = 0; i < cookieArray.length; ++i) {
                Cookie cookie = cookieArray[i];
                if (LTPA_COOKIE_NAME.equals(cookie.getName()) || WASPOSTPARAM_COOKIE_NAME.equals(cookie.getName())) continue;
                stringBuilder.append(cookie.getName()).append("=").append(cookie.getValue()).append("; ");
            }
        }
        return stringBuilder.toString();
    }

    public String getLtpaToken() {
        try {
            return this.getLtpaToken(WSSubject.getRunAsSubject());
        }
        catch (WSSecurityException wSSecurityException) {
            TDiag.exception((Throwable)wSSecurityException, (String)"Error when getting LTPA token");
            return null;
        }
    }

    public String getLtpaToken(Subject subject) {
        String string = null;
        try {
            if (subject != null) {
                Object[] objectArray = subject.getPublicCredentials(WSCredential.class).toArray();
                if (objectArray != null && objectArray.length > 0) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        WSCredential wSCredential = (WSCredential)objectArray[i];
                        byte[] byArray = wSCredential.getCredentialToken();
                        if (byArray != null && byArray.length > 0) {
                            string = new String(TBase64.encode((byte[])byArray));
                            continue;
                        }
                        System.out.println("credential token null or empty.");
                    }
                } else {
                    System.out.println("credentials not found on subject: " + objectArray);
                }
            } else {
                System.out.println("subject is null");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }
}

