/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.lotus;

import com.flowbuilder.lib.JDom;
import com.flowbuilder.util.MIME;
import com.flowbuilder.util.TDiag;
import com.flowbuilder.util.TString;
import com.flowbuilder.util.io.file.TFile;
import com.flowbuilder.util.xml.JDOMUtil;
import com.flowbuilder.util.xml.XMLException;
import com.triloggroup.lc.Community;
import com.triloggroup.lotus.IServiceConnector;
import com.triloggroup.lotus.atom.Member;
import com.triloggroup.lotus.atom.cmis.CmisEntry;
import com.triloggroup.quickr.doclib.UDocumentLibrary;
import com.triloggroup.util.UString;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.jdom.Document;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportExportDocUtil {
    public static final String LIB_STRUCT_ENTRY = "TG_PE_LIBRARY_STRCUTURE.XML";
    public static final String COMMUNITY_STRUCT_ENTRY = "TG_COMMUNITY_DOCS_STRCUTURE.XML";
    private static boolean DEBUG = false;

    public boolean isQuickrExport(ZipFile zipFile) {
        return zipFile.getEntry(LIB_STRUCT_ENTRY) != null;
    }

    public boolean isLCExport(ZipFile zipFile) {
        return zipFile.getEntry(COMMUNITY_STRUCT_ENTRY) != null;
    }

    public Document readQuickrTreeStructure(ZipFile zipFile) throws XMLException, IOException {
        ZipEntry zipEntry = zipFile.getEntry(LIB_STRUCT_ENTRY);
        if (zipEntry != null) {
            return JDOMUtil.read((InputStream)zipFile.getInputStream(zipEntry));
        }
        return null;
    }

    public CmisEntry[] getLCEntriesInfo(ZipFile zipFile) throws Exception {
        List list;
        Element element;
        ZipEntry zipEntry = zipFile.getEntry(COMMUNITY_STRUCT_ENTRY);
        if (zipEntry == null) {
            throw new Exception("Zip file " + zipFile.getName() + " is not an export of Community Documents");
        }
        Document document = JDOMUtil.read((InputStream)zipFile.getInputStream(zipEntry));
        CmisEntry[] cmisEntryArray = null;
        Element element2 = document.getRootElement();
        if (element2 != null && (element = element2.getChild("entries")) != null && (list = element.getChildren("entry")) != null) {
            cmisEntryArray = new CmisEntry[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                cmisEntryArray[i] = this.deserializeCmisEntry((Element)list.get(i));
            }
        }
        return cmisEntryArray;
    }

    private CmisEntry deserializeCmisEntry(Element element) throws Exception {
        CmisEntry cmisEntry = new CmisEntry();
        cmisEntry.id = element.getAttributeValue("id");
        cmisEntry.title = element.getChildText("title");
        cmisEntry.cmisContentFileName = element.getChildText("fileName");
        cmisEntry.viewHtmlUrl = element.getChildText("url");
        cmisEntry.selfUrl = element.getChildText("entryUrl");
        cmisEntry.cmisContentUrl = element.getChildText("contentUrl");
        cmisEntry.author = new Member();
        cmisEntry.author.name = JDOMUtil.getStringValue((Element)element, (String)"author/name");
        cmisEntry.author.email = JDOMUtil.getStringValue((Element)element, (String)"author/email");
        cmisEntry.author.userId = JDOMUtil.getStringValue((Element)element, (String)"author/userId");
        cmisEntry.publishedDate = JDOMUtil.getDateValue((Element)element, (String)"creationDate");
        cmisEntry.updatedDate = JDOMUtil.getDateValue((Element)element, (String)"modificationDate");
        cmisEntry.cmisContentMimeType = JDOMUtil.getString((Element)element, (String)"contentType");
        return cmisEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeQuickrLibraryTreeStructure(ZipOutputStream zipOutputStream, Node node) throws Exception {
        Document document = new Document();
        Element element = new Element("library");
        element.setAttribute("name", node.docId);
        document.setRootElement(element);
        this.serializeQuickrDocChildren(element, node);
        ZipEntry zipEntry = new ZipEntry(LIB_STRUCT_ENTRY);
        try {
            zipOutputStream.putNextEntry(zipEntry);
            JDOMUtil.save((OutputStream)zipOutputStream, (Document)document, (boolean)false);
        }
        finally {
            zipOutputStream.closeEntry();
        }
    }

    private void serializeQuickrDocChildren(Element element, Node node) throws Exception {
        for (int i = 0; i < node.children.size(); ++i) {
            Leaf leaf = node.children.get(i);
            Element element2 = null;
            if (leaf instanceof Node) {
                element2 = new Element("folder");
                this.serializeQuickDocEntry(element2, leaf.quickrData);
                this.serializeQuickrDocChildren(element2, (Node)leaf);
            } else {
                element2 = new Element("document");
                element2.setAttribute("id", leaf.docId);
                this.serializeQuickDocEntry(element2, leaf.quickrData);
            }
            element.addContent(element2);
        }
    }

    private void serializeQuickDocEntry(Element element, UDocumentLibrary.Entry entry) throws Exception {
        element.setAttribute("id", entry.id);
        JDOMUtil.setString((Element)element, (String)"title", (String)entry.title);
        JDOMUtil.setString((Element)element, (String)"fileName", (String)entry.fileName);
        JDOMUtil.setString((Element)element, (String)"summary", (String)entry.summary);
        JDOMUtil.setString((Element)element, (String)"url", (String)entry.url);
        JDOMUtil.setString((Element)element, (String)"entryUrl", (String)entry.entryUrl);
        JDOMUtil.setString((Element)element, (String)"contentUrl", (String)entry.contentUrl);
        JDOMUtil.setString((Element)element, (String)"author", (String)entry.author);
        JDOMUtil.setString((Element)element, (String)"authorDn", (String)entry.authorDn);
        JDOMUtil.setString((Element)element, (String)"authorEmail", (String)entry.authorEmail);
        JDOMUtil.setString((Element)element, (String)"creationDate", (String)entry.creationDate);
        JDOMUtil.setString((Element)element, (String)"modificationDate", (String)entry.modificationDate);
        JDOMUtil.setString((Element)element, (String)"contentType", (String)entry.contentType);
    }

    public UDocumentLibrary.Entry deserializeQuickDocEntry(Element element) throws Exception {
        UDocumentLibrary.Entry entry = new UDocumentLibrary.Entry();
        entry.id = element.getAttributeValue("id");
        entry.title = element.getChildText("title");
        entry.fileName = element.getChildText("fileName");
        if (TString.isEmpty((String)entry.fileName)) {
            entry.fileName = entry.title;
        }
        entry.summary = element.getChildText("summary");
        entry.url = element.getChildText("url");
        entry.entryUrl = element.getChildText("entryUrl");
        entry.contentUrl = element.getChildText("contentUrl");
        entry.author = element.getChildText("author");
        entry.authorDn = element.getChildText("authorDn");
        entry.authorEmail = element.getChildText("authorEmail");
        entry.creationDate = element.getChildText("creationDate");
        entry.modificationDate = element.getChildText("modificationDate");
        entry.contentType = element.getChildText("contentType");
        if (TString.isEmpty((String)entry.contentType)) {
            String string = TFile.getFileExtension((String)entry.fileName);
            entry.contentType = TString.isEmpty((String)string) ? "" : MIME.getMIMETypeFromExtension((String)string);
        }
        entry.category = UString.equals((String)element.getName(), (String)"document") ? "document" : "folder";
        return entry;
    }

    public UDocumentLibrary.Entry[] getAllLCDocumentsAsQuickr(ZipFile zipFile) throws Exception {
        List list;
        ZipEntry zipEntry;
        if (DEBUG) {
            System.out.println("---- getAllLCDocumentsAsQuickr ----");
        }
        if ((zipEntry = zipFile.getEntry(COMMUNITY_STRUCT_ENTRY)) == null) {
            throw new Exception("Zip file " + zipFile.getName() + " is not an export of Community Documents");
        }
        Document document = JDOMUtil.read((InputStream)zipFile.getInputStream(zipEntry));
        if (DEBUG) {
            System.out.println("-------------Tree Doc Struct --------");
            System.out.println(JDom.getXMLString((Document)document));
            System.out.println("-------------------------------------");
        }
        Element element = document.getRootElement();
        UDocumentLibrary.Entry[] entryArray = null;
        Element element2 = element.getChild("entries");
        if (element2 != null && (list = element2.getChildren("entry")) != null) {
            entryArray = new UDocumentLibrary.Entry[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                entryArray[i] = this.deserializeQuickDocEntry((Element)list.get(i));
            }
            if (DEBUG) {
                System.out.println(entryArray.length + " entries");
            }
            return entryArray;
        }
        if (DEBUG) {
            System.out.println("No entry");
        }
        return new UDocumentLibrary.Entry[0];
    }

    public CmisEntry[] getAllQuickrDocumentsAsCmisEntries(ZipFile zipFile) throws Exception {
        Object[] objectArray;
        Element element;
        ZipEntry zipEntry;
        if (DEBUG) {
            System.out.println("---- getAllQuickrDocumentsAsCmisEntries ----");
        }
        if ((zipEntry = zipFile.getEntry(LIB_STRUCT_ENTRY)) == null) {
            throw new Exception("Zip file " + zipFile.getName() + " is not an export of Quickr librairie Documents");
        }
        CmisEntry[] cmisEntryArray = null;
        Document document = JDOMUtil.read((InputStream)zipFile.getInputStream(zipEntry));
        if (DEBUG) {
            System.out.println("-------------Tree Doc Struct --------");
            System.out.println(JDom.getXMLString((Document)document));
            System.out.println("-------------------------------------");
        }
        if ((element = document.getRootElement()) != null && (objectArray = JDOMUtil.nodes((Element)element, (String)"//document")) != null) {
            cmisEntryArray = new CmisEntry[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                cmisEntryArray[i] = this.deserializeCmisEntry((Element)objectArray[i]);
            }
        }
        return cmisEntryArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCommunityTreeStructure(ZipOutputStream zipOutputStream, Community community, ArrayList<CmisEntry> arrayList) throws Exception {
        Document document = new Document();
        Element element = new Element("communityTree");
        element.setAttribute("name", community.title);
        document.setRootElement(element);
        Element element2 = new Element("entries");
        element.addContent(element2);
        for (int i = 0; i < arrayList.size(); ++i) {
            this.serializeCmisEntry(element2, arrayList.get(i));
        }
        ZipEntry zipEntry = new ZipEntry(COMMUNITY_STRUCT_ENTRY);
        try {
            zipOutputStream.putNextEntry(zipEntry);
            JDOMUtil.save((OutputStream)zipOutputStream, (Document)document, (boolean)false);
        }
        finally {
            zipOutputStream.closeEntry();
        }
    }

    private void serializeCmisEntry(Element element, CmisEntry cmisEntry) throws Exception {
        Element element2 = new Element("entry");
        element.addContent(element2);
        element2.setAttribute("id", cmisEntry.id);
        JDOMUtil.setString((Element)element2, (String)"title", (String)cmisEntry.title);
        JDOMUtil.setString((Element)element2, (String)"fileName", (String)cmisEntry.cmisContentFileName);
        JDOMUtil.setString((Element)element2, (String)"url", (String)cmisEntry.viewHtmlUrl);
        JDOMUtil.setString((Element)element2, (String)"entryUrl", (String)cmisEntry.selfUrl);
        JDOMUtil.setString((Element)element2, (String)"contentUrl", (String)cmisEntry.cmisContentUrl);
        JDOMUtil.setStringValue((Element)element2, (String)"author/name", (String)cmisEntry.author.name);
        JDOMUtil.setStringValue((Element)element2, (String)"author/email", (String)cmisEntry.author.email);
        JDOMUtil.setStringValue((Element)element2, (String)"author/userId", (String)cmisEntry.author.userId);
        JDOMUtil.setDateValue((Element)element2, (String)"creationDate", (Date)cmisEntry.publishedDate);
        JDOMUtil.setDateValue((Element)element2, (String)"modificationDate", (Date)cmisEntry.updatedDate);
        JDOMUtil.setString((Element)element2, (String)"contentType", (String)cmisEntry.cmisContentMimeType);
    }

    public void addDocumentToZip(UDocumentLibrary.Entry entry, String string, IServiceConnector iServiceConnector, ZipOutputStream zipOutputStream) {
        if (TString.equals((String)entry.category, (String)"document") || TString.equals((String)entry.category, (String)"draft")) {
            try {
                this.addDocumentToZip(string, this.getDocumentInputStream(entry, iServiceConnector), zipOutputStream);
            }
            catch (Exception exception) {
                TDiag.exception((Throwable)exception, (String)("ERROR: Could not export document " + entry.title));
            }
        } else {
            TDiag.println((String)("Could not export " + entry.title + " because its category is " + entry.category));
        }
    }

    public void addDocumentToZip(CmisEntry cmisEntry, IServiceConnector iServiceConnector, ZipOutputStream zipOutputStream) {
        if (cmisEntry.isFile()) {
            try {
                this.addDocumentToZip(cmisEntry.id, this.getDocumentInputStream(cmisEntry, iServiceConnector), zipOutputStream);
            }
            catch (Exception exception) {
                TDiag.exception((Throwable)exception, (String)("ERROR: Could not export document " + cmisEntry.title));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDocumentToZip(String string, InputStream inputStream, ZipOutputStream zipOutputStream) throws Exception {
        ZipEntry zipEntry = new ZipEntry(string);
        try {
            zipOutputStream.putNextEntry(zipEntry);
            try {
                byte[] byArray = new byte[4096];
                int n = 0;
                while (n >= 0) {
                    if (n > 0) {
                        zipOutputStream.write(byArray, 0, n);
                    }
                    n = inputStream.read(byArray);
                }
            }
            finally {
                inputStream.close();
            }
        }
        finally {
            zipOutputStream.flush();
            zipOutputStream.closeEntry();
        }
    }

    protected InputStream getDocumentInputStream(UDocumentLibrary.Entry entry, IServiceConnector iServiceConnector) throws Exception {
        return this.getDocumentInputStream(entry.contentUrl, iServiceConnector);
    }

    protected InputStream getDocumentInputStream(CmisEntry cmisEntry, IServiceConnector iServiceConnector) throws Exception {
        return this.getDocumentInputStream(cmisEntry.cmisContentUrl, iServiceConnector);
    }

    public InputStream getDocumentInputStream(String string, IServiceConnector iServiceConnector) throws Exception {
        URL uRL = new URL(string);
        URLConnection uRLConnection = uRL.openConnection();
        this.forceDisableKeepAlive(uRLConnection);
        iServiceConnector.setAuthorization(uRLConnection);
        if (uRLConnection instanceof HttpURLConnection) {
            int n = ((HttpURLConnection)uRLConnection).getResponseCode();
            String string2 = ((HttpURLConnection)uRLConnection).getResponseMessage();
            if (n != 200 && n != 201) {
                TDiag.error((String)"Error during getDocumentInputStream - ResponseCode=%1 ResponseMessage=%2", (Object)String.valueOf(n), (Object)string2);
                throw new Exception("HttpURLConnection error: " + n + " - " + string2);
            }
        }
        return uRLConnection.getInputStream();
    }

    protected void forceDisableKeepAlive(URLConnection uRLConnection) {
        uRLConnection.setRequestProperty("Connection", "close");
    }

    public static class Result
    implements Serializable {
        public ArrayList unexportedFolder = new ArrayList();
    }

    public static class Node
    extends Leaf
    implements Serializable {
        public ArrayList<Leaf> children = new ArrayList();
    }

    public static class Leaf
    implements Serializable {
        public String docId;
        public UDocumentLibrary.Entry quickrData;
    }
}

