/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.lc.vcard;

import com.triloggroup.lc.vcard.VCard;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VCardParser {
    private static final String[] NEED_UNESCAPING = new String[]{"\\n", "\\N", "\\\\\\", "\\,", "\\;", "\\:"};

    public VCard parse(File file) throws IOException {
        String string = this.getContent(file);
        return this.parse(string);
    }

    public VCard parse(String string) {
        string = this.unfoldVCard(string);
        VCard vCard = new VCard();
        ArrayList<String[]> arrayList = this.splitLines(string);
        String[] stringArray = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray = arrayList.get(i);
            String string2 = stringArray[0].trim();
            String string3 = stringArray[1].trim();
            if ("BEGIN".equals(string2) || "END".equals(string2)) continue;
            if (string3.length() > 0 && !string2.endsWith(";VALUE=URL") && !"URL".equals(string2)) {
                String string4;
                int n = 0;
                int n2 = string3.indexOf(58);
                ArrayList<String> arrayList2 = new ArrayList<String>();
                while (n2 != -1) {
                    if (string3.charAt(n2 - 1) == '\\') {
                        n2 = string3.indexOf(n2 + 1, 58);
                        continue;
                    }
                    string4 = string3.substring(n, n2);
                    if (this.needsUnEscaping(string4)) {
                        string4 = this.unescapeString(string4);
                    }
                    arrayList2.add(string4);
                    n = n2 + 1;
                    n2 = string3.indexOf(n, 58);
                }
                string4 = string3.substring(n);
                if (this.needsUnEscaping(string4)) {
                    string4 = this.unescapeString(string4);
                }
                arrayList2.add(string4);
                vCard.put(string2, arrayList2);
                continue;
            }
            vCard.put(string2, Collections.singletonList(string3));
        }
        return vCard;
    }

    private ArrayList<String[]> splitLines(String string) {
        String[] stringArray = string.split("\n");
        ArrayList<String[]> arrayList = new ArrayList<String[]>(stringArray.length);
        String string2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2;
            string2 = stringArray[i];
            int n = string2.indexOf(";VALUE=URL");
            if (n != -1) {
                stringArray2 = new String[]{string2.substring(0, n + ";VALUE=URL".length()), string2.substring(n + ";VALUE=URL".length() + 1)};
                arrayList.add(stringArray2);
                continue;
            }
            stringArray2 = string2.split(":", 2);
            arrayList.add(stringArray2);
        }
        return arrayList;
    }

    private String getContent(File file) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string = "";
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = bufferedReader.readLine()) != null) {
            if (string.matches("$")) continue;
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        bufferedReader.close();
        return stringBuffer.toString();
    }

    private String unfoldVCard(String string) {
        String string2 = string.replaceAll("=\n\\p{Blank}+", "");
        String string3 = string2.replaceAll("\n\\p{Blank}+", "");
        return string3;
    }

    public boolean needsUnEscaping(String string) {
        for (int i = 0; i < NEED_UNESCAPING.length; ++i) {
            if (string.indexOf(NEED_UNESCAPING[i]) == -1) continue;
            return true;
        }
        return false;
    }

    public String unescapeString(String string) {
        String string2 = string.replaceAll("\\\\n", "\n");
        string2 = string2.replaceAll("\\\\N", "\n");
        string2 = string2.replaceAll("\\\\\\\\", "\\\\");
        string2 = string2.replaceAll("\\\\,", ",");
        string2 = string2.replaceAll("\\\\;", ";");
        string2 = string2.replaceAll("\\\\:", ":");
        return string2;
    }
}

