/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.lc.test;

import com.triloggroup.lc.FileEntry;
import com.triloggroup.lc.FilesConnection;
import com.triloggroup.lc.test.DocumentLibraryExplorer;
import com.triloggroup.lotus.ClientServiceConnector;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FilesExplorer
extends JFrame {
    private JTextArea textArea;
    private JTree tree;
    private JProgressBar progress;
    private boolean actionInProgress = false;
    private FilesConnection connection;

    FilesExplorer(FilesConnection filesConnection, FileEntry ... fileEntryArray) {
        super("Files Explorer");
        FileTreeNode fileTreeNode;
        this.connection = filesConnection;
        if (fileEntryArray.length == 1) {
            fileTreeNode = new FileTreeNode(null, fileEntryArray[0]);
        } else {
            FileEntry fileEntry = new FileEntry();
            fileEntry.isFolder = true;
            fileTreeNode = new FileTreeNode(null, fileEntry);
            FileTreeNode[] fileTreeNodeArray = new FileTreeNode[fileEntryArray.length];
            for (int i = 0; i < fileEntryArray.length; ++i) {
                fileTreeNodeArray[i] = new FileTreeNode(fileTreeNode, fileEntryArray[i]);
            }
            FileTreeNode.access$102(fileTreeNode, fileTreeNodeArray);
        }
        this.init(fileTreeNode);
    }

    private void init(FileTreeNode fileTreeNode) {
        this.setDefaultCloseOperation(3);
        this.tree = new JTree(fileTreeNode);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.textArea = new JTextArea();
        JSplitPane jSplitPane = new JSplitPane(0, new JScrollPane(this.tree), new JScrollPane(this.textArea));
        jSplitPane.setDividerLocation(300);
        this.progress = new JProgressBar();
        this.getContentPane().add((Component)jSplitPane, "Center");
        this.getContentPane().add((Component)this.progress, "South");
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
                if (treePath == null) {
                    FilesExplorer.this.textArea.setText("");
                    return;
                }
                FileTreeNode fileTreeNode = (FileTreeNode)treePath.getLastPathComponent();
                StringWriter stringWriter = new StringWriter();
                fileTreeNode.entry.dump(new PrintWriter(stringWriter));
                FilesExplorer.this.textArea.setText(stringWriter.toString());
            }
        });
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Actions");
        UIAction uIAction = new UIAction("Refresh"){

            protected void perform() throws Exception {
                FilesExplorer.this.refresh(FilesExplorer.this.getSelection());
            }
        };
        jMenu.add(new JMenuItem(uIAction));
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
        ActionMap actionMap = this.getRootPane().getActionMap();
        actionMap.put("REFRESH", uIAction);
        InputMap inputMap = this.getRootPane().getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(116, 0), "REFRESH");
        this.pack();
        this.setSize(800, 600);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private FileTreeNode getSelection() {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        return (FileTreeNode)treePath.getLastPathComponent();
    }

    private void refresh(FileTreeNode fileTreeNode) {
        if (fileTreeNode == null) {
            fileTreeNode = (FileTreeNode)this.tree.getModel().getRoot();
        }
        this.refreshNode(fileTreeNode, false);
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        defaultTreeModel.nodeStructureChanged(fileTreeNode);
    }

    private void refreshNode(FileTreeNode fileTreeNode, boolean bl) {
        try {
            if (!((FileTreeNode)fileTreeNode).entry.isFolder && !((FileTreeNode)fileTreeNode).entry.isLibrary) {
                return;
            }
            if (((FileTreeNode)fileTreeNode).entry.contentUrl == null) {
                if (fileTreeNode.children == null) {
                    FileTreeNode.access$102(fileTreeNode, new FileTreeNode[0]);
                    return;
                }
                if (bl) {
                    for (int i = 0; i < fileTreeNode.children.length; ++i) {
                        if (!fileTreeNode.children[i].getAllowsChildren()) continue;
                        this.refreshNode(fileTreeNode.children[i], true);
                    }
                }
            } else {
                FileEntry[] fileEntryArray = this.connection.getEntriesFromUrl(((FileTreeNode)fileTreeNode).entry.contentUrl);
                if (fileEntryArray == null) {
                    fileEntryArray = new FileEntry[]{};
                }
                FileTreeNode.access$102(fileTreeNode, new FileTreeNode[fileEntryArray.length]);
                for (int i = 0; i < fileEntryArray.length; ++i) {
                    ((FileTreeNode)fileTreeNode).children[i] = new FileTreeNode(fileTreeNode, fileEntryArray[i]);
                    if (!bl || !fileEntryArray[i].isFolder) continue;
                    this.refreshNode(fileTreeNode.children[i], true);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        DocumentLibraryExplorer.disableHttpsCertificateValidation();
        ClientServiceConnector clientServiceConnector = new ClientServiceConnector("https://tglc45fr.triloggroup.com/", "pcollins", "floflo");
        FilesConnection filesConnection = new FilesConnection(clientServiceConnector);
        FileEntry fileEntry = new FileEntry();
        fileEntry.contentUrl = "https://tglc45fr.triloggroup.com/dm/atom/libraries/feed";
        fileEntry.isLibrary = true;
        fileEntry.title = "libraries";
        new FilesExplorer(filesConnection, fileEntry);
    }

    private abstract class UIAction
    extends AbstractAction
    implements Runnable {
        UIAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (FilesExplorer.this.actionInProgress) {
                JOptionPane.showMessageDialog(FilesExplorer.this, "There is already an action in progress");
                return;
            }
            FilesExplorer.this.actionInProgress = true;
            FilesExplorer.this.progress.setIndeterminate(true);
            new Thread(this).start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            try {
                this.perform();
            }
            catch (Exception exception) {
                try {
                    exception.printStackTrace();
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            FilesExplorer.this.actionInProgress = false;
                            FilesExplorer.this.progress.setIndeterminate(false);
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }

        protected abstract void perform() throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileTreeNode
    implements TreeNode {
        private FileTreeNode parent;
        private FileTreeNode[] children;
        private FileEntry entry;

        private FileTreeNode(FileTreeNode fileTreeNode, FileEntry fileEntry) {
            this.parent = fileTreeNode;
            this.entry = fileEntry;
        }

        private FileTreeNode[] getChildren() {
            if (this.children == null) {
                FilesExplorer.this.refreshNode(this, false);
            }
            return this.children;
        }

        @Override
        public TreeNode getChildAt(int n) {
            return this.getChildren()[n];
        }

        @Override
        public int getChildCount() {
            return this.getChildren().length;
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public int getIndex(TreeNode treeNode) {
            for (int i = 0; i < this.children.length; ++i) {
                if (treeNode != this.children[i]) continue;
                return i;
            }
            return -1;
        }

        @Override
        public boolean getAllowsChildren() {
            return this.entry.isFolder || this.entry.isLibrary;
        }

        @Override
        public boolean isLeaf() {
            return this.entry.isFile;
        }

        public Enumeration<FileTreeNode> children() {
            return Collections.enumeration(Arrays.asList(this.getChildren()));
        }

        public String toString() {
            return this.entry.toString();
        }

        static /* synthetic */ FileTreeNode[] access$102(FileTreeNode fileTreeNode, FileTreeNode[] fileTreeNodeArray) {
            fileTreeNode.children = fileTreeNodeArray;
            return fileTreeNodeArray;
        }
    }
}

