/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.lc;

import com.flowbuilder.lib.JDom;
import com.triloggroup.lc.FileEntry;
import com.triloggroup.lotus.IServiceConnector;
import com.triloggroup.lotus.ServiceException;
import com.triloggroup.lotus.atom.AbstractConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;

public class FilesConnection
extends AbstractConnection {
    public static final String WORKSPACE_LIBRAIRIES_TITLE = "Libraries";
    public static final String WORKSPACE_FILES_TITLE = "Files";
    public static final String WORKSPACE_FOLDERS_TITLE = "Folders";
    public static final String WORKSPACE_RECYCLE_BIN_TITLE = "Recycle Bin";
    public static final String VIEW_MY_FILES_TITLE = "My Files";
    public static final String VIEW_SHARED_WITH_ME_TITLE = "Shared with me";
    public static final String VIEW_SHARED_BY_ME_TITLE = "Shared by me";
    public static final String VIEW_DOCUMENTS_FEED_TITLE = "Documents Feed";
    public static final String VIEW_REMOVED_FILES_TITLE = "Removed Files";
    protected HashMap<String, Workspace> workspaces;
    protected HashMap<String, View> views;

    public FilesConnection(IServiceConnector iServiceConnector) throws Exception {
        super(iServiceConnector);
        this.initFilesUrls();
    }

    public void dumpWorkspacesContent() {
        try {
            for (String string : this.workspaces.keySet()) {
                System.out.println("---------- " + string + " --------------");
                Workspace workspace = this.workspaces.get(string);
                for (int i = 0; i < workspace.collection.size(); ++i) {
                    View view = workspace.collection.get(i);
                    System.out.println("\t---------- " + view.title + " --------------");
                    FileEntry[] fileEntryArray = this.doGetEntries(view.href);
                    if (fileEntryArray == null || fileEntryArray.length <= 0) continue;
                    for (int j = 0; j < fileEntryArray.length; ++j) {
                        fileEntryArray[j].dump("\t\t");
                        System.out.println("\t\t -------------------");
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void dumpWorkspacesInfo() {
        try {
            Iterator<String> iterator = this.workspaces.keySet().iterator();
            while (iterator.hasNext()) {
                System.out.println("------------------------");
                Workspace workspace = this.workspaces.get(iterator.next());
                System.out.println(workspace);
                System.out.println("\t---------- views --------------");
                for (int i = 0; i < workspace.collection.size(); ++i) {
                    View view = workspace.collection.get(i);
                    System.out.println("\t" + view);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public FileEntry[] getAllCommunityFiles(String string) throws Exception {
        return this.doGetEntries(this.getCommunityFilesUrl(string));
    }

    protected String getCommunityFilesUrl(String string) {
        String string2 = this.serviceConnector.getBaseUrl();
        if (!string2.endsWith("/")) {
            string2 = string2 + '/';
        }
        string2 = string2 + "files/basic/api/communitycollection/" + string + "/feed?acls=true";
        return string2;
    }

    public FileEntry[] getAllFilesOfCurrentUser() throws Exception {
        String string = this.getFilesViewUrl(VIEW_MY_FILES_TITLE);
        return this.doGetEntries(string);
    }

    public FileEntry[] getAllFilesSharedWithCurrentUser() throws Exception {
        String string = this.getFilesViewUrl(VIEW_SHARED_WITH_ME_TITLE);
        return this.doGetEntries(string);
    }

    public FileEntry[] getAllFilesSharedByCurrentUser() throws Exception {
        String string = this.getFilesViewUrl(VIEW_SHARED_BY_ME_TITLE);
        return this.doGetEntries(string);
    }

    protected String getFilesViewUrl(String string) throws Exception {
        ArrayList<View> arrayList = this.workspaces.get((Object)WORKSPACE_FILES_TITLE).collection;
        for (View view : arrayList) {
            if (!string.equals(view.title)) continue;
            return view.href;
        }
        throw new Exception("Cannot find URL of " + string + " view");
    }

    protected String getFoldersViewUrl(String string) throws Exception {
        ArrayList<View> arrayList = this.workspaces.get((Object)WORKSPACE_FOLDERS_TITLE).collection;
        for (View view : arrayList) {
            if (!string.equals(view.title)) continue;
            return view.href;
        }
        throw new Exception("Cannot find URL of " + string + " view");
    }

    public FileEntry[] getUserFolders() throws Exception {
        String string = this.getFoldersViewUrl("My Folders");
        return this.doGetEntries(string);
    }

    protected String getLibrariesViewUrl(String string) throws Exception {
        ArrayList<View> arrayList = this.workspaces.get((Object)WORKSPACE_LIBRAIRIES_TITLE).collection;
        for (View view : arrayList) {
            if (!string.equals(view.title)) continue;
            return view.href;
        }
        throw new Exception("Cannot find URL of " + string + " view");
    }

    public FileEntry[] getUserLibraries() throws Exception {
        String string = this.getLibrariesViewUrl("Libraries Feed");
        return this.doGetEntries(string);
    }

    public FileEntry[] getEntriesFromUrl(String string) throws Exception {
        return this.doGetEntries(string);
    }

    protected FileEntry[] doGetEntries(String string) throws Exception {
        Document document = null;
        try {
            document = this.callService(string, this.serviceConnector);
        }
        catch (ServiceException serviceException) {
            if (serviceException.getErrorCode() == 404) {
                return null;
            }
            throw serviceException;
        }
        return this.readFileEntries(document);
    }

    protected FileEntry[] readFileEntries(Document document) throws Exception {
        if (document != null) {
            System.out.println(JDom.getXMLString((Document)document));
            Element element = document.getRootElement();
            if (element != null) {
                FileEntry[] fileEntryArray = null;
                if (element.getName().equals("entry")) {
                    fileEntryArray = new FileEntry[]{FileEntry.readFileEntry(element)};
                } else {
                    List list = element.getChildren("entry", atomNs);
                    if (list != null && list.size() > 0) {
                        fileEntryArray = new FileEntry[list.size()];
                        for (int i = 0; i < fileEntryArray.length; ++i) {
                            fileEntryArray[i] = FileEntry.readFileEntry((Element)list.get(i));
                        }
                    }
                }
                return fileEntryArray;
            }
        }
        return new FileEntry[0];
    }

    protected String getFilesServiceDocumentUrl() {
        String string = this.serviceConnector.getBaseUrl();
        if (!string.endsWith("/")) {
            string = string + '/';
        }
        string = string + "files/basic/api/introspection";
        return string;
    }

    protected void initFilesUrls() throws Exception {
        if (this.workspaces != null) {
            return;
        }
        this.workspaces = new HashMap();
        String[][] stringArray = new String[1][2];
        stringArray[0][0] = "Accept-Language";
        stringArray[0][1] = "en";
        Document document = this.callService(this.getFilesServiceDocumentUrl(), this.serviceConnector);
        if (document != null) {
            System.out.println(JDom.getXMLString((Document)document));
            Element element = document.getRootElement();
            List list = element.getChildren("workspace", appNs);
            if (list != null && list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    Element element2 = (Element)list.get(i);
                    Workspace workspace = new Workspace(element2.getChildText("title", atomNs));
                    this.workspaces.put(workspace.title, workspace);
                    List list2 = element2.getChildren("collection", appNs);
                    for (int j = 0; j < list2.size(); ++j) {
                        Element element3 = (Element)list2.get(j);
                        View view = new View(element3.getChildText("title", atomNs));
                        view.href = element3.getAttributeValue("href");
                        workspace.collection.add(view);
                    }
                }
            }
        }
    }

    private class View {
        String title;
        String href;

        View(String string) {
            this.title = string;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("View: ").append(this.title);
            stringBuilder.append("  - href: ").append(this.href);
            return stringBuilder.toString();
        }
    }

    private class Workspace {
        String title;
        ArrayList<View> collection = new ArrayList();

        Workspace(String string) {
            this.title = string;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("Workspace: ").append(this.title);
            stringBuilder.append("  - views: ");
            if (this.collection.size() > 0) {
                for (View view : this.collection) {
                    stringBuilder.append(view.title).append(", ");
                }
            }
            return stringBuilder.toString();
        }
    }
}

