/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.lc;

import com.flowbuilder.lib.JDom;
import com.flowbuilder.lib.NamespaceContext;
import com.flowbuilder.util.TString;
import com.flowbuilder.util.xml.JDOMUtil;
import com.triloggroup.lc.FilesConnection;
import com.triloggroup.lotus.atom.Category;
import com.triloggroup.lotus.atom.Entry;
import java.io.PrintWriter;
import org.jdom.Element;

public class FileEntry
extends Entry {
    public boolean isFile;
    public boolean isFolder;
    public boolean isLibrary;
    public String contentUrl;
    public String fileName;
    public String contentType;
    public long contentLength = -1L;

    public static FileEntry readFileEntry(Element element) {
        FileEntry fileEntry = new FileEntry();
        fileEntry.initEntryFromXml(element);
        return fileEntry;
    }

    public void initEntryFromXml(Element element) {
        super.initEntryFromXml(element);
        try {
            Element element2;
            if (this.categories.length > 0) {
                element2 = this.categories;
                int n = ((Category[])element2).length;
                for (int i = 0; i < n; ++i) {
                    Element element3 = element2[i];
                    if ("document".equals(element3.label)) {
                        this.isFile = true;
                        continue;
                    }
                    if ("folder".equals(element3.label)) {
                        this.isFolder = true;
                        continue;
                    }
                    if (!"library".equals(element3.label)) continue;
                    this.isLibrary = true;
                }
            }
            if (this.isFile && (element2 = (Element)JDom.node((Element)element, (String)"atom:link[@rel='enclosure']", (NamespaceContext)FilesConnection.NAMESAPCE_CONTEXT)) != null) {
                this.fileName = element2.getAttributeValue("title");
                this.contentType = element2.getAttributeValue("type");
                this.contentLength = JDOMUtil.parseLong((String)element2.getAttributeValue("length"));
            }
        }
        catch (Exception exception) {
            System.out.println("Unable to read file entry");
            try {
                System.out.println(JDom.getXMLString((Element)element));
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new IllegalStateException("Cannot read File Entry");
        }
    }

    protected void setLinkUrl(String string, String string2, String string3) {
        super.setLinkUrl(string, string2, string3);
        if (TString.equals((String)string2, (String)"edit-media")) {
            this.contentUrl = string;
            this.isFile = true;
        }
        if (TString.equals((String)string2, (String)"files")) {
            this.contentUrl = string;
            this.isFolder = true;
        }
    }

    public void dump(PrintWriter printWriter, String string) {
        super.dump(printWriter, string);
        if (string == null) {
            string = "";
        }
        if (this.isFile) {
            printWriter.println(string + "fileName = " + this.fileName);
            printWriter.println(string + "contentType = " + this.contentType);
            printWriter.println(string + "contentLength = " + this.contentLength);
        }
        printWriter.flush();
    }
}

