/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.lc;

import com.flowbuilder.util.TDiag;
import com.flowbuilder.xsp.servlet.Context;
import com.triloggroup.lc.Community;
import com.triloggroup.lc.CommunityConnection;
import com.triloggroup.lc.ConnectionUtil;
import com.triloggroup.lc.IDocumentLibraryMoverForLC;
import com.triloggroup.lotus.ClientServiceConnector;
import com.triloggroup.lotus.IServiceConnector;
import com.triloggroup.lotus.ImportExportDocUtil;
import com.triloggroup.lotus.atom.cmis.CmisConnection;
import com.triloggroup.lotus.atom.cmis.CmisEntry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class CommunityDocumentsImport
implements IDocumentLibraryMoverForLC {
    public static boolean DEBUG = false;
    private IServiceConnector serviceConnector;
    private ImportExportDocUtil importDocUtil;
    private Community community;
    private HashMap<String, CmisEntry> docEntriesMap = new HashMap();

    public CommunityDocumentsImport(Context context) {
        this.serviceConnector = ConnectionUtil.get().createServiceConnector(context);
    }

    public CommunityDocumentsImport(IServiceConnector iServiceConnector) {
        this.serviceConnector = iServiceConnector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importCommunityDocuments(String string, ZipFile zipFile) throws Exception {
        block14: {
            if (DEBUG) {
                System.out.println("-------import community docs ------------ " + string);
            }
            this.docEntriesMap.clear();
            this.importDocUtil = new ImportExportDocUtil();
            try {
                CommunityConnection communityConnection = new CommunityConnection(this.serviceConnector);
                this.community = communityConnection.getCommunityByUid(string);
                if (this.community != null) {
                    if (DEBUG) {
                        System.out.println("...community title = " + this.community.title);
                    }
                    CmisEntry[] cmisEntryArray = null;
                    if (this.importDocUtil.isLCExport(zipFile)) {
                        cmisEntryArray = this.importDocUtil.getLCEntriesInfo(zipFile);
                    } else if (this.importDocUtil.isQuickrExport(zipFile)) {
                        cmisEntryArray = this.importDocUtil.getAllQuickrDocumentsAsCmisEntries(zipFile);
                    } else {
                        throw new Exception("Zip file " + zipFile.getName() + " is not a ProjExec document export");
                    }
                    if (cmisEntryArray != null && cmisEntryArray.length > 0) {
                        if (DEBUG) {
                            System.out.println(".... content " + cmisEntryArray.length + " entries");
                        }
                        CmisConnection cmisConnection = new CmisConnection(this.serviceConnector);
                        this.importEntriesInCommunity(string, cmisEntryArray, zipFile, cmisConnection);
                    } else if (DEBUG) {
                        System.out.println(".... content no entry !!!!");
                    }
                    break block14;
                }
                throw new Exception("Could not access target community " + string);
            }
            finally {
                zipFile.close();
            }
        }
    }

    protected void importEntriesInCommunity(String string, CmisEntry[] cmisEntryArray, ZipFile zipFile, CmisConnection cmisConnection) throws IOException {
        for (int i = 0; i < cmisEntryArray.length; ++i) {
            ZipEntry zipEntry = zipFile.getEntry(cmisEntryArray[i].id);
            if (zipEntry == null) {
                TDiag.println((String)("Document " + cmisEntryArray[i].id + " with file name " + cmisEntryArray[i].cmisContentFileName + " was not correctly exported"));
                continue;
            }
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            try {
                CmisEntry cmisEntry = cmisConnection.createDocumentForCommunity(string, cmisEntryArray[i].cmisContentFileName, cmisEntryArray[i].cmisContentMimeType, inputStream);
                this.docEntriesMap.put(cmisEntryArray[i].cmisContentUrl, cmisEntry);
                continue;
            }
            catch (Exception exception) {
                TDiag.println((String)("Could not create document Entry " + cmisEntryArray[i].cmisContentFileName + ". May be it already exists"));
                TDiag.exception((Throwable)exception);
            }
        }
    }

    public CmisEntry getNewDocumentEntryByOldContentUrl(String string) {
        int n;
        CmisEntry cmisEntry;
        if (DEBUG) {
            System.out.println("getNewDocumentEntryByOldContentUrl " + string);
        }
        if ((cmisEntry = this.docEntriesMap.get(string)) == null && (n = string.indexOf("/repository/co%21file")) != -1) {
            String string2 = string.substring(0, n) + "/repository/cs" + string.substring(n + "/repository/co%21file".length());
            if (DEBUG) {
                System.out.println("try to find entry by corrected LC url: \n\t" + string2);
            }
            cmisEntry = this.docEntriesMap.get(string2);
        }
        return cmisEntry;
    }

    public static void main(String[] stringArray) {
        try {
            ClientServiceConnector clientServiceConnector = new ClientServiceConnector("https://apps.na.collabservtest.lotus.com", "sgrenier@triloggroup.com", "gemini13");
            CommunityDocumentsImport communityDocumentsImport = new CommunityDocumentsImport(clientServiceConnector);
            String string = "cd7f47fa-c9bd-4a50-b9c0-7ea2c685e751";
            ZipFile zipFile = new ZipFile(new File("C:\\tmp\\projexec\\testExportPrj\\DocumentLib.zip"));
            communityDocumentsImport.importCommunityDocuments(string, zipFile);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

