/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.lc;

import com.flowbuilder.xsp.servlet.Context;
import com.triloggroup.lc.Community;
import com.triloggroup.lc.CommunityConnection;
import com.triloggroup.lc.ConnectionUtil;
import com.triloggroup.lotus.ClientServiceConnector;
import com.triloggroup.lotus.IServiceConnector;
import com.triloggroup.lotus.ImportExportDocUtil;
import com.triloggroup.lotus.atom.cmis.CmisConnection;
import com.triloggroup.lotus.atom.cmis.CmisEntry;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommunityDocumentsExport {
    private IServiceConnector serviceConnector;
    private ImportExportDocUtil exportDocUtil;
    private Community community;
    private ZipOutputStream zipOutput = null;
    private ArrayList<CmisEntry> entriesExported;
    private String[] entriesContentUrlToExport = null;

    public CommunityDocumentsExport(Context context) {
        this(ConnectionUtil.get().createServiceConnector(context));
    }

    public CommunityDocumentsExport(IServiceConnector iServiceConnector) {
        this.serviceConnector = iServiceConnector;
    }

    public ArrayList<CmisEntry> exportCommunityDocuments(String string, OutputStream outputStream) throws Exception {
        return this.exportEntriesOfCommunityDocuments(null, string, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<CmisEntry> exportEntriesOfCommunityDocuments(String[] stringArray, String string, OutputStream outputStream) throws Exception {
        this.entriesExported = new ArrayList();
        this.exportDocUtil = new ImportExportDocUtil();
        this.community = null;
        this.entriesContentUrlToExport = stringArray;
        if (this.entriesContentUrlToExport != null && this.entriesContentUrlToExport.length > 0) {
            Arrays.sort(this.entriesContentUrlToExport);
        }
        CommunityConnection communityConnection = new CommunityConnection(this.serviceConnector);
        this.community = communityConnection.getCommunityByUid(string);
        if (this.community != null) {
            this.zipOutput = new ZipOutputStream(outputStream);
            try {
                CmisConnection cmisConnection = new CmisConnection(this.serviceConnector);
                CmisEntry[] cmisEntryArray = cmisConnection.getAllCommunityFiles(string);
                if (cmisEntryArray != null && cmisEntryArray.length > 0) {
                    this.listAllEntries(cmisEntryArray);
                }
                this.exportDocUtil.writeCommunityTreeStructure(this.zipOutput, this.community, this.entriesExported);
            }
            finally {
                if (this.zipOutput != null) {
                    this.zipOutput.close();
                }
            }
            return this.entriesExported;
        }
        throw new Exception("Could not access Community to export " + string);
    }

    private boolean listAllEntries(CmisEntry[] cmisEntryArray) throws Exception {
        boolean bl = false;
        if (cmisEntryArray != null) {
            for (int i = 0; i < cmisEntryArray.length; ++i) {
                cmisEntryArray[i].id = this.getUidFromUrl(cmisEntryArray[i]);
                if (!cmisEntryArray[i].isFile() || !this.isEntryToExport(cmisEntryArray[i])) continue;
                bl = true;
                this.entriesExported.add(cmisEntryArray[i]);
                this.addDocumentToZip(cmisEntryArray[i]);
            }
        }
        return bl;
    }

    private boolean isEntryToExport(CmisEntry cmisEntry) {
        if (this.entriesContentUrlToExport == null || this.entriesContentUrlToExport.length == 0) {
            return true;
        }
        return Arrays.binarySearch(this.entriesContentUrlToExport, cmisEntry.cmisContentUrl) >= 0;
    }

    private void addDocumentToZip(CmisEntry cmisEntry) {
        this.exportDocUtil.addDocumentToZip(cmisEntry, this.serviceConnector, this.zipOutput);
    }

    private String getUidFromUrl(CmisEntry cmisEntry) {
        String string = cmisEntry.id;
        String string2 = "snx:file!";
        int n = string.indexOf(string2);
        if (n != -1 && n + string2.length() < string.length()) {
            string = string.substring(n + string2.length());
        }
        return string;
    }

    public static void main(String[] stringArray) {
        try {
            ClientServiceConnector clientServiceConnector = new ClientServiceConnector("https://apps.na.collabservtest.lotus.com", "sgrenier@triloggroup.com", "gemini13");
            CommunityDocumentsExport communityDocumentsExport = new CommunityDocumentsExport(clientServiceConnector);
            String string = "b3f62b28-daa1-4fe2-b8db-7b52fde44a82";
            FileOutputStream fileOutputStream = new FileOutputStream("C:\\tmp\\projexec\\testExportPrj\\communityDocs.zip");
            communityDocumentsExport.exportCommunityDocuments(string, fileOutputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

