/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.quickr.doclib;

import com.flowbuilder.lib.NamespaceContext;
import com.flowbuilder.server.directory.DirectoryUser;
import com.flowbuilder.util.MIME;
import com.flowbuilder.util.TDiag;
import com.flowbuilder.util.TProperties;
import com.flowbuilder.util.TString;
import com.flowbuilder.util.io.file.TFile;
import com.flowbuilder.util.xml.JDOMUtil;
import com.flowbuilder.util.xml.XPathEngine;
import com.flowbuilder.xsp.servlet.Context;
import com.triloggroup.lotus.ClientServiceConnector;
import com.triloggroup.lotus.IServiceConnector;
import com.triloggroup.lotus.ServletServiceConnector;
import com.triloggroup.lotus.ULTPA;
import com.triloggroup.lotus.UService;
import com.triloggroup.quickr.QuickrUtil;
import com.triloggroup.quickr.XSPServiceConnector;
import com.triloggroup.quickr.doclib.UDocLibQDPatch;
import com.triloggroup.quickr.doclib.UDocLibSOAP;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;

public class UDocumentLibrary
extends UService {
    private static UDocumentLibrary singleton = new UDocumentLibrary();

    private UDocumentLibrary() {
    }

    public static Library[] getLibrariesInfo(Context context) throws Exception {
        return UDocumentLibrary.getLibrariesInfo(new XSPServiceConnector(context));
    }

    public static Library[] getLibrariesInfo(IServiceConnector iServiceConnector) throws Exception {
        List list;
        String string = UDocumentLibrary.getLibraryServiceBaseUrl(iServiceConnector);
        String string2 = string + "libraries/feed?pageSize=500000&page=1&sK=title&sO=asc";
        Document document = singleton.callService(string2, iServiceConnector);
        if (document == null || document.getRootElement() == null) {
            return null;
        }
        Element element = document.getRootElement();
        if (element != null && (list = element.getChildren("entry", atomNs)) != null && list.size() > 0) {
            ArrayList<Library> arrayList = new ArrayList<Library>();
            for (int i = 0; i < list.size(); ++i) {
                Element element2 = (Element)list.get(i);
                Element element3 = element2.getChild("category", atomNs);
                if (element3 == null || !TString.equals((String)element3.getAttributeValue("term"), (String)"library")) continue;
                Library library = new Library();
                library.title = UDocumentLibrary.getChildText(element2, "title", atomNs);
                List list2 = element2.getChildren("link", atomNs);
                if (list2 != null) {
                    for (int j = 0; j < list2.size(); ++j) {
                        String string3;
                        Element element4 = (Element)list2.get(j);
                        String string4 = element4.getAttributeValue("rel");
                        if (!TString.equals((String)string4, (String)"self") || (string3 = element4.getAttributeValue("href")) == null) continue;
                        if (!string3.endsWith("/feed")) {
                            int n = string3.lastIndexOf(47);
                            string3 = string3.substring(0, n) + "/feed";
                        }
                        library.url = string3;
                        if (string3.startsWith(string) || string3.startsWith("http")) continue;
                        library.url = string + string3;
                    }
                }
                arrayList.add(library);
            }
            Library[] libraryArray = new Library[arrayList.size()];
            libraryArray = arrayList.toArray(libraryArray);
            return libraryArray;
        }
        return null;
    }

    public static Library getCurrentLibraryInfo(Context context) throws Exception {
        String string = QuickrUtil.getCurrentDocumentLibraryHrefId(context);
        if (!TString.isEmpty((String)string)) {
            return UDocumentLibrary.getLibraryInfo(context, string);
        }
        return null;
    }

    public static Library getLibraryInfo(Context context, String string) throws Exception {
        return UDocumentLibrary.getLibraryInfo(new XSPServiceConnector(context), string);
    }

    public static Library getLibraryInfo(IServiceConnector iServiceConnector, String string) throws Exception {
        Element element;
        String string2 = UDocumentLibrary.getLibraryServiceBaseUrl(iServiceConnector);
        Library library = new Library();
        library.url = string2 + "library/" + string + "/feed";
        Document document = singleton.callService(library.url, iServiceConnector);
        if (document != null && (element = document.getRootElement()) != null && element.getName().equals("feed")) {
            library.title = UDocumentLibrary.getChildText(element, "title", atomNs);
            return library;
        }
        return null;
    }

    public static ListResult getLibraryContent(Context context, Library library, String string) throws Exception {
        return UDocumentLibrary.getLibraryContent(context, library, string, 1, 10);
    }

    public static ListResult getLibraryContent(Context context, Library library, String string, int n, int n2) throws Exception {
        return UDocumentLibrary.getLibraryContent(new XSPServiceConnector(context), library, string, n, n2);
    }

    public static ListResult getLibraryContent(IServiceConnector iServiceConnector, Library library, String string, int n, int n2) throws Exception {
        return UDocumentLibrary.getLibraryContent(iServiceConnector, library, string, n, n2, null, true);
    }

    public static ListResult getLibraryContent(Context context, Library library, String string, int n, int n2, String string2, boolean bl) throws Exception {
        return UDocumentLibrary.getLibraryContent(new XSPServiceConnector(context), library, string, n, n2, string2, bl);
    }

    public static ListResult getLibraryContent(IServiceConnector iServiceConnector, Library library, String string, int n, int n2, String string2, boolean bl) throws Exception {
        String string3 = library.url;
        if (!TString.isEmpty((String)string)) {
            string3 = library.url.substring(0, library.url.lastIndexOf(47)) + "/view/" + string + "/feed";
        }
        string3 = UDocumentLibrary.appendPageIndexAndSizeToUrl(string3, n, n2);
        string3 = TString.isEmpty((String)string2) ? UDocumentLibrary.appendSort(string3, "title", true) : UDocumentLibrary.appendSort(string3, string2, bl);
        Document document = singleton.callService(string3, iServiceConnector);
        if (document == null || document.getRootElement() == null) {
            return null;
        }
        ListResult listResult = new ListResult();
        listResult.entries = UDocumentLibrary.readEntries(UDocumentLibrary.getLibraryServiceBaseUrl(iServiceConnector), document);
        listResult.pageIndex = n;
        listResult.pageSize = n2;
        listResult.hasPrevious = UDocumentLibrary.hasPreviousPage(document);
        listResult.hasNext = UDocumentLibrary.hasNextPage(document);
        return listResult;
    }

    public static ListResult getFolderContent(Context context, Entry entry) throws Exception {
        return UDocumentLibrary.getFolderContent(context, entry, 1, 10);
    }

    public static ListResult getFolderContent(Context context, Entry entry, int n, int n2) throws Exception {
        return UDocumentLibrary.getFolderContent(context, entry.contentUrl, n, n2);
    }

    public static ListResult getFolderContent(Context context, String string, int n, int n2) throws Exception {
        return UDocumentLibrary.getFolderContent(new XSPServiceConnector(context), string, n, n2);
    }

    public static ListResult getFolderContent(IServiceConnector iServiceConnector, String string, int n, int n2) throws Exception {
        return UDocumentLibrary.getFolderContent(iServiceConnector, string, n, n2, null, true);
    }

    public static ListResult getFolderContent(Context context, String string, int n, int n2, String string2, boolean bl) throws Exception {
        return UDocumentLibrary.getFolderContent(new XSPServiceConnector(context), string, n, n2, string2, bl);
    }

    public static ListResult getFolderContent(IServiceConnector iServiceConnector, String string, int n, int n2, String string2, boolean bl) throws Exception {
        String string3 = UDocumentLibrary.appendPageIndexAndSizeToUrl(string, n, n2);
        string3 = TString.isEmpty((String)string2) ? UDocumentLibrary.appendSort(string3, "title", true) : UDocumentLibrary.appendSort(string3, string2, bl);
        Document document = singleton.callService(string3, iServiceConnector);
        if (document == null || document.getRootElement() == null) {
            return null;
        }
        ListResult listResult = new ListResult();
        listResult.entries = UDocumentLibrary.readEntries(UDocumentLibrary.getLibraryServiceBaseUrl(iServiceConnector), document);
        listResult.pageIndex = n;
        listResult.pageSize = n2;
        listResult.hasPrevious = UDocumentLibrary.hasPreviousPage(document);
        listResult.hasNext = UDocumentLibrary.hasNextPage(document);
        return listResult;
    }

    public static boolean doesEntryExist(Context context, String string) {
        return UDocumentLibrary.doesEntryExist(new XSPServiceConnector(context), string);
    }

    public static boolean doesEntryExist(IServiceConnector iServiceConnector, String string) {
        try {
            Document document = singleton.callService(string, iServiceConnector);
            if (document == null || document.getRootElement() == null) {
                return false;
            }
            Element element = document.getRootElement();
            Element element2 = element.getChild("error", ibmTdNs);
            String string2 = "";
            if (element2 != null) {
                string2 = UDocumentLibrary.getChildText(element2, "errorCode", ibmTdNs);
            }
            return !TString.equals((String)string2, (String)"ItemNotFound");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Entry getEntryInfo(IServiceConnector iServiceConnector, String string) throws Exception {
        Document document = singleton.callService(string, iServiceConnector);
        if (document == null || document.getRootElement() == null) {
            return null;
        }
        Element element = document.getRootElement();
        String string2 = element.getAttributeValue("base", xmlNs);
        if (!element.getName().equals("entry")) {
            return null;
        }
        return UDocumentLibrary.readEntryElement(element, string2);
    }

    public static Scope[] getSearchScopes(Context context) throws Exception {
        List list;
        Element element;
        XSPServiceConnector xSPServiceConnector = new XSPServiceConnector(context);
        String string = UDocumentLibrary.getSearchServiceBaseUrl(xSPServiceConnector);
        Document document = singleton.callService(string + "scopes", xSPServiceConnector);
        if (document != null && (element = document.getRootElement()) != null && element.getName().equals("feed") && (list = element.getChildren("entry", atomNs)) != null) {
            Scope[] scopeArray = new Scope[list.size()];
            for (int i = 0; i < scopeArray.length; ++i) {
                scopeArray[i] = new Scope();
                Element element2 = (Element)list.get(i);
                scopeArray[i].title = UDocumentLibrary.getChildText(element2, "title", atomNs);
                scopeArray[i].summary = UDocumentLibrary.getChildText(element2, "summary", atomNs);
                scopeArray[i].id = UDocumentLibrary.getChildText(element2, "id", atomNs);
            }
            return scopeArray;
        }
        return null;
    }

    public static SearchResult searchEntries(Context context, String string) throws Exception {
        return UDocumentLibrary.searchEntries(context, string, 0, 10, (String)null, null);
    }

    public static SearchResult searchEntries(Context context, String string, int n, int n2) throws Exception {
        return UDocumentLibrary.searchEntries(context, string, n, n2, (String)null, null);
    }

    public static SearchResult searchEntries(Context context, String string, int n, int n2, Scope scope, String string2) throws Exception {
        String string3 = scope != null ? scope.id : "";
        return UDocumentLibrary.searchEntries(context, string, n, n2, string3, string2);
    }

    public static SearchResult searchEntries(Context context, String string, int n, int n2, String string2, String string3) throws Exception {
        return UDocumentLibrary.searchEntries(new XSPServiceConnector(context), string, n, n2, string2, string3);
    }

    public static SearchResult searchEntries(IServiceConnector iServiceConnector, String string, int n, int n2, String string2, String string3) throws Exception {
        if (DEV_ENV) {
            System.out.println("--- searchEntries query=" + string + " start=" + n + " maxResult=" + n2 + " scopeId=" + string2);
        }
        String string4 = UDocumentLibrary.getSearchServiceBaseUrl(iServiceConnector);
        StringBuffer stringBuffer = new StringBuffer(string4);
        stringBuffer.append("search?");
        stringBuffer.append("query=").append(URLEncoder.encode(string, "UTF-8"));
        stringBuffer.append("&start=").append(n);
        stringBuffer.append("&results=").append(n2);
        stringBuffer.append("&scope=");
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        if (string3 != null) {
            stringBuffer.append("&queryLang=").append(string3);
        }
        Document document = singleton.callService(stringBuffer.toString(), iServiceConnector);
        return UDocumentLibrary.extractSearchResult(iServiceConnector, document);
    }

    public static SearchResult searchEntriesInLibraryQD(Context context, String string, String string2, int n, int n2) throws Exception {
        if (DEV_ENV) {
            System.out.println("--- searchEntriesQD query=" + string2 + " placeId=" + string + " start=" + n + " maxResult=" + n2);
        }
        XSPServiceConnector xSPServiceConnector = new XSPServiceConnector(context);
        String string3 = ULTPA.getCookiesWithLtpaToken(xSPServiceConnector.getHttpServletRequest());
        SearchResult searchResult = UDocLibQDPatch.searchEntriesQD(xSPServiceConnector.getBaseUrl(), string3, string, string2, n, n2);
        return searchResult;
    }

    public static SearchResult searchEntriesInLibrary(Context context, String string, int n, int n2, String string2, String string3) throws Exception {
        return UDocumentLibrary.searchEntriesInLibrary(new XSPServiceConnector(context), string, n, n2, string2, string3);
    }

    public static SearchResult searchEntriesInLibrary(IServiceConnector iServiceConnector, String string, int n, int n2, String string2, String string3) throws Exception {
        if (DEV_ENV) {
            System.out.println("--- searchEntries query=" + string + " start=" + n + " maxResult=" + n2 + " libHrefId=" + string2);
        }
        String string4 = UDocumentLibrary.getSearchServiceBaseUrl(iServiceConnector);
        StringBuffer stringBuffer = new StringBuffer(string4);
        stringBuffer.append("search?");
        stringBuffer.append("query=").append(URLEncoder.encode(string, "UTF-8"));
        stringBuffer.append("&start=").append(n);
        stringBuffer.append("&results=").append(n2);
        stringBuffer.append("&scope=");
        String string5 = UDocumentLibrary.getLibSearchScopeXmlStr(string2);
        stringBuffer.append(URLEncoder.encode(string5, "UTF-8"));
        if (string3 != null) {
            stringBuffer.append("&queryLang=").append(string3);
        }
        Document document = singleton.callService(stringBuffer.toString(), iServiceConnector);
        return UDocumentLibrary.extractSearchResult(iServiceConnector, document);
    }

    protected static SearchResult extractSearchResult(IServiceConnector iServiceConnector, Document document) throws Exception {
        Element element;
        if (document != null && (element = document.getRootElement()) != null) {
            SearchResult searchResult = new SearchResult();
            Element element2 = element.getChild("link", atomNs);
            if (element2 != null) {
                searchResult.url = element2.getAttributeValue("href");
            }
            searchResult.totalResult = Integer.parseInt(UDocumentLibrary.getChildText(element, "totalResults", openSearchNs));
            searchResult.startIndex = Integer.parseInt(UDocumentLibrary.getChildText(element, "startIndex", openSearchNs));
            searchResult.itemsPerPage = Integer.parseInt(UDocumentLibrary.getChildText(element, "itemsPerPage", openSearchNs));
            List list = element.getChildren("entry", atomNs);
            if (list != null && list.size() > 0) {
                ArrayList<Element> arrayList = new ArrayList<Element>();
                for (int i = 0; i < list.size(); ++i) {
                    String string;
                    Object object;
                    Object object2;
                    String string2;
                    Element element3 = (Element)list.get(i);
                    String string3 = null;
                    Element element4 = element3.getChild("category", atomNs);
                    String string4 = string2 = element4 != null ? element4.getAttributeValue("label") : null;
                    if (TString.equalsIgnoreCase((String)string2, (String)"document")) {
                        object2 = null;
                        object = element3.getChildren("link", atomNs);
                        if (object.size() == 1) {
                            object2 = (Element)object.get(0);
                        }
                        String string5 = string = object2 != null ? object2.getAttributeValue("href") : null;
                        if (!TString.isEmpty((String)string)) {
                            String string6;
                            int n = string.indexOf(63);
                            int n2 = string.indexOf(38, n);
                            if (n2 == -1) {
                                n2 = string.length();
                            }
                            int n3 = string.indexOf(61, n);
                            if (n != -1 && n2 != -1 && n3 != -1 && n3 < n2) {
                                string6 = string.substring(n3 + 1, n2);
                                n3 = (string6 = URLDecoder.decode(string6)).indexOf(58);
                                if (n3 != -1) {
                                    string3 = string6.substring(n3 + 1);
                                }
                            }
                            if (TString.isEmpty(string3)) {
                                int n4;
                                if (n == -1) {
                                    n = string.length();
                                }
                                if ((n4 = (string6 = string.substring(0, n)).lastIndexOf("/dm/")) != -1) {
                                    string3 = string6.substring(n4 + 4);
                                }
                            }
                        }
                    }
                    object2 = null;
                    if (string3 != null) {
                        Element element5;
                        object = UDocumentLibrary.getLibraryServiceBaseUrl(iServiceConnector) + "library/" + string3 + "/";
                        string = (String)object + "document/" + string3 + "/entry";
                        Document document2 = singleton.callService(string, iServiceConnector);
                        if (document2 != null && (element5 = document2.getRootElement()) != null) {
                            object2 = UDocumentLibrary.readEntryElement(element5, (String)object);
                            if (TString.isEmpty((String)object2.category)) {
                                object2.category = string2;
                            }
                        }
                    } else {
                        object2 = UDocumentLibrary.readEntryElement(element3, UDocumentLibrary.getLibraryServiceBaseUrl(iServiceConnector) + "library/anything/");
                    }
                    if (object2 == null) continue;
                    try {
                        object2.searchRelevance = Float.parseFloat(UDocumentLibrary.getChildText(element3, "relevance", openSearchNs));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    arrayList.add((Element)object2);
                }
                searchResult.entries = new Entry[arrayList.size()];
                searchResult.entries = arrayList.toArray(searchResult.entries);
            } else {
                searchResult.entries = new Entry[0];
            }
            return searchResult;
        }
        return null;
    }

    private static String getPlaceSearchScopeXmlStr(String string) {
        StringBuffer stringBuffer = new StringBuffer("<scope><title></title><scopeelement><location source=\"com.ibm.cai,localhost\" path=\"");
        stringBuffer.append(string);
        stringBuffer.append("\"/></scopeelement></scope>");
        return stringBuffer.toString();
    }

    private static String getLibSearchScopeXmlStr(String string) {
        StringBuffer stringBuffer = new StringBuffer("<scope><title></title><scopeelement><location source=\"com.ibm.jcr,localhost\" path=\"");
        stringBuffer.append(string);
        stringBuffer.append("\"/></scopeelement></scope>");
        return stringBuffer.toString();
    }

    public static Entry createFolder(Context context, Library library, String string, String string2, String string3) throws Exception {
        return UDocumentLibrary.createFolder(context, library.url, string, string2, string3);
    }

    public static Entry createFolder(Context context, Entry entry, String string, String string2, String string3) throws Exception {
        return UDocumentLibrary.createFolder(context, entry.contentUrl, string, string2, string3);
    }

    public static Entry createFolder(Context context, String string, String string2, String string3, String string4) throws Exception {
        DirectoryUser directoryUser = null;
        if (DEV_ENV && context == null) {
            directoryUser = new DirectoryUser("quikradm", "quikradm");
            directoryUser.setFullName("uid=quikradm,O=default+organization");
        } else {
            directoryUser = context.getUser();
        }
        return UDocumentLibrary.createFolder(new XSPServiceConnector(context), string, string2, string3, string4, directoryUser.getCommonName(), directoryUser.getDistinguishedName(), directoryUser.getMail());
    }

    public static Entry createFolder(IServiceConnector iServiceConnector, String string, String string2, String string3, String string4, String string5, String string6, String string7) throws Exception {
        String string8 = UDocumentLibrary.getCreationFolderXmlStr(string, string2, string3, string4, string5, string6, string7);
        Document document = singleton.callService(string, iServiceConnector, string8);
        if (document == null || document.getRootElement() == null) {
            return null;
        }
        Element element = document.getRootElement();
        String string9 = element.getAttributeValue("base", xmlNs);
        if (!element.getName().equals("entry")) {
            return null;
        }
        return UDocumentLibrary.readEntryElement(element, string9);
    }

    private static String getCreationFolderXmlStr(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        StringBuffer stringBuffer = new StringBuffer("<entry xml:base=\"");
        stringBuffer.append(string);
        stringBuffer.append("\" xmlns=\"http://www.w3.org/2005/Atom\">\n");
        stringBuffer.append(" <id>urn:lsid:ibm.com:td:unknown</id>\n");
        stringBuffer.append(" <category term=\"folder\" scheme=\"tag:ibm.com,2006:td/type\" label=\"folder\"/>\n");
        stringBuffer.append(" <author>\n");
        stringBuffer.append("   <uri>").append(TString.toXMLString((String)string6)).append("</uri>\n");
        stringBuffer.append("   <name>").append(TString.toXMLString((String)string5)).append("</name>\n");
        stringBuffer.append("   <email>").append(TString.toXMLString((String)string7)).append("</email>\n");
        stringBuffer.append(" </author>\n");
        stringBuffer.append(" <title type=\"text\">").append(TString.toXMLString((String)string2)).append("</title>\n");
        if (TString.isEmpty((String)string4) || !TString.equals((String)string4, (String)"text") || !TString.equals((String)string4, (String)"html")) {
            string4 = "text";
        }
        stringBuffer.append(" <summary type=\"").append(string4).append("\">").append(TString.toXMLString((String)string3)).append("</summary>\n");
        stringBuffer.append("</entry>");
        return stringBuffer.toString();
    }

    public static Entry addDocument(Context context, Library library, String string, String string2, String string3, String string4, InputStream inputStream) throws Exception {
        return UDocumentLibrary.addDocument(context, library.url, string, string2, string3, string4, inputStream);
    }

    public static Entry addDocument(Context context, Entry entry, String string, String string2, String string3, String string4, InputStream inputStream) throws Exception {
        return UDocumentLibrary.addDocument(context, entry.contentUrl, string, string2, string3, string4, inputStream);
    }

    public static Entry addDocument(Context context, String string, String string2, String string3, String string4, String string5, InputStream inputStream) throws Exception {
        return UDocumentLibrary.addDocument(new XSPServiceConnector(context), string, string2, string3, string4, string5, inputStream);
    }

    public static Entry addDocument(IServiceConnector iServiceConnector, String string, String string2, String string3, String string4, String string5, InputStream inputStream) throws Exception {
        return UDocumentLibrary.addDocument(iServiceConnector, string, string2, string3, string4, string5, inputStream, null, null, null);
    }

    public static Entry addDocument(IServiceConnector iServiceConnector, String string, String string2, String string3, String string4, String string5, InputStream inputStream, Date date, Date date2, String string6) throws Exception {
        if (DEV_ENV) {
            System.out.println("--- addDocument " + string + " " + string2 + " " + string3 + " " + string4 + " " + string5 + " " + string6);
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if (date != null) {
            if (stringBuffer.indexOf("?") == -1) {
                stringBuffer.append('?');
            } else {
                stringBuffer.append('&');
            }
            stringBuffer.append("created=").append(date.getTime());
        }
        if (date2 != null) {
            if (stringBuffer.indexOf("?") == -1) {
                stringBuffer.append('?');
            } else {
                stringBuffer.append('&');
            }
            stringBuffer.append("modified=").append(date2.getTime());
        }
        if (stringBuffer.indexOf("?") == -1) {
            stringBuffer.append('?');
        } else {
            stringBuffer.append('&');
        }
        stringBuffer.append("replace=true&lock=true&submit=true");
        Document document = singleton.callService(stringBuffer.toString(), iServiceConnector, string2, inputStream, string3);
        if (document == null || document.getRootElement() == null) {
            return null;
        }
        if (!TString.isEmpty((String)string4)) {
            NamespaceContext namespaceContext = new NamespaceContext();
            namespaceContext.addNamespace("atom", "http://www.w3.org/2005/Atom");
            namespaceContext.addNamespace("", "");
            String string7 = document.getRootElement().getAttributeValue("base", xmlNs);
            String string8 = JDOMUtil.getStringValue((Document)document, (String)"/atom:entry/atom:link[@rel='self']/@href", (XPathEngine.INamespaceContext)namespaceContext);
            if (!string8.startsWith(string7) && !string8.startsWith("http")) {
                string8 = string7 + string8;
            }
            if (iServiceConnector instanceof ServletServiceConnector) {
                string8 = QuickrUtil.convertQuickrProxyRestUrlToServer(((ServletServiceConnector)iServiceConnector).getHttpServletRequest(), string8);
            }
            Entry entry = UDocumentLibrary.updateDocSummary(iServiceConnector, string8, string2, string4, string5);
            UDocumentLibrary.lockDoc(iServiceConnector, string8, false);
            return entry;
        }
        Element element = document.getRootElement();
        String string9 = element.getAttributeValue("base", xmlNs);
        if (!element.getName().equals("entry")) {
            return null;
        }
        Entry entry = UDocumentLibrary.readEntryElement(element, string9);
        String string10 = entry.entryUrl;
        if (iServiceConnector instanceof ServletServiceConnector) {
            string10 = QuickrUtil.convertQuickrProxyRestUrlToServer(((ServletServiceConnector)iServiceConnector).getHttpServletRequest(), string10);
        }
        UDocumentLibrary.lockDoc(iServiceConnector, string10, false);
        return entry;
    }

    public static Entry updateDocSummary(IServiceConnector iServiceConnector, String string, String string2, String string3, String string4) throws Exception {
        if (DEV_ENV) {
            System.out.println("--- updateDocSummary  " + string + " '" + string2 + "' " + " '" + string3 + "' " + string4);
        }
        String string5 = string.substring(0, string.lastIndexOf(47));
        string5 = string5.substring(string5.lastIndexOf(47) + 1);
        String string6 = UDocumentLibrary.getUpdateDocSummaryXmlStr(string5, string2, string3, string4);
        String[][] stringArray = new String[1][2];
        stringArray[0][0] = "X-Method-Override";
        stringArray[0][1] = "PUT";
        Document document = singleton.callService(string + "?lock=true", iServiceConnector, string6, stringArray);
        if (document == null || document.getRootElement() == null) {
            return null;
        }
        Element element = document.getRootElement();
        String string7 = element.getAttributeValue("base", xmlNs);
        if (!element.getName().equals("entry")) {
            return null;
        }
        return UDocumentLibrary.readEntryElement(element, string7);
    }

    private static String getUpdateDocSummaryXmlStr(String string, String string2, String string3, String string4) {
        StringBuffer stringBuffer = new StringBuffer("<entry xmlns=\"http://www.w3.org/2005/Atom\">\n");
        stringBuffer.append(" <id>urn:lsid:ibm.com:td:").append(string).append("</id>\n");
        stringBuffer.append(" <category term=\"document\" scheme=\"tag:ibm.com,2006:td/type\" label=\"document\"/>\n");
        if (!TString.isEmpty((String)string2)) {
            stringBuffer.append(" <title type=\"text\">").append(string2).append("</title>");
        }
        if (TString.isEmpty((String)string4) || !TString.equals((String)string4, (String)"text") || !TString.equals((String)string4, (String)"html")) {
            string4 = "text";
        }
        stringBuffer.append(" <summary type=\"").append(string4).append("\">").append(TString.toXMLString((String)string3)).append("</summary>\n");
        stringBuffer.append("</entry>");
        return stringBuffer.toString();
    }

    public static boolean lockDoc(Context context, String string, boolean bl) throws Exception {
        if (DEV_ENV) {
            System.out.println("--- lockDoc  " + string + " " + bl);
        }
        return singleton.callService(string + "?lock=" + Boolean.toString(bl), new XSPServiceConnector(context)) != null;
    }

    public static boolean lockDoc(IServiceConnector iServiceConnector, String string, boolean bl) throws Exception {
        if (DEV_ENV) {
            System.out.println("--- lockDoc  " + string + " " + bl);
        }
        return singleton.callService(string + "?lock=" + Boolean.toString(bl), iServiceConnector) != null;
    }

    public static boolean checkOutDoc(IServiceConnector iServiceConnector, String string, String string2, String string3) throws Exception {
        if (DEV_ENV) {
            System.out.println("--- checkOutDoc  " + string3);
        }
        UDocLibSOAP uDocLibSOAP = new UDocLibSOAP();
        return uDocLibSOAP.checkOutDoc(iServiceConnector, string3);
    }

    protected static boolean checkOutDocREST(IServiceConnector iServiceConnector, String string, Entry entry) throws Exception {
        if (DEV_ENV) {
            System.out.println("--- checkOutDoc  " + entry.id);
        }
        String string2 = UDocumentLibrary.getLibraryServiceBaseUrl(iServiceConnector);
        string2 = string2 + "library/" + string + "/view/CheckedOut/feed";
        singleton.callService(string2, iServiceConnector, entry.toXmlEntryAtom());
        return true;
    }

    public static Entry[] getCheckedOutDocuments(IServiceConnector iServiceConnector, String string) throws Exception {
        String string2 = UDocumentLibrary.getLibraryServiceBaseUrl(iServiceConnector);
        Document document = singleton.callService(string2 = string2 + "library/" + string + "/view/CheckedOut/feed?pageSize=-1", iServiceConnector);
        if (document == null || document.getRootElement() == null) {
            return null;
        }
        return UDocumentLibrary.readEntries(UDocumentLibrary.getLibraryServiceBaseUrl(iServiceConnector), document);
    }

    public static boolean checkInDoc(IServiceConnector iServiceConnector, String string, String string2, String string3) throws Exception {
        if (DEV_ENV) {
            System.out.println("--- checkInDoc  " + string3);
        }
        UDocLibSOAP uDocLibSOAP = new UDocLibSOAP();
        return uDocLibSOAP.checkInDoc(iServiceConnector, string3);
    }

    public static boolean cancelCheckOutDoc(IServiceConnector iServiceConnector, String string, String string2) throws Exception {
        if (DEV_ENV) {
            System.out.println("--- cancelCheckOutDoc  " + string2);
        }
        UDocLibSOAP uDocLibSOAP = new UDocLibSOAP();
        return uDocLibSOAP.cancelDocCheck(iServiceConnector, string2);
    }

    public static Date getDocumentCreationDateQD(Context context, String string, String string2) throws Exception {
        if (DEV_ENV) {
            System.out.println("--- getDocumentCreationDateQD " + string2);
        }
        XSPServiceConnector xSPServiceConnector = new XSPServiceConnector(context);
        String string3 = ULTPA.getCookiesWithLtpaToken(xSPServiceConnector.getHttpServletRequest());
        return UDocLibQDPatch.getDocumentCreationDate(string3, string, string2);
    }

    public static File getTemporaryDocumentFile(IServiceConnector iServiceConnector, Entry entry) throws Exception {
        return UDocumentLibrary.getTemporaryDocumentFile(iServiceConnector, entry.contentUrl, entry.title);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getTemporaryDocumentFile(IServiceConnector iServiceConnector, String string, String string2) throws Exception {
        File file = UDocumentLibrary.getTemporaryFile(string2);
        file.deleteOnExit();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        InputStream inputStream = UDocumentLibrary.getDocumentInputStream(iServiceConnector, string);
        try {
            byte[] byArray = new byte[4096];
            int n = 0;
            while (n >= 0) {
                if (n > 0) {
                    fileOutputStream.write(byArray, 0, n);
                }
                n = inputStream.read(byArray);
            }
        }
        finally {
            inputStream.close();
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        return file;
    }

    private static File getTemporaryFile(String string) throws IOException {
        int n = string.lastIndexOf(46);
        String string2 = n >= 0 ? string.substring(n + 1) : "";
        string2 = !TString.isEmpty((String)string2) ? "." + string2 : null;
        return File.createTempFile("TMP_docLib_", string2);
    }

    private static InputStream getDocumentInputStream(IServiceConnector iServiceConnector, String string) throws Exception {
        URL uRL = new URL(string);
        URLConnection uRLConnection = uRL.openConnection();
        iServiceConnector.setAuthorization(uRLConnection);
        if (uRLConnection instanceof HttpURLConnection) {
            int n = ((HttpURLConnection)uRLConnection).getResponseCode();
            String string2 = ((HttpURLConnection)uRLConnection).getResponseMessage();
            if (n != 200 && n != 201) {
                TDiag.error((String)"Error during getDocumentInputStream - ResponseCode=%1 ResponseMessage=%2", (Object)String.valueOf(n), (Object)string2);
                throw new Exception("HttpURLConnection error: " + n + " - " + string2);
            }
        }
        return uRLConnection.getInputStream();
    }

    protected static String getLibraryServiceBaseUrl(IServiceConnector iServiceConnector) {
        return iServiceConnector.getBaseUrl() + "dm/atom/";
    }

    protected static String getSearchServiceBaseUrl(IServiceConnector iServiceConnector) {
        return iServiceConnector.getBaseUrl() + "searchfeed/myserver/";
    }

    private static Entry[] readEntries(String string, Document document) {
        Element element = document.getRootElement();
        String string2 = element.getAttributeValue("base", xmlNs);
        List list = element.getChildren("entry", atomNs);
        if (list != null && list.size() > 0) {
            ArrayList<Entry> arrayList = new ArrayList<Entry>();
            for (int i = 0; i < list.size(); ++i) {
                arrayList.add(UDocumentLibrary.readEntryElement((Element)list.get(i), string2));
            }
            Entry[] entryArray = new Entry[arrayList.size()];
            entryArray = arrayList.toArray(entryArray);
            return entryArray;
        }
        return null;
    }

    private static Entry readEntryElement(Element element, String string) {
        Element element2;
        Element element3;
        String string2;
        int n;
        String string3;
        Element element4;
        String string4;
        Entry entry = new Entry();
        Element element5 = element.getChild("category", atomNs);
        if (element5 != null) {
            entry.category = element5.getAttributeValue("term");
        }
        entry.title = UDocumentLibrary.getChildText(element, "title", atomNs);
        entry.summary = UDocumentLibrary.getChildText(element, "summary", atomNs);
        entry.fileName = UDocumentLibrary.getChildText(element, "label", ibmTdNs);
        String string5 = UDocumentLibrary.getChildText(element, "id", atomNs);
        entry.id = singleton.extractId(string5);
        List list = element.getChildren("link", atomNs);
        String string6 = null;
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Element element6 = (Element)list.get(i);
                string4 = element6.getAttributeValue("rel");
                if (TString.equals((String)string4, (String)"alternate")) {
                    entry.url = element6.getAttributeValue("href");
                    if (entry.url == null || string == null || entry.url.startsWith(string) || entry.url.startsWith("http")) continue;
                    entry.url = string + entry.url;
                    continue;
                }
                if (TString.equals((String)string4, (String)"self")) {
                    entry.entryUrl = element6.getAttributeValue("href");
                    if (entry.entryUrl == null || string == null || entry.entryUrl.startsWith(string) || entry.entryUrl.startsWith("http")) continue;
                    entry.entryUrl = string + entry.entryUrl;
                    continue;
                }
                if (TString.equals((String)string4, (String)"edit-media")) {
                    string6 = element6.getAttributeValue("href");
                    if (string6 == null || string == null || string6.startsWith(string) || string6.startsWith("http")) continue;
                    string6 = string + string6;
                    continue;
                }
                if (!TString.equals((String)string4, (String)"attachment0")) continue;
                entry.fileName = element6.getAttributeValue("title");
                entry.contentType = element6.getAttributeValue("type");
            }
        }
        if ((element4 = element.getChild("content", atomNs)) != null) {
            entry.contentUrl = element4.getAttributeValue("src");
            if (entry.contentUrl != null && string != null && !entry.contentUrl.startsWith(string) && !entry.contentUrl.startsWith("http")) {
                entry.contentUrl = string + entry.contentUrl;
            }
            entry.contentType = element4.getAttributeValue("type");
            if (entry.contentUrl.endsWith("/feed") && "document".equalsIgnoreCase(entry.category)) {
                entry.contentUrl = null;
            }
        }
        if (TString.isEmpty((String)entry.contentUrl) || TString.isEmpty((String)entry.fileName)) {
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    String string7;
                    string4 = (Element)list.get(i);
                    string3 = string4.getAttributeValue("rel");
                    if (!TString.equals((String)string3, (String)"enclosure")) continue;
                    if (TString.isEmpty((String)entry.contentUrl)) {
                        entry.contentUrl = string4.getAttributeValue("href");
                        if (entry.contentUrl != null && string != null && !entry.contentUrl.startsWith(string) && !entry.contentUrl.startsWith("http")) {
                            entry.contentUrl = string + entry.contentUrl;
                        }
                    }
                    if (TString.isEmpty((String)entry.fileName)) {
                        entry.fileName = string4.getAttributeValue("title");
                    }
                    if (!TString.isEmpty((String)entry.contentType)) break;
                    entry.contentType = string4.getAttributeValue("type");
                    if (!TString.isEmpty((String)entry.contentType) && !"application/msword".equals(entry.contentType) && !"application/atom+xml".equals(entry.contentType) || TString.isEmpty((String)(string7 = TFile.getFileExtension((String)entry.fileName)))) break;
                    entry.contentType = MIME.getMIMETypeFromExtension((String)string7);
                    break;
                }
            }
            if (entry.contentUrl == null) {
                entry.contentUrl = string6;
            }
            if (TString.isEmpty((String)entry.fileName) && ("document".equalsIgnoreCase(entry.category) || "draft".equalsIgnoreCase(entry.category))) {
                entry.fileName = entry.title;
            }
        }
        if (("document".equalsIgnoreCase(entry.category) || "draft".equalsIgnoreCase(entry.category)) && (TString.isEmpty((String)entry.contentType) || "application/atom+xml".equals(entry.contentType) || "application/unknown".equals(entry.contentType))) {
            entry.contentType = null;
            String string8 = TFile.getFileExtension((String)entry.fileName);
            if (!TString.isEmpty((String)string8)) {
                entry.contentType = MIME.getMIMETypeFromExtension((String)string8);
            }
            if (TString.isEmpty((String)entry.contentType) && TString.isEmpty((String)string8) && !TString.isEmpty((String)(string4 = TFile.getFileExtension((String)entry.id)))) {
                entry.contentType = MIME.getMIMETypeFromExtension((String)string4);
                entry.fileName = entry.fileName + "." + string4;
            }
        }
        if (TString.equals((String)entry.category, (String)"folder") && !TString.isEmpty((String)entry.contentUrl) && (n = entry.contentUrl.indexOf(string2 = "%2F%40RMain.nsf%5D/document/%5B%40P")) != -1) {
            entry.contentUrl = entry.contentUrl.substring(0, n) + "%2F%40RMain.nsf%5D/folder/%5B%40P" + entry.contentUrl.substring(n + string2.length());
        }
        if ((element3 = element.getChild("author", atomNs)) != null) {
            entry.author = UDocumentLibrary.getChildText(element3, "name", atomNs);
            String string9 = UDocumentLibrary.getChildText(element3, "uri", atomNs);
            if (!TString.isEmpty((String)string9)) {
                entry.authorDn = URLDecoder.decode(string9);
            }
            entry.authorEmail = UDocumentLibrary.getChildText(element3, "email ", atomNs);
        }
        if (!TString.isEmpty((String)entry.authorDn) && TProperties.getBoolean((String)"fb.ldap.dn.forceLowerCase")) {
            entry.authorDn = entry.authorDn.toLowerCase();
        }
        entry.creationDate = UDocumentLibrary.getChildText(element, "created", ibmTdNs);
        entry.modificationDate = UDocumentLibrary.getChildText(element, "modified", ibmTdNs);
        if (TString.isEmpty((String)entry.modificationDate)) {
            entry.modificationDate = UDocumentLibrary.getChildText(element, "updated", atomNs);
        }
        if ((element2 = element.getChild("modifier", ibmTdNs)) != null) {
            entry.modifier = UDocumentLibrary.getChildText(element2, "name", ibmTdNs);
            string3 = UDocumentLibrary.getChildText(element2, "uri", ibmTdNs);
            if (!TString.isEmpty((String)string3)) {
                entry.modifierDn = URLDecoder.decode(string3);
            }
            entry.modifierEmail = UDocumentLibrary.getChildText(element2, "email ", ibmTdNs);
        }
        return entry;
    }

    private static boolean hasNextPage(Document document) {
        List list;
        Element element;
        if (document != null && (element = document.getRootElement()) != null && (list = element.getChildren("link", atomNs)) != null) {
            for (int i = 0; i < list.size(); ++i) {
                Element element2 = (Element)list.get(i);
                if (!TString.equalsIgnoreCase((String)element2.getAttributeValue("rel"), (String)"next")) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasPreviousPage(Document document) {
        List list;
        Element element;
        if (document != null && (element = document.getRootElement()) != null && (list = element.getChildren("link", atomNs)) != null) {
            for (int i = 0; i < list.size(); ++i) {
                Element element2 = (Element)list.get(i);
                if (!TString.equalsIgnoreCase((String)element2.getAttributeValue("rel"), (String)"previous")) continue;
                return true;
            }
        }
        return false;
    }

    private static String appendPageIndexAndSizeToUrl(String string, int n, int n2) {
        if (n != 0 || n2 != 10) {
            StringBuffer stringBuffer = new StringBuffer(string);
            if (string.indexOf(63) == -1) {
                stringBuffer.append("?");
            } else {
                stringBuffer.append("&");
            }
            stringBuffer.append("page=").append(n);
            stringBuffer.append("&pagesize=").append(n2);
            return stringBuffer.toString();
        }
        return string;
    }

    private static String appendSort(String string, String string2, boolean bl) {
        if (!TString.isEmpty((String)string2)) {
            StringBuffer stringBuffer = new StringBuffer(string);
            if (string.indexOf(63) == -1) {
                stringBuffer.append("?");
            } else {
                stringBuffer.append("&");
            }
            stringBuffer.append("sK=").append(string2);
            stringBuffer.append("&sO=");
            if (bl) {
                stringBuffer.append("asc");
            } else {
                stringBuffer.append("dsc");
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public static void dumpEntry(Entry entry) {
        System.out.println(" Entry :  " + entry.title);
        System.out.println(" ........ category = " + entry.category);
        System.out.println(" ........ summary = " + entry.summary);
        System.out.println(" ........ id = " + entry.id);
        System.out.println(" ........ url = " + entry.url);
        System.out.println(" ........ entryUrl = " + entry.entryUrl);
        System.out.println(" ........ contentUrl = " + entry.contentUrl);
        System.out.println(" ........ author = " + entry.author);
        System.out.println(" ........ authorDn = " + entry.authorDn);
        System.out.println(" ........ authorEmail = " + entry.authorEmail);
        System.out.println(" ........ creationDate = " + entry.creationDate);
        System.out.println(" ........ modifier = " + entry.modifier);
        System.out.println(" ........ modifierDn = " + entry.modifierDn);
        System.out.println(" ........ modifierEmail = " + entry.modifierEmail);
        System.out.println(" ........ modificationDate = " + entry.modificationDate);
        System.out.println(" ........ relevance = " + entry.searchRelevance);
        if ("document".equals(entry.category)) {
            System.out.println(" ........ fileName = " + entry.fileName);
            System.out.println(" ........ contentType = " + entry.contentType);
        }
    }

    public static void main(String[] stringArray) {
        try {
            Entry[] entryArray;
            Object object;
            UService.DEV_ENV = true;
            ClientServiceConnector clientServiceConnector = new ClientServiceConnector("http://tgqj85fr.triloggroup.com:10040/", "pcollins", "flafla");
            SearchResult searchResult = UDocumentLibrary.searchEntriesInLibrary(clientServiceConnector, "install%", 0, 10, "ce301f804cf539cb95689d1442fd00e1", null);
            System.out.println("Result of search :");
            System.out.println(".. url = " + searchResult.url);
            System.out.println(".. totalResult = " + searchResult.totalResult);
            System.out.println(".. startIndex = " + searchResult.startIndex);
            System.out.println(".. itemsPerPage = " + searchResult.itemsPerPage);
            System.out.println("\n ---- nb entries = " + searchResult.entries.length);
            for (int i = 0; i < searchResult.entries.length; ++i) {
                UDocumentLibrary.dumpEntry(searchResult.entries[i]);
                System.out.println("-------------------------------");
            }
            System.exit(0);
            String string = "ce301f804cf539cb95689d1442fd00e1";
            Library library = UDocumentLibrary.getLibraryInfo(clientServiceConnector, string);
            System.out.println("---- lib " + library.title);
            System.out.println("     lib.url " + library.url);
            ListResult listResult = UDocumentLibrary.getLibraryContent(clientServiceConnector, library, null, 1, 100);
            Entry[] entryArray2 = listResult.entries;
            for (int i = 0; i < entryArray2.length; ++i) {
                UDocumentLibrary.dumpEntry(entryArray2[i]);
                if (!entryArray2[i].category.equals("folder")) continue;
                System.out.println("---- get folder content for test---");
                object = UDocumentLibrary.getFolderContent(clientServiceConnector, entryArray2[i].contentUrl, 1, 100);
                entryArray = ((ListResult)object).entries;
                if (entryArray == null) continue;
                for (int j = 0; j < entryArray.length; ++j) {
                    UDocumentLibrary.dumpEntry(entryArray[j]);
                    if (entryArray[j].category.equals("folder")) {
                        System.out.println("\t ---- get folder content for test---");
                        ListResult listResult2 = UDocumentLibrary.getFolderContent(clientServiceConnector, entryArray[j].contentUrl, 1, 100);
                        Entry[] entryArray3 = listResult2.entries;
                        if (entryArray3 == null) continue;
                        for (int k = 0; k < entryArray3.length; ++k) {
                            UDocumentLibrary.dumpEntry(entryArray3[k]);
                        }
                        continue;
                    }
                    if (!entryArray[j].category.equals("document")) continue;
                }
            }
            String string2 = "allcalendar.gif";
            object = "image/gif";
            entryArray = new FileInputStream("C:\\FlowBuilder35_PMWorkplace\\workspace\\projexec\\projexec\\media\\allcalendar.gif");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static class Scope
    implements Serializable {
        public String title;
        public String summary;
        public String id;
    }

    public static class SearchResult
    implements Serializable {
        public String url;
        public int totalResult;
        public int startIndex;
        public int itemsPerPage;
        public Entry[] entries;
    }

    public static class ListResult
    implements Serializable {
        public int pageSize = 10;
        public int pageIndex = 1;
        public boolean hasNext = false;
        public boolean hasPrevious = false;
        public Entry[] entries;
    }

    public static class Entry
    implements Serializable {
        public String category;
        public String title;
        public String fileName;
        public String summary;
        public String id;
        public String url;
        public String entryUrl;
        public String contentUrl;
        public String author;
        public String authorDn;
        public String authorEmail;
        public String creationDate;
        public String modificationDate;
        public String modifier;
        public String modifierDn;
        public String modifierEmail;
        public String contentType;
        public float searchRelevance = 0.0f;

        public String toXmlEntryAtom() {
            StringBuffer stringBuffer = new StringBuffer("<entry xmlns=\"http://www.w3.org/2005/Atom\" xmlns:td=\"urn:ibm.com/td\">\n");
            stringBuffer.append(" <id>urn:lsid:ibm.com:td:").append(this.id).append("</id>\n");
            stringBuffer.append(" <category term=\"").append(this.category).append("\" scheme=\"tag:ibm.com,2006:td/type\" label=\"").append(this.category).append("\"/>\n");
            stringBuffer.append(" <title type=\"text\">").append(this.title).append("</title>");
            stringBuffer.append(" <td:label>").append(this.title).append("</td:label> ");
            stringBuffer.append(" <td:uuid>").append(this.id).append("</td:uuid> ");
            stringBuffer.append(" <summary type=\"text\">").append(TString.toXMLString((String)this.summary)).append("</summary>\n");
            stringBuffer.append("</entry>");
            return stringBuffer.toString();
        }
    }

    public static class Library
    implements Serializable {
        public String title;
        public String url;
    }
}

