/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.quickr.doclib;

import com.flowbuilder.lib.JDom;
import com.flowbuilder.util.TDiag;
import com.flowbuilder.util.TString;
import com.flowbuilder.util.xml.JDOMUtil;
import com.flowbuilder.xsp.servlet.Context;
import com.triloggroup.lotus.IServiceConnector;
import com.triloggroup.lotus.ImportExportDocUtil;
import com.triloggroup.lotus.ServletServiceConnector;
import com.triloggroup.quickr.QuickrUtil;
import com.triloggroup.quickr.XSPServiceConnector;
import com.triloggroup.quickr.doclib.IDocumentLibraryMoverForQuickr;
import com.triloggroup.quickr.doclib.UDocumentLibrary;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Document;
import org.jdom.Element;

public class DocumentLibraryImport
implements IDocumentLibraryMoverForQuickr {
    public static String START_LIB_URL = "/dm/atom/";
    public static boolean DEBUG = false;
    private Context xspContext;
    private IServiceConnector serviceConnector;
    private ImportExportDocUtil importDocUtil;
    private ZipFile zipFile;
    private HashMap docEntriesMap = new HashMap();
    private boolean isLCImport = false;

    public DocumentLibraryImport(Context context) {
        this.xspContext = context;
        this.serviceConnector = new XSPServiceConnector(context);
    }

    public DocumentLibraryImport(IServiceConnector iServiceConnector) {
        this.serviceConnector = iServiceConnector;
    }

    public void ImportCurrentLibrary(ZipFile zipFile) throws Exception {
        this.importLibrary(QuickrUtil.getCurrentDocumentLibraryHrefId(this.xspContext), zipFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importLibrary(String string, ZipFile zipFile) throws Exception {
        block28: {
            if (DEBUG) {
                System.out.println("-------importLibrary ------------ " + string);
            }
            this.zipFile = zipFile;
            this.docEntriesMap.clear();
            this.importDocUtil = new ImportExportDocUtil();
            try {
                UDocumentLibrary.Library library = UDocumentLibrary.getLibraryInfo(this.serviceConnector, string);
                if (library != null) {
                    UDocumentLibrary.Entry[] entryArray;
                    if (DEBUG) {
                        System.out.println("...current lib title = " + library.title);
                        System.out.println("...current lib url = " + library.url);
                    }
                    String string2 = library.url = this.convertQuickrProxyRestUrlToServer_QD85ProxyPatch(library.url);
                    Document document = null;
                    String string3 = "unknown";
                    if (this.importDocUtil.isQuickrExport(zipFile)) {
                        document = this.importDocUtil.readQuickrTreeStructure(zipFile);
                        string3 = document.getRootElement().getAttributeValue("name");
                    }
                    if (DEBUG) {
                        System.out.println("...... libNameToImport: " + string3);
                    }
                    if (string3 != null && !string3.endsWith("/Main.nsf") && QuickrUtil.isInQuickrDomino()) {
                        if (DEBUG) {
                            System.out.println(".... get current lib content");
                        }
                        entryArray = UDocumentLibrary.getLibraryContent(this.serviceConnector, library, null, 1, 100);
                        UDocumentLibrary.Entry[] entryArray2 = entryArray.entries;
                        if (entryArray2.length > 0) {
                            if (entryArray2.length == 1) {
                                if (DEBUG) {
                                    System.out.println(".... content only one entry");
                                    UDocumentLibrary.dumpEntry(entryArray2[0]);
                                }
                                this.convertQuickrProxyRestUrlToServer_QD85ProxyPatch(entryArray2[0]);
                                if ("folder".equals(entryArray2[0].category)) {
                                    string2 = entryArray2[0].contentUrl;
                                }
                            } else {
                                if (DEBUG) {
                                    System.out.println(".... content " + entryArray2.length + " entries");
                                }
                                for (int i = 0; i < entryArray2.length; ++i) {
                                    if (DEBUG) {
                                        System.out.println(".......................................");
                                        UDocumentLibrary.dumpEntry(entryArray2[i]);
                                    }
                                    this.convertQuickrProxyRestUrlToServer_QD85ProxyPatch(entryArray2[i]);
                                    if (!"folder".equals(entryArray2[i].category)) continue;
                                    string2 = entryArray2[i].contentUrl;
                                    if (!entryArray2[i].title.equals("Library")) {
                                        continue;
                                    }
                                    break;
                                }
                            }
                        } else if (DEBUG) {
                            System.out.println(".... content no entry !!!!");
                        }
                    }
                    if (DEBUG) {
                        System.out.println(".... use lib url: " + string2);
                    }
                    if (this.importDocUtil.isQuickrExport(zipFile)) {
                        if (DEBUG) {
                            System.out.println("...lib to import structure");
                            System.out.println(JDom.getXMLString((Document)document));
                            System.out.println("......................................");
                        }
                        document = this.importDocUtil.readQuickrTreeStructure(zipFile);
                        this.createLibraryStructure(document.getRootElement(), string2);
                        break block28;
                    }
                    if (this.importDocUtil.isLCExport(zipFile)) {
                        this.isLCImport = true;
                        entryArray = this.importDocUtil.getAllLCDocumentsAsQuickr(zipFile);
                        if (entryArray != null) {
                            for (int i = 0; i < entryArray.length; ++i) {
                                UDocumentLibrary.Entry entry = this.addDocument(entryArray[i], string2);
                            }
                        }
                        break block28;
                    }
                    throw new Exception("Zip file " + zipFile.getName() + " is not a ProjExec document export");
                }
                throw new Exception("Could not access target library " + string);
            }
            finally {
                zipFile.close();
            }
        }
    }

    public UDocumentLibrary.Entry getNewDocumentEntryByOldContentUrl(String string) {
        int n;
        String string2;
        int n2;
        if (DEBUG) {
            System.out.println("getNewDocumentEntryByOldContentUrl " + string);
        }
        UDocumentLibrary.Entry entry = (UDocumentLibrary.Entry)this.docEntriesMap.get(string);
        HttpServletRequest httpServletRequest = this.getHttpServletRequest();
        if (entry == null && httpServletRequest != null) {
            String string3 = QuickrUtil.convertQuickrProxyRestUrlToServer(httpServletRequest, string);
            entry = (UDocumentLibrary.Entry)this.docEntriesMap.get(string3);
            if (DEBUG && entry != null) {
                System.out.println("entry found with server Url");
            }
        } else if (DEBUG) {
            System.out.println("entry found with same Url");
        }
        if (entry == null && (n2 = string.indexOf(START_LIB_URL)) != -1) {
            string2 = string.substring(n2);
            for (Map.Entry entry2 : this.docEntriesMap.entrySet()) {
                UDocumentLibrary.Entry entry3 = (UDocumentLibrary.Entry)entry2.getValue();
                String string4 = entry3.contentUrl;
                n2 = string4.indexOf(START_LIB_URL);
                if (n2 == -1 || !TString.equals((String)string4.substring(n2), (String)string2)) continue;
                entry = entry3;
                if (!DEBUG) break;
                System.out.println("entry found by Url comparaison " + string + " <-> " + entry3.contentUrl);
                break;
            }
        }
        if (entry == null && this.isLCImport && (n = string.indexOf("/repository/co%21file")) != -1) {
            string2 = string.substring(0, n) + "/repository/cs" + string.substring(n + "/repository/co%21file".length());
            if (DEBUG) {
                System.out.println("try to find entry by corrected LC url: \n\t" + string2);
            }
            entry = (UDocumentLibrary.Entry)this.docEntriesMap.get(string2);
        }
        if (entry != null && httpServletRequest != null) {
            if (DEBUG) {
                System.out.println("---- dump entry -----");
                UDocumentLibrary.dumpEntry(entry);
            }
            entry.contentUrl = QuickrUtil.convertQuickrServerRestUrlToProxy(httpServletRequest, entry.contentUrl);
            entry.entryUrl = QuickrUtil.convertQuickrServerRestUrlToProxy(httpServletRequest, entry.entryUrl);
            entry.url = QuickrUtil.convertQuickrServerRestUrlToProxy(httpServletRequest, entry.url);
            if (DEBUG) {
                System.out.println("---- dump converted entry -----");
                UDocumentLibrary.dumpEntry(entry);
            }
        }
        return entry;
    }

    public HashMap getDocEntriesMap() {
        return this.docEntriesMap;
    }

    private void createLibraryStructure(Element element, String string) throws Exception {
        Object object;
        String string2;
        List list = element.getChildren("folder");
        for (int i = 0; i < list.size(); ++i) {
            UDocumentLibrary.Entry entry;
            Element element2;
            block9: {
                element2 = (Element)list.get(i);
                string2 = element2.getChildText("title");
                object = element2.getChildText("summary");
                if ("@@[MEETINGROOM_H.DESC_LIBRARY]@@".equals(object)) {
                    TDiag.println((String)("Folder entry " + string2 + " is the library root one"));
                    this.createLibraryStructure(element2, string);
                    continue;
                }
                entry = null;
                if (QuickrUtil.isInQuickrDomino()) {
                    entry = this.searchEntryByName(string, string2, true);
                }
                if (entry != null) {
                    TDiag.println((String)("Folder entry " + string2 + " already exist"));
                } else {
                    try {
                        entry = UDocumentLibrary.createFolder(this.serviceConnector, string, string2, (String)object, null, null, null, null);
                    }
                    catch (Exception exception) {
                        entry = this.searchEntryByName(string, string2, true);
                        if (entry == null) break block9;
                        TDiag.println((String)("Folder entry " + string2 + " already exist"));
                    }
                }
            }
            if (entry != null) {
                this.convertQuickrProxyRestUrlToServer_QD85ProxyPatch(entry);
                this.createLibraryStructure(element2, entry.contentUrl);
                continue;
            }
            TDiag.println((String)("Could not create and find folder entry " + string2));
        }
        List list2 = element.getChildren("document");
        for (int i = 0; i < list2.size(); ++i) {
            string2 = (Element)list2.get(i);
            object = this.importDocUtil.deserializeQuickDocEntry((Element)string2);
            object = this.addDocument((UDocumentLibrary.Entry)object, string);
        }
    }

    private UDocumentLibrary.Entry addDocument(UDocumentLibrary.Entry entry, String string) throws IOException {
        String string2;
        UDocumentLibrary.Entry entry2;
        block6: {
            entry2 = null;
            string2 = entry.contentUrl;
            ZipEntry zipEntry = this.zipFile.getEntry(entry.id);
            if (zipEntry == null) {
                TDiag.println((String)("Document " + entry.id + " with file name " + entry.fileName + " was not correctly exported"));
            } else {
                InputStream inputStream = this.zipFile.getInputStream(zipEntry);
                try {
                    entry2 = UDocumentLibrary.addDocument(this.serviceConnector, string, entry.fileName, entry.contentType, entry.summary, null, inputStream, JDOMUtil.parseDate((String)entry.creationDate), JDOMUtil.parseDate((String)entry.modificationDate), entry.authorDn);
                }
                catch (Exception exception) {
                    entry2 = this.searchEntryByName(string, entry.fileName, false);
                    if (entry2 == null) break block6;
                    TDiag.println((String)("Document entry " + entry.fileName + " already exist"));
                }
            }
        }
        if (entry2 != null) {
            this.convertQuickrProxyRestUrlToServer_QD85ProxyPatch(entry2);
            this.docEntriesMap.put(string2, entry2);
        } else {
            TDiag.println((String)("Could not create and find document entry " + entry.fileName));
        }
        return entry2;
    }

    private UDocumentLibrary.Entry searchEntryByName(String string, String string2, boolean bl) {
        String string3 = bl ? "folder" : "document";
        try {
            int n = 1;
            UDocumentLibrary.ListResult listResult = UDocumentLibrary.getFolderContent(this.serviceConnector, string, 1, 100);
            while (listResult != null && listResult.entries != null) {
                for (int i = 0; i < listResult.entries.length; ++i) {
                    if (!TString.equals((String)listResult.entries[i].title, (String)string2) || !TString.equals((String)listResult.entries[i].category, (String)string3)) continue;
                    return listResult.entries[i];
                }
                if (listResult.hasNext) {
                    listResult = UDocumentLibrary.getFolderContent(this.serviceConnector, string, ++n, 100);
                    continue;
                }
                listResult = null;
            }
        }
        catch (Exception exception) {
            TDiag.exception((Throwable)exception, (String)("Could not find entry by name " + string2));
        }
        return null;
    }

    private HttpServletRequest getHttpServletRequest() {
        if (this.serviceConnector instanceof ServletServiceConnector) {
            return ((ServletServiceConnector)this.serviceConnector).getHttpServletRequest();
        }
        return null;
    }

    private String convertQuickrProxyRestUrlToServer_QD85ProxyPatch(String string) {
        if (this.xspContext != null) {
            return QuickrUtil.convertQuickrProxyRestUrlToServer(this.xspContext, string);
        }
        if (this.serviceConnector instanceof ServletServiceConnector) {
            return QuickrUtil.convertQuickrProxyRestUrlToServer(((ServletServiceConnector)this.serviceConnector).getHttpServletRequest(), string);
        }
        return string;
    }

    private void convertQuickrProxyRestUrlToServer_QD85ProxyPatch(UDocumentLibrary.Entry entry) {
        if (DEBUG) {
            System.out.println("entry.contentUrl before convertion: " + entry.contentUrl);
        }
        entry.url = this.convertQuickrProxyRestUrlToServer_QD85ProxyPatch(entry.url);
        entry.entryUrl = this.convertQuickrProxyRestUrlToServer_QD85ProxyPatch(entry.entryUrl);
        entry.contentUrl = this.convertQuickrProxyRestUrlToServer_QD85ProxyPatch(entry.contentUrl);
        if (DEBUG) {
            System.out.println("entry.contentUrl After convertion: " + entry.contentUrl);
        }
    }
}

