/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.quickr.admin;

import com.ibm.portal.ListModel;
import com.ibm.portal.MetaDataProvider;
import com.ibm.portal.ObjectID;
import com.ibm.portal.app.model.Folder;
import com.ibm.portal.app.service.ApplicationCatalogService;
import com.ibm.portal.app.service.ApplicationCatalogServiceHome;
import com.ibm.portal.app.service.ApplicationService;
import com.ibm.portal.app.service.ApplicationServiceHome;
import com.ibm.portal.app.service.TemplateCatalogService;
import com.ibm.portal.app.service.TemplateCatalogServiceHome;
import com.ibm.portal.app.service.TemplateService;
import com.ibm.portal.app.service.TemplateServiceHome;
import com.ibm.portal.app.service.exceptions.TemplateCatalogServiceException;
import com.ibm.portal.content.ContentLabel;
import com.ibm.portal.content.ContentModel;
import com.ibm.portal.content.ContentNode;
import com.ibm.portal.content.ContentNodeType;
import com.ibm.portal.content.ContentPage;
import com.ibm.portal.model.ContentModelHome;
import com.ibm.portal.model.ContentModelProvider;
import com.ibm.wps.datastore.domains.DatabaseDomain;
import com.ibm.wps.services.authentication.Authentication;
import com.triloggroup.quickr.ProviderQuickrUtilJSR168;
import com.triloggroup.quickr.admin.TGAdminPortalAbstract;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Locale;
import javax.naming.CompositeName;
import javax.naming.InitialContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom.Document;
import org.jdom.Element;

public class TGAdminPortal61
extends TGAdminPortalAbstract {
    public void installTemplate(final File file, final String string, String string2, final boolean bl) throws Exception {
        PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                System.out.println("-- Install template " + string + " --");
                InitialContext initialContext = new InitialContext();
                TemplateCatalogServiceHome templateCatalogServiceHome = (TemplateCatalogServiceHome)initialContext.lookup("portal:extensions/com.ibm.portal.ai.api.service.TemplateCatalogServiceHome/com.ibm.wps.ai.io.impl.service.TemplateCatalogServiceHomeImpl");
                TemplateCatalogService templateCatalogService = templateCatalogServiceHome.getTemplateCatalogService();
                ObjectID objectID = templateCatalogService.getRootFolderID();
                FileInputStream fileInputStream = new FileInputStream(file);
                ObjectID objectID2 = TGAdminPortal61.this.findTemplate(templateCatalogService, objectID, string);
                if (objectID2 != null) {
                    System.out.println("Template " + string + " found with ID " + objectID2);
                    try {
                        TemplateServiceHome templateServiceHome = (TemplateServiceHome)initialContext.lookup("portal:extensions/com.ibm.portal.ai.api.service.TemplateServiceHome/com.ibm.wps.ai.io.impl.service.TemplateServiceHomeImpl");
                        TemplateService templateService = templateServiceHome.getTemplateService(objectID2);
                        if (templateService != null) {
                            templateService.unlockTemplate();
                            System.out.println("-- Template unlocked --");
                        }
                    }
                    catch (Throwable throwable) {
                        System.out.println("Error when try to unlock template ");
                        throwable.printStackTrace();
                    }
                } else {
                    System.out.println("Template " + string + " not found - Import it");
                }
                if (bl && objectID2 != null) {
                    templateCatalogService.updateTemplate(objectID2, (InputStream)fileInputStream);
                    System.out.println("-- Template updated --");
                } else {
                    if (objectID2 != null) {
                        templateCatalogService.deleteTemplate(objectID2);
                        System.out.println("-- Template removed --");
                    }
                    templateCatalogService.importTemplate(string, (InputStream)fileInputStream, objectID);
                    System.out.println("-- Template installed --");
                }
                return "OK";
            }
        };
        Authentication.getService().runAsDomainAdministrator(DatabaseDomain.DOMAIN_COMMUNITY, privilegedExceptionAction);
    }

    public void deleteTemplate(final String string, String string2) throws Exception {
        PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                System.out.println("-- delete template " + string + " --");
                InitialContext initialContext = new InitialContext();
                TemplateCatalogServiceHome templateCatalogServiceHome = (TemplateCatalogServiceHome)initialContext.lookup("portal:extensions/com.ibm.portal.ai.api.service.TemplateCatalogServiceHome/com.ibm.wps.ai.io.impl.service.TemplateCatalogServiceHomeImpl");
                TemplateCatalogService templateCatalogService = templateCatalogServiceHome.getTemplateCatalogService();
                ObjectID objectID = templateCatalogService.getRootFolderID();
                ObjectID objectID2 = TGAdminPortal61.this.findTemplate(templateCatalogService, objectID, string);
                if (objectID2 != null) {
                    try {
                        TemplateServiceHome templateServiceHome = (TemplateServiceHome)initialContext.lookup("portal:extensions/com.ibm.portal.ai.api.service.TemplateServiceHome/com.ibm.wps.ai.io.impl.service.TemplateServiceHomeImpl");
                        TemplateService templateService = templateServiceHome.getTemplateService(objectID2);
                        if (templateService != null) {
                            templateService.unlockTemplate();
                            System.out.println("-- Template unlocked --");
                        }
                    }
                    catch (Throwable throwable) {
                        System.out.println("Error when try to unlock template ");
                        throwable.printStackTrace();
                    }
                    templateCatalogService.deleteTemplate(objectID2);
                    System.out.println("-- Template removed --");
                }
                return "OK";
            }
        };
        Authentication.getService().runAsDomainAdministrator(DatabaseDomain.DOMAIN_COMMUNITY, privilegedExceptionAction);
    }

    protected ObjectID findTemplate(TemplateCatalogService templateCatalogService, ObjectID objectID, String string) throws TemplateCatalogServiceException {
        List list = templateCatalogService.findTemplatesByTitleInFolder(string, Locale.ENGLISH, objectID, TemplateCatalogService.SearchPattern.COMPLETE_TITLE);
        if (list != null && list.size() != 0) {
            return (ObjectID)list.get(0);
        }
        return null;
    }

    public String dumpAllTemplates() throws Exception {
        PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                try {
                    InitialContext initialContext = new InitialContext();
                    TemplateCatalogServiceHome templateCatalogServiceHome = (TemplateCatalogServiceHome)initialContext.lookup("portal:extensions/com.ibm.portal.ai.api.service.TemplateCatalogServiceHome/com.ibm.wps.ai.io.impl.service.TemplateCatalogServiceHomeImpl");
                    TemplateCatalogService templateCatalogService = templateCatalogServiceHome.getTemplateCatalogService();
                    Folder folder = templateCatalogService.getRootFolder();
                    TemplateServiceHome templateServiceHome = (TemplateServiceHome)initialContext.lookup("portal:extensions/com.ibm.portal.ai.api.service.TemplateServiceHome/com.ibm.wps.ai.io.impl.service.TemplateServiceHomeImpl");
                    TGAdminPortal61.this.dumpReccursively(templateCatalogService, folder.getObjectID(), templateServiceHome);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                return null;
            }
        };
        Authentication.getService().runAsDomainAdministrator(DatabaseDomain.DOMAIN_COMMUNITY, privilegedExceptionAction);
        return "OK";
    }

    private void dumpReccursively(TemplateCatalogService templateCatalogService, ObjectID objectID, TemplateServiceHome templateServiceHome) throws Exception {
        Folder folder = templateCatalogService.getFolder(objectID);
        this.dumpFolder(folder);
        List list = templateCatalogService.findTemplatesInFolder(objectID);
        if (list != null) {
            System.out.println("-------- templates of the folder --------");
            for (int i = 0; i < list.size(); ++i) {
                ObjectID objectID2 = (ObjectID)list.get(i);
                this.dumpTemplate(templateServiceHome, objectID2);
            }
        } else {
            System.out.println("-------- No template --------");
        }
        List list2 = templateCatalogService.findChildFolders(objectID);
        if (list2 != null) {
            System.out.println("-------- sub folders --------");
            for (int i = 0; i < list2.size(); ++i) {
                ObjectID objectID3 = (ObjectID)list2.get(i);
                this.dumpReccursively(templateCatalogService, objectID3, templateServiceHome);
            }
        } else {
            System.out.println("-------- No sub folders --------");
        }
    }

    private void dumpFolder(Folder folder) {
        System.out.println("------- dumpFolder : " + folder.getObjectID());
        System.out.println("...title en: " + folder.getTitle(Locale.ENGLISH));
        System.out.println("...description en: " + folder.getDescription(Locale.ENGLISH));
    }

    private void dumpTemplate(TemplateServiceHome templateServiceHome, ObjectID objectID) throws Exception {
        System.out.println("------- dumpTemplate : " + objectID);
        TemplateService templateService = templateServiceHome.getTemplateService(objectID);
        if (templateService != null) {
            System.out.println("...title en: " + templateService.getTitle(Locale.ENGLISH));
            System.out.println("...description en: " + templateService.getDescription(Locale.ENGLISH));
            System.out.println("...created by: " + templateService.getCreatedBy());
            System.out.println("...created the: " + templateService.getCreated());
        } else {
            System.out.println("...Template is null");
        }
    }

    public Document getAllPlacesInfo(final HttpServletRequest httpServletRequest, final HttpServletResponse httpServletResponse) throws Exception {
        PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                try {
                    InitialContext initialContext = new InitialContext();
                    ContentModelHome contentModelHome = (ContentModelHome)initialContext.lookup("portal:service/model/ContentModel");
                    ContentModelProvider contentModelProvider = contentModelHome.getContentModelProvider();
                    ContentModel contentModel = contentModelProvider.getContentModel((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                    ContentNode contentNode = (ContentNode)contentModel.getRoot();
                    ApplicationCatalogServiceHome applicationCatalogServiceHome = (ApplicationCatalogServiceHome)initialContext.lookup("portal:extensions/com.ibm.portal.ai.api.service.ApplicationCatalogServiceHome/com.ibm.wps.ai.base.impl.service.ApplicationCatalogServiceHomeImpl");
                    ApplicationCatalogService applicationCatalogService = applicationCatalogServiceHome.getApplicationCatalogService();
                    List list = applicationCatalogService.findAllApplications();
                    ApplicationServiceHome applicationServiceHome = (ApplicationServiceHome)initialContext.lookup("portal:extensions/com.ibm.portal.ai.api.service.ApplicationServiceHome/com.ibm.wps.ai.base.impl.service.ApplicationServiceHomeImpl");
                    Document document = new Document();
                    Element element = new Element("places");
                    document.setRootElement(element);
                    System.out.println("nb places uid found = " + list.size());
                    for (int i = 0; i < list.size(); ++i) {
                        System.out.println(" place ObjectID = " + list.get(i));
                        ApplicationService applicationService = applicationServiceHome.getApplicationService((ObjectID)list.get(i));
                        Element element2 = TGAdminPortal61.this.getPlaceInfoInElement(applicationService);
                        if (element2 == null) continue;
                        element.addContent(element2);
                    }
                    return document;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return null;
                }
            }
        };
        return (Document)Authentication.getService().runAsDomainAdministrator(DatabaseDomain.DOMAIN_COMMUNITY, privilegedExceptionAction);
    }

    protected void dumpAllApp(ContentModel contentModel, ContentNode contentNode) {
        Object object;
        System.out.println("-- node=" + contentNode);
        System.out.println("-- node.objectId=" + contentNode.getObjectID());
        ContentNodeType contentNodeType = contentNode.getContentNodeType();
        if (contentNodeType == ContentNodeType.LABEL) {
            System.out.println("....label title= " + ((ContentLabel)contentNode).getTitle(Locale.ENGLISH));
        } else if (contentNodeType == ContentNodeType.PAGE) {
            System.out.println("....page title= " + ((ContentPage)contentNode).getTitle(Locale.ENGLISH));
        }
        if (contentNode instanceof MetaDataProvider) {
            object = ((MetaDataProvider)contentNode).getMetaData();
            ListModel listModel = object.getNames();
            System.out.println("------ MetaData");
            try {
                for (Object e : listModel) {
                    System.out.println("              " + e + " = " + object.getValue((String)e));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            object = contentModel.getChildren((Object)contentNode);
            while (object.hasNext()) {
                this.dumpAllApp(contentModel, (ContentNode)object.next());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected Element getPlaceInfoInElement(ApplicationService applicationService) throws Exception {
        try {
            Element element = new Element("place");
            Element element2 = new Element("id");
            element2.setText(applicationService.getObjectID().getUniqueName());
            element.addContent(element2);
            Element element3 = new Element("title");
            element3.setText(applicationService.getTitle(Locale.ENGLISH));
            element.addContent(element3);
            Element element4 = new Element("summary");
            element4.setText(applicationService.getDescription(Locale.ENGLISH));
            element.addContent(element4);
            Element element5 = new Element("template");
            element5.setText(applicationService.getTemplateID().getUniqueName());
            element.addContent(element5);
            return element;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    protected Element getPlaceInfoInElement(String string, ProviderQuickrUtilJSR168 providerQuickrUtilJSR168) throws Exception {
        try {
            InitialContext initialContext = new InitialContext();
            ApplicationServiceHome applicationServiceHome = (ApplicationServiceHome)initialContext.lookup("portal:extensions/com.ibm.portal.ai.api.service.ApplicationServiceHome/com.ibm.wps.ai.base.impl.service.ApplicationServiceHomeImpl");
            CompositeName compositeName = new CompositeName("portal:uniquename");
            compositeName.add(string);
            ObjectID objectID = (ObjectID)initialContext.lookup(compositeName);
            ApplicationService applicationService = applicationServiceHome.getApplicationService(objectID);
            Element element = new Element("place");
            Element element2 = new Element("id");
            element2.setText(string);
            element.addContent(element2);
            Element element3 = new Element("title");
            element3.setText(applicationService.getTitle(Locale.ENGLISH));
            element.addContent(element3);
            Element element4 = new Element("summary");
            element4.setText(applicationService.getDescription(Locale.ENGLISH));
            element.addContent(element4);
            Element element5 = new Element("template");
            element5.setText(applicationService.getTemplateID().getUniqueName());
            element.addContent(element5);
            return element;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public String dumpCdoInfo(String string) throws Exception {
        return "Error: DumpCdo not implemented";
    }
}

