/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.quickr.admin;

import com.ibm.portal.CreationContext;
import com.ibm.portal.Identifiable;
import com.ibm.portal.ListModel;
import com.ibm.portal.MetaDataProvider;
import com.ibm.portal.ModelException;
import com.ibm.portal.ObjectID;
import com.ibm.portal.ObjectNotFoundException;
import com.ibm.portal.app.service.ApplicationCatalogService;
import com.ibm.portal.app.service.ApplicationCatalogServiceHome;
import com.ibm.portal.app.service.ApplicationService;
import com.ibm.portal.app.service.ApplicationServiceHome;
import com.ibm.portal.app.service.TemplateCatalogService;
import com.ibm.portal.app.service.TemplateCatalogServiceHome;
import com.ibm.portal.app.service.TemplateService;
import com.ibm.portal.app.service.TemplateServiceHome;
import com.ibm.portal.community.CommunityController;
import com.ibm.portal.community.CommunityHome;
import com.ibm.portal.community.CommunityRole;
import com.ibm.portal.content.ContentLabel;
import com.ibm.portal.content.ContentModel;
import com.ibm.portal.content.ContentModelController;
import com.ibm.portal.content.ContentNode;
import com.ibm.portal.content.ContentNodeCreationContext;
import com.ibm.portal.content.ContentNodeType;
import com.ibm.portal.content.ContentPage;
import com.ibm.portal.content.ContentPageCreationContext;
import com.ibm.portal.content.LayoutContainer;
import com.ibm.portal.content.LayoutControl;
import com.ibm.portal.content.LayoutControlCreationContext;
import com.ibm.portal.content.LayoutModel;
import com.ibm.portal.content.LayoutModelController;
import com.ibm.portal.content.LayoutNode;
import com.ibm.portal.content.ModifiableContentPage;
import com.ibm.portal.content.ModifiableLayoutContainer;
import com.ibm.portal.content.ModifiableLayoutNode;
import com.ibm.portal.content.Orientation;
import com.ibm.portal.model.controller.ContentModelControllerHome;
import com.ibm.portal.model.controller.CreationContextBuilderFactory;
import com.ibm.portal.portlet.service.PortletServiceHome;
import com.ibm.portal.portlet.service.model.ContentModelProvider;
import com.ibm.portal.portlet.service.model.PortletModelProvider;
import com.ibm.portal.portletmodel.Portlet;
import com.ibm.portal.portletmodel.PortletDefinition;
import com.ibm.portal.portletmodel.PortletEntity;
import com.ibm.portal.portletmodel.PortletModel;
import com.ibm.portal.portletmodel.PortletWindow;
import com.ibm.portal.um.PumaHome;
import com.ibm.portal.um.PumaProfile;
import com.ibm.portal.um.User;
import com.ibm.wps.datastore.ApplicationDescriptor;
import com.ibm.wps.datastore.ApplicationDescriptorHome;
import com.ibm.wps.datastore.PortletDescriptor;
import com.ibm.wps.datastore.PortletDescriptorHome;
import com.ibm.wps.datastore.ResourceHomeFactory;
import com.ibm.wps.datastore.domains.DatabaseDomain;
import com.ibm.wps.services.authentication.Authentication;
import com.ibm.wps.services.registry.PortletRegistry;
import com.ibm.wps.util.DataBackendException;
import com.triloggroup.util.UString;
import java.io.Serializable;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.naming.InitialContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.jdom.Document;
import org.jdom.Element;

public class PlaceMigrator {
    protected Locale locale;
    protected TemplateCatalogService templateCatalog;
    protected TemplateServiceHome templateServiceHome;
    protected ApplicationCatalogService appCatalog;
    protected ApplicationServiceHome appServiceHome;
    protected ContentModelControllerHome contentModelCtrlHome;
    protected HashMap<String, PortletInfo> portletsToReplaceByName = new HashMap();
    protected HashMap<String, PageInfo[]> pagesToAddByTemplateName = new HashMap();
    protected HashMap<String, PageInfo[]> pagesToDeleteByTemplateName = new HashMap();
    protected HashMap<String, PageInfo[]> pagesToCustomizeByTemplateName = new HashMap();

    public PlaceMigrator(Locale locale, Document document) {
        this.locale = locale;
        if (this.locale == null) {
            this.locale = Locale.ENGLISH;
        }
        System.out.println("--- PlaceMigrator created with Locale " + this.locale);
        this.initMigrator(document);
    }

    protected void initMigrator(Document document) {
        if (document != null) {
            String string;
            PageInfo[] pageInfoArray;
            Object object;
            Element element;
            int n;
            List list;
            Element element2 = document.getRootElement();
            if (element2 == null || !"placesMigration".equals(element2.getName())) {
                System.out.println("Error: Wrong Place Migration document structure");
                return;
            }
            this.portletsToReplaceByName.clear();
            Element element3 = element2.getChild("portletsToReplace");
            if (element3 != null && (list = element3.getChildren("portletChange")) != null) {
                for (n = 0; n < list.size(); ++n) {
                    element = (Element)list.get(n);
                    object = element.getChild("oldPortlet");
                    pageInfoArray = element.getChild("portlet");
                    if (object == null || pageInfoArray == null) continue;
                    string = object.getAttributeValue("name");
                    this.portletsToReplaceByName.put(string, this.createPortletInfoFromElement((Element)pageInfoArray));
                }
            }
            this.pagesToAddByTemplateName.clear();
            this.pagesToDeleteByTemplateName.clear();
            this.pagesToCustomizeByTemplateName.clear();
            list = element2.getChildren("template");
            if (list != null) {
                for (n = 0; n < list.size(); ++n) {
                    List list2;
                    PageInfo[] pageInfoArray2;
                    PageInfo[] pageInfoArray3;
                    element = (Element)list.get(n);
                    object = element.getAttributeValue("name");
                    pageInfoArray = null;
                    string = element.getChild("pagesToAdd");
                    if (string != null && (pageInfoArray3 = string.getChildren("page")) != null) {
                        pageInfoArray = new PageInfo[pageInfoArray3.size()];
                        for (int i = 0; i < pageInfoArray3.size(); ++i) {
                            pageInfoArray2 = (Element)pageInfoArray3.get(i);
                            pageInfoArray[i] = this.createPageInfoFromElement((Element)pageInfoArray2);
                        }
                    }
                    this.pagesToAddByTemplateName.put((String)object, pageInfoArray);
                    pageInfoArray3 = null;
                    Element element4 = element.getChild("pagesToRemove");
                    if (element4 != null && (pageInfoArray2 = element4.getChildren("page")) != null) {
                        pageInfoArray3 = new PageInfo[pageInfoArray2.size()];
                        for (int i = 0; i < pageInfoArray2.size(); ++i) {
                            list2 = (Element)pageInfoArray2.get(i);
                            pageInfoArray3[i] = this.createPageInfoFromElement((Element)list2);
                        }
                    }
                    this.pagesToDeleteByTemplateName.put((String)object, pageInfoArray3);
                    pageInfoArray2 = null;
                    Element element5 = element.getChild("pagesToCustomize");
                    if (element5 != null && (list2 = element5.getChildren("page")) != null) {
                        pageInfoArray2 = new PageInfo[list2.size()];
                        for (int i = 0; i < list2.size(); ++i) {
                            Element element6 = (Element)list2.get(i);
                            pageInfoArray2[i] = this.createPageInfoFromElement(element6);
                        }
                    }
                    this.pagesToCustomizeByTemplateName.put((String)object, pageInfoArray2);
                }
            }
        }
    }

    protected PortletInfo createPortletInfoFromElement(Element element) {
        PortletInfo portletInfo = new PortletInfo();
        portletInfo.appName = element.getAttributeValue("appName");
        portletInfo.portletName = element.getAttributeValue("name");
        return portletInfo;
    }

    protected PageInfo createPageInfoFromElement(Element element) {
        List list;
        PageInfo pageInfo = new PageInfo();
        pageInfo.titleMapByLocale = new HashMap();
        Element element2 = element.getChild("titles");
        if (element2 != null) {
            list = element2.getChildren("title");
            for (int i = 0; i < list.size(); ++i) {
                Element element3 = (Element)list.get(i);
                Locale locale = new Locale(element3.getAttributeValue("locale"));
                pageInfo.titleMapByLocale.put(locale, element3.getText());
            }
        }
        if ((list = element.getChild("portlets")) != null) {
            List list2 = list.getChildren("portlet");
            pageInfo.portlets = new PortletInfo[list2.size()];
            for (int i = 0; i < list2.size(); ++i) {
                pageInfo.portlets[i] = this.createPortletInfoFromElement((Element)list2.get(i));
            }
        }
        pageInfo.nextPageEnglishTitle = element.getChildText("nextPageEnglishTitle");
        return pageInfo;
    }

    public String[] getTemplatesNameToMigrate() {
        String[] stringArray = new String[this.pagesToCustomizeByTemplateName.size()];
        int n = 0;
        Iterator<String> iterator = this.pagesToCustomizeByTemplateName.keySet().iterator();
        while (iterator.hasNext()) {
            stringArray[n] = iterator.next();
            ++n;
        }
        return stringArray;
    }

    public String[] getAllTemplatesName() throws Exception {
        System.out.println("-------- getAllTemplatesName--------");
        PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                PlaceMigrator.this.initTemplateAndAppServiceCatalog();
                ObjectID objectID = PlaceMigrator.this.templateCatalog.getRootFolderID();
                List list = PlaceMigrator.this.templateCatalog.findTemplates();
                if (list != null && list.size() >= 0) {
                    System.out.println("... " + list.size() + " templates found");
                    String[] stringArray = new String[list.size()];
                    for (int i = 0; i < stringArray.length; ++i) {
                        TemplateService templateService = PlaceMigrator.this.templateServiceHome.getTemplateService((ObjectID)list.get(i));
                        stringArray[i] = PlaceMigrator.this.getTemplateTitle(templateService);
                        System.out.println("....... " + stringArray[i]);
                    }
                    return stringArray;
                }
                System.out.println("... no template found");
                return new String[0];
            }
        };
        return (String[])Authentication.getService().runAsDomainAdministrator(DatabaseDomain.DOMAIN_COMMUNITY, privilegedExceptionAction);
    }

    public AppInfo[] getAllApplicationByTemplateName(final String string) throws Exception {
        System.out.println("-------- getAllApplicationByTemplateName : " + string);
        PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws Exception {
                AppInfo[] appInfoArray;
                PlaceMigrator.this.initTemplateAndAppServiceCatalog();
                List list = null;
                if (UString.isEmpty((String)string)) {
                    System.out.println("... no template specified, return all application");
                    list = PlaceMigrator.this.appCatalog.findAllApplications();
                } else {
                    appInfoArray = PlaceMigrator.this.searchTemplateByName(PlaceMigrator.this.templateCatalog, string);
                    if (appInfoArray != null) {
                        System.out.println("... template Id found");
                        TemplateService templateService = PlaceMigrator.this.templateServiceHome.getTemplateService((ObjectID)appInfoArray);
                        list = PlaceMigrator.this.appCatalog.findAllApplicationsByTemplate((ObjectID)appInfoArray);
                    } else {
                        System.out.println(" No Template found by Name '" + string + "'");
                    }
                }
                if (list != null && list.size() > 0) {
                    System.out.println("... " + list.size() + " places found");
                    appInfoArray = new AppInfo[list.size()];
                    for (int i = 0; i < appInfoArray.length; ++i) {
                        ObjectID objectID = (ObjectID)list.get(i);
                        ApplicationService applicationService = PlaceMigrator.this.appServiceHome.getApplicationService(objectID);
                        try {
                            appInfoArray[i] = new AppInfo();
                            appInfoArray[i].title = PlaceMigrator.this.getApplicationTitle(applicationService);
                            appInfoArray[i].objectId = objectID;
                            System.out.println("....... " + appInfoArray[i].title);
                            continue;
                        }
                        finally {
                            applicationService.dispose();
                        }
                    }
                    return appInfoArray;
                }
                System.out.println(" No Application found for template '" + string + "'");
                return null;
            }
        };
        return (AppInfo[])Authentication.getService().runAsDomainAdministrator(DatabaseDomain.DOMAIN_COMMUNITY, privilegedExceptionAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpAllApplication() {
        block10: {
            System.out.println("------ Dump All Application ------");
            try {
                List list = this.appCatalog.findAllApplications();
                if (list != null && list.size() > 0) {
                    System.out.println("... " + list.size() + " places found");
                    for (int i = 0; i < list.size(); ++i) {
                        ObjectID objectID = (ObjectID)list.get(i);
                        ApplicationService applicationService = this.appServiceHome.getApplicationService(objectID);
                        try {
                            String string = applicationService.getTitle(Locale.ENGLISH);
                            String string2 = "Unknown";
                            ObjectID objectID2 = applicationService.getTemplateID();
                            if (objectID2 != null) {
                                try {
                                    TemplateService templateService = this.templateServiceHome.getTemplateService(objectID2);
                                    string2 = templateService.getTitle(Locale.ENGLISH);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                            System.out.println("..." + string + " created from template " + string2);
                            continue;
                        }
                        finally {
                            applicationService.dispose();
                        }
                    }
                    break block10;
                }
                System.out.println("... NO places found!!");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void migrateApplications(final String string, final List list, final PortletRequest portletRequest, final PortletResponse portletResponse) throws Exception {
        System.out.println("-------- migrateApplications with reference  template " + string);
        PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws Exception {
                if (list != null) {
                    PlaceMigrator.this.initTemplateAndAppServiceCatalog();
                    InitialContext initialContext = new InitialContext();
                    ContentModelProvider contentModelProvider = (ContentModelProvider)((PortletServiceHome)initialContext.lookup("portletservice/com.ibm.portal.portlet.service.model.ContentModelProvider")).getPortletService(ContentModelProvider.class);
                    ContentModel contentModel = contentModelProvider.getContentModel(portletRequest, portletResponse);
                    PortletModelProvider portletModelProvider = (PortletModelProvider)((PortletServiceHome)initialContext.lookup("portletservice/com.ibm.portal.portlet.service.model.PortletModelProvider")).getPortletService(PortletModelProvider.class);
                    PortletModel portletModel = portletModelProvider.getPortletModel(portletRequest, portletResponse);
                    for (int i = 0; i < list.size(); ++i) {
                        ApplicationService applicationService = PlaceMigrator.this.appServiceHome.getApplicationService((ObjectID)list.get(i));
                        if (applicationService != null) {
                            System.out.println("... start migration of place " + PlaceMigrator.this.getApplicationTitle(applicationService));
                            try {
                                PlaceMigrator.this.addUserToApplicationCommunityIfNotMember(applicationService);
                                ObjectID objectID = applicationService.getRootContentNodeID();
                                ContentNode contentNode = (ContentNode)contentModel.getLocator().findByID(objectID);
                                PlaceMigrator.this.replacePortlets(contentModel, portletModel, contentNode);
                                PlaceMigrator.this.addNewPages(string, contentModel, contentNode);
                                PlaceMigrator.this.customizePages(string, contentModel, portletModel, contentNode);
                                PlaceMigrator.this.deletePages(string, contentModel, contentNode);
                            }
                            finally {
                                applicationService.dispose();
                            }
                            System.out.println("... migration done");
                            continue;
                        }
                        System.out.println("... could not find place service to migrate");
                    }
                } else {
                    System.out.println("... no place to migrate");
                }
                return null;
            }
        };
        Authentication.getService().runAsDomainAdministrator(DatabaseDomain.DOMAIN_COMMUNITY, privilegedExceptionAction);
    }

    public void dumpAllPlacesLayoutOfTemplate(String string, PortletRequest portletRequest, PortletResponse portletResponse) throws Exception {
        System.out.println("\n---- dump All Places from template" + string);
        AppInfo[] appInfoArray = this.getAllApplicationByTemplateName(string);
        if (appInfoArray != null && appInfoArray.length > 0) {
            ArrayList<ObjectID> arrayList = new ArrayList<ObjectID>(appInfoArray.length);
            for (int i = 0; i < appInfoArray.length; ++i) {
                arrayList.add(appInfoArray[i].objectId);
            }
            this.dumpPlacesLayout(arrayList, portletRequest, portletResponse);
        } else {
            System.out.println("No place from template " + string + " found");
        }
    }

    public void dumpPlacesLayout(final List list, final PortletRequest portletRequest, final PortletResponse portletResponse) throws Exception {
        PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws Exception {
                if (list != null) {
                    PlaceMigrator.this.initTemplateAndAppServiceCatalog();
                    InitialContext initialContext = new InitialContext();
                    ContentModelProvider contentModelProvider = (ContentModelProvider)((PortletServiceHome)initialContext.lookup("portletservice/com.ibm.portal.portlet.service.model.ContentModelProvider")).getPortletService(ContentModelProvider.class);
                    ContentModel contentModel = contentModelProvider.getContentModel(portletRequest, portletResponse);
                    ContentModelControllerHome contentModelControllerHome = (ContentModelControllerHome)initialContext.lookup("portal:service/model/controller/ContentModelController");
                    ContentModelController contentModelController = contentModelControllerHome.getContentModelControllerProvider().createContentModelController(contentModel);
                    PortletModelProvider portletModelProvider = (PortletModelProvider)((PortletServiceHome)initialContext.lookup("portletservice/com.ibm.portal.portlet.service.model.PortletModelProvider")).getPortletService(PortletModelProvider.class);
                    PortletModel portletModel = portletModelProvider.getPortletModel(portletRequest, portletResponse);
                    for (int i = 0; i < list.size(); ++i) {
                        ApplicationService applicationService = PlaceMigrator.this.appServiceHome.getApplicationService((ObjectID)list.get(i));
                        if (applicationService == null) continue;
                        try {
                            System.out.println("\n------- dump Place " + applicationService.getTitle(Locale.ENGLISH));
                            ObjectID objectID = applicationService.getRootContentNodeID();
                            ContentNode contentNode = (ContentNode)contentModel.getLocator().findByID(objectID);
                            PlaceMigrator.this.dumpPlaceLayout(contentModel, portletModel, contentNode, "");
                            System.out.println("--------------------------------------------------\n");
                            continue;
                        }
                        finally {
                            applicationService.dispose();
                        }
                    }
                }
                return null;
            }
        };
        Authentication.getService().runAsDomainAdministrator(DatabaseDomain.DOMAIN_COMMUNITY, privilegedExceptionAction);
    }

    public void close() {
        if (this.appCatalog != null) {
            this.appCatalog.dispose();
        }
        if (this.templateCatalog != null) {
            this.templateCatalog.dispose();
        }
    }

    protected void initTemplateAndAppServiceCatalog() throws Exception {
        if (this.templateCatalog == null) {
            InitialContext initialContext = new InitialContext();
            TemplateCatalogServiceHome templateCatalogServiceHome = (TemplateCatalogServiceHome)initialContext.lookup("portal:extensions/com.ibm.portal.ai.api.service.TemplateCatalogServiceHome/com.ibm.wps.ai.io.impl.service.TemplateCatalogServiceHomeImpl");
            this.templateCatalog = templateCatalogServiceHome.getTemplateCatalogService();
            this.templateServiceHome = (TemplateServiceHome)initialContext.lookup("portal:extensions/com.ibm.portal.ai.api.service.TemplateServiceHome/com.ibm.wps.ai.io.impl.service.TemplateServiceHomeImpl");
            ApplicationCatalogServiceHome applicationCatalogServiceHome = (ApplicationCatalogServiceHome)initialContext.lookup("portal:extensions/com.ibm.portal.ai.api.service.ApplicationCatalogServiceHome/com.ibm.wps.ai.base.impl.service.ApplicationCatalogServiceHomeImpl");
            this.appCatalog = applicationCatalogServiceHome.getApplicationCatalogService();
            this.appServiceHome = (ApplicationServiceHome)initialContext.lookup("portal:extensions/com.ibm.portal.ai.api.service.ApplicationServiceHome/com.ibm.wps.ai.base.impl.service.ApplicationServiceHomeImpl");
            this.contentModelCtrlHome = (ContentModelControllerHome)initialContext.lookup("portal:service/model/controller/ContentModelController");
        }
    }

    protected ObjectID searchTemplateByName(TemplateCatalogService templateCatalogService, String string) throws Exception {
        ObjectID objectID = templateCatalogService.getRootFolderID();
        List list = templateCatalogService.findTemplatesByTitleInFolder(string, this.locale, objectID, TemplateCatalogService.SearchPattern.COMPLETE_TITLE);
        if (list != null && list.size() != 0) {
            return (ObjectID)list.get(0);
        }
        list = templateCatalogService.findTemplatesByTitleInFolder(string, Locale.ENGLISH, objectID, TemplateCatalogService.SearchPattern.COMPLETE_TITLE);
        if (list != null && list.size() != 0) {
            return (ObjectID)list.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replacePortlets(ContentModel contentModel, PortletModel portletModel, ContentNode contentNode) {
        ContentModelController contentModelController = null;
        try {
            contentModelController = this.contentModelCtrlHome.getContentModelControllerProvider().createContentModelController(contentModel);
            this.replacePortletsRecursively(contentModel, contentModelController, portletModel, contentNode);
            contentModelController.commit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (contentModelController != null) {
                contentModelController.dispose();
            }
        }
    }

    protected void replacePortletsRecursively(ContentModel contentModel, ContentModelController contentModelController, PortletModel portletModel, ContentNode contentNode) throws Exception {
        ContentNodeType contentNodeType = contentNode.getContentNodeType();
        if (contentNodeType == ContentNodeType.PAGE) {
            Object object;
            LayoutModel layoutModel = contentModel.getLayoutModel((ContentPage)contentNode);
            try {
                object = contentModelController.getLayoutModelController((ContentPage)contentNode);
                this.replacePortletsInPage((ContentPage)contentNode, layoutModel, portletModel, (LayoutModelController)object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                object = contentModel.getChildren((Object)contentNode);
                while (object.hasNext()) {
                    this.replacePortletsRecursively(contentModel, contentModelController, portletModel, (ContentNode)object.next());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected void replacePortletsInPage(ContentPage contentPage, LayoutModel layoutModel, PortletModel portletModel, LayoutModelController layoutModelController) throws Exception {
        Set set = this.findLayoutControls((LayoutNode)layoutModel.getRoot(), layoutModel);
        for (LayoutControl layoutControl : set) {
            PortletWindow portletWindow = portletModel.getPortletWindow(layoutControl);
            PortletEntity portletEntity = portletModel.getPortletEntity(portletWindow);
            PortletDefinition portletDefinition = portletModel.getPortletDefinition(portletEntity);
            Portlet portlet = portletModel.getPortlet(portletDefinition);
            String string = portlet.getPortletName();
            PortletInfo portletInfo = this.portletsToReplaceByName.get(string);
            if (portletInfo == null) continue;
            this.replacePortlet(portletInfo, portlet, layoutModel, layoutControl, layoutModelController);
        }
    }

    protected void replacePortlet(PortletInfo portletInfo, Portlet portlet, LayoutModel layoutModel, LayoutControl layoutControl, LayoutModelController layoutModelController) throws Exception {
        ObjectID objectID = this.searchPortlet(portletInfo);
        if (objectID == null) {
            System.out.println("portlet " + portletInfo.portletName + " not found !!!!!");
        } else {
            System.out.println("replacing " + portlet.getPortletName() + " / " + portletInfo.portletName);
            CreationContextBuilderFactory creationContextBuilderFactory = CreationContextBuilderFactory.getInstance();
            LayoutContainer layoutContainer = (LayoutContainer)layoutModel.getParent((Object)layoutControl);
            PortletDefinition portletDefinition = this.getPortletDefinition(portletInfo);
            LayoutControlCreationContext layoutControlCreationContext = creationContextBuilderFactory.newLayoutControlCreationContext((Identifiable)portletDefinition, null);
            ModifiableLayoutNode modifiableLayoutNode = layoutModelController.create(LayoutControl.class, (CreationContext)layoutControlCreationContext);
            layoutModelController.insert((Object)modifiableLayoutNode, (Object)layoutContainer, null);
            layoutModelController.delete((Object)layoutControl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNewPages(String string, ContentModel contentModel, ContentNode contentNode) {
        ContentNodeType contentNodeType = contentNode.getContentNodeType();
        if (contentNodeType != ContentNodeType.LABEL) {
            System.out.println("Cannot add new pages because cannot found root label of pages");
            return;
        }
        PageInfo[] pageInfoArray = this.pagesToAddByTemplateName.get(string);
        if (pageInfoArray != null && pageInfoArray.length > 0) {
            ContentModelController contentModelController = null;
            try {
                contentModelController = this.contentModelCtrlHome.getContentModelControllerProvider().createContentModelController(contentModel);
                for (int i = 0; i < pageInfoArray.length; ++i) {
                    String string2 = (String)pageInfoArray[i].titleMapByLocale.get(Locale.ENGLISH);
                    ContentPage contentPage = this.searchPageByEnglishName(string2, contentModel, contentNode);
                    if (contentPage != null) {
                        System.out.println("Page to add " + string2 + " already exist");
                        continue;
                    }
                    ContentPage contentPage2 = null;
                    if (!UString.isEmpty((String)pageInfoArray[i].nextPageEnglishTitle)) {
                        contentPage2 = this.searchPageByEnglishName(pageInfoArray[i].nextPageEnglishTitle, contentModel, contentNode);
                    }
                    this.addNewPage(pageInfoArray[i], contentModelController, contentNode, (ContentNode)contentPage2);
                }
                contentModelController.commit();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                if (contentModelController != null) {
                    contentModelController.dispose();
                }
            }
        }
    }

    protected void addNewPage(PageInfo pageInfo, ContentModelController contentModelController, ContentNode contentNode, ContentNode contentNode2) {
        System.out.println("--- add New Page " + pageInfo.titleMapByLocale.get(Locale.ENGLISH) + " before " + pageInfo.nextPageEnglishTitle);
        if (!UString.isEmpty((String)pageInfo.nextPageEnglishTitle) && contentNode2 == null) {
            System.out.println("... next page not found");
        }
        try {
            CreationContextBuilderFactory creationContextBuilderFactory = CreationContextBuilderFactory.getInstance();
            ContentPageCreationContext contentPageCreationContext = creationContextBuilderFactory.newContentPageCreationContext(false);
            ModifiableContentPage modifiableContentPage = (ModifiableContentPage)contentModelController.create(ContentPage.class, (CreationContext)contentPageCreationContext);
            for (Locale locale : pageInfo.titleMapByLocale.keySet()) {
                modifiableContentPage.setTitle(locale, (String)pageInfo.titleMapByLocale.get(locale));
            }
            contentModelController.insert((Object)modifiableContentPage, (Object)contentNode, (Object)contentNode2);
            if (pageInfo.portlets != null) {
                Locale locale;
                LayoutModelController layoutModelController = contentModelController.getLayoutModelController((ContentPage)modifiableContentPage);
                locale = contentModelController.getLayoutModel((ContentPage)modifiableContentPage);
                for (int i = 0; i < pageInfo.portlets.length; ++i) {
                    System.out.println("------- add portlet " + pageInfo.portlets[i].portletName);
                    PortletDefinition portletDefinition = this.getPortletDefinition(pageInfo.portlets[i]);
                    if (portletDefinition == null) {
                        System.out.println("portlet " + pageInfo.portlets[i].portletName + " not found");
                        continue;
                    }
                    LayoutNode layoutNode = (LayoutNode)layoutModelController.getRoot();
                    ContentNodeCreationContext contentNodeCreationContext = creationContextBuilderFactory.newContentNodeCreationContext(false);
                    ModifiableLayoutContainer modifiableLayoutContainer = (ModifiableLayoutContainer)layoutModelController.create(LayoutContainer.class, (CreationContext)contentNodeCreationContext);
                    modifiableLayoutContainer.getModifiableLayoutMetrics().setValue("ORIENTATION", (Object)Orientation.VERTICAL);
                    layoutModelController.insert((Object)modifiableLayoutContainer, (Object)layoutNode, null);
                    LayoutControlCreationContext layoutControlCreationContext = creationContextBuilderFactory.newLayoutControlCreationContext((Identifiable)portletDefinition, null);
                    ModifiableLayoutNode modifiableLayoutNode = layoutModelController.create(LayoutControl.class, (CreationContext)layoutControlCreationContext);
                    layoutModelController.insert((Object)modifiableLayoutNode, (Object)modifiableLayoutContainer, null);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Error to create The new page with portlet: " + pageInfo.titleMapByLocale.get(Locale.ENGLISH));
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void customizePages(String string, ContentModel contentModel, PortletModel portletModel, ContentNode contentNode) {
        PageInfo[] pageInfoArray = this.pagesToCustomizeByTemplateName.get(string);
        if (pageInfoArray != null && pageInfoArray.length > 0) {
            ContentModelController contentModelController = null;
            try {
                contentModelController = this.contentModelCtrlHome.getContentModelControllerProvider().createContentModelController(contentModel);
                System.out.println("--- customizes Pages of the place");
                for (int i = 0; i < pageInfoArray.length; ++i) {
                    String string2 = (String)pageInfoArray[i].titleMapByLocale.get(Locale.ENGLISH);
                    System.out.println("...Search page " + string2);
                    ContentPage contentPage = this.searchPageByEnglishName(string2, contentModel, contentNode);
                    if (contentPage == null) {
                        System.out.println("...Page to customize " + string2 + " not found");
                        continue;
                    }
                    this.customizePage(pageInfoArray[i], contentPage, contentModel, contentModelController, portletModel);
                }
                contentModelController.commit();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                if (contentModelController != null) {
                    contentModelController.dispose();
                }
            }
        }
    }

    protected void customizePage(PageInfo pageInfo, ContentPage contentPage, ContentModel contentModel, ContentModelController contentModelController, PortletModel portletModel) {
        System.out.println("--- customize Page " + pageInfo.titleMapByLocale.get(Locale.ENGLISH));
        try {
            if (pageInfo.portlets != null) {
                for (int i = 0; i < pageInfo.portlets.length; ++i) {
                    PortletDefinition portletDefinition = this.getPortletDefinition(pageInfo.portlets[i]);
                    if (portletDefinition == null) {
                        System.out.println("...portlet " + pageInfo.portlets[i].portletName + " not found");
                        continue;
                    }
                    LayoutModel layoutModel = contentModel.getLayoutModel(contentPage);
                    LayoutModelController layoutModelController = contentModelController.getLayoutModelController(contentPage);
                    if (this.isPortletInPage(pageInfo.portlets[i].portletName, (LayoutNode)layoutModel.getRoot(), layoutModel, portletModel)) {
                        System.out.println("...portlet " + pageInfo.portlets[i].portletName + " is already in page " + pageInfo.titleMapByLocale.get(Locale.ENGLISH));
                        continue;
                    }
                    System.out.println("...add portlet " + pageInfo.portlets[i].portletName + " to the page");
                    this.addPortletToPage(contentPage, portletDefinition, layoutModel, layoutModelController);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Error to customize page: " + pageInfo.titleMapByLocale.get(Locale.ENGLISH));
            exception.printStackTrace();
        }
    }

    protected void addPortletToPage(ContentPage contentPage, PortletDefinition portletDefinition, LayoutModel layoutModel, LayoutModelController layoutModelController) throws Exception {
        CreationContextBuilderFactory creationContextBuilderFactory = CreationContextBuilderFactory.getInstance();
        LayoutContainer layoutContainer = this.getFirstLayoutContainer((LayoutNode)layoutModel.getRoot(), layoutModel);
        LayoutControlCreationContext layoutControlCreationContext = creationContextBuilderFactory.newLayoutControlCreationContext((Identifiable)portletDefinition, null);
        ModifiableLayoutNode modifiableLayoutNode = layoutModelController.create(LayoutControl.class, (CreationContext)layoutControlCreationContext);
        layoutModelController.insert((Object)modifiableLayoutNode, (Object)layoutContainer, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deletePages(String string, ContentModel contentModel, ContentNode contentNode) {
        PageInfo[] pageInfoArray = this.pagesToDeleteByTemplateName.get(string);
        if (pageInfoArray != null && pageInfoArray.length > 0) {
            System.out.println("--- delete Pages ");
            ContentModelController contentModelController = null;
            try {
                contentModelController = this.contentModelCtrlHome.getContentModelControllerProvider().createContentModelController(contentModel);
                for (int i = 0; i < pageInfoArray.length; ++i) {
                    String string2 = (String)pageInfoArray[i].titleMapByLocale.get(Locale.ENGLISH);
                    ContentPage contentPage = this.searchPageByEnglishName(string2, contentModel, contentNode);
                    if (contentPage == null) {
                        System.out.println("Page to delete " + string2 + " does not exist");
                        continue;
                    }
                    System.out.println("...... delete Page " + string2);
                    this.deletePage((ContentNode)contentPage, contentModelController);
                }
                contentModelController.commit();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                if (contentModelController != null) {
                    contentModelController.dispose();
                }
            }
        }
    }

    protected void deletePage(ContentNode contentNode, ContentModelController contentModelController) {
        try {
            ContentPage contentPage = (ContentPage)contentModelController.getLocator().findByID(contentNode.getObjectID());
            contentModelController.delete((Object)contentPage);
        }
        catch (Exception exception) {
            System.out.println("Error to delete the page " + contentNode.getTitle(Locale.ENGLISH));
            exception.printStackTrace();
        }
    }

    protected void dumpPlaceLayout(ContentModel contentModel, PortletModel portletModel, ContentNode contentNode, String string) throws Exception {
        ListModel listModel;
        Object object;
        ContentNodeType contentNodeType = contentNode.getContentNodeType();
        if (contentNodeType == ContentNodeType.LABEL) {
            System.out.println(string + "LABEL title= " + ((ContentLabel)contentNode).getTitle(Locale.ENGLISH));
        } else if (contentNodeType == ContentNodeType.PAGE) {
            object = ((ContentPage)contentNode).getTitle(Locale.ENGLISH);
            System.out.println(string + "PAGE title= " + ((ContentPage)contentNode).getTitle(Locale.ENGLISH));
            listModel = contentModel.getLayoutModel((ContentPage)contentNode);
            try {
                this.dumpPortletsOfPage((ContentPage)contentNode, (LayoutModel)listModel, portletModel, string + "...");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (contentNode instanceof MetaDataProvider) {
            object = ((MetaDataProvider)contentNode).getMetaData();
            listModel = object.getNames();
            System.out.println(string + "... MetaData:");
            try {
                for (Object e : listModel) {
                    System.out.println(string + "          " + e + " = " + object.getValue((String)e));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            object = contentModel.getChildren((Object)contentNode);
            while (object.hasNext()) {
                this.dumpPlaceLayout(contentModel, portletModel, (ContentNode)object.next(), string + "\t");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void dumpPortletsOfPage(ContentPage contentPage, LayoutModel layoutModel, PortletModel portletModel, String string) throws Exception {
        Set set = this.findLayoutControls((LayoutNode)layoutModel.getRoot(), layoutModel);
        for (LayoutControl layoutControl : set) {
            PortletWindow portletWindow = portletModel.getPortletWindow(layoutControl);
            PortletEntity portletEntity = portletModel.getPortletEntity(portletWindow);
            PortletDefinition portletDefinition = portletModel.getPortletDefinition(portletEntity);
            Portlet portlet = portletModel.getPortlet(portletDefinition);
            System.out.println(string + "portlet name: " + portlet.getPortletName());
            System.out.println(string + "portlet id  : " + portlet.getObjectID());
        }
    }

    protected Set findLayoutControls(LayoutNode layoutNode, LayoutModel layoutModel) throws ObjectNotFoundException, ModelException {
        HashSet<LayoutNode> hashSet = new HashSet<LayoutNode>();
        if (layoutNode != null) {
            if (layoutNode instanceof LayoutControl) {
                hashSet.add(layoutNode);
            }
            Iterator iterator = layoutModel.getChildren((Object)layoutNode);
            while (iterator.hasNext()) {
                hashSet.addAll(this.findLayoutControls((LayoutNode)iterator.next(), layoutModel));
            }
        }
        return hashSet;
    }

    protected boolean isPortletInPage(String string, LayoutNode layoutNode, LayoutModel layoutModel, PortletModel portletModel) throws Exception {
        Iterator iterator;
        PortletEntity portletEntity;
        PortletDefinition portletDefinition;
        Portlet portlet;
        if (layoutNode instanceof LayoutControl && (portlet = portletModel.getPortlet(portletDefinition = portletModel.getPortletDefinition(portletEntity = portletModel.getPortletEntity((PortletWindow)(iterator = portletModel.getPortletWindow((LayoutControl)layoutNode)))))) != null && string.equals(portlet.getPortletName())) {
            return true;
        }
        iterator = layoutModel.getChildren((Object)layoutNode);
        while (iterator.hasNext()) {
            if (!this.isPortletInPage(string, (LayoutNode)iterator.next(), layoutModel, portletModel)) continue;
            return true;
        }
        return false;
    }

    protected LayoutContainer getFirstLayoutContainer(LayoutNode layoutNode, LayoutModel layoutModel) throws Exception {
        if (layoutNode instanceof LayoutContainer && !layoutModel.hasContainerChild((Object)layoutNode)) {
            return (LayoutContainer)layoutNode;
        }
        Iterator iterator = layoutModel.getChildren((Object)layoutNode);
        while (iterator.hasNext()) {
            LayoutContainer layoutContainer = this.getFirstLayoutContainer((LayoutNode)iterator.next(), layoutModel);
            if (layoutContainer == null) continue;
            return layoutContainer;
        }
        return null;
    }

    protected ObjectID searchPortlet(PortletInfo portletInfo) throws DataBackendException {
        ApplicationDescriptorHome applicationDescriptorHome = (ApplicationDescriptorHome)ResourceHomeFactory.getResourceHome(ApplicationDescriptorHome.class, null);
        PortletDescriptorHome portletDescriptorHome = (PortletDescriptorHome)ResourceHomeFactory.getResourceHome(PortletDescriptorHome.class, null);
        List list = applicationDescriptorHome.findByName(portletInfo.appName);
        for (ApplicationDescriptor applicationDescriptor : list) {
            List list2 = portletDescriptorHome.findByApplicationDescriptor(applicationDescriptor);
            for (PortletDescriptor portletDescriptor : list2) {
                if (!portletDescriptor.getPortletName().equals(portletInfo.portletName)) continue;
                return portletDescriptor.getObjectID();
            }
        }
        return null;
    }

    protected ContentPage searchPageByEnglishName(String string, ContentModel contentModel, ContentNode contentNode) {
        try {
            Iterator iterator = contentModel.getChildren((Object)contentNode);
            while (iterator.hasNext()) {
                ContentNode contentNode2 = (ContentNode)iterator.next();
                String string2 = contentNode2.getTitle(Locale.ENGLISH);
                if (!UString.equals((String)string, (String)string2) || contentNode2.getContentNodeType() != ContentNodeType.PAGE) continue;
                return (ContentPage)contentNode2;
            }
        }
        catch (Exception exception) {
            System.out.println("Error to find page " + string);
            exception.printStackTrace();
        }
        return null;
    }

    protected PortletDefinition getPortletDefinition(PortletInfo portletInfo) throws Exception {
        ObjectID objectID = this.searchPortlet(portletInfo);
        if (objectID != null) {
            return this.getPortletDefinition(objectID);
        }
        return null;
    }

    protected PortletDefinition getPortletDefinition(ObjectID objectID) {
        return PortletRegistry.getInstance().getPortletDefinition(objectID);
    }

    protected String getTemplateTitle(TemplateService templateService) {
        String string = templateService.getTitle(this.locale);
        if (UString.isEmpty((String)string)) {
            string = templateService.getTitle(Locale.ENGLISH);
        }
        return string;
    }

    protected String getApplicationTitle(ApplicationService applicationService) throws Exception {
        String string;
        block2: {
            Locale locale;
            string = applicationService.getTitle(this.locale);
            if (UString.isEmpty((String)string)) {
                string = applicationService.getTitle(Locale.ENGLISH);
            }
            if (!UString.isEmpty((String)string)) break block2;
            Iterator iterator = applicationService.getLocales().iterator();
            while (iterator.hasNext() && UString.isEmpty((String)(string = applicationService.getTitle(locale = (Locale)iterator.next())))) {
            }
        }
        return string;
    }

    protected void addUserToApplicationCommunityIfNotMember(ApplicationService applicationService) {
        System.out.println("-- Add user to application community");
        try {
            ObjectID objectID = applicationService.getCommunityID();
            InitialContext initialContext = new InitialContext();
            CommunityHome communityHome = (CommunityHome)initialContext.lookup("portal:service/community/home");
            CommunityController communityController = communityHome.getController();
            if (!communityController.isUserMemberOfCommunity(objectID)) {
                PumaHome pumaHome = (PumaHome)initialContext.lookup("portal:service/usermanagement/Puma");
                PumaProfile pumaProfile = pumaHome.getProfile();
                User user = pumaProfile.getCurrentUser();
                Set set = communityController.getCommunityRolesForCommunity(objectID);
                for (CommunityRole communityRole : set) {
                    if (!"manager".equals(communityRole.getRoleName())) continue;
                    System.out.println("..... add user as application manager");
                    communityController.addMemberToCommunityRole(communityRole, Collections.singleton(user));
                    return;
                }
            } else {
                System.out.println("...User is already member of the community");
            }
        }
        catch (Exception exception) {
            System.out.println("Error to add user to application " + applicationService.getTitle(this.locale));
            exception.printStackTrace();
        }
    }

    public static class PageInfo {
        public HashMap titleMapByLocale = new HashMap();
        public PortletInfo[] portlets = new PortletInfo[0];
        public String nextPageEnglishTitle;
    }

    public static class PortletInfo {
        public String portletName;
        public String appName;
    }

    public static class AppInfo
    implements Serializable {
        public String title;
        public ObjectID objectId;
    }
}

